<?php
/****************************************************************
 * IBM Confidential
 *
 * SFA100-Collaboration Source Materials
 *
 * (C) Copyright IBM Corp. 2014
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office
 *
 ***************************************************************/

class Logger{
    protected $logger;
    protected $debug;
    
    public function __construct(){
        self::setLogFile('error.log');
        self::setDebug(false);
    }
    
    public function setLogFile($file) {
        $this->logger = $file;
        return true;
    }
    
    public function getLogFile() {
        return $this->logger;
    }
    
    public function log($message, $type = null){
        $pre = '[' . date('Y/m/d H:i:s') . ']';
        if (!empty($type)){
            $pre .= '[' . strtoupper($type) . ']';
        }
        $message = $pre . $message . "\n\n";
        return file_put_contents($this->logger, $message, FILE_APPEND);
    }
    
    public function error($message) {
        return self::log($message, 'error');
    }
    
    public function info($message) {
        return self::log($message, 'info');
    }
    
    public function warning($message) {
        return self::log($message, 'warning');
    }
    
    public function debug($message) {
        return self::log($message, 'debug');
    }
    
    public function setDebug($debug) {
        if (is_bool($debug)) {
            $this->debug = $debug;
        }
        return $this->debug;
    }
    
    public function isDebug() {
        return $this->debug;
    }
}