<?php
/****************************************************************
 * IBM Confidential
 *
 * SFA100-Collaboration Source Materials
 *
 * (C) Copyright IBM Corp. 2014
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office
 *
 ***************************************************************/

require_once 'include/UrbanCodeClient.php';
require_once 'include/Utils.php';
require_once 'include/BackupUCD.php';
require_once 'include/RestoreUCD.php';
require_once 'include/Snapshot.php';
require_once 'include/ApplicationProcess.php';
require_once('include/Logger.php');
include 'config/ucd.config.php';

$return = array ();
$return_msg = '';

// Setup logger
$log = new Logger();
if (file_exists('config/logger.config.php')) {
    include('config/logger.config.php');
    $log->setLogFile($config['log']);
    $log->setDebug($config['debug']);
}

$valid_actions = array (
                    'API'                       => 'Call any of the APIs available in UrbanCodeClient',
                    'backup'                    => 'Run a complete back up of uDeploy.',
                    'restore'                   => 'Run a complete restore of uDeploy. Requires a backup source path as argument.',
                    'upgrade'                   => 'Run a complete upgrade of uDeploy. Requires a backup source path as argument',
                    'restoreComponent'          => 'Restore a component. Requires a path to a json file as argument.',
                    'upgradeComponent'          => 'Upgrade an existing component. Requires a path to a json file as argument.',
                    'restoreApplication'        => 'Restore an application. Requires a path to a json file as argument.',
                    'upgradeApplication'        => 'Upgrade an existing application. Requires a path to a json file or to a directory as argument.',
                    'restoreComponentTemplate'  => 'Restore a ComponentTemplate. Requires a path to a json file as argument.',
                    'upgradeComponentTemplate'  => 'Upgrade an existing ComponentTemplate. Requires a path to a json file as argument.',
                    'run'                       => 'Run an application process. Requires a path to a json file as argument.',
                    'promoteSnapshot'           => 'Promote a snapshot from a uDeploy origin server to a destination uDeploy server',
                    'promoteConfig'             => 'Promote (upgrade) configuration from a uDeploy origin server to a destination uDeploy server',
                    'RTCbackup'                 => 'Cleanup RTC directory and backup files',
                    'requestStatus'             => 'Get status for a specified request ID',
                    'runAndWait'                => 'Run a process and wait for completion',
                    'waitRequestCompletion'     => 'Wait for a specific application process request for completion',
                    'createVersion'             => 'Create a new version for the component',
                    'createSnapshot'            => 'Create an application snapshot based on json file',
                    'createVersionsAndSnapshot' => 'First create component versions, then add them into a snapshot',
                    'addTeamToComponent'        => 'Add a team to one or more component',
                    'addTeamToResource'         => 'Add a team to one or more resource',
                    'ver'                       => 'Show current uCommand version and list of uDeploy versions compatibility',
					'exportEnvironmentProperties'         => 'Export the environment variables of an application',
					'importEnvironmentProperties'         => 'Import the environment variables of an application',
                );

// Prompt a start-up message to user
Utils::CLIout( "##################################" );
Utils::CLIout( "#            uCommand            #" );
Utils::CLIout( "# Urban Code Deploy PHP CLI Tool #" );
Utils::CLIout( "#    by SalesConnect - Dublin    #" );
Utils::CLIout( "##################################\n" );

// Check if arguments are passed
if (count( $argv ) == 1) {
    Utils::CLIerror( "Please provide a valid Action as Argument." );
    Utils::CLIout( "Usage: ", true );
    foreach ( $valid_actions as $action => $description ) {
        if ($action == "API") {
            continue;
        }
        Utils::CLIout( "\t{$action} => {$description}", true );
    }
    Utils::CLIout( "\n", true );
    exit( 1 );
}

// Valid arguments
switch ($argv [1]) {
    case "API":
        $ucc = new UrbanCodeClient();
        $arguments = array();
        if (!empty($argv[2])){
            if ( $ucc->isValidAction($argv[2]) || $ucc->isValidRestAction($argv[2]) ) {
                Utils::Cliapi($argv[2]);
                for ($i=3; $i<$argc; $i++){
                    array_push($arguments,$argv[$i]);
                }
                $ucc->setArgs($arguments);
                $return = $ucc->$argv[2]();
                Utils::CLIresult("Server response (JSON):\n");
                print_r(Utils::outputToJson($return));
            }
            else {
                Utils::CLIerror( "API '{$argv[2]}' is not valid.", true );
                Utils::CLIapi("List of available functions:\n");
                print_r($ucc->getActions());
                print_r($ucc->getRestActions());
                exit( 1 );
            }
        } 
        else {
            Utils::CLIerror( "No API passed as argument.", true );
            exit( 1 );
        }
        break;
    case "backup" :
        $backup = new BackupUCD();
        $config['output'] = $backup->output;
        $return = $backup->backup();
        $config ['json_check'] = true;
        break;
    case "restore" :
        if (empty( $argv [2] )) {
            Utils::CLIerror( "No source path for restore defined", true );
            exit( 1 );
        }
        if (!empty($argv[3]) && $argv[3] == 'clean') {
            $clean = true;
        } else {
            $clean = false;
        }
        $path = $argv [2];
        $restore = new RestoreUCD();
        $return = $restore->restoreAll( $path, false, $clean );
        
        if ($return === false) {
            exit(1);
        }
        
        $success = true;
        foreach ($return as $val) {
            if ($val === false) {
                $success = false;
            }
        }
        
        if ($success) {
            exit(0);
        } else {
            exit(1);
        }
        break;
    case "upgrade" :
        if (empty( $argv [2] )) {
            Utils::CLIerror( "No source path for upgrade defined", true );
            exit( 1 );
        }
        $path = $argv [2];
        $restore = new RestoreUCD();
        $return = $restore->restoreAll( $path, true );
        break;
    case "restoreComponent" :
        if (empty( $argv [2] )) {
            Utils::CLIerror( "No source path for restore defined", true );
            exit( 1 );
        }
        $path = $argv [2];
        $restore = new RestoreUCD();
        $return = $restore->restoreComponent( $path );
        break;
    case "upgradeComponent" :
        if (empty( $argv [2] )) {
            Utils::CLIerror( "No source path for restore defined", true );
            exit( 1 );
        }
        $path = $argv [2];
        
        $upgradeTemplate = false;
        $upgradeProcess = false;
        if (!empty($argv[3])) {
            if ($argv[3] == "upgradeTemplate") {
                $upgradeTemplate = true;
            }
            else if ($argv[3] == "upgradeProcess") {
                $upgradeProcess = true;
            }
        }
        if (!empty($argv[4])) {
            if ($argv[4] == "upgradeTemplate") {
                $upgradeTemplate = true;
            }
            else if ($argv[4] == "upgradeProcess") {
                $upgradeProcess = true;
            }
        }
        
        $ucc = new UrbanCodeClient();
        $return = $ucc->upgradeComponent( $path, $upgradeTemplate, $upgradeProcess );
        break;
    case "restoreApplication" :
        if (empty( $argv [2] )) {
            Utils::CLIerror( "No source path for restore defined", true );
            exit( 1 );
        }
        $path = $argv [2];
        $restore = new RestoreUCD();
        $return = $restore->restoreApplication( $path );
        break;
    case "upgradeApplication" :
        if (empty( $argv[2] )) {
            Utils::CLIerror( "No source path for restore defined", true );
            exit( 1 );
        }
        $path = $argv[2];
        
        $upgradeTemplate = false;
        $upgradeProcess = false;
        if (!empty($argv[3])) {
            if ($argv[3] == "upgradeTemplate") {
                $upgradeTemplate = true;
            }
            else if ($argv[3] == "upgradeProcess") {
                $upgradeProcess = true;
            }
        }
        if (!empty($argv[4])) {
            if ($argv[4] == "upgradeTemplate") {
                $upgradeTemplate = true;
            }
            else if ($argv[4] == "upgradeProcess") {
                $upgradeProcess = true;
            }
        }
        
        $ucc = new UrbanCodeClient();
        $return = $ucc->upgradeApplication( $path, $upgradeTemplate, $upgradeProcess );
        break;
    case 'restoreComponentTemplate' :
        if (empty( $argv [2] )) {
            Utils::CLIerror( "No source path for restore defined", true );
            exit( 1 );
        }
        $path = $argv [2];
        $restore = new RestoreUCD();
        $return = $restore->restoreComponentTemplate( $path );
        break;
    case 'upgradeComponentTemplate' :
        if (empty( $argv [2] )) {
            Utils::CLIerror( "No source path for upgrade defined", true );
            exit( 1 );
        }
        $path = $argv [2];
        $restore = new RestoreUCD();
        $return = $restore->restoreComponentTemplate( $path, true );
        break;
    case "run":
        if (empty($argv[2]) || !file_exists($argv[2])) {
            Utils::CLIerror("Invalid or missing template for application process.");
            exit (1);
        }
        $appProcess = new ApplicationProcess();
        $process = $argv[2];
        $result = $appProcess->request($process);
        if ($result === false){
            exit (1);
        } else {
            Utils::CLIout("{$result}",true,"id");
            Utils::CLIout("{$appProcess->getWeburl()}/#applicationProcessRequest/{$result}",true,"link");
            exit (0);
        }
        
        break;
    case "promoteSnapshot":
        if (empty($argv[2])) {
            Utils::CLIerror("Missing snapshot name.");
            exit (1);
        }
        $promote = new Snapshot();
        $snapshot = $argv[2];
        $config = null;
        if (!empty($argv[3])) {
            if ($argv[3] == 'default') {
                $config = null;
            } else {
                $config = $argv[3];
            }
        }
        
        if (!empty($argv[4])) {
            $force = $argv[4];
        } else {
            $force = null;
        }
        $return = $promote->promoteSnapshot($snapshot,$config,null,$force);
        Utils::CLIout("\n");
        
        if ($return === false) {
            exit (1);
        } else {
            exit (0);
        }
        break;
    case "promoteConfig":
        $source = null;
        $clean = false;
        if (!empty($argv[2])) {
            if ($argv[2] == 'clean') {
                $clean = true;
            }
            else {
                if (is_dir($argv[2])) {
                    $source = $argv[2];
                }
                else {
                    Utils::CLIout("Argument is not valid.");
                    exit (1);
                }
                
                if (!empty($argv[3]) && $argv[3] == 'clean') {
                    $clean = true;
                } else {
                    $clean = false;
                }
            }
        }
        
        $promote = new Snapshot();
        
        $return = $promote->promoteConfig($source, $clean);
        
        if ($return === false) {
            exit (1);
        } else {
            exit (0);
        }
        break;
    case "RTCbackup":
        $backup = new BackupUCD();
        Utils::CLIinfo("Removing old backup data from {$config['output']}");
        $cwd = getcwd();
        $cleanCommand = "cd {$config['output']}; rm -R `ls | grep -v 'build.xml' | grep -v 'component.xml'`";
        exec($cleanCommand,$output,$result);
        chdir($cwd);
        if ($result == 0) {
            $return = $backup->backup();
        } else {
            Utils::CLIerror("Error while removing old backup data from RTC directory.");
        }
        break;
    case "requestStatus":
        if (empty($argv[2])) {
            Utils::CLIerror("Missing process request ID.");
            exit (1);
        }
        $appProcess = new ApplicationProcess();
        $appProcess->setRequestId($argv[2]);
        
        $exit = $appProcess->status(true);
        
        if ($exit === false) {
            exit (1);
        } else {
            exit ($exit);
        }
        
        break;
    case "runAndWait":
        if (empty($argv[2]) || !file_exists($argv[2])) {
            Utils::CLIerror("Invalid or missing template for application process.");
            exit (1);
        }
        
        $process = $argv[2];
        $appProcess = new ApplicationProcess();
        $result = $appProcess->request($process);
        if ($result === false){
            exit (1);
        }
        Utils::CLIout("{$result}",true,"id");
        Utils::CLIout("{$appProcess->getWeburl()}/#applicationProcessRequest/{$result}",true,"link");
        if (!empty($argv[3])){
            $timeout = $argv[3];
        } else {
            $timeout = true;
        }
        
        $exit = $appProcess->waitCompletion($timeout);
        
        if ($exit === false) {
            exit (1);
        } else {
            exit ($exit);
        }
        
        break;
    case "waitRequestCompletion":
        if (empty($argv[2])) {
            Utils::CLIerror("Missing process request ID.");
            exit (1);
        }
        $appProcess = new ApplicationProcess();
        $appProcess->setRequestId($argv[2]);
        
        if (!empty($argv[3])){
            $timeout = $argv[3];
        } else {
            $timeout = true;
        }
        
        $exit = $appProcess->waitCompletion($timeout);
        
        if ($exit === false) {
            exit (1);
        } else {
            exit ($exit);
        }
        
        break;
    case 'createVersion':
        $ucc = new UrbanCodeClient();
        if (empty($argv[2])) {
            Utils::CLIerror("Missing component name or ID.");
            exit (1);
        }
        if (empty($argv[3])) {
            Utils::CLIerror("Missing version name.");
            exit (1);
        }
        
        if (isset($argv[4])) {
            $description = $argv[4];
        } else {
            $description = '';
        }
        
        $result = $ucc->createVersion($argv[2],$argv[3],$description);
        
        if ($result === false) {
            exit (1);
        } else {
            exit (0);
        }
        
        break;
   case 'exportEnvironmentProperties':
        $ucc = new UrbanCodeClient();
        if (empty($argv[2])) {
                Utils::CLIerror("Missing the environment id.");
                exit (1);
        }
        
        $result = $ucc->exportEnvironmentProperties($argv[2]);
        
        if ($result === false) {
                exit (1);
        } else {
                 exit (0);
        }
        break;
   case 'importEnvironmentProperties':
        $ucc = new UrbanCodeClient();
        if (empty($argv[2])) {
                Utils::CLIerror("Missing the file name.");
                exit (1);
        }
        if (empty($argv[3])) {
        	Utils::CLIerror("Missing the environment id.");
        	exit (1);
        }
        
        $result = $ucc->importEnvironmentProperties($argv[2], $argv[3]);
        
        if ($result === false) {
                exit (1);
        } else {
                 exit (0);
        }
        break;
    case 'createSnapshot':
        $ucc = new UrbanCodeClient();
        if (empty($argv[2])) {
            Utils::CLIerror("Missing snapshot file.");
            exit (1);
        }
        
        $result = $ucc->createSnapshot($argv[2]);
        
        if ($result === false) {
            exit (1);
        } else {
            exit (0);
        }
        break;
    case 'createVersionsAndSnapshot':
        $snapshot = new Snapshot();
        if (empty($argv[2])) {
            Utils::CLIerror("Missing configuration file.");
            exit (1);
        }
        
        if (!empty($argv[3]) && $argv[3] == 'force') {
            $force = true;
        } else {
            $force = false;
        }
        
        $result = $snapshot->createVersionsAndSnapshot($argv[2], $force);
        Utils::CLIout("\n");
        
        if ($result === false) {
            exit (1);
        } else {
            exit (0);
        }
        break;
    case 'vers':
    case 'version':
    case 'versions':
    case 'ver':
        include ('include/version.php');
        Utils::CLIout("Version: {$ver['ucommand']}");
        Utils::CLIout("Supported uDeploy versions:");
        foreach ($ver['ucd'] as $ucdver) {
            Utils::CLIout("  {$ucdver}");
        }
        Utils::CLIout("");
        exit(0);
    case 'addTeamToComponent':
        if (empty($argv[2])) {
            Utils::CLIerror("Missing team name/ID");
            exit (1);
        }
        $team = $argv[2];
        
        if (empty($argv[3])) {
            $all = true;
        } else {
            $component = $argv[3];
        }
        
        $restore = new RestoreUCD();
        if ($all) {
            // Apply team to all components
            $result = $restore->addTeamToAllComponents($team);
        } else {
            // Apply team to a single component
            $result = $restore->addComponentToTeam($component, $team);
        }
        
        if ($result !== false) {
            exit (0);
        } else {
            exit (1);
        }
        
    case 'addTeamToResource':
        if (empty($argv[2])) {
            Utils::CLIerror("Missing team name/ID");
            exit(1);
        }
        $team = $argv[2];
        
        if (empty($argv[3])) {
            $all = true;
        } else {
            $resource = $argv[3];
        }
        
        $restore = new RestoreUCD();
        if ($all) {
            // Apply team to all resources
            $result = $restore->addTeamToAllResources($team);
        } else {
            // Apply team to a single resource
            $result = $restore->addResourceToTeam($resource, $team);
        }
        
        if ($result !== false) {
            exit (0);
        } else {
            exit (1);
        }
        
    default :
        Utils::CLIerror( '"' . $argv [1] . '" is Not a valid action', true );
        Utils::CLIinfo( "Please provide a valid Action as Argument." );
        Utils::CLIout( "Usage: ", true );
        foreach ( $valid_actions as $action => $description ) {
            if ($action == "API") {
                continue;
            }
            Utils::CLIout( "\t{$action} => {$description}", true );
        }
        Utils::CLIout( "\n", true );
        exit( 1 );
}

// Print final mesasge
echo "\n";
Utils::CLIresult( "Action '{$argv[1]}' completed");

// JSON validation
if ($config ['json_check'] === true) {
    Utils::validateDirectoryJSON( $config ['output'] );
}

// Quick spot errors
if (Utils::quickErrorCheck($return)) {
    Utils::CLIout("Success\n");
    exit (0);
} else {
    Utils::CLIout("Some failures where found");
    exit (1);
}

Utils::CLIdebug( var_export( $return, true ) );
$log->log( var_export( $return, true ) );