/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.processes.Processes;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceClient {
    private static final Logger log = Logger.getLogger(PerforceClient.class);
    private final Processes processes = new Processes();
    private final String p4Path;
    private final String port;
    private final String user;
    private final String password;
    private final String template;
    private final boolean doLogin;
    private File workDir;
    private final String clientName;
    private File p4TicketsFile;
    private List<String> indcludeFiles;
    private List<String> excludeFiles;
    boolean isSetup = false;
    private Pattern excludedFilesPattern;

    public PerforceClient(String p4Path, String port, String user, String password, String template, boolean doLogin) {
        Check.nonBlank(p4Path, "p4Path");
        Check.nonBlank(port, "port");
        Check.nonBlank(user, "user");
        Check.nonBlank(template, "template");
        this.p4Path = p4Path.trim();
        this.port = port.trim();
        this.user = user.trim();
        this.password = this.trimToNull(password);
        this.template = template.trim();
        this.doLogin = doLogin;
        this.clientName = this.newClientName();
    }

    public String getLatestVersion() throws IOException, InterruptedException {
        this.assertSetup();
        Integer latestVersion = Integer.MIN_VALUE;
        if (this.excludeFiles.isEmpty()) {
            for (String filePath : this.indcludeFiles) {
                Integer version = this.getLastestVersionForFile(filePath);
                if (version == null || version <= latestVersion) continue;
                latestVersion = version;
            }
        } else {
            List<Integer> versions = this.getAllVersions();
            latestVersion = this.getLatestVersionWithChangeNotExcluded(versions);
        }
        return String.valueOf(latestVersion);
    }

    public File downloadFiles(String version) throws IOException, InterruptedException {
        this.assertSetup();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.p4Path);
        commandLine.add("-c");
        commandLine.add(this.clientName);
        commandLine.add("-p");
        commandLine.add(this.port);
        commandLine.add("-u");
        commandLine.add(this.user);
        if (this.password != null && !this.doLogin) {
            commandLine.add("-P");
            commandLine.add(this.password);
        }
        commandLine.add("sync");
        commandLine.add("@" + version);
        this.handleProcess(this.execute(commandLine), null);
        return this.workDir;
    }

    private void setup() throws IOException, InterruptedException {
        this.workDir = this.newPath();
        this.p4TicketsFile = this.newPath();
        IO.mkdirs(this.workDir);
        if (this.doLogin) {
            this.p4TicketsFile.createNewFile();
            this.login();
        }
        String clientSpec = this.createClientSpec();
        this.setDepotFileLists(clientSpec);
        this.excludedFilesPattern = this.convertToPattern(this.excludeFiles);
        clientSpec = this.changeClientSpecRoot(clientSpec);
        this.createClient(clientSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, InterruptedException {
        try {
            this.removeClient();
            if (this.doLogin) {
                this.logout();
                this.p4TicketsFile.delete();
            }
        }
        finally {
            this.isSetup = false;
            IO.delete(this.workDir);
        }
    }

    private void removeClient() throws IOException, InterruptedException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.p4Path);
        commandLine.add("-p");
        commandLine.add(this.port);
        commandLine.add("-u");
        commandLine.add(this.user);
        if (this.password != null && !this.doLogin) {
            commandLine.add("-P");
            commandLine.add(this.password);
        }
        commandLine.add("client");
        commandLine.add("-d");
        commandLine.add(this.clientName);
        this.handleProcess(this.execute(commandLine), null);
    }

    private String createClientSpec() throws IOException, InterruptedException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.p4Path);
        commandLine.add("-p");
        commandLine.add(this.port);
        commandLine.add("-u");
        commandLine.add(this.user);
        if (this.password != null && !this.doLogin) {
            commandLine.add("-P");
            commandLine.add(this.password);
        }
        commandLine.add("client");
        commandLine.add("-o");
        commandLine.add("-t");
        commandLine.add(this.template);
        commandLine.add(this.clientName);
        return this.handleProcess(this.execute(commandLine), null);
    }

    private void createClient(String clientSpec) throws IOException, InterruptedException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.p4Path);
        commandLine.add("-p");
        commandLine.add(this.port);
        commandLine.add("-u");
        commandLine.add(this.user);
        if (this.password != null && !this.doLogin) {
            commandLine.add("-P");
            commandLine.add(this.password);
        }
        commandLine.add("client");
        commandLine.add("-i");
        this.handleProcess(this.execute(commandLine), clientSpec);
    }

    private String changeClientSpecRoot(String clientSpec) {
        String[] tokens;
        StringBuilder builder = new StringBuilder();
        for (String token : tokens = clientSpec.split("\\r?\\n")) {
            if (token.startsWith("Root:")) {
                builder.append("Root:  ");
                builder.append(this.workDir.getAbsolutePath());
                builder.append("\n");
                continue;
            }
            builder.append(token);
            builder.append("\n");
        }
        return builder.toString();
    }

    public void setDepotFileLists(String clientSpec) {
        Pattern includesFilePattern = Pattern.compile("^\\+?(\"?)\\+?(\\/\\/.*?) \"?\\/\\/.*$");
        Pattern excludesFilePattern = Pattern.compile("^(\"?)-(\\/\\/.*?) \"?\\/\\/.*$");
        ArrayList<String> excludeFiles = new ArrayList<String>();
        ArrayList<String> includeFiles = new ArrayList<String>();
        List<String> mappingLines = this.getViewMappingFromClient(clientSpec);
        for (String mapping : mappingLines) {
            int i;
            StringBuilder builder = new StringBuilder();
            Matcher matcher = includesFilePattern.matcher(mapping);
            if (matcher.find()) {
                for (i = 1; i <= matcher.groupCount(); ++i) {
                    builder.append(matcher.group(i));
                }
                includeFiles.add(builder.toString());
            }
            if (!(matcher = excludesFilePattern.matcher(mapping)).find()) continue;
            for (i = 1; i <= matcher.groupCount(); ++i) {
                builder.append(matcher.group(i));
            }
            excludeFiles.add(builder.toString());
        }
        this.excludeFiles = excludeFiles;
        this.indcludeFiles = includeFiles;
    }

    public List<String> getViewMappingFromClient(String clientSpec) {
        boolean insideViewSection = false;
        String[] lines = clientSpec.split("\n");
        ArrayList<String> mappingLines = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.startsWith("#")) continue;
            if (insideViewSection) {
                mappingLines.add(line);
                continue;
            }
            if (!line.startsWith("View:")) continue;
            insideViewSection = true;
        }
        return mappingLines;
    }

    private void login() throws IOException, InterruptedException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.p4Path);
        commandLine.add("-p");
        commandLine.add(this.port);
        commandLine.add("-u");
        commandLine.add(this.user);
        commandLine.add("login");
        this.handleProcess(this.execute(commandLine), this.password);
    }

    private void logout() throws IOException, InterruptedException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.p4Path);
        commandLine.add("-p");
        commandLine.add(this.port);
        commandLine.add("-u");
        commandLine.add(this.user);
        commandLine.add("logout");
        this.handleProcess(this.execute(commandLine), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleProcess(Process process, String input) throws IOException, InterruptedException {
        String result;
        try {
            Future<String> errorFuture = this.processes.getErrorStringFuture(process);
            Future<String> outputFuture = this.processes.getOutputStringFuture(process);
            if (input != null && input.length() > 0) {
                process.getOutputStream().write(input.getBytes());
            }
            process.getOutputStream().close();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                String errorText = "";
                try {
                    errorText = errorFuture.get();
                }
                catch (ExecutionException swallow) {
                    // empty catch block
                }
                throw new IOException(String.format("Command failed with code %d: %s", exitCode, errorText));
            }
            try {
                result = outputFuture.get();
            }
            catch (ExecutionException e) {
                throw (IOException)new IOException().initCause(e.getCause());
            }
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)("Command output: " + outputFuture.get()));
                    log.debug((Object)("Command error: " + errorFuture.get()));
                }
                catch (ExecutionException swallow) {
                    // empty catch block
                }
            }
        }
        finally {
            process.destroy();
        }
        return result;
    }

    private Process execute(List<String> commandLine) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Command Line :" + commandLine.toString().replace(this.password, "****")));
        }
        ProcessBuilder builder = new ProcessBuilder(commandLine);
        if (this.p4TicketsFile != null) {
            builder.environment().put("P4TICKETS", this.p4TicketsFile.getAbsolutePath());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set P4TICKETS=" + this.p4TicketsFile.getAbsolutePath()));
            }
        }
        builder.directory(this.workDir);
        return builder.start();
    }

    private File newPath() throws IOException {
        return new File(new File("."), UUID.randomUUID().toString());
    }

    private String newClientName() {
        return "IBM_UCD-" + UUID.randomUUID().toString();
    }

    private String trimToNull(String text) {
        String result = text;
        if (result != null && (result = result.trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    private void assertSetup() throws IOException, InterruptedException {
        if (!this.isSetup) {
            this.setup();
            this.isSetup = true;
        }
    }

    private Integer getLastestVersionForFile(String file) throws IOException, InterruptedException {
        Integer result = null;
        List<Integer> fileChanges = this.getChangesForFile(file, 1);
        if (fileChanges.size() > 0) {
            result = fileChanges.get(0);
        }
        return result;
    }

    private List<Integer> getChangesForFile(String file, int numberOfChanges) throws IOException, InterruptedException {
        String[] changeList;
        ArrayList<Integer> result = new ArrayList<Integer>();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.p4Path);
        commandLine.add("-p");
        commandLine.add(this.port);
        commandLine.add("-u");
        commandLine.add(this.user);
        if (this.password != null && !this.doLogin) {
            commandLine.add("-P");
            commandLine.add(this.password);
        }
        commandLine.add("changes");
        if (numberOfChanges > 0) {
            commandLine.add("-m");
            commandLine.add("1");
        }
        commandLine.add(file);
        String output = this.handleProcess(this.execute(commandLine), null);
        for (String change : changeList = output.split("\\n")) {
            Pattern pattern = Pattern.compile("^Change (\\d+) ");
            Matcher matcher = pattern.matcher(change);
            if (!matcher.find()) continue;
            result.add(Integer.parseInt(matcher.group(1)));
        }
        return result;
    }

    public List<String> getIncludePaths() {
        return this.indcludeFiles;
    }

    public List<String> getExcludePaths() {
        return this.excludeFiles;
    }

    public List<String> clone(List<String> list) {
        ArrayList<String> clone = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            clone.add(list.get(i));
        }
        return clone;
    }

    public List<Integer> getAllVersions() throws IOException, InterruptedException {
        ArrayList<Integer> versionList = new ArrayList<Integer>();
        this.assertSetup();
        HashSet<Integer> versions = new HashSet<Integer>();
        for (String file : this.indcludeFiles) {
            versions.addAll(this.getChangesForFile(file, 0));
        }
        versionList.addAll(versions);
        Collections.sort(versionList);
        return versionList;
    }

    private Integer getLatestVersionWithChangeNotExcluded(List<Integer> versions) throws IOException, InterruptedException {
        Integer version = versions.remove(versions.size() - 1);
        while (!this.changesExist(version)) {
            if (versions.isEmpty()) {
                throw new IOException("No changes exist in this perforce template");
            }
            version = versions.remove(versions.size() - 1);
        }
        return version;
    }

    public boolean changesExist(Integer version) throws IOException, InterruptedException {
        String description = this.getChangeDescription(version);
        List<String> changedFiles = this.getChangedFilesFromDescription(description);
        boolean isExcluded = false;
        for (String file : changedFiles) {
            Matcher m = this.excludedFilesPattern.matcher(file);
            if (m.matches()) continue;
            isExcluded = true;
            break;
        }
        return isExcluded;
    }

    public Pattern convertToPattern(List<String> files) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < files.size(); ++i) {
            if (i > 0) {
                builder.append("|");
            }
            String pattern = files.get(i);
            pattern.replaceAll("%%[1-9]", "*");
            pattern = pattern.replace("*", "[^\\/^*]*");
            pattern = pattern.replace("...", ".*");
            pattern = pattern.replace("/", "\\/");
            builder.append(pattern);
        }
        return Pattern.compile(builder.toString());
    }

    public List<String> getChangedFilesFromDescription(String changeDescription) {
        boolean inAffectedFilepaths = false;
        Pattern changedFilePattern = Pattern.compile("\\.{3} (.*)#.*");
        String[] descriptionLines = changeDescription.split("\n");
        ArrayList<String> changedFilePaths = new ArrayList<String>();
        for (int i = 0; i < descriptionLines.length; ++i) {
            String line = descriptionLines[i].trim();
            if (inAffectedFilepaths) {
                Matcher matcher = changedFilePattern.matcher(line);
                if (matcher.find()) {
                    changedFilePaths.add(matcher.group(1));
                } else {
                    if (line.isEmpty()) continue;
                    inAffectedFilepaths = false;
                }
            }
            if (!line.contains("Affected files ...")) continue;
            inAffectedFilepaths = true;
        }
        return changedFilePaths;
    }

    private String getChangeDescription(Integer change) throws IOException, InterruptedException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.p4Path);
        commandLine.add("-p");
        commandLine.add(this.port);
        commandLine.add("-u");
        commandLine.add(this.user);
        if (this.password != null && !this.doLogin) {
            commandLine.add("-P");
            commandLine.add(this.password);
        }
        commandLine.add("describe");
        commandLine.add("-s");
        commandLine.add(String.valueOf(change));
        return this.handleProcess(this.execute(commandLine), null);
    }
}

