/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.PerforceClient;
import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int returnCode = 0;
        File repoDir = null;
        try {
            Properties props = new Properties();
            props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
            PropertyConfigurator.configure((Properties)props);
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String charsetName = agentProps.getProperty("system.default.encoding");
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            String extensionString = this.inputProperties.getProperty("extensions");
            String[] extensions = new String[]{};
            if (extensionString != null) {
                extensions = extensionString.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
            }
            String componentName = this.inputProperties.getProperty("componentName");
            String port = this.inputProperties.getProperty("port");
            String template = this.inputProperties.getProperty("template");
            String perforceUsername = this.inputProperties.getProperty("user");
            String perforcePassword = this.inputProperties.getProperty("password");
            String p4Path = this.inputProperties.getProperty("p4Path");
            boolean doLoginAndLogout = Boolean.valueOf(this.inputProperties.getProperty("doLogin"));
            boolean saveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
            String[] includes = new String[]{"**/*"};
            String[] excludes = new String[]{};
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            String username = "PasswordIsAuthToken";
            String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI url = new URI(webUrl);
            VersionClient versionClient = new VersionClient(url, username, password);
            ComponentClient componentClient = new ComponentClient(url, username, password);
            PerforceClient perforceClient = new PerforceClient(p4Path, port, perforceUsername, perforcePassword, template, doLoginAndLogout);
            String p4Version = perforceClient.getLatestVersion();
            List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
            boolean hasVersion = versions.contains(p4Version);
            System.out.println(String.format("Version from perforce: %s", p4Version));
            if (!hasVersion) {
                System.out.println(String.format("Creating version: %s", p4Version));
                String versionId = versionClient.createVersion(componentName, p4Version, " ", true).toString();
                this.outputProperties.setProperty("VersionID", versionId);
                if (isUseVFS) {
                    repoDir = perforceClient.downloadFiles(p4Version);
                    System.out.println("Uploading artifact files.");
                    versionClient.addVersionFiles(componentName, p4Version, repoDir, "", includes, excludes, saveExecutePermissions, true, charset, extensions);
                } else {
                    System.out.println("Skipping Artifact Upload: Component is configured not to use codestation.");
                }
                versionClient.markImportFinished(componentName, versionId);
            } else {
                System.out.println(String.format("Component Already Has Version: %s", p4Version));
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Error Creating New Version: %s", e.getMessage()));
            e.printStackTrace();
            returnCode = 1;
        }
        finally {
            if (repoDir != null && repoDir.exists()) {
                FileUtils.deleteFile((File)repoDir);
            }
        }
        return returnCode;
    }
}

