/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.processes.Processes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PvcsClient {
    private static final Logger log = Logger.getLogger(PvcsClient.class);
    final String pcliPath;
    final String databasePath;
    final String basePath;
    final String projectPath;
    final String archivePath;
    final String id;
    final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy:HH:mm:ss");

    public PvcsClient(String pcliPath, String databasePath, String basePath, String projectPath, String archivePath, String user, String password) {
        this.pcliPath = pcliPath;
        this.databasePath = databasePath;
        this.basePath = basePath;
        this.projectPath = projectPath;
        this.archivePath = archivePath;
        this.id = user != null && user.length() > 0 ? (password != null && password.length() > 0 ? user + ":" + password : user) : null;
    }

    public String getLatestVersion() {
        return this.dateFormat.format(new Date());
    }

    public File downloadFilesDateString(String dateString) throws IOException {
        Date date;
        try {
            date = this.dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            throw (IOException)new IOException("Invalid date string").initCause(e);
        }
        return this.downloadFilesDate(date);
    }

    public File downloadFilesDate(Date date) throws IOException {
        File result = this.getTempFile();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.pcliPath);
        command.add("Get");
        command.add("-q");
        command.add("-y");
        command.add("-o");
        command.add("-bp" + this.basePath);
        command.add("-z");
        if (this.id != null) {
            command.add("-id" + this.id);
        }
        command.add("-pr" + this.databasePath);
        command.add("-d" + this.dateFormat.format(date));
        command.add("-a" + result.getAbsolutePath());
        command.add("/" + this.scrub(this.projectPath));
        this.runCommand(command);
        return result;
    }

    public File downloadFilesLabel(String label) throws IOException {
        File result = this.getTempFile();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.pcliPath);
        command.add("Get");
        command.add("-q");
        command.add("-y");
        command.add("-o");
        command.add("-bp" + this.basePath);
        command.add("-z");
        if (this.id != null) {
            command.add("-id" + this.id);
        }
        command.add("-pr" + this.databasePath);
        command.add("-r" + label);
        command.add("-a" + result.getAbsolutePath());
        command.add("/" + this.scrub(this.projectPath));
        this.runCommand(command);
        return result;
    }

    public File downloadFilesBranch(String branch) throws IOException {
        return this.downloadFilesLabel(branch);
    }

    public File downloadFilesPromotionGroup(String promotionGroup) throws IOException {
        File result = this.getTempFile();
        File temp = this.getPromotedFiles(promotionGroup);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.pcliPath);
        command.add("Get");
        command.add("-q");
        command.add("-y");
        command.add("-o");
        command.add("-bp" + this.basePath);
        command.add("-z");
        if (this.id != null) {
            command.add("-id" + this.id);
        }
        command.add("-pr" + this.databasePath);
        command.add("-g" + promotionGroup);
        command.add("-a" + result.getAbsolutePath());
        command.add("@" + temp.getAbsolutePath());
        this.runCommand(command);
        try {
            IO.delete(temp);
        }
        catch (IOException e) {
            log.warn("Unable to delete file " + temp.getAbsolutePath());
        }
        return result;
    }

    public File downloadFilesLatest() throws IOException {
        File result = this.getTempFile();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.pcliPath);
        command.add("Get");
        command.add("-q");
        command.add("-y");
        command.add("-o");
        command.add("-bp" + this.basePath);
        command.add("-z");
        if (this.id != null) {
            command.add("-id" + this.id);
        }
        command.add("-pr" + this.databasePath);
        command.add("-a" + result.getAbsolutePath());
        command.add("/" + this.scrub(this.projectPath));
        this.runCommand(command);
        return result;
    }

    private void runCommand(List<String> command) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            IO.copy(process.getInputStream(), IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("PVCS error: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    private File getTempFile() {
        return new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
    }

    private File getPromotedFiles(String promotionGroup) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.pcliPath);
        command.add("run");
        command.add("-ns");
        command.add("-q");
        command.add("vlog");
        command.add("-bg" + promotionGroup);
        if (this.id != null) {
            command.add("-id" + this.id);
        }
        command.add("-pr" + this.databasePath);
        command.add("-z");
        command.add("/" + this.scrub(this.projectPath));
        return this.runGetPromotionGroupFiles(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File runGetPromotionGroupFiles(List<String> command) throws IOException {
        File tempFile = this.getTempFile();
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            BufferedReader in = IO.buffer(IO.reader(process.getInputStream()));
            try {
                PrintStream out = IO.printer(IO.buffer(new FileOutputStream(tempFile)));
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        String path = this.extractPath(line);
                        out.println(path);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("PVCS error: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return tempFile;
    }

    private String extractPath(String line) {
        String prefix = this.getArchivePrefix();
        String result = this.scrub(line);
        if (!result.toLowerCase().startsWith(prefix.toLowerCase())) {
            throw new RuntimeException("Unable to parse line \"" + line + "\". Expected prefix \"" + prefix + "\".");
        }
        result = result.substring(prefix.length());
        int versionOffset = result.lastIndexOf(" : ");
        int groupOffset = result.lastIndexOf(" - ", versionOffset);
        if (versionOffset == -1 || groupOffset == -1) {
            throw new RuntimeException("Unable to parse line \"" + line + "\". Can't find group or version tokens.");
        }
        if (!(result = result.substring(0, groupOffset)).endsWith("-arc")) {
            throw new RuntimeException("Unable to parse line \"" + line + "\". Can't find -arc token.");
        }
        result = result.substring(0, result.length() - "-arc".length());
        return result;
    }

    private String getArchivePrefix() {
        return this.scrub(this.databasePath) + "/" + this.scrub(this.archivePath);
    }

    private String scrub(String string) {
        string = string.replace('\\', '/');
        string = string.replaceAll("/+", "/");
        string = string.replaceAll("^/", "");
        string = string.replaceAll("/$", "");
        return string;
    }
}

