/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import com.ibm.ram.common.data.exception.RAMException;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.access.ws.Constants;
import com.ibm.ram.internal.access.ws.RAM1;
import com.ibm.ram.internal.client.AbstractRESTClient;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.common.util.WriteServerDataCallback;
import com.ibm.ram.io.zip.ZipEntry;
import com.ibm.ram.io.zip.ZipFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class AbstractRAMClient {
    public static Level ERROR_LOG_LEVEL_DEFAULT = Level.WARN;
    public Level ERROR_LOG_LEVEL = ERROR_LOG_LEVEL_DEFAULT;
    public static final String DEFAULT_HTTP_ERROR_MESSAGE = "Error in transport medium trying to communicate with server";
    public static final int TIMEOUT_NEVER = 0;
    public static final int TIMEOUT_DEFAULT_HTTP = 120000;
    public static final String CLIENT_LOGOUT_PARM_NAME = "clientLogout";
    protected static Constants webServiceConstants = null;
    public static String RICH_CLIENT_VERSION_70 = "10.0.0.0";
    public static String RICH_CLIENT_VERSION_71 = "11.0.0.0";
    public static String RICH_CLIENT_VERSION_7101 = "11.0.1.0";
    public static String RICH_CLIENT_VERSION_711 = "11.1.0.0";
    public static String RICH_CLIENT_VERSION_7111 = "11.1.0.1";
    public static String RICH_CLIENT_VERSION_72 = "12.0.0.0";
    public static String RICH_CLIENT_VERSION_7201 = "12.0.0.1";
    public static String RICH_CLIENT_VERSION_7202 = "12.0.0.2";
    public static String RICH_CLIENT_VERSION_7500 = "15.0.0.0";
    public static String RICH_CLIENT_VERSION_7501 = "15.0.0.1";
    public static String RICH_CLIENT_VERSION_7502 = "15.0.0.2";
    public static String RICH_CLIENT_VERSION_751 = "15.1.0.0";
    public static String RICH_CLIENT_VERSION_7511 = "15.1.1.0";
    public static String RICH_CLIENT_VERSION_752 = "15.1.1.1";
    public static String RICH_CLIENT_VERSION_7521;
    public static String RICH_CLIENT_VERSION_CURRENT;
    protected static Map<String, String> serviceToProductVersionMap;
    protected static Map<String, ServerVersion> serviceToServerReleaseVersion;
    public boolean isAnonymous;

    static {
        RICH_CLIENT_VERSION_CURRENT = RICH_CLIENT_VERSION_7521 = "15.1.1.2";
        serviceToProductVersionMap = new HashMap<String, String>();
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_70, "v7.0.0.0");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_71, "v7.1.0.0");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7101, "v7.1.0.1");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_711, "v7.1.1.0");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7111, "v7.1.1.1");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_72, "v7.2.0.0");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7201, "v7.2.0.1");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7202, "v7.2.0.2");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7500, "v7.5.0.0");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7501, "v7.5.0.1");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7502, "v7.5.0.2");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_751, "v7.5.1");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7511, "v7.5.1.1");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_752, "v7.5.2.0");
        serviceToProductVersionMap.put(RICH_CLIENT_VERSION_7521, "v7.5.2.1");
        serviceToServerReleaseVersion = new HashMap<String, ServerVersion>();
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_70, ServerVersion.VERSION_70);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_71, ServerVersion.VERSION_71);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7101, ServerVersion.VERSION_71);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_711, ServerVersion.VERSION_711);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7111, ServerVersion.VERSION_711);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_72, ServerVersion.VERSION_72);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7201, ServerVersion.VERSION_72);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7202, ServerVersion.VERSION_72);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7500, ServerVersion.VERSION_75);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7501, ServerVersion.VERSION_75);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7502, ServerVersion.VERSION_75);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_751, ServerVersion.VERSION_751);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7511, ServerVersion.VERSION_7511);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_752, ServerVersion.VERSION_752);
        serviceToServerReleaseVersion.put(RICH_CLIENT_VERSION_7521, ServerVersion.VERSION_7521);
    }

    public abstract boolean areClientsDisconnected();

    public abstract boolean disconnect(boolean var1, Runnable var2);

    public abstract boolean disconnect(Runnable var1);

    public abstract boolean disconnect();

    public abstract DownloadRequest download(String var1) throws RAMServiceException;

    public abstract DownloadRequest downloadAsset(URL var1, boolean var2) throws RAMServiceException;

    public abstract URL getArtifactDownloadURL(String var1, String var2, String var3, boolean var4) throws MalformedURLException, RAMServiceException;

    public abstract URL getAssetDownloadURL(String var1, String var2, boolean var3) throws MalformedURLException, RAMServiceException;

    public abstract InputStream getInputStream(URL var1) throws IOException, RAMServiceException;

    public abstract InputStream getInputStream(URL var1, WriteServerDataCallback var2) throws IOException, RAMServiceException;

    public abstract String getOnBehalfOfUserID();

    public abstract RAM1 getRAM1Webservice() throws RAMServiceException;

    public abstract AbstractRESTClient getRestClient() throws RAMServiceException;

    public abstract ServerVersion getServerVersion() throws RAMServiceException;

    public abstract String getServerVersionString() throws RemoteException, RAMServiceException, RAMException;

    public abstract Response getURL(URL var1, boolean var2, int var3) throws IOException, RAMServiceException;

    public abstract int getUploadDownloadTimeout();

    public abstract String getUserName();

    public abstract String getWebServerPath();

    public abstract String getWebServicesPath();

    public abstract Constants getWebServiceConstants() throws RAMException, RemoteException, MalformedURLException, RAMServiceException;

    public abstract int getWebServicesTimeout();

    public abstract void setUploadDownloadTimeout(int var1);

    public abstract void setWebServicesTimeout(int var1);

    public abstract UploadResponse uploadAsset(String var1, File var2, int var3, String var4, String var5, boolean var6, boolean var7, String var8, String var9, String var10, boolean var11, boolean var12, boolean var13, String[] var14, int var15, boolean var16, IUploadProgress var17) throws RAMServiceException, FileNotFoundException;

    public abstract String[] copySchemasToLocalOS(String[] var1, File var2) throws IOException, RAMRuntimeException;

    public abstract ResourceSet createCachedResourceSet(Map var1, File var2);

    public abstract String getStatusText(int var1);

    public abstract void initialize() throws RAMServiceException;

    public UploadResponse uploadAsset(String serializedAsset, File artifacts, int assetGroupID, String stateOption, String userAssetTags, boolean isDelta, boolean isUpdate, String updateComment, String updateOriginalGUID, String updateOriginalVersion, boolean keepOlderAssetVersion, boolean updatePendingAsset, boolean overrideValidation, String[] newOwnerIDs, int managementStyle, IUploadProgress uploadProgressMonitor) throws RAMServiceException, FileNotFoundException {
        return this.uploadAsset(serializedAsset, artifacts, assetGroupID, stateOption, userAssetTags, isDelta, isUpdate, updateComment, updateOriginalGUID, updateOriginalVersion, keepOlderAssetVersion, updatePendingAsset, overrideValidation, newOwnerIDs, managementStyle, false, uploadProgressMonitor);
    }

    public UploadResponse uploadAsset(File zippedFile, int assetGroupID, String stateOption, String userAssetTags, boolean isDelta, boolean isUpdate, String updateComment, String updateOriginalGUID, String updateOriginalVersion, boolean keepOlderAssetVersion, boolean updatePendingAsset, String[] newOwnerIDs, IUploadProgress uploadProgressMonitor) throws RAMServiceException, FileNotFoundException {
        return this.uploadAsset(zippedFile, assetGroupID, stateOption, userAssetTags, isDelta, isUpdate, updateComment, updateOriginalGUID, updateOriginalVersion, keepOlderAssetVersion, updatePendingAsset, newOwnerIDs, false, uploadProgressMonitor);
    }

    public UploadResponse uploadAsset(File zippedFile, int assetGroupID, String stateOption, String userAssetTags, boolean isDelta, boolean isUpdate, String updateComment, String updateOriginalGUID, String updateOriginalVersion, boolean keepOlderAssetVersion, boolean updatePendingAsset, String[] newOwnerIDs, boolean isTagOnly, IUploadProgress uploadProgressMonitor) throws RAMServiceException, FileNotFoundException {
        try {
            String serializedAsset = this.getAssetManifest(zippedFile);
            return this.uploadAsset(serializedAsset, zippedFile, assetGroupID, stateOption, userAssetTags, isDelta, isUpdate, updateComment, updateOriginalGUID, updateOriginalVersion, keepOlderAssetVersion, updatePendingAsset, false, newOwnerIDs, 0, isTagOnly, uploadProgressMonitor);
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message == null) {
                message = DEFAULT_HTTP_ERROR_MESSAGE;
            }
            throw new RAMServiceException(10002, message, e);
        }
    }

    private String getAssetManifest(File assetFile) throws IOException {
        ZipFile zipFile = new ZipFile(assetFile);
        ZipEntry manifestEntry = zipFile.getEntry("manifest.rmd");
        InputStream is = zipFile.getInputStream(manifestEntry);
        InputStreamReader reader = new InputStreamReader(is, "UTF-8");
        StringBuffer buff = new StringBuffer();
        char[] content = new char[4096];
        int read = reader.read(content);
        while (read > -1) {
            buff.append(content, 0, read);
            read = reader.read(content);
        }
        is.close();
        return buff.toString();
    }

    public abstract Response downloadArtifact(String var1, String var2, String var3, boolean var4) throws IOException, RAMServiceException;

    public abstract InputStream getInputStream(String var1, String var2, boolean var3) throws IOException, RAMServiceException;

    public abstract void cleanResourceSet(ResourceSet var1);

    public boolean isServerVersionCompatible(ServerVersion toThisVersion) {
        if (toThisVersion != null) {
            try {
                ServerVersion server = this.getServerVersion();
                return server != null && server.compareTo(toThisVersion) >= 0;
            }
            catch (RAMServiceException rAMServiceException) {
                return false;
            }
        }
        return false;
    }

    public static abstract class DownloadRequest {
        public abstract InputStream getInputStream() throws IOException;

        public abstract void releaseConnection();

        public abstract long getContentLength();

        public abstract RAMServiceException getException();
    }

    public static interface IUploadProgress {
        public void setProgress(int var1);

        public boolean isCanceled();
    }

    public static class Response {
        public InputStream is;
        public int code;
        public String message;
        public Map<String, String> headers;
        public List<String> cookies;
        public Object content;
    }

    public static enum ServerVersion {
        VERSION_70,
        VERSION_71,
        VERSION_711,
        VERSION_72,
        VERSION_75,
        VERSION_751,
        VERSION_7511,
        VERSION_752,
        VERSION_7521;

    }

    public static class UploadResponse {
        public int newRevisionCount;
        public boolean pendingAsset;
        public long lastModified = -1L;
    }
}

