/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.ucm.Component;
import java.util.ArrayList;

public class ListComponentsCommand
extends OutputCleartoolCommand {
    public static int MODE_INVOB = 0;
    public static int MODE_BYSELECTOR = 1;
    private static String KEY_OWNER = CleartoolCommandConstants.LSBL_OWNER;
    private static String KEY_GROUP = CleartoolCommandConstants.LSBL_GROUP;
    private static String KEY_ROOTDIR = CleartoolCommandConstants.LSCOMP_ROOTDIR;
    private String pvobPath = null;
    private String selector = null;
    private int mode = MODE_INVOB;

    public ListComponentsCommand(String pvobPath) {
        this.pvobPath = pvobPath;
    }

    public ListComponentsCommand(String selector, int mode) {
        this.mode = mode;
        if (mode == MODE_BYSELECTOR) {
            this.selector = selector;
        } else if (mode == MODE_INVOB) {
            this.pvobPath = selector;
        }
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (output != null && output.length() > 0) {
            String[] componentStrings = output.split("\r\n");
            int pc = 0;
            while (pc < componentStrings.length) {
                if (componentStrings[pc].trim().length() > 0 && componentStrings[pc].charAt(0) != ' ') {
                    String componentName = this.stripQuotes(componentStrings[pc]);
                    String componentRoot = null;
                    String owner = null;
                    String group = null;
                    String line = null;
                    ++pc;
                    while (pc < componentStrings.length && !componentStrings[pc].startsWith(CleartoolCommandConstants.BASELINE)) {
                        line = componentStrings[pc].trim();
                        if (line.startsWith(KEY_ROOTDIR)) {
                            componentRoot = line.substring(KEY_ROOTDIR.length()).trim();
                            componentRoot = this.stripQuotes(componentRoot);
                        } else if (line.startsWith(KEY_OWNER)) {
                            owner = line.substring(KEY_OWNER.length()).trim();
                        } else if (line.startsWith(KEY_GROUP)) {
                            group = line.substring(KEY_GROUP.length()).trim();
                        }
                        ++pc;
                    }
                    Component component = new Component();
                    component.setName(componentName);
                    component.setGroup(group);
                    component.setOwner(owner);
                    component.setRootdirectory(componentRoot);
                    component.setRootless(componentRoot.equals(Component.NONE));
                    components.add(component);
                }
                ++pc;
            }
        }
        final Component[] finalComponents = components.toArray(new Component[components.size()]);
        return new ListComponentsOutput(){

            @Override
            public Component[] getComponents() {
                return finalComponents;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        String[] args = null;
        if (this.mode == MODE_INVOB) {
            args = new String[]{"lscomp", "-long", "-invob", this.pvobPath};
        } else if (this.mode == MODE_BYSELECTOR) {
            args = new String[]{"lscomp", "-long", this.selector};
        }
        return args;
    }

    private String stripQuotes(String str) {
        String stripped = str.replace('\"', ' ');
        return stripped.trim();
    }

    public static interface ListComponentsOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public Component[] getComponents();
    }
}

