/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMCategory;
import com.ibm.ram.client.RAMQueryBuilder;
import com.ibm.ram.client.RAMSearchFilter;
import com.ibm.ram.client.RAMSearchFilterItem;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMSubCategory;
import com.ibm.ram.common.data.AssetRating;
import com.ibm.ram.common.data.AssetTag;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.SearchFilter;
import com.ibm.ram.common.data.SearchFilterItem;
import com.ibm.ram.common.data.State;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.exception.InvalidQueryException;
import com.ibm.ram.common.data.exception.RAMException;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.access.ws.Constants;
import com.ibm.ram.internal.client.AbstractRAMClient;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.common.data.FacetSelectionSO;
import com.ibm.ram.internal.common.data.SearchNode;
import com.ibm.ram.internal.common.data.SearchResultSO;
import com.ibm.ram.internal.common.util.FacetConverter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class RAMAssetQueryBuilder
extends RAMQueryBuilder {
    private List fFieldNames = new ArrayList();
    private List fFieldValues = new ArrayList();
    private Map fSearchFacetsByName = new HashMap();
    private List fSelectedFilterItems = new ArrayList();
    private String fSearchString;
    public String QUERY_FIELD_GUID;
    public String QUERY_FIELD_DATE;
    public String QUERY_FIELD_DBID;
    public String QUERY_FIELD_DESCRIPTION;
    public String QUERY_FIELD_NAME;
    public String QUERY_FIELD_OWNER;
    public String QUERY_FIELD_RATING;
    public String QUERY_FIELD_STATE;
    public String QUERY_FIELD_VERSION;
    public String QUERY_ATTRIBUTE_NAME;
    public String QUERY_ATTRIBUTE_VALUE;
    public String QUERY_FIELD_ATTRIBUTE;
    public String SORT_BY_FIELD_COMMUNITY_NAME;
    public String SORT_BY_FIELD_LAST_MODIFIED;
    public String SORT_BY_FIELD_NAME;
    public String SORT_BY_FIELD_GUID;
    public String SORT_BY_FIELD_RATING;
    public String SORT_BY_FIELD_RELEVANCE;
    public String SORT_BY_FIELD_STATE;
    public String SORT_BY_FIELD_VERSION;

    RAMAssetQueryBuilder(RAMSession session, Constants constants) {
        super(session);
        this.QUERY_FIELD_GUID = constants.getQUERY_GUID();
        this.QUERY_FIELD_DATE = constants.getQUERY_DATE();
        this.QUERY_FIELD_DBID = constants.getQUERY_DBID();
        this.QUERY_FIELD_DESCRIPTION = constants.getQUERY_DESCRIPTION();
        this.QUERY_FIELD_NAME = constants.getQUERY_NAME();
        this.QUERY_FIELD_OWNER = constants.getQUERY_OWNER();
        this.QUERY_FIELD_RATING = constants.getQUERY_RATING();
        this.QUERY_FIELD_STATE = constants.getQUERY_STATE();
        this.QUERY_FIELD_VERSION = constants.getQUERY_VERSION();
        this.QUERY_ATTRIBUTE_NAME = constants.getQUERY_ATTRIBUTE_NAME();
        this.QUERY_ATTRIBUTE_VALUE = constants.getQUERY_ATTRIBUTE_VALUE();
        this.QUERY_FIELD_ATTRIBUTE = "attribute";
        this.SORT_BY_FIELD_COMMUNITY_NAME = constants.getSORT_GROUP();
        this.SORT_BY_FIELD_LAST_MODIFIED = constants.getSORT_LAST_MODIFIED();
        this.SORT_BY_FIELD_NAME = constants.getSORT_NAME();
        this.SORT_BY_FIELD_GUID = constants.getSORT_ID();
        this.SORT_BY_FIELD_RATING = constants.getSORT_RATING();
        this.SORT_BY_FIELD_RELEVANCE = constants.getSORT_RELEVANCE();
        this.SORT_BY_FIELD_STATE = constants.getSORT_STATE();
        this.SORT_BY_FIELD_VERSION = constants.getSORT_VERSION();
    }

    public RAMAssetQueryBuilder(RAMSession session) {
        this(session, session.getConstants());
    }

    public void addQueryTextField(String queryText) {
        this.invalidateQuery();
        this.fFieldNames.add(this.QUERY_FIELD_TEXT);
        this.fFieldValues.add(queryText);
    }

    public void addQueryField(String queryField, String value) {
        this.invalidateQuery();
        this.fFieldNames.add(queryField);
        this.fFieldValues.add(value);
    }

    public void clearQueryFields() {
        this.fFieldNames.clear();
        this.fFieldValues.clear();
        this.invalidateQuery();
    }

    public void clearSearchFilters() {
        this.fSearchFacetsByName.clear();
        this.fSelectedFilterItems.clear();
        this.invalidateQuery();
    }

    @Override
    public String getQueryString() {
        if (this.fSearchString == null) {
            if (this.fFieldNames == null || this.fFieldValues == null) {
                this.fSearchString = "";
            } else {
                ArrayList<String> textSearches = new ArrayList<String>();
                ArrayList<FacetSelectionSO> searchFilters = new ArrayList<FacetSelectionSO>();
                StringBuffer buffer = new StringBuffer();
                boolean moreThanOneField = this.fFieldNames.size() > 1;
                int i = 0;
                while (i < this.fFieldNames.size()) {
                    String newField = this.createQueryField(this.fFieldNames.get(i), this.fFieldValues.get(i));
                    if (i > 0) {
                        if (this.isMatchAnyQueryField()) {
                            buffer.append(" || ");
                        } else {
                            buffer.append(" && ");
                        }
                    }
                    if (moreThanOneField) {
                        buffer.append("(");
                    }
                    buffer.append(newField);
                    if (moreThanOneField) {
                        buffer.append(")");
                    }
                    ++i;
                }
                String searchString = buffer.toString();
                if (!"".equals(searchString)) {
                    textSearches.add(searchString);
                }
                SearchFilterItem[] filters = this.getSelectedFilters();
                int i2 = 0;
                while (i2 < filters.length) {
                    FacetSelectionSO facet = new FacetSelectionSO(((RAMSearchFilterItem)filters[i2]).getFilterName(), filters[i2].getItemName());
                    searchFilters.add(facet);
                    ++i2;
                }
                SearchNode node = new SearchNode(textSearches, searchFilters, searchFilters, false, false, false);
                this.fSearchString = node.toString();
            }
        }
        return this.fSearchString;
    }

    public SearchFilterItem[] getSelectedFilters() {
        return this.fSelectedFilterItems.toArray(new SearchFilterItem[this.fSearchFacetsByName.size()]);
    }

    private String createQueryField(Object fieldName, Object feildValue) {
        StringBuffer newField = new StringBuffer();
        if (this.QUERY_FIELD_TEXT.equals(fieldName)) {
            newField.append(feildValue);
        } else {
            newField.append(fieldName);
            newField.append(":(");
            newField.append(feildValue);
            newField.append(")");
        }
        return newField.toString();
    }

    public String createQueryFieldText(String queryField, String value) {
        return this.createQueryField(queryField, value);
    }

    public RAMSearchFilter[] getAllSearchFilters() throws RAMRuntimeException {
        RAMSearchFilter[] ret;
        if (this.fSearchFacetsByName == null) {
            try {
                SearchFilter[] facets = this.fetchSearchFiltersFromTheServer();
                this.fSearchFacetsByName = new HashMap();
                ret = new RAMSearchFilter[facets.length];
                int i = 0;
                while (i < facets.length) {
                    ret[i] = new RAMSearchFilter(facets[i]);
                    this.fSearchFacetsByName.put(ret[i].getName(), ret[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        } else {
            Collection values = this.fSearchFacetsByName.values();
            ret = new RAMSearchFilter[values.size()];
            ret = values.toArray(ret);
        }
        return ret;
    }

    private SearchFilter[] fetchSearchFiltersFromTheServer() throws RemoteException, InvalidQueryException, RAMException, RAMServiceException {
        SearchResultSO results = this.getSession().getRAMClient().getRAM1Webservice().search(null, null, false, null, 0, 0, 0, false, this.getSession().getLocale().getLanguage());
        SearchFilter[] facets = results.getFacets();
        return facets;
    }

    public RAMSearchFilter getSearchFilter(String filterName) throws RAMRuntimeException {
        if (this.fSearchFacetsByName == null) {
            try {
                SearchFilter[] facets = this.fetchSearchFiltersFromTheServer();
                this.fSearchFacetsByName = new HashMap();
                int i = 0;
                while (i < facets.length) {
                    RAMSearchFilter filter = new RAMSearchFilter(facets[i]);
                    this.fSearchFacetsByName.put(filter.getName(), filter);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return (RAMSearchFilter)this.fSearchFacetsByName.get(filterName);
    }

    protected void addSearchFilter(SearchFilterItem searchFilterItem) {
        if (!this.fSelectedFilterItems.contains(searchFilterItem)) {
            this.fSelectedFilterItems.add(searchFilterItem);
        }
    }

    public void addSearchFilter(String filterName, String filterItem) {
        String value = "Classification".equals(filterName) || !FacetConverter.FACET_TITLE_KEY_MAP.keySet().contains(filterName) ? FacetConverter.convertCategoryFacetValue(filterItem) : FacetConverter.convertFacetValue(filterItem);
        this.addSearchFilter(new RAMSearchFilterItem(filterName, value));
    }

    public void addSearchFilter(CategorySchema categorySchema) {
        this.addSearchFilter("Classification", categorySchema.getName());
    }

    public void addSearchFilter(Category category, String categorization) {
        String categoryFacetName = FacetConverter.convertFacetName(category.getName());
        this.addSearchFilter(((RAMCategory)category).getSchema());
        if (!this.getSession().getRAMClient().isServerVersionCompatible(AbstractRAMClient.ServerVersion.VERSION_7511)) {
            if (categorization.contains("\\/")) {
                categorization = categorization.replaceAll("\\\\/", "*RAM INTERNAL FORWARD SLASH MARKER*");
            }
            StringTokenizer pathToker = new StringTokenizer(categorization, "/");
            while (pathToker.hasMoreTokens()) {
                String singleCategorization = pathToker.nextToken();
                if (singleCategorization.contains("\\\\")) {
                    singleCategorization = singleCategorization.replace("\\\\", "\\");
                }
                if (singleCategorization.contains("*RAM INTERNAL FORWARD SLASH MARKER*")) {
                    singleCategorization = singleCategorization.replace("*RAM INTERNAL FORWARD SLASH MARKER*", "/");
                }
                this.addSearchFilter(categoryFacetName, singleCategorization);
            }
        } else {
            SubCategory subcategory = category.getSubCategory(categorization);
            this.addSearchFilter(categoryFacetName, subcategory.getId());
        }
    }

    public void addSearchFilter(State state) {
        this.addSearchFilter("fState", state.getName());
    }

    public void addSearchFilter(AssetType assetType) {
        this.addSearchFilter("fType", assetType.getName());
    }

    public void addSearchFilter(CommunityInformation community) {
        this.addSearchFilter("fGroup", community.getName());
    }

    public void addSearchFilter(AssetTag tag) {
        this.addSearchFilter("fTag", tag.getTag());
    }

    public void addSearchFilter(AssetRating rating) {
        this.addSearchFilter("fRate", String.valueOf(rating.getRating()));
    }

    public void addSearchFilter(SubCategory subcategory) {
        this.addSearchFilter(((RAMSubCategory)subcategory).getCategory(), subcategory.getCategorization());
    }

    @Override
    protected void invalidateQuery() {
        this.fSearchString = null;
    }

    public String toString() {
        return this.getQueryString();
    }
}

