/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class RAMURLEncoder {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static String encode(String s, String encoding) throws UnsupportedEncodingException {
        if (s != null && s.length() > 0) {
            if (encoding == null) {
                encoding = DEFAULT_ENCODING;
            }
            s = URLEncoder.encode(s, encoding);
            s = s.replace("+", "%20");
        }
        return s;
    }

    public static String encode(String s) {
        try {
            return RAMURLEncoder.encode(s, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s;
        }
    }

    public static String encode(String s, char ... ignore) {
        s = RAMURLEncoder.encode(s);
        if (ignore != null) {
            char[] cArray = ignore;
            int n = ignore.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                String ignoreString = "%" + String.format("%1$02X", c & 0xFF);
                s = s.replace(ignoreString, Character.toString(c));
                ++n2;
            }
        }
        return s;
    }
}

