/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.data;

import com.ibm.ram.internal.common.data.Event;
import com.ibm.ram.internal.jaxb.EventConfiguration;
import com.ibm.ram.internal.jaxb.EventType;
import com.ibm.ram.internal.jaxb.PolicyConfiguration;
import com.ibm.ram.internal.jaxb.TimerUnit;
import java.util.ArrayList;
import java.util.List;

public class TimerEvent
extends Event {
    private List<PolicyConfiguration> policyConfigs;
    private static String CONFIG_DETAIL_ID_TIMER_UNIT = "timerUnit";
    private static String CONFIG_DETAIL_ID_TIMER_AMOUNT = "timerAmount";

    public TimerEvent() {
        super(EventType.TIMER, "Timer based event fired", "An event has been triggered after a length of time.");
    }

    public List<PolicyConfiguration> getPolicyConfigurations() {
        if (this.policyConfigs == null) {
            this.policyConfigs = new ArrayList<PolicyConfiguration>();
        }
        return this.policyConfigs;
    }

    public static int getTimerAmount(EventConfiguration eventConfig) {
        String val = TimerEvent.getConfigDetailValue(eventConfig, CONFIG_DETAIL_ID_TIMER_AMOUNT);
        int ret = 1;
        if (val != null) {
            ret = Integer.parseInt(val);
        }
        return ret;
    }

    public static int getTimerAmount(String date) {
        int ret = 1;
        if (date != null) {
            ret = Integer.parseInt(date);
        }
        return ret;
    }

    public static String getTimerValue(EventConfiguration eventConfig) {
        String val = TimerEvent.getConfigDetailValue(eventConfig, CONFIG_DETAIL_ID_TIMER_AMOUNT);
        return val;
    }

    public static void setTimerAmount(EventConfiguration eventConfig, int amt) {
        TimerEvent.setConfigDetailValue(eventConfig, CONFIG_DETAIL_ID_TIMER_AMOUNT, amt > 0 ? Integer.toString(amt) : null);
    }

    public static TimerUnit getTimerUnit(EventConfiguration eventConfig) {
        String val = TimerEvent.getConfigDetailValue(eventConfig, CONFIG_DETAIL_ID_TIMER_UNIT);
        TimerUnit ret = TimerUnit.DAY;
        if (val != null) {
            ret = TimerUnit.valueOf(val);
        }
        return ret;
    }

    public static void setTimerUnit(EventConfiguration eventConfig, TimerUnit unit) {
        TimerEvent.setConfigDetailValue(eventConfig, CONFIG_DETAIL_ID_TIMER_UNIT, unit != null ? unit.toString() : null);
    }
}

