/*
 * Decompiled with CFR 0.152.
 */
package org.oslc.asset.internal.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.oslc.asset.internal.query.InvalidQuerySyntax;
import org.oslc.asset.internal.query.Messages;
import org.oslc.asset.internal.query.ast.Eq;
import org.oslc.asset.internal.query.ast.Eqw;
import org.oslc.asset.internal.query.ast.Gt;
import org.oslc.asset.internal.query.ast.Gte;
import org.oslc.asset.internal.query.ast.In;
import org.oslc.asset.internal.query.ast.Lt;
import org.oslc.asset.internal.query.ast.Lte;
import org.oslc.asset.internal.query.ast.Ne;
import org.oslc.asset.internal.query.ast.Query;
import org.oslc.asset.internal.query.ast.Term;
import org.oslc.asset.internal.query.ast.Union;

public class SimpleQueryParser {
    private static final String S_UNION = "union";
    private static final String S_EQ = "=";
    private static final String S_NE = "!=";
    private static final String S_LT = "<";
    private static final String S_GT = ">";
    private static final String S_LTE = "<=";
    private static final String S_GTE = ">=";
    private static final String QNAME = "(([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?)(/([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?))*)";
    private static final Pattern Q_SORT = Pattern.compile("\\p{Space}*/\\p{Space}*sort\\p{Space}*=\\p{Space}*(([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?)(/([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?))*)$");
    private static final Pattern Q_LIMIT = Pattern.compile("\\p{Space}*/\\p{Space}*limit\\p{Space}*=\\p{Space}*(\\p{Digit}+)$");
    private static final Pattern Q_OFFSET = Pattern.compile("\\p{Space}*/\\p{Space}*offset\\p{Space}*=\\p{Space}*(\\p{Digit}+)$");
    private static final Pattern Q_CON = Pattern.compile("\\p{Space}+(and|union)\\p{Space}");
    private static final String Q_PROP = "(([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?)(/([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?))*)";
    private static final String Q_OPER = "\\p{Space}*(=|!=|<|>|<=|>=)\\p{Space}*";
    private static final String Q_VALUE = "(\\p{Digit}+|true|false|\"(\\\\\"|[^\"])*\"(\\^\\^dateTime)?|<[^>]*>)";
    private static final String Q_VALUE_LIST = "\\p{Space}*\\[\\p{Space}*(.+)\\p{Space}*\\]\\p{Space}*";
    private static final Pattern Q_TERM = Pattern.compile("^\\p{Space}*(([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?)(/([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?))*)\\p{Space}*(=|!=|<|>|<=|>=)\\p{Space}*(\\p{Digit}+|true|false|\"(\\\\\"|[^\"])*\"(\\^\\^dateTime)?|<[^>]*>)");
    private static final Pattern Q_IN_TERM = Pattern.compile("^\\p{Space}*(([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?)(/([\\p{Alnum}\\.\\-_]+(:[\\p{Alnum}\\.\\-_]+)?))*)\\p{Space}*(in)\\p{Space}*\\p{Space}*\\[\\p{Space}*(.+)\\p{Space}*\\]\\p{Space}*");
    private static final int G_CON = 1;
    private static final int G_PROP_NAME = 1;
    private static final int G_LIMIT_INT = 1;
    private static final int G_OFFSET_INT = 1;
    private static final int G_OPERATOR = 7;
    private static final int G_VALUE = 8;
    private static final String EX_BAD_OP = Messages.getString("app.query.exceptions.operator-error");
    private static final String EX_BAD_TERM = Messages.getString("app.query.exceptions.term-error");

    private static Term parseTerm(String term) {
        Term parsed = null;
        Matcher match = Q_TERM.matcher(term);
        if (match.find()) {
            String remainder;
            if (match.end() < term.length() && (remainder = term.substring(match.end()).trim()).length() > 0) {
                throw new InvalidQuerySyntax(String.format(EX_BAD_TERM, term));
            }
            String oper = match.group(7);
            String name = match.group(1);
            String value = match.group(8);
            Term.Datatype dt = null;
            if (value.endsWith("^^dateTime")) {
                value = value.substring(0, value.length() - 10);
                dt = Term.Datatype.dateTime;
            }
            if (oper.equals(S_EQ)) {
                parsed = value.endsWith("*\"") ? new Eqw(name, value) : new Eq(name, value);
            } else if (oper.equals(S_NE)) {
                parsed = new Ne(name, value);
            } else if (oper.equals(S_LT)) {
                parsed = new Lt(name, value);
            } else if (oper.equals(S_GT)) {
                parsed = new Gt(name, value);
            } else if (oper.equals(S_LTE)) {
                parsed = new Lte(name, value);
            } else if (oper.equals(S_GTE)) {
                parsed = new Gte(name, value);
            } else {
                throw new InvalidQuerySyntax(String.format(EX_BAD_OP, oper));
            }
            parsed.setDatatype(dt);
        } else {
            match = Q_IN_TERM.matcher(term);
            if (match.find()) {
                String[] items;
                String remainder;
                if (match.end() < term.length() && (remainder = term.substring(match.end()).trim()).length() > 0) {
                    throw new InvalidQuerySyntax(String.format(EX_BAD_TERM, term));
                }
                parsed = new In(match.group(1));
                String list = match.group(8);
                String[] stringArray = items = list.split("\\p{Space}*,\\p{Space}*");
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    parsed.addValue(value);
                    ++n2;
                }
            } else {
                throw new InvalidQuerySyntax(String.format(EX_BAD_TERM, term));
            }
        }
        return parsed;
    }

    public static Query parse(String queryString) throws InvalidQuerySyntax {
        Query ast = new Query();
        Matcher match = Q_OFFSET.matcher(queryString);
        while (match.find()) {
            queryString = queryString.substring(0, match.start());
            ast.setOffset(Integer.valueOf(match.group(1)));
        }
        match = Q_LIMIT.matcher(queryString);
        while (match.find()) {
            queryString = queryString.substring(0, match.start());
            ast.setLimit(Integer.valueOf(match.group(1)));
        }
        match = Q_SORT.matcher(queryString);
        while (match.find()) {
            queryString = queryString.substring(0, match.start());
            String sortProperty = match.group(1);
            if (sortProperty.startsWith("-")) {
                ast.setSortProperty(sortProperty.substring(1));
                ast.setSortOrder(Query.SortOrder.DESC);
                continue;
            }
            ast.setSortProperty(sortProperty);
            ast.setSortOrder(Query.SortOrder.ASC);
        }
        match = Q_CON.matcher(queryString);
        int start = 0;
        while (match.find()) {
            ast.add(SimpleQueryParser.parseTerm(queryString.substring(start, match.start())));
            if (match.group(1).equals(S_UNION)) {
                ast.add(new Union());
            }
            start = match.end();
        }
        ast.add(SimpleQueryParser.parseTerm(queryString.substring(start)));
        return ast;
    }
}

