/*
 * Decompiled with CFR 0.152.
 */
package org.oslc.asset.internal.v2;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.ibm.ram.common.util.AttributeConstants;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.internal.jaxb.AssetAttribute;
import com.ibm.ram.internal.jaxb.AssetType;
import com.ibm.ram.internal.jaxb.AttributeType;
import com.ibm.ram.internal.jaxb.AttributeValue;
import com.ibm.ram.internal.jaxb.Category;
import com.ibm.ram.internal.jaxb.Community;
import com.ibm.ram.internal.jaxb.atom.EntryType;
import com.ibm.ram.internal.jaxb.atom.FeedType;
import com.ibm.ram.internal.jaxb.atom.LinkType;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.rest.Request;
import com.ibm.ram.internal.rest.ServiceContributionResource;
import com.ibm.ram.internal.rest.trs.Base;
import com.ibm.ram.internal.rest.trs.ChangeEvent;
import com.ibm.ram.internal.rest.trs.ChangeLog;
import com.ibm.ram.internal.rest.trs.TrackedResourceSet;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.oslc.asset.internal.Artifact;
import org.oslc.asset.internal.Asset;
import org.oslc.asset.internal.Assets;
import org.oslc.asset.internal.CompactRendering;
import org.oslc.asset.internal.Dialog;
import org.oslc.asset.internal.Factory;
import org.oslc.asset.internal.ObjectFactory;
import org.oslc.asset.internal.Relation;
import org.oslc.asset.internal.ResourceRef;
import org.oslc.asset.internal.ServiceDescriptor;
import org.oslc.asset.internal.ServiceProviderCatalog;
import org.oslc.asset.internal.ServiceProviderEntry;
import org.oslc.asset.internal.Shapes;
import org.oslc.asset.internal.SimpleQuery;
import org.oslc.asset.internal.Tag;
import org.oslc.asset.internal.v2.OSLCVocabulary;
import org.oslc.asset.internal.v2.RelatedResource;
import org.oslc.asset.internal.v2.RelationshipUtil;

public class OSLCEncoder {
    public static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String BASE = "http://someserver/ram";
    public static final String ATTR_PREFIX = "classif/assetTypesSchema";
    private final Model model;
    private final Request request;
    private boolean renderAbbreviatedOutput = true;
    private ArrayList<Resource> prettyTypes;

    public OSLCEncoder(Request request, boolean renderAbbreviatedOutput) {
        this.renderAbbreviatedOutput = renderAbbreviatedOutput;
        this.model = ModelFactory.createDefaultModel();
        this.request = request;
        this.model.setNsPrefix("oslc", "http://open-services.net/ns/core#");
        this.model.setNsPrefix("oslc_asset", "http://open-services.net/ns/asset#");
        this.model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
    }

    public Model getModel() {
        return this.model;
    }

    public Resource encode(CompactRendering compact) {
        Resource resource = this.model.createResource(String.valueOf(compact.getBase()) + compact.getAbout(), OSLCVocabulary.Core.Compact);
        resource.addProperty(DCTerms.title, compact.getTitle());
        resource.addProperty(OSLCVocabulary.Core.icon, (RDFNode)this.model.createResource(compact.getIcon().getResource()));
        Resource previewRes = this.model.createResource(OSLCVocabulary.Core.Preview);
        previewRes.addProperty(OSLCVocabulary.Core.document, (RDFNode)this.model.createResource(compact.getSmallPreview().getResource()));
        previewRes.addProperty(OSLCVocabulary.Core.hintHeight, (RDFNode)this.model.createLiteral(String.valueOf(compact.getSmallPreview().getPreferredHeight())));
        previewRes.addProperty(OSLCVocabulary.Core.hintWidth, (RDFNode)this.model.createLiteral(String.valueOf(compact.getSmallPreview().getPreferredWidth())));
        resource.addProperty(OSLCVocabulary.Core.smallPreview, (RDFNode)previewRes);
        return resource;
    }

    public Resource encode(ServiceProviderCatalog catalog) {
        Resource resource = this.model.createResource(String.valueOf(catalog.getBase()) + catalog.getAbout(), OSLCVocabulary.Core.ServiceProviderCatalog);
        resource.addProperty(DCTerms.title, catalog.getTitle());
        if (catalog.getEntries() != null) {
            for (ServiceProviderEntry serviceProviderResource : catalog.getEntries()) {
                resource.addProperty(OSLCVocabulary.Core.serviceProvider, (RDFNode)this.encode(serviceProviderResource, catalog.getBase()));
            }
        }
        return resource;
    }

    public Resource encode(ServiceProviderEntry provider, String base) {
        Resource resource = this.model.createResource(String.valueOf(base) + provider.getServiceProvider().getServices().getResource(), OSLCVocabulary.Core.ServiceProvider);
        resource.addProperty(DCTerms.title, provider.getServiceProvider().getTitle());
        return resource;
    }

    public Resource encode(ServiceDescriptor serviceDescriptor) {
        Resource resource = this.model.createResource(String.valueOf(serviceDescriptor.getBase()) + serviceDescriptor.getAbout(), OSLCVocabulary.Core.ServiceProvider);
        resource.addProperty(DCTerms.title, serviceDescriptor.getTitle());
        resource.addProperty(DCTerms.description, serviceDescriptor.getDescription());
        Resource publisher = this.model.createResource(String.valueOf(serviceDescriptor.getBase()) + serviceDescriptor.getContributor().getIdentifier(), OSLCVocabulary.Core.Publisher);
        publisher.addProperty(DCTerms.title, serviceDescriptor.getContributor().getTitle());
        publisher.addProperty(DCTerms.identifier, serviceDescriptor.getContributor().getIdentifier());
        publisher.addProperty(OSLCVocabulary.Core.icon, (RDFNode)this.model.createResource(String.valueOf(serviceDescriptor.getBase()) + serviceDescriptor.getContributor().getIcon()));
        resource.addProperty(DCTerms.publisher, (RDFNode)publisher);
        resource.addProperty(OSLCVocabulary.Core.service, (RDFNode)this.encode(serviceDescriptor.getAssets(), serviceDescriptor.getBase()));
        return resource;
    }

    public void encode(ServiceContributionResource scr) {
        for (ServiceContributionResource.Application app : scr.getApplications()) {
            this.model.setNsPrefix("jd", "http://jazz.net/xmlns/prod/jazz/discovery/1.0/");
            Resource appResource = this.model.createResource(OSLCVocabulary.JazzDiscovery.Application);
            appResource.addProperty(OSLCVocabulary.JazzDiscovery.contextRoot, app.getContextRoot());
            appResource.addProperty(OSLCVocabulary.JazzDiscovery.rootServices, app.getRootServices().getResource());
        }
        for (ServiceContributionResource.Service service : scr.getServices()) {
            if (!(service instanceof ServiceContributionResource.TrackedResourceSetService)) continue;
            this.model.setNsPrefix("trs", "http://jazz.net/ns/trs#");
            Resource svc = this.model.createResource(OSLCVocabulary.TRS.TrackedResourceSetProvider);
            svc.addProperty(OSLCVocabulary.TRS.trackedResourceSet, service.getLocation());
        }
    }

    public static String encode(Date date) {
        return new SimpleDateFormat(ISO_8601).format(date);
    }

    public Resource encode(Asset asset) {
        Resource assetResource = this.model.createResource(String.valueOf(asset.getBase()) + asset.getAbout(), OSLCVocabulary.Asset.Asset);
        if (asset.getTitle() != null) {
            assetResource.addProperty(DCTerms.title, asset.getTitle());
        }
        if (asset.getDescription() != null) {
            assetResource.addProperty(DCTerms.description, asset.getDescription());
        }
        if (asset.getSubject() != null) {
            assetResource.addProperty(DCTerms.abstract_, asset.getSubject());
        }
        if (asset.getContributors() != null) {
            for (ResourceRef contributor : asset.getContributors()) {
                assetResource.addProperty(DCTerms.contributor, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + contributor.getResource()));
            }
        }
        if (asset.getEtag() != null) {
            try {
                this.model.setNsPrefix("ram_asset", "http://jazz.net/xmlns/prod/ram/2.0/");
                int rc = Integer.parseInt(asset.getEtag());
                assetResource.addProperty(OSLCVocabulary.RAMAsset.revisionCount, Integer.toString(rc));
            }
            catch (Exception exception) {}
        }
        if (asset.getModified() != null) {
            assetResource.addProperty(DCTerms.modified, OSLCEncoder.encode(asset.getModified()));
        }
        if (asset.getType() != null) {
            assetResource.addProperty(DCTerms.type, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + asset.getType().getResource()));
            assetResource.addProperty(OSLCVocabulary.Core.instanceShape, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + asset.getType().getResource()));
        }
        if (asset.getRAMCommunity() != null) {
            this.model.setNsPrefix("ram_asset", "http://jazz.net/xmlns/prod/ram/2.0/");
            assetResource.addProperty(OSLCVocabulary.RAMAsset.community, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + asset.getRAMCommunity().getResource()));
        }
        if (asset.getId() != null) {
            assetResource.addProperty(OSLCVocabulary.Asset.guid, asset.getId().getGUID());
            assetResource.addProperty(OSLCVocabulary.Asset.version, asset.getId().getVersion());
        }
        if (asset.getDbid() != null) {
            assetResource.addProperty(DCTerms.identifier, Integer.toString(asset.getDbid()));
            this.model.setNsPrefix("acc", "http://jazz.net/ns/acp#");
            assetResource.addProperty(OSLCVocabulary.ACC.accessControl, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + "acc" + "/" + "assets" + "/" + asset.getDbid()));
        }
        if (asset.getState() != null) {
            assetResource.addProperty(OSLCVocabulary.Asset.state, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + asset.getState().getResource()));
        }
        if (asset.getRAMCategories() != null) {
            for (ResourceRef ref : asset.getRAMCategories()) {
                assetResource.addProperty(OSLCVocabulary.Asset.categorization, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + ref.getResource()));
            }
        }
        if (asset.getArtifacts() != null) {
            for (Artifact a : asset.getArtifacts()) {
                assetResource.addProperty(OSLCVocabulary.Asset.artifact, (RDFNode)this.encode(a, asset.getBase()));
            }
        }
        assetResource.addProperty(OSLCVocabulary.Core.serviceProvider, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + "oslc" + "/" + "assetServices"));
        if (asset.getArtifactFactory() != null) {
            assetResource.addProperty(OSLCVocabulary.Asset.artifactFactory, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + asset.getArtifactFactory().getResource()));
        }
        if (!asset.getTagsList().isEmpty()) {
            for (Tag tag : asset.getTagsList()) {
                assetResource.addProperty(OSLCVocabulary.RAMAsset.tag, tag.getValue());
            }
        }
        if (!asset.getRAMAttributeValues().isEmpty()) {
            String customPropertiesNSURL = MessageFormat.format("{0}custom_properties#", asset.getBase());
            this.model.setNsPrefix("ram_asset_custom_properties", customPropertiesNSURL);
            for (AttributeValue av : asset.getRAMAttributeValues()) {
                String attributeIdentifier = JAXBLinksUtil.getAttributeIdentifier(av.getAttribute().getHref());
                StringBuilder oslcID = new StringBuilder();
                if (attributeIdentifier.startsWith(ATTR_PREFIX)) {
                    if (attributeIdentifier.substring(ATTR_PREFIX.length()).startsWith(".xmi#")) {
                        oslcID.append("_");
                        oslcID.append(attributeIdentifier.substring(ATTR_PREFIX.length() + 5));
                    } else if (attributeIdentifier.charAt(ATTR_PREFIX.length()) == '/') {
                        int firstSlashIndex = ATTR_PREFIX.length() + 1;
                        int secondSlashIndex = firstSlashIndex > -1 ? attributeIdentifier.indexOf("/", firstSlashIndex + 1) : -1;
                        int thirdSlashIndex = secondSlashIndex > -1 ? attributeIdentifier.indexOf("/", secondSlashIndex + 1) : -1;
                        int fragmentIndex = attributeIdentifier.lastIndexOf("#");
                        if (secondSlashIndex > -1 && thirdSlashIndex < 0) {
                            oslcID.append("_");
                            oslcID.append(attributeIdentifier.substring(firstSlashIndex, secondSlashIndex));
                            oslcID.append("___");
                            oslcID.append(attributeIdentifier.substring(fragmentIndex + 1));
                        } else if (secondSlashIndex > -1 && thirdSlashIndex > -1) {
                            oslcID.append("_");
                            oslcID.append(attributeIdentifier.substring(secondSlashIndex + 1, thirdSlashIndex));
                            oslcID.append("___");
                            oslcID.append(attributeIdentifier.substring(firstSlashIndex, secondSlashIndex));
                            oslcID.append("___");
                            oslcID.append(attributeIdentifier.substring(fragmentIndex + 1));
                        }
                    }
                } else {
                    Property selfDefinedAttribute = this.model.createProperty(String.valueOf(asset.getBase()) + asset.getAbout() + "#" + (String)attributeIdentifier);
                    this.model.createResource(String.valueOf(asset.getBase()) + asset.getAbout() + "#" + (String)attributeIdentifier, RDF.Property).addProperty(DCTerms.title, av.getAttribute().getTitle().toString());
                    for (String attributeValue : av.getValues()) {
                        assetResource.addProperty(selfDefinedAttribute, attributeValue);
                    }
                    assetResource.addProperty(selfDefinedAttribute, av.getValues().get(0));
                }
                if (oslcID.length() <= 0) continue;
                Property customProperty = this.model.createProperty(String.valueOf(customPropertiesNSURL) + oslcID);
                AssetAttribute attribute = av.getAttribute().getValue();
                AttributeType type = attribute == null ? AttributeType.TEXT : attribute.getType();
                for (String val : av.getValues()) {
                    switch (type) {
                        default: {
                            assetResource.addProperty(customProperty, val);
                            break;
                        }
                        case DATE: {
                            assetResource.addProperty(customProperty, OSLCEncoder.encode(AttributeConstants.getDate(val)));
                            break;
                        }
                        case USER: {
                            assetResource.addProperty(customProperty, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + JAXBLinksUtil.USERS_PATH + RAMURLEncoder.encode(val)));
                            break;
                        }
                        case RESOURCE: {
                            assetResource.addProperty(customProperty, val);
                            break;
                        }
                        case LINK: {
                            int lastIndex;
                            int startIndex = val.indexOf("href=\"");
                            if (startIndex > -1) {
                                startIndex += 6;
                            }
                            if ((lastIndex = val.indexOf("\"", startIndex)) > -1 && startIndex > -1) {
                                assetResource.addProperty(customProperty, (RDFNode)this.model.createResource(val.substring(startIndex, lastIndex)));
                                break;
                            }
                            assetResource.addProperty(customProperty, val);
                        }
                    }
                }
            }
        }
        int relationCount = 0;
        if (asset.getRelationships() != null) {
            if (this.isRenderAbbreviatedOutput()) {
                if (!this.getPrettyTypes().contains(OSLCVocabulary.Asset.Asset)) {
                    this.getPrettyTypes().add(OSLCVocabulary.Asset.Asset);
                }
                String relativePart = "#" + DCTerms.relation.getLocalName().toString();
                for (Relation relation : asset.getRelationships()) {
                    String relativePartFinal = String.valueOf(relativePart) + relationCount++;
                    String relationReifiedURI = BASE + relativePartFinal;
                    Statement statement = this.model.createStatement(assetResource, DCTerms.relation, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + relation.getResource()));
                    this.model.add(statement);
                    statement.createReifiedStatement(relationReifiedURI);
                    Resource reifiedResource = this.model.createResource(relativePartFinal);
                    reifiedResource.addProperty(OSLCVocabulary.Asset.relationshipType, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + relation.getType().getResource()));
                }
            } else {
                for (Relation relation : asset.getRelationships()) {
                    assetResource.addProperty(DCTerms.relation, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + relation.getResource()));
                    Statement statement = this.model.createStatement(assetResource, OSLCVocabulary.Asset.relatedAsset, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + relation.getResource()));
                    ReifiedStatement reifiedStatement = statement.createReifiedStatement();
                    reifiedStatement.addProperty(OSLCVocabulary.Asset.relationshipType, (RDFNode)this.model.createResource(String.valueOf(asset.getBase()) + relation.getType().getResource()));
                }
            }
        }
        List<RelatedResource> resources = RelationshipUtil.getRelatedResources(asset);
        this.addRelationshipProperty(assetResource, DCTerms.relation, resources, asset.getBase(), relationCount);
        assetResource.removeAll(OSLCVocabulary.RAMAsset.tag);
        for (Tag tag : asset.getTagsList()) {
            assetResource.addProperty(OSLCVocabulary.Asset.tag, tag.getValue());
            Statement statement = this.model.createStatement(assetResource, OSLCVocabulary.Asset.tag, (RDFNode)this.model.createLiteral(tag.getValue()));
            ReifiedStatement reifiedStatement = statement.createReifiedStatement();
            reifiedStatement.addLiteral(OSLCVocabulary.Core.readOnly, tag.getReadOnly());
        }
        return assetResource;
    }

    protected void addRelationshipProperty(Resource assetResource, Property property, List<RelatedResource> resources, String base, int countStart) {
        block4: {
            if (resources == null) break block4;
            if (this.isRenderAbbreviatedOutput()) {
                int count = countStart;
                String relativePart = "#" + property.getLocalName().toString();
                for (RelatedResource cr : resources) {
                    String relativePartFinal = String.valueOf(relativePart) + count++;
                    String relationReifiedURI = BASE + relativePartFinal;
                    Statement statement = this.model.createStatement(assetResource, property, (RDFNode)this.model.createResource(cr.getUrl()));
                    this.model.add(statement);
                    statement.createReifiedStatement(relationReifiedURI);
                    Resource reifiedResource = this.model.createResource(relativePartFinal);
                    reifiedResource.addProperty(OSLCVocabulary.Asset.relationshipType, (RDFNode)this.model.createResource(String.valueOf(base) + cr.getAttributeUri()));
                }
            } else {
                for (RelatedResource cr : resources) {
                    assetResource.addProperty(property, (RDFNode)this.model.createResource(cr.getUrl()));
                    Statement statement = this.model.createStatement(assetResource, property, (RDFNode)this.model.createResource(cr.getUrl()));
                    ReifiedStatement reifiedStatement = statement.createReifiedStatement();
                    reifiedStatement.addProperty(OSLCVocabulary.Asset.relationshipType, (RDFNode)this.model.createResource(String.valueOf(base) + cr.getAttributeUri()));
                }
            }
        }
    }

    public Resource encode(Artifact artifact, String base) {
        String v2Path = JAXBLinksUtil.getOSLCv2ArtifactPathFromV1Path(artifact.getAbout());
        Resource artifactResource = this.model.createResource(String.valueOf(base) + v2Path, OSLCVocabulary.Asset.Artifact);
        artifactResource.addProperty(DCTerms.title, artifact.getTitle());
        if (artifact.getSubject() != null) {
            artifactResource.addProperty(OSLCVocabulary.Core.label, artifact.getSubject());
        }
        if (artifact.getContent() != null) {
            artifactResource.addProperty(OSLCVocabulary.Asset.content, (RDFNode)this.model.createResource(String.valueOf(base) + artifact.getContent().getResource()));
        }
        if (artifact.getMimeType() != null) {
            artifactResource.addProperty(DCTerms.format, artifact.getMimeType());
        }
        if (artifact.getSize() != null) {
            artifactResource.addProperty(OSLCVocabulary.Asset.size, Long.toString(artifact.getSize()));
        }
        if (artifact.getModified() != null) {
            artifactResource.addProperty(DCTerms.modified, OSLCEncoder.encode(artifact.getModified()));
        }
        return artifactResource;
    }

    public Resource encode(Assets service, String base) {
        Resource dialogResource;
        boolean isDefaultSet;
        Resource serviceResource = this.model.createResource(OSLCVocabulary.Core.Service);
        serviceResource.addProperty(OSLCVocabulary.Core.domain, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
        if (service.getFactory() != null) {
            isDefaultSet = false;
            for (Factory factory : service.getFactory()) {
                Resource creationFR = this.model.createResource(OSLCVocabulary.Core.CreationFactory);
                creationFR.addProperty(DCTerms.title, factory.getTitle());
                creationFR.addProperty(OSLCVocabulary.Core.creation, (RDFNode)this.model.createResource(String.valueOf(base) + factory.getAbout()));
                creationFR.addProperty(OSLCVocabulary.Core.resourceShape, (RDFNode)this.model.createResource(String.valueOf(base) + JAXBLinksUtil.getOSLCAssetShapeURL()));
                creationFR.addProperty(OSLCVocabulary.Core.resourceType, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
                creationFR.addProperty(OSLCVocabulary.Core.usage, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
                if (!isDefaultSet) {
                    creationFR.addProperty(OSLCVocabulary.Core.usage, (RDFNode)this.model.createResource("http://open-services.net/ns/core#default"));
                    isDefaultSet = true;
                }
                serviceResource.addProperty(OSLCVocabulary.Core.creationFactory, (RDFNode)creationFR);
            }
        }
        if (service.getSimpleQuery() != null) {
            isDefaultSet = false;
            for (SimpleQuery query : service.getSimpleQuery()) {
                Resource queryResource = this.model.createResource(OSLCVocabulary.Core.QueryCapability);
                queryResource.addProperty(DCTerms.title, query.getTitle());
                queryResource.addProperty(OSLCVocabulary.Core.queryBase, (RDFNode)this.model.createResource(String.valueOf(base) + query.getAbout()));
                queryResource.addProperty(OSLCVocabulary.Core.resourceShape, (RDFNode)this.model.createResource(String.valueOf(base) + JAXBLinksUtil.getOSLCAssetShapeURL()));
                queryResource.addProperty(OSLCVocabulary.Core.resourceType, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
                queryResource.addProperty(OSLCVocabulary.Core.usage, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
                if (!isDefaultSet) {
                    queryResource.addProperty(OSLCVocabulary.Core.usage, (RDFNode)this.model.createResource("http://open-services.net/ns/core#default"));
                    isDefaultSet = true;
                }
                serviceResource.addProperty(OSLCVocabulary.Core.queryCapability, (RDFNode)queryResource);
            }
        }
        if (service.getSelectionDialog() != null) {
            isDefaultSet = false;
            for (Dialog dialog : service.getSelectionDialog()) {
                dialogResource = this.model.createResource(OSLCVocabulary.Core.Dialog);
                dialogResource.addProperty(DCTerms.title, dialog.getTitle());
                dialogResource.addProperty(OSLCVocabulary.Core.label, dialog.getLabel());
                dialogResource.addProperty(OSLCVocabulary.Core.dialog, (RDFNode)this.model.createResource(String.valueOf(base) + dialog.getUrl()));
                dialogResource.addProperty(OSLCVocabulary.Core.hintWidth, dialog.getHintWidth());
                dialogResource.addProperty(OSLCVocabulary.Core.hintHeight, dialog.getHintHeight());
                dialogResource.addProperty(OSLCVocabulary.Core.resourceType, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
                dialogResource.addProperty(OSLCVocabulary.Core.usage, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
                if (!isDefaultSet) {
                    dialogResource.addProperty(OSLCVocabulary.Core.usage, (RDFNode)this.model.createResource("http://open-services.net/ns/core#default"));
                    isDefaultSet = true;
                }
                serviceResource.addProperty(OSLCVocabulary.Core.selectionDialog, (RDFNode)dialogResource);
            }
        }
        if (service.getCreationDialog() != null) {
            isDefaultSet = false;
            for (Dialog dialog : service.getCreationDialog()) {
                dialogResource = this.model.createResource(OSLCVocabulary.Core.Dialog);
                dialogResource.addProperty(DCTerms.title, dialog.getTitle());
                dialogResource.addProperty(OSLCVocabulary.Core.label, dialog.getLabel());
                dialogResource.addProperty(OSLCVocabulary.Core.dialog, (RDFNode)this.model.createResource(String.valueOf(base) + dialog.getUrl()));
                dialogResource.addProperty(OSLCVocabulary.Core.hintWidth, dialog.getHintWidth());
                dialogResource.addProperty(OSLCVocabulary.Core.hintHeight, dialog.getHintHeight());
                dialogResource.addProperty(OSLCVocabulary.Core.resourceType, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
                dialogResource.addProperty(OSLCVocabulary.Core.usage, (RDFNode)this.model.createResource(OSLCVocabulary.Asset.Asset.getURI()));
                if (!isDefaultSet) {
                    dialogResource.addProperty(OSLCVocabulary.Core.usage, (RDFNode)this.model.createResource("http://open-services.net/ns/core#default"));
                    isDefaultSet = true;
                }
                serviceResource.addProperty(OSLCVocabulary.Core.creationDialog, (RDFNode)dialogResource);
            }
        }
        serviceResource.addProperty(OSLCVocabulary.Core.prefixDefinition, (RDFNode)this.encodePrefixDefinition("rdf", RDF.getURI()));
        serviceResource.addProperty(OSLCVocabulary.Core.prefixDefinition, (RDFNode)this.encodePrefixDefinition("dcterms", "http://purl.org/dc/terms/"));
        serviceResource.addProperty(OSLCVocabulary.Core.prefixDefinition, (RDFNode)this.encodePrefixDefinition("oslc", "http://open-services.net/ns/core#"));
        serviceResource.addProperty(OSLCVocabulary.Core.prefixDefinition, (RDFNode)this.encodePrefixDefinition("oslc_asset", "http://open-services.net/ns/asset#"));
        return serviceResource;
    }

    private Resource encodePrefixDefinition(String prefix, String uri) {
        Resource resource = this.model.createResource(OSLCVocabulary.Core.PrefixDefinition);
        resource.addProperty(OSLCVocabulary.Core.prefix, prefix);
        resource.addProperty(OSLCVocabulary.Core.prefixBase, (RDFNode)this.model.createResource(uri));
        return resource;
    }

    public Resource encode(FeedType atomFeed) {
        Resource resource;
        String requestURI;
        this.encodeResponseInfo(atomFeed);
        try {
            requestURI = this.request != null && this.request.getRequestURI() != null ? this.request.getRequestURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            requestURI = null;
        }
        Resource resource2 = resource = requestURI == null ? this.model.createResource() : this.model.createResource(requestURI);
        if (atomFeed.getEntry() != null) {
            this.model.setNsPrefix("rdfs", RDFS.getURI());
            for (EntryType entry : atomFeed.getEntry()) {
                if (entry.getContent() != null && entry.getContent().getContent() != null && entry.getContent().getContent().size() > 0) {
                    resource.addProperty(RDFS.member, (RDFNode)this.encode(entry.getContent().getContent().get(0)));
                    continue;
                }
                List<LinkType> links = entry.getLink();
                LinkType xmlLink = null;
                for (LinkType linkType : links) {
                    if (!"text/xml".equals(linkType.getType())) continue;
                    xmlLink = linkType;
                    break;
                }
                resource.addProperty(RDFS.member, (RDFNode)this.model.createResource(String.valueOf(entry.getBase()) + xmlLink.getHref()));
            }
        }
        return resource;
    }

    private Resource encodeResponseInfo(FeedType atomFeed) {
        Resource resource;
        String requestURI;
        try {
            requestURI = this.request != null && this.request.getRequestURI() != null ? this.request.getRequestURI().toString() : null;
            Map<String, String> paramMap = this.request.getParameterMap();
            if (requestURI != null && paramMap != null && !paramMap.isEmpty()) {
                String prefix = "?";
                for (String key : paramMap.keySet()) {
                    requestURI = String.valueOf(requestURI) + prefix + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(paramMap.get(key), "UTF-8");
                    prefix = "&";
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            requestURI = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            requestURI = null;
        }
        Resource resource2 = resource = requestURI != null ? this.model.createResource(requestURI, OSLCVocabulary.Core.ResponseInfo) : this.model.createResource(OSLCVocabulary.Core.ResponseInfo);
        if (atomFeed.getTitle() != null && atomFeed.getTitle().getContent() != null & atomFeed.getTitle().getContent().size() > 0) {
            resource.addProperty(DCTerms.title, atomFeed.getTitle().getContent().get(0).toString());
        }
        if (atomFeed.getOtherAttributes().containsKey(ObjectFactory.TOTAL_COUNT_QNAME)) {
            resource.addProperty(OSLCVocabulary.Core.totalCount, atomFeed.getOtherAttributes().get(ObjectFactory.TOTAL_COUNT_QNAME));
        }
        LinkType nextPageLink = null;
        if (atomFeed.getLink() != null) {
            for (LinkType lt : atomFeed.getLink()) {
                if (!"next".equals(lt.getRel())) continue;
                nextPageLink = lt;
                break;
            }
            if (nextPageLink != null) {
                resource.addProperty(OSLCVocabulary.Core.nextPage, (RDFNode)this.model.createResource(nextPageLink.getHref()));
            }
        }
        return resource;
    }

    public Resource encode(TrackedResourceSet trs) {
        Resource res = this.model.createResource(String.valueOf(trs.getBase()) + trs.getAbout(), OSLCVocabulary.TRS.TrackedResourceSet);
        this.model.setNsPrefix("trs", "http://jazz.net/ns/trs#");
        res.addProperty(OSLCVocabulary.TRS.base, (RDFNode)this.model.createResource(String.valueOf(trs.getBase()) + trs.getBaseResource().getResource()));
        res.addProperty(OSLCVocabulary.TRS.changeLog, (RDFNode)this.encode(trs.getChangeLog()));
        return res;
    }

    public Resource encode(Base base) {
        Resource res = this.model.createResource(String.valueOf(base.getBase()) + base.getAbout(), OSLCVocabulary.TRS.Base);
        this.model.setNsPrefix("trs", "http://jazz.net/ns/trs#");
        if (base.getCutOffEvent() != null) {
            res.addProperty(OSLCVocabulary.TRS.cutoffEvent, (RDFNode)this.model.createResource(base.getCutOffEvent().getId()));
        }
        if (base.getResources() != null) {
            for (ResourceRef ref : base.getResources()) {
                res.addProperty(RDFS.member, (RDFNode)this.model.createResource(String.valueOf(base.getBase()) + ref.getResource()));
            }
        }
        Resource pageResource = this.model.createResource(String.valueOf(base.getBase()) + JAXBLinksUtil.getTRSBaseURL(base.getStartAssetDBID()));
        if (base.getNextBaseAssetDBID() > -1) {
            pageResource.addProperty(OSLCVocabulary.TRS.nextPage, (RDFNode)this.model.createResource(String.valueOf(base.getBase()) + JAXBLinksUtil.getTRSBaseURL(base.getNextBaseAssetDBID())));
        } else {
            pageResource.addProperty(OSLCVocabulary.TRS.nextPage, (RDFNode)RDF.nil);
        }
        return res;
    }

    public Resource encode(Category category) {
        Resource res = this.model.createResource(String.valueOf(category.getBase()) + category.getHref());
        res.addProperty(DCTerms.title, category.getName());
        res.addProperty(DCTerms.abstract_, category.getDisplayPath());
        return res;
    }

    public Resource encode(ChangeLog changelog) {
        Resource res = this.model.createResource(String.valueOf(changelog.getBase()) + changelog.getAbout(), OSLCVocabulary.TRS.ChangeLog);
        this.model.setNsPrefix("trs", "http://jazz.net/ns/trs#");
        if (changelog.getPrevious() != null) {
            res.addProperty(OSLCVocabulary.TRS.previous, (RDFNode)this.model.createResource(String.valueOf(changelog.getBase()) + changelog.getPrevious().getResource()));
        } else {
            res.addProperty(OSLCVocabulary.TRS.previous, (RDFNode)RDF.nil);
        }
        ArrayList<Resource> ceList = new ArrayList<Resource>();
        List<ChangeEvent> changes = changelog.getChanges();
        if (changes != null) {
            block5: for (ChangeEvent changeEvent : changes) {
                Resource cer = null;
                switch (changeEvent.getType()) {
                    case CREATION: {
                        cer = this.model.createResource(changeEvent.getId(), OSLCVocabulary.TRS.Creation);
                        break;
                    }
                    case DELETION: {
                        cer = this.model.createResource(changeEvent.getId(), OSLCVocabulary.TRS.Deletion);
                        break;
                    }
                    case MODIFICATION: {
                        cer = this.model.createResource(changeEvent.getId(), OSLCVocabulary.TRS.Modification);
                        break;
                    }
                    default: {
                        continue block5;
                    }
                }
                cer.addProperty(OSLCVocabulary.TRS.changed, (RDFNode)this.model.createResource(String.valueOf(changelog.getBase()) + changeEvent.getResource().getResource()));
                cer.addProperty(OSLCVocabulary.TRS.order, Long.toString(changeEvent.getOrder()));
                ceList.add(cer);
            }
            res.addProperty(OSLCVocabulary.TRS.changes, (RDFNode)this.model.createList(ceList.toArray(new RDFNode[ceList.size()])));
        }
        return res;
    }

    public Resource encode(Community community) {
        Resource res = this.model.createResource(String.valueOf(community.getBase()) + community.getHref());
        res.addProperty(DCTerms.title, community.getName());
        return res;
    }

    public Resource encode(AssetType assetType) {
        Resource res = this.model.createResource(String.valueOf(assetType.getBase()) + assetType.getHref());
        res.addProperty(DCTerms.title, assetType.getName());
        return res;
    }

    public Resource encode(Object o) {
        if (o instanceof ServiceProviderCatalog) {
            ServiceProviderCatalog spc = (ServiceProviderCatalog)o;
            return this.encode(spc);
        }
        if (o instanceof ServiceDescriptor) {
            ServiceDescriptor sd = (ServiceDescriptor)o;
            return this.encode(sd);
        }
        if (o instanceof Asset) {
            Asset asset = (Asset)o;
            return this.encode(asset);
        }
        if (o instanceof Artifact) {
            Artifact artifact = (Artifact)o;
            return this.encode(artifact, artifact.getBase());
        }
        if (o instanceof FeedType) {
            FeedType feed = (FeedType)o;
            return this.encode(feed);
        }
        if (o instanceof JAXBElement) {
            JAXBElement jb = (JAXBElement)o;
            return this.encode(jb.getValue());
        }
        if (o instanceof com.ibm.ram.internal.jaxb.Artifact) {
            com.ibm.ram.internal.jaxb.Artifact jaxbArtifact = (com.ibm.ram.internal.jaxb.Artifact)o;
            return this.encode(jaxbArtifact.toOSLCArtifact(), jaxbArtifact.getBase());
        }
        if (o instanceof ServiceContributionResource) {
            ServiceContributionResource scr = (ServiceContributionResource)o;
            this.encode(scr);
        } else {
            if (o instanceof TrackedResourceSet) {
                TrackedResourceSet trs = (TrackedResourceSet)o;
                return this.encode(trs);
            }
            if (o instanceof ChangeLog) {
                ChangeLog cl = (ChangeLog)o;
                return this.encode(cl);
            }
            if (o instanceof Base) {
                Base base = (Base)o;
                return this.encode(base);
            }
            if (o instanceof Community) {
                Community comm = (Community)o;
                return this.encode(comm);
            }
            if (o instanceof AssetType) {
                AssetType at = (AssetType)o;
                return this.encode(at);
            }
            if (o instanceof Shapes) {
                Shapes shape = (Shapes)((Object)o);
                switch (shape) {
                    case ASSET: {
                        return this.encodeAssetShape();
                    }
                }
            } else {
                if (o instanceof Category) {
                    Category c = (Category)o;
                    return this.encode(c);
                }
                if (o instanceof CompactRendering) {
                    CompactRendering cr = (CompactRendering)o;
                    return this.encode(cr);
                }
            }
        }
        return null;
    }

    private Resource encodeAssetShape() {
        String uri;
        try {
            uri = this.request.getRequestURI().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            uri = null;
        }
        Resource r = uri == null ? this.model.createResource(OSLCVocabulary.Core.ResourceShape) : this.model.createResource(uri, OSLCVocabulary.Core.ResourceShape);
        r.addProperty(DCTerms.title, "Asset Management V2 Asset");
        r.addProperty(OSLCVocabulary.Core.describes, (RDFNode)OSLCVocabulary.Asset.Asset);
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.title, OSLCVocabulary.RDFSyntax.XMLLiteral, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.description, OSLCVocabulary.RDFSyntax.XMLLiteral, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.abstract_, OSLCVocabulary.RDFSyntax.XMLLiteral, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.creator, OSLCVocabulary.Core.AnyResource, OSLCVocabulary.Core.ZeroOrOne, "http://xmlns.com/foaf/0.1/Person", "http://example.com/oslc/shapes/Person", OSLCVocabulary.Core.Either, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.contributor, OSLCVocabulary.Core.AnyResource, OSLCVocabulary.Core.ZeroOrOne, "http://xmlns.com/foaf/0.1/Person", "http://example.com/oslc/shapes/Person", OSLCVocabulary.Core.Either, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.created, OSLCVocabulary.XMLSchema.DateTime, OSLCVocabulary.Core.ZeroOrOne, null, null, null, true));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.modified, OSLCVocabulary.XMLSchema.DateTime, OSLCVocabulary.Core.ZeroOrOne, null, null, null, true));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(RDF.type, OSLCVocabulary.Core.Resource, OSLCVocabulary.Core.OneOrMany, null, null, OSLCVocabulary.Core.Reference, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Core.serviceProvider, OSLCVocabulary.Core.Resource, OSLCVocabulary.Core.ZeroOrOne, OSLCVocabulary.Core.ServiceProvider.getURI(), null, OSLCVocabulary.Core.Reference, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Core.instanceShape, OSLCVocabulary.Core.Resource, OSLCVocabulary.Core.ZeroOrMany, OSLCVocabulary.Core.ResourceShape.getURI(), null, OSLCVocabulary.Core.Reference, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.identifier, OSLCVocabulary.XMLSchema.String, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.guid, OSLCVocabulary.XMLSchema.String, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.version, OSLCVocabulary.XMLSchema.String, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.type, OSLCVocabulary.Core.AnyResource, OSLCVocabulary.Core.ZeroOrOne, null, null, OSLCVocabulary.Core.Either, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.state, OSLCVocabulary.Core.AnyResource, OSLCVocabulary.Core.ZeroOrOne, null, null, OSLCVocabulary.Core.Either, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.categorization, OSLCVocabulary.Core.AnyResource, OSLCVocabulary.Core.ZeroOrMany, null, null, OSLCVocabulary.Core.Either, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.manufacturer, OSLCVocabulary.XMLSchema.String, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.model, OSLCVocabulary.XMLSchema.String, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.serialNumber, OSLCVocabulary.XMLSchema.String, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.artifact, OSLCVocabulary.Core.LocalResource, OSLCVocabulary.Core.ZeroOrMany, OSLCVocabulary.Asset.Artifact.getURI(), null, OSLCVocabulary.Core.Inline, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.artifactFactory, OSLCVocabulary.Core.Resource, OSLCVocabulary.Core.ExactlyOne, null, null, OSLCVocabulary.Core.Reference, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Core.label, OSLCVocabulary.RDFSyntax.XMLLiteral, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.content, OSLCVocabulary.Core.Resource, OSLCVocabulary.Core.ZeroOrOne, null, null, OSLCVocabulary.Core.Reference, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.format, OSLCVocabulary.XMLSchema.String, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.size, OSLCVocabulary.XMLSchema.Integer, OSLCVocabulary.Core.ZeroOrOne, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(DCTerms.relation, OSLCVocabulary.Core.Resource, OSLCVocabulary.Core.ZeroOrMany, null, null, null, null));
        r.addProperty(OSLCVocabulary.Core.property, (RDFNode)this.createShapePropertyResource(OSLCVocabulary.Asset.relationshipType, OSLCVocabulary.Core.AnyResource, OSLCVocabulary.Core.ZeroOrOne, null, null, OSLCVocabulary.Core.Either, null));
        return r;
    }

    private Resource createShapePropertyResource(Property propertyDefined, Resource valueType, Resource occurs, String range, String valueShape, Resource representation, Boolean readOnly) {
        Resource r = this.model.createResource(OSLCVocabulary.Core.Property);
        r.addProperty(OSLCVocabulary.Core.name, propertyDefined.getLocalName().toString());
        r.addProperty(OSLCVocabulary.Core.propertyDefinition, (RDFNode)propertyDefined);
        r.addProperty(OSLCVocabulary.Core.valueType, (RDFNode)valueType);
        r.addProperty(OSLCVocabulary.Core.occurs, (RDFNode)occurs);
        if (range != null) {
            r.addProperty(OSLCVocabulary.Core.range, (RDFNode)this.model.createResource(range));
        }
        if (valueShape != null) {
            r.addProperty(OSLCVocabulary.Core.valueShape, (RDFNode)this.model.createResource(valueShape));
        }
        if (representation != null) {
            r.addProperty(OSLCVocabulary.Core.representation, (RDFNode)representation);
        }
        if (readOnly != null) {
            r.addProperty(OSLCVocabulary.Core.readOnly, readOnly.toString());
        }
        return r;
    }

    public List<Resource> getPrettyTypes() {
        if (this.prettyTypes == null) {
            this.prettyTypes = new ArrayList();
        }
        return this.prettyTypes;
    }

    public boolean isRenderAbbreviatedOutput() {
        return this.renderAbbreviatedOutput;
    }
}

