/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.AbstractView;
import com.ibm.ram.internal.scm.clearcase.DynamicView;
import com.ibm.ram.internal.scm.clearcase.SnapshotView;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GetViewInfoCommand
extends OutputCleartoolCommand {
    private static String KEY_VIEW_SEPERATOR = CleartoolCommandConstants.LSVIEW_VIEW_SEPERATOR;
    private static String KEY_GLOBAL_PATH = CleartoolCommandConstants.LSVIEW_GLOBAL_PATH;
    private static String KEY_SERVER_HOST = CleartoolCommandConstants.LSVIEW_SERVER_HOST;
    private static String KEY_REGION = CleartoolCommandConstants.LSVIEW_REGION;
    private static String KEY_ACTIVE = CleartoolCommandConstants.LSVIEW_ACTIVE;
    private static String KEY_UUID = CleartoolCommandConstants.LSVIEW_UUID;
    private static String KEY_OWNER = CleartoolCommandConstants.LSVIEW_OWNER;
    private static String KEY_ATTRIBUTES = CleartoolCommandConstants.LSVIEW_ATTRIBUTES;
    private static String KEY_SERVER_PATH = CleartoolCommandConstants.LSVIEW_SERVER_PATH;
    private static String KEY_SNAPSHOT = CleartoolCommandConstants.LSVIEW_SNAPSHOT;
    private static String KEY_UCMVIEW = CleartoolCommandConstants.LSVIEW_UCMVIEW;
    private File viewLocation = null;

    public GetViewInfoCommand(File viewLocation) {
        this.viewLocation = viewLocation;
    }

    @Override
    public String[] getArguments() {
        return new String[]{"lsview", "-long", "-cview"};
    }

    @Override
    protected File getFolderToRunIn() {
        if (this.viewLocation.isFile()) {
            return this.viewLocation.getParentFile();
        }
        return this.viewLocation;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        final ArrayList<AbstractView> viewsList = new ArrayList<AbstractView>();
        if (output != null && output.length() > 0) {
            String[] viewStrings = output.split(KEY_VIEW_SEPERATOR);
            int vc = 0;
            while (vc < viewStrings.length) {
                if (viewStrings[vc].trim().length() > 0) {
                    StringTokenizer lines = new StringTokenizer(viewStrings[vc], "\r\n");
                    String firstLine = lines.nextToken();
                    int spaceLocation = firstLine.indexOf(" ");
                    String viewName = spaceLocation < 0 ? firstLine : firstLine.substring(0, spaceLocation);
                    String viewDescription = spaceLocation < 0 ? null : firstLine.substring(spaceLocation + 1, firstLine.length());
                    boolean active = false;
                    String attributes = null;
                    String globalPath = null;
                    String owner = null;
                    String region = null;
                    String serverHost = null;
                    String uuid = null;
                    String serverPath = null;
                    while (lines.hasMoreTokens()) {
                        String line = lines.nextToken().trim();
                        if (line.startsWith(KEY_ACTIVE)) {
                            active = line.substring(KEY_ACTIVE.length()).indexOf(CleartoolCommandConstants.LSVIEW_ACTIVE_YES) > -1;
                            continue;
                        }
                        if (line.startsWith(KEY_ATTRIBUTES)) {
                            attributes = line.substring(KEY_ATTRIBUTES.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_GLOBAL_PATH)) {
                            globalPath = line.substring(KEY_GLOBAL_PATH.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_OWNER)) {
                            owner = line.substring(KEY_OWNER.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_REGION)) {
                            region = line.substring(KEY_REGION.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_SERVER_HOST)) {
                            serverHost = line.substring(KEY_SERVER_HOST.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_UUID)) {
                            uuid = line.substring(KEY_UUID.length()).trim();
                            continue;
                        }
                        if (!line.startsWith(KEY_SERVER_PATH)) continue;
                        serverPath = line.substring(KEY_SERVER_PATH.length()).trim();
                    }
                    AbstractView v = null;
                    boolean isUCM = false;
                    if (attributes != null && attributes.indexOf(KEY_UCMVIEW) > -1) {
                        isUCM = true;
                    }
                    v = attributes != null && attributes.indexOf(KEY_SNAPSHOT) > -1 ? new SnapshotView() : new DynamicView();
                    v.setActive(active);
                    v.setUCM(isUCM);
                    v.setDescription(viewDescription);
                    v.setGlobalPath(globalPath);
                    v.setTag(viewName);
                    v.setOwner(owner);
                    v.setRegion(region);
                    v.setRemoteHost(serverHost);
                    v.setRemotePath(serverPath);
                    v.setUid(uuid);
                    viewsList.add(v);
                }
                ++vc;
            }
        }
        return new ViewInfoOutput(){

            @Override
            public AbstractView getView() {
                if (viewsList.size() > 0) {
                    return (AbstractView)viewsList.get(0);
                }
                return null;
            }
        };
    }

    public static interface ViewInfoOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public AbstractView getView();
    }
}

