/*
 * Decompiled with CFR 0.152.
 */
package org.oslc.asset.internal.query;

import com.ibm.ram.common.util.RAMURLDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oslc.asset.internal.query.InvalidQuerySyntax;
import org.oslc.asset.internal.query.Messages;
import org.oslc.asset.internal.query.SimpleQueryParser;
import org.oslc.asset.internal.query.SparqlGenerator;
import org.oslc.asset.internal.query.ast.Query;

public class QueryHelper {
    public static final String QUERY_ENCODING = "UTF-8";
    public static final String QUERY_WILDCARD = "*";
    public static final String NAME_SEPARATOR = "/";
    private static final String EX_PARSE_ERROR = Messages.getString("app.query.exceptions.invalid-form");
    private static final String EX_PROPERTY_ERROR = Messages.getString("app.query.exceptions.invalid-property-list");

    public Query parseInputQuery(String queryString) throws InvalidQuerySyntax {
        try {
            return SimpleQueryParser.parse(RAMURLDecoder.decode(queryString));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return SimpleQueryParser.parse(queryString);
        }
    }

    public Query parseInputQueryUnencoded(String queryString) throws InvalidQuerySyntax {
        try {
            return SimpleQueryParser.parse(queryString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidQuerySyntax(EX_PARSE_ERROR);
        }
    }

    public List<String> parsePropertyList(String propertyString) throws InvalidQuerySyntax {
        ArrayList<String> properties = new ArrayList<String>();
        String decoded = null;
        decoded = RAMURLDecoder.decode(propertyString);
        String[] split = decoded.split("\\p{Space}*,\\p{Space}*");
        int i = 0;
        while (i < split.length) {
            String prop = split[i].trim();
            if (prop.contains(" ")) {
                throw new InvalidQuerySyntax(EX_PROPERTY_ERROR);
            }
            properties.add(prop);
            ++i;
        }
        return properties;
    }

    public Map<String, String> parseNamespaceList(String namespaceString) throws InvalidQuerySyntax {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        String decoded = null;
        decoded = RAMURLDecoder.decode(namespaceString);
        String[] split = decoded.split("\\p{Space}*,\\p{Space}*");
        int i = 0;
        while (i < split.length) {
            String[] pair = split[i].trim().split("\\p{Space}*=\\p{Space}*");
            if (pair.length != 2) {
                throw new InvalidQuerySyntax(EX_PROPERTY_ERROR);
            }
            String pr = pair[0].trim();
            String ns = pair[1].trim();
            if (pr.contains(" ") || ns.contains(" ")) {
                throw new InvalidQuerySyntax(EX_PROPERTY_ERROR);
            }
            namespaces.put(pr, ns);
            ++i;
        }
        return namespaces;
    }

    public String generateSparqlQuery(Query query, Map<String, String> namespaces, List<String> returnProps) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.generateSparqlQuery(query, namespaces, returnProps, baos);
        return baos.toString(QUERY_ENCODING);
    }

    public void generateSparqlQuery(Query query, Map<String, String> namespaces, List<String> returnProps, OutputStream os) throws IOException {
        SparqlGenerator.generate(query, namespaces, returnProps, os);
    }

    public void directToSparql(String queryString, String propertyString, Map<String, String> namespaces, OutputStream os) throws InvalidQuerySyntax, IOException {
        Query query = this.parseInputQuery(queryString);
        List<String> properties = this.parsePropertyList(propertyString);
        this.generateSparqlQuery(query, namespaces, properties, os);
    }
}

