#!/usr/bin/env groovy
/*******************************************************************************
* Licensed Materials - Property of IBM
* (c) Copyright IBM Corporation 2013. All Rights Reserved.
*
* Note to U.S. Government Users Restricted Rights:
* Use, duplication or disclosure restricted by GSA ADP Schedule
* Contract with IBM Corp.
*******************************************************************************/

import com.ibm.ram.cli.*;
import com.ibm.ram.internal.cli.command.*;

final def workDir = new File('.').canonicalFile

final def inputPropsFile = new File(args[0])
final def props = new Properties()
final def outputProps = new Properties()
final def inputPropsStream = null
try {
	inputPropsStream = new FileInputStream(inputPropsFile)
	props.load(inputPropsStream)
}
catch (IOException e) {
	throw new RuntimeException(e)
}

final def REPO_PATH_SEPARATOR = File.separator;
def repoUrl = props['repositoryUrl'];
while (repoUrl.endsWith(REPO_PATH_SEPARATOR)) {
    repoUrl = repoUrl.substring(0, repoUrl.length() - 1);
}
def username = props['username'];
def password = props['password']; 
def community = props['community']
def guid = props['guid']
def version = props['version']
def directoryOffset = props['directoryOffset']
def assetType = props['assetType']

println "repoUrl = ${repoUrl}"
println "username = ${username}"
println "community = ${community}"
println "guid = ${guid}"
println "version = ${version}"
println "directoryOffset = ${directoryOffset}"
println "assetType = ${assetType}"

 
// Get the working directory
def baseDirectory = workDir
try {
	if (directoryOffset) {
		baseDirectory = new File(workDir, directoryOffset).canonicalFile
	}
}
catch (Exception e) {
	throw new RuntimeException(e)
}

if (!baseDirectory.exists()){
	throw new IllegalArgumentException("Directory ${baseDirectory} does not exist!")
}

if (baseDirectory.isFile()) {
    throw new IllegalArgumentException("Directory ${baseDirectory} is a file!")
}

// Create the library server configuration file
String[] arguments = ["config", "-url", repoUrl, "-u", username, "-p", password, "-c", community];
println "Config Arguments = ${arguments}"
ConfigCommand cmd = new ConfigCommand(arguments)
int exitVal = Ram.execute(cmd)

// Upload the packages to the library server
if (exitVal == 0) {
	
	
	BufferedWriter bw = null
	try { 
		// Create a package.json 
		File descriptor = new File(baseDirectory, "package.json")
		descriptor.createNewFile()
		FileWriter fw = new FileWriter(descriptor.getAbsoluteFile())
		bw = new BufferedWriter(fw)

		// Write the package.json contents
		bw.write("{\n\"id\":\"${guid}\",\n\"version\":\"${version}\",\n\"type\":\"${assetType}\"\n}")
		bw.flush()
		bw.close()
		bw = null

		// Publish the asset
		arguments = [ "publish", baseDirectory.getAbsoluteFile()]
		println "Publish Arguments = ${arguments}"
		PublishCommand publishCommand = new PublishCommand(arguments)
		exitVal = Ram.execute(publishCommand);
	}
	catch (Exception e) {
		if (bw != null) {
			bw.flush()
			bw.close()
		}
		e.printStackTrace()
		exitVal = 1
	} 
}

System.exit(exitVal)
