/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.TypeInfo;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;

final class TypeInfoArray
extends TypeInfo {
    private final Class<?> componentRawType;
    private final Type secondLevel;

    TypeInfoArray(Type type) {
        super(type);
        Class<?> rootComponentType = this.rawClass;
        while (rootComponentType.isArray()) {
            rootComponentType = rootComponentType.getComponentType();
        }
        this.componentRawType = rootComponentType;
        this.secondLevel = TypeInfoArray.extractSecondLevelType(this.actualType, this.rawClass);
    }

    private static Type extractSecondLevelType(Type actualType, Class<?> rawClass) {
        if (actualType instanceof GenericArrayType) {
            GenericArrayType castedType = (GenericArrayType)actualType;
            return castedType.getGenericComponentType();
        }
        return rawClass.getComponentType();
    }

    public Type getSecondLevelType() {
        return this.secondLevel;
    }

    public Class<?> getComponentRawType() {
        return this.componentRawType;
    }
}

