/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAttachment;
import com.ibm.ram.client.RAMTopic;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.Attachment;
import com.ibm.ram.common.data.Post;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import org.eclipse.core.runtime.IProgressMonitor;

public class RAMPost
extends Post {
    private RAMTopic fTopic;
    private RAMAttachment fAttachment;
    private RAMPost[] fReplies;
    private Post fPost;
    private boolean fUpdate = false;
    private boolean fDirty = false;
    private boolean fDelete = false;
    private RAMUser fSubmitter;
    private RAMAsset fAsset;

    RAMPost(RAMTopic topic, Post post) {
        this.fAsset = topic.getAsset();
        this.fPost = post;
        this.fTopic = topic;
        this.fPost = post;
        this.fUpdate = true;
    }

    RAMPost(RAMTopic topic, RAMUser submitter, String title, String description) {
        this.fAsset = topic.getAsset();
        this.fPost = new Post();
        this.fTopic = topic;
        this.fPost.setId(-1L);
        this.fPost.setReplyToPostID(-1L);
        this.fPost.setTopicID(topic.getId());
        this.fPost.setTitle(title != null ? title : "");
        this.fPost.setDescription(description != null ? description : "");
        this.setSubmitter(submitter);
        this.fUpdate = false;
        this.fDirty = true;
    }

    void updatePost(Post post, IProgressMonitor monitor) {
        monitor.beginTask(ClientMessages.getString("RAMPost.0"), 1);
        if (!this.fDirty) {
            this.fSubmitter = null;
            this.fPost = post;
            monitor.worked(1);
        } else {
            this.fSubmitter = null;
            this.fPost.setDescription(post.getDescription());
            this.fPost.setId(post.getId());
            this.fPost.setLastUpdatedDate(post.getLastUpdatedDate());
            this.fPost.setState(post.getState());
            this.fPost.setTitle(post.getTitle());
            monitor.worked(1);
        }
        this.fDirty = false;
        this.fUpdate = true;
    }

    @Override
    public Attachment getAttachment() {
        if (this.fAttachment == null && this.fPost.getAttachment() != null) {
            this.fAttachment = new RAMAttachment(this, this.fPost.getAttachment());
        }
        return this.fAttachment;
    }

    @Override
    public long getId() {
        return this.fPost.getId();
    }

    @Override
    public Post[] getReplies() {
        if (this.fReplies == null) {
            if (this.fPost.getReplies() == null) {
                this.fReplies = new RAMPost[0];
            } else {
                this.fReplies = new RAMPost[this.fPost.getReplies().length];
                int i = 0;
                while (i < this.fPost.getReplies().length) {
                    this.fReplies[i] = new RAMPost(this.getTopic(), this.fPost.getReplies()[0]);
                    ++i;
                }
            }
        }
        return this.fReplies;
    }

    @Override
    public long getReplyToPostID() {
        return this.fPost.getReplyToPostID();
    }

    @Override
    public int getTopicID() {
        return this.fPost.getTopicID();
    }

    public RAMTopic getTopic() {
        return this.fTopic;
    }

    public String toString() {
        if (this.fPost == null) {
            return super.toString();
        }
        return this.getTopic() + "/" + ClientMessages.getString("RAMPost.1") + this.getId();
    }

    @Override
    public String getDescription() {
        return this.fPost.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.fPost.setDescription(description);
    }

    @Override
    public long getLastUpdatedDate() {
        return this.fPost.getLastUpdatedDate();
    }

    @Override
    public String getState() {
        return this.fPost.getState();
    }

    @Override
    public long getSubmissionDate() {
        return this.fPost.getSubmissionDate();
    }

    boolean isUpdate() {
        return this.fUpdate;
    }

    boolean isDelete() {
        return this.fDelete;
    }

    boolean isDirty() {
        return this.fDirty;
    }

    @Override
    public void setAttachment(Attachment attachment) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMPost.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setId(long id) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMPost.ID_ONLY_SETTABLE_BY_THE_SERVER"), true);
    }

    @Override
    public void setReplies(Post[] replies) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMPost.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setReplyToPostID(long replyToPostID) {
        this.fPost.setReplyToPostID(replyToPostID);
    }

    @Override
    public void setTopicID(int topicID) {
        this.fPost.setTopicID(topicID);
    }

    @Override
    public void setLastUpdatedDate(long lastUpdatedDate) {
        this.fPost.setLastUpdatedDate(lastUpdatedDate);
    }

    @Override
    public void setState(String state) {
        this.fPost.setState(state);
    }

    @Override
    public void setSubmissionDate(long submissionDate) {
        this.fPost.setSubmissionDate(submissionDate);
    }

    @Override
    public void setSubmitter(UserInformation submitter) {
        if (submitter instanceof RAMUser) {
            RAMUser ramUser = (RAMUser)submitter;
            this.fPost.setSubmitter(ramUser.getInternalUser());
            this.fSubmitter = ramUser;
        } else {
            this.fPost.setSubmitter(submitter);
            this.fSubmitter = null;
        }
    }

    @Override
    public UserInformation getSubmitter() {
        if (this.fSubmitter == null) {
            RAMUser newUser;
            this.fSubmitter = newUser = this.getAsset().getSession().fetchUser(this.fPost.getSubmitter());
        }
        return this.fSubmitter;
    }

    @Override
    public String getTitle() {
        return this.fPost.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.fPost.setTitle(title);
    }

    public RAMAsset getAsset() {
        return this.fAsset;
    }
}

