/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.data;

import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.internal.common.bundles.CommonMessages;
import com.ibm.ram.internal.common.util.RelationshipRangeUtility;

public class RelationshipRange {
    public static final String GREATER_THAN_OR_EQUAL_TO = "GREATER_THAN_OR_EQUAL_TO";
    public static final String GREATER_THAN = "GREATER_THAN";
    public static final String LESS_THAN = "LESS_THAN";
    public static final String LESS_THAN_OR_EQUAL_TO = "LESS_THAN_OR_EQUAL_TO";
    public static final String HIGHEST_VERSION = "Highest";
    public static final String ALL_VERSIONS = "All";
    private String lowestVersion;
    private String lowestVersionType;
    private String highestVersion;
    private String highestVersionType;
    private String type;
    private static final RelationshipRangeUtility.RangeInfo NEVER_SET = new RelationshipRangeUtility.RangeInfo("");
    private RelationshipRangeUtility.RangeInfo rinfo = NEVER_SET;

    public RelationshipRange() {
    }

    public RelationshipRange(RelationshipRangeUtility.RangeInfo rinfo, boolean highest) {
        if (highest) {
            this.setType(HIGHEST_VERSION);
        } else {
            this.setType(ALL_VERSIONS);
        }
        rinfo.fillInRelationshipRange(this);
        this.rinfo = rinfo;
    }

    public int hashCode() {
        return (this.rinfo != NEVER_SET ? this.getRangeInfo().hashCode() : 0) * 31 + (this.type != null ? this.type.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof RelationshipRange)) {
            return false;
        }
        RelationshipRange ri = (RelationshipRange)obj;
        return (this.rinfo == NEVER_SET && ri.rinfo == NEVER_SET || UtilitiesCommon.objectsEqual(this.getRangeInfo(), ri.getRangeInfo())) && UtilitiesCommon.objectsEqual(this.getType(), ri.getType());
    }

    public String toString() {
        return "RelationshipRange{range:" + this.rinfo + ", type:" + this.type + '}';
    }

    public String getLowestVersion() {
        return this.lowestVersion;
    }

    public void setLowestVersion(String lowestVersion) {
        this.rinfo = null;
        this.lowestVersion = lowestVersion;
    }

    public String getLowestVersionType() {
        return this.lowestVersionType;
    }

    public boolean isLowerVersionIncluded() {
        return GREATER_THAN_OR_EQUAL_TO.equals(this.lowestVersionType);
    }

    public void setLowestVersionType(String lowestVersionType) {
        this.rinfo = null;
        if (!GREATER_THAN.equals(lowestVersionType) && !GREATER_THAN_OR_EQUAL_TO.equals(lowestVersionType)) {
            throw new IllegalArgumentException(CommonMessages.getString("relationshiprange.lower.version.error"));
        }
        this.lowestVersionType = lowestVersionType;
    }

    public String getHighestVersion() {
        return this.highestVersion;
    }

    public void setHighestVersion(String highestVersion) {
        this.rinfo = null;
        this.highestVersion = highestVersion;
    }

    public String getHighestVersionType() {
        return this.highestVersionType;
    }

    public void setHighestVersionType(String highestVersionType) {
        this.rinfo = null;
        if (!LESS_THAN.equals(highestVersionType) && !LESS_THAN_OR_EQUAL_TO.equals(highestVersionType)) {
            throw new IllegalArgumentException(CommonMessages.getString("relationshiprange.higher.version.error"));
        }
        this.highestVersionType = highestVersionType;
    }

    public boolean isHigherVersionIncluded() {
        return LESS_THAN_OR_EQUAL_TO.equals(this.highestVersionType);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type != null ? type.trim() : null;
    }

    public boolean isHighestVersionRangeRelationship() {
        return HIGHEST_VERSION.equals(this.getType());
    }

    public boolean isAllVersionsRangeRelationship() {
        return ALL_VERSIONS.equals(this.getType());
    }

    public RelationshipRangeUtility.RangeInfo getRangeInfo() {
        if (this.rinfo == null || this.rinfo == NEVER_SET) {
            this.rinfo = new RelationshipRangeUtility.RangeInfo(this);
        }
        return this.rinfo;
    }
}

