/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.defaultprofile.util.Utilities;
import com.ibm.ram.internal.jaxb.BooleanProperty;
import com.ibm.ram.internal.jaxb.RoleOverride;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.Checksum;
import org.apache.log4j.NDC;

public class UtilitiesCommon {
    private UtilitiesCommon() {
    }

    public static long copyStreams(InputStream in, OutputStream output, byte[] buffer, boolean closeInput, boolean closeOutput, Checksum checksum) throws IOException {
        long l;
        block18: {
            try {
                int read;
                if (buffer == null) {
                    buffer = new byte[100000];
                }
                int start = 0;
                long copied = 0L;
                while ((read = in.read(buffer, start, buffer.length - start)) > -1) {
                    if ((start += read) < buffer.length) continue;
                    if (checksum != null) {
                        checksum.update(buffer, 0, buffer.length);
                    }
                    output.write(buffer);
                    start = 0;
                    copied += (long)buffer.length;
                }
                if (start > 0) {
                    if (checksum != null) {
                        checksum.update(buffer, 0, start);
                    }
                    output.write(buffer, 0, start);
                    copied += (long)start;
                }
                l = copied;
                if (!closeInput) break block18;
            }
            catch (Throwable throwable) {
                if (closeInput) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (closeOutput) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (closeOutput) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
        return l;
    }

    public static long copyStreams(InputStream in, OutputStream output, byte[] buffer, boolean closeInput, boolean closeOutput) throws IOException {
        return UtilitiesCommon.copyStreams(in, output, buffer, closeInput, closeOutput, null);
    }

    public static void copyReader(Reader in, Writer output, char[] buffer, boolean closeInput, boolean closeOutput) throws IOException {
        block23: {
            block24: {
                if (in != null && output != null) break block23;
                if (!closeInput || in == null) break block24;
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (closeOutput && output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
        try {
            int read;
            if (buffer == null) {
                buffer = new char[100000];
            }
            int start = 0;
            while ((read = in.read(buffer, start, buffer.length - start)) > -1) {
                if ((start += read) < buffer.length) continue;
                output.write(buffer);
                start = 0;
            }
            if (start > 0) {
                output.write(buffer, 0, start);
            }
        }
        catch (Throwable throwable) {
            if (closeInput && in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (closeOutput && output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (closeInput && in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (closeOutput && output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean objectsEqual(Object before, Object after) {
        if (before != null) {
            return before.equals(after);
        }
        return after == null;
    }

    public static boolean stringsEqualOrEmpty(String before, String after) {
        if (UtilitiesCommon.objectsEqual(before, after)) {
            return true;
        }
        return UtilitiesCommon.isEmptyString(before) && UtilitiesCommon.isEmptyString(after);
    }

    public static boolean isEmptyString(String teststring) {
        return teststring == null || teststring.length() == 0;
    }

    public static boolean isTrue(BooleanProperty booleanProp) {
        return booleanProp != null && booleanProp.getValue();
    }

    public static boolean isSameValue(BooleanProperty bp1, BooleanProperty bp2) {
        if (bp1 == null) {
            if (bp2 == null) {
                return true;
            }
            return !bp2.getValue();
        }
        if (bp2 != null) {
            return bp1.getValue() == bp2.getValue();
        }
        return !bp1.getValue();
    }

    public static boolean isSameValue(RoleOverride ro1, RoleOverride ro2) {
        if (ro1 == null) {
            if (ro2 == null) {
                return true;
            }
            return ro2.getValue() == RoleOverride.Choice.NO_CHANGE;
        }
        if (ro2 != null) {
            return ro1.getValue() == ro2.getValue();
        }
        return ro1.getValue() == RoleOverride.Choice.NO_CHANGE;
    }

    public static boolean isEmptyStringTrimmed(String teststring) {
        if (UtilitiesCommon.isEmptyString(teststring)) {
            return true;
        }
        int i = 0;
        int n = teststring.length();
        while (i < n) {
            if (teststring.charAt(i) != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void appendQueryParm(String parmId, int intParmValue, boolean firstParm, StringBuilder urlBuffer) {
        Utilities.appendQueryParm(parmId, String.valueOf(intParmValue), firstParm, urlBuffer);
    }

    public static int pushNDC(String ndcMessage) {
        if (UtilitiesCommon.objectsEqual(NDC.peek(), ndcMessage)) {
            return -1;
        }
        try {
            int n = NDC.getDepth();
            return n;
        }
        finally {
            NDC.push((String)ndcMessage);
        }
    }

    public static void popNDC(int pushCnt) {
        switch (pushCnt) {
            case -1: {
                break;
            }
            case 0: {
                NDC.remove();
                break;
            }
            default: {
                NDC.pop();
            }
        }
    }

    public static String getStacktrace(Throwable t) {
        String stacktrace = null;
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            try {
                t.printStackTrace(pw);
                stacktrace = sw.toString();
            }
            finally {
                pw.close();
            }
        }
        return stacktrace;
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map, K key, V value) {
        V ov = map.putIfAbsent(key, value);
        if (ov == null) {
            return value;
        }
        return ov;
    }

    public static <E extends Enum<E>> EnumSet<E> create(Class<E> enumType, long setValue) {
        EnumSet<Enum> result = EnumSet.noneOf(enumType);
        try {
            Enum[] values;
            Method vf = enumType.getMethod("values", new Class[0]);
            Enum[] enumArray = values = (Enum[])vf.invoke(null, new Object[0]);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Enum e = enumArray[n2];
                if ((setValue & 1L << e.ordinal()) != 0L) {
                    result.add(e);
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Class " + enumType + " is not valid for EMFNumSet", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + enumType + " is not valid for EMFNumSet", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Class " + enumType + " is not valid for EMFNumSet", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class " + enumType + " is not valid for EMFNumSet", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Class " + enumType + " is not valid for EMFNumSet", e);
        }
        return result;
    }

    public static <E extends Enum<E>> long getBitmap(Set<E> set) {
        if (set.isEmpty()) {
            return 0L;
        }
        long bitmap = 0L;
        for (Enum e : set) {
            bitmap |= UtilitiesCommon.getAsBits(e);
        }
        return bitmap;
    }

    public static <E extends Enum<E>> long getAsBits(E e) {
        return 1L << e.ordinal();
    }
}

