/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GetFileLabelsCommand
extends OutputCleartoolCommand {
    private File[] files = null;

    public GetFileLabelsCommand(File[] viewFile) {
        this.files = viewFile;
    }

    @Override
    public String[] getArguments() {
        String[] args = new String[3 + this.files.length];
        args[0] = "describe";
        args[1] = "-fmt";
        args[2] = "%Nl";
        int c = 0;
        while (c < args.length) {
            args[3 + c] = this.files[c].getAbsolutePath();
            ++c;
        }
        return args;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(final String output, String error) {
        return new GetFileLabelsOutput(){

            @Override
            public String[] getLabels() {
                String[] labels = null;
                if (output != null) {
                    StringTokenizer newlineTokenizer = new StringTokenizer(output, " ", false);
                    ArrayList<String> labelsList = new ArrayList<String>();
                    while (newlineTokenizer.hasMoreTokens()) {
                        labelsList.add(newlineTokenizer.nextToken());
                    }
                    labels = labelsList.toArray(new String[labelsList.size()]);
                }
                return labels;
            }
        };
    }

    public static interface GetFileLabelsOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public String[] getLabels();
    }
}

