/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class RemoveViewCommand
extends OutputCleartoolCommand {
    private boolean force = false;
    private File viewLocation = null;

    public RemoveViewCommand(File viewlocation, boolean force) {
        this.viewLocation = viewlocation;
        this.force = force;
    }

    @Override
    public String[] getArguments() {
        if (this.force) {
            return new String[]{"rmview", "-force", this.viewLocation.getAbsolutePath()};
        }
        return new String[]{"rmview", this.viewLocation.getAbsolutePath()};
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, final String error) {
        return new RemoveViewCommandOutput(){

            @Override
            public boolean isRemoved() {
                return error == null || error.trim().length() <= 0;
            }
        };
    }

    public static interface RemoveViewCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean isRemoved();
    }
}

