/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.io.File;

public class MakeActivityCommand
extends OutputCleartoolCommand {
    private String activityName;
    private File viewRoot;

    public MakeActivityCommand(String activityName, File viewRoot) {
        this.viewRoot = viewRoot;
        this.activityName = activityName;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        String[] lines;
        boolean mkActivity = false;
        boolean setStatus = false;
        if (output != null && output.length() > 0 && (lines = output.split("\r\n")).length > 0) {
            boolean bl = mkActivity = lines[0].indexOf(CleartoolCommandConstants.CREATED) > -1;
            if (lines.length > 1) {
                setStatus = lines[1].indexOf(CleartoolCommandConstants.SET) > -1;
            }
        }
        final boolean activityStatus = mkActivity;
        final boolean currentStatus = setStatus;
        return new MakeActivityCommandOutput(){

            @Override
            public boolean isActivityCreated() {
                return activityStatus;
            }

            @Override
            public boolean isActivitySetCurrent() {
                return currentStatus;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"mkactivity", "-nc", "-f", this.activityName};
    }

    @Override
    protected File getFolderToRunIn() {
        return this.viewRoot;
    }

    public static interface MakeActivityCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean isActivityCreated();

        public boolean isActivitySetCurrent();
    }
}

