/*
 * Decompiled with CFR 0.152.
 */
package org.oslc.asset.internal.v2;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import com.ibm.ram.common.util.AttributeConstants;
import com.ibm.ram.internal.jaxb.AssetID;
import com.ibm.ram.internal.jaxb.AttributeValue;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.oslc.asset.internal.Artifact;
import org.oslc.asset.internal.Asset;
import org.oslc.asset.internal.Assets;
import org.oslc.asset.internal.Contributor;
import org.oslc.asset.internal.Dialog;
import org.oslc.asset.internal.Factory;
import org.oslc.asset.internal.Relation;
import org.oslc.asset.internal.ResourceRef;
import org.oslc.asset.internal.ServiceDescriptor;
import org.oslc.asset.internal.ServiceProvider;
import org.oslc.asset.internal.ServiceProviderCatalog;
import org.oslc.asset.internal.ServiceProviderEntry;
import org.oslc.asset.internal.SimpleQuery;
import org.oslc.asset.internal.Tag;
import org.oslc.asset.internal.v2.OSLCVocabulary;
import org.oslc.asset.internal.v2.RelatedResource;
import org.oslc.asset.internal.v2.RelationshipUtil;
import org.oslc.asset.internal.v2.ResponseInfo;

public class OSLCDecoder {
    private Model model;
    private final String serverBase;

    public static Date decode(String dateString) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(dateString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public OSLCDecoder(InputStream inputStream, String serverBase) {
        this.serverBase = serverBase;
        this.model = ModelFactory.createDefaultModel();
        this.model = this.model.read(inputStream, "http://someserver/ram");
    }

    protected Object decode(Resource rdfType) {
        Object decoded = null;
        ResIterator listSubjects = this.model.listSubjectsWithProperty(RDF.type, (RDFNode)rdfType);
        while (listSubjects.hasNext()) {
            Resource subject = (Resource)listSubjects.next();
            decoded = this.decodeSubject(subject);
            if (decoded != null) break;
        }
        return decoded;
    }

    public Asset decodeAsset() {
        return (Asset)this.decode(OSLCVocabulary.Asset.Asset);
    }

    public Artifact decodeArtifact() {
        return (Artifact)this.decode(OSLCVocabulary.Asset.Artifact);
    }

    protected Object decodeSubject(Resource subject) {
        StmtIterator typeStmtsItr = subject.listProperties(RDF.type);
        while (typeStmtsItr.hasNext()) {
            Statement statement = (Statement)typeStmtsItr.next();
            Resource type = statement.getObject().asResource();
            if (OSLCVocabulary.Asset.Asset.equals((Object)type)) {
                return this.decodeAsset(subject);
            }
            if (OSLCVocabulary.Asset.Artifact.equals((Object)type)) {
                return this.decodeArtifact(subject);
            }
            if (OSLCVocabulary.Core.ServiceProviderCatalog.equals((Object)type)) {
                return this.decodeServiceProviderCatalog(subject);
            }
            if (OSLCVocabulary.Core.ServiceProvider.equals((Object)type)) {
                return this.decodeServiceProvider(subject);
            }
            if (!OSLCVocabulary.Core.ResponseInfo.equals((Object)type)) continue;
            return this.decodeResponseInfo(subject);
        }
        return null;
    }

    private ServiceDescriptor decodeServiceProvider(Resource subject) {
        ServiceDescriptor sd = new ServiceDescriptor();
        sd.setBase(this.serverBase);
        sd.setAbout(this.getRelativeLocation(subject.getURI()));
        sd.setTitle(subject.getProperty(DCTerms.title).getObject().asLiteral().getString());
        sd.setDescription(subject.getProperty(DCTerms.description).getObject().asLiteral().getString());
        sd.setContributor(this.decodeContributor(subject.getPropertyResourceValue(DCTerms.publisher)));
        sd.setAssets(this.decodeAssets(subject.getPropertyResourceValue(OSLCVocabulary.Core.service)));
        return sd;
    }

    private Assets decodeAssets(Resource subject) {
        Assets a = new Assets();
        Resource cfr = subject.getPropertyResourceValue(OSLCVocabulary.Core.creationFactory);
        Factory cf = new Factory();
        cf.setAbout(this.getRelativeLocation(cfr.getProperty(OSLCVocabulary.Core.creation).getObject().asResource().getURI()));
        cf.setTitle(cfr.getProperty(DCTerms.title).getObject().asLiteral().getString());
        a.getFactory().add(cf);
        Resource sqr = subject.getPropertyResourceValue(OSLCVocabulary.Core.queryCapability);
        SimpleQuery sq = new SimpleQuery();
        sq.setAbout(this.getRelativeLocation(sqr.getProperty(OSLCVocabulary.Core.queryBase).getObject().asResource().getURI()));
        sq.setTitle(sqr.getProperty(DCTerms.title).getObject().asLiteral().getString());
        a.getSimpleQuery().add(sq);
        Resource sdr = subject.getPropertyResourceValue(OSLCVocabulary.Core.selectionDialog);
        Dialog sd = new Dialog();
        sd.setUrl(this.getRelativeLocation(sdr.getProperty(OSLCVocabulary.Core.dialog).getObject().asResource().getURI()));
        sd.setTitle(sdr.getProperty(DCTerms.title).getObject().asLiteral().getString());
        sd.setLabel(sdr.getProperty(OSLCVocabulary.Core.label).getObject().asLiteral().getString());
        sd.setHintWidth(sdr.getProperty(OSLCVocabulary.Core.hintWidth).getObject().asLiteral().getString());
        sd.setHintHeight(sdr.getProperty(OSLCVocabulary.Core.hintHeight).getObject().asLiteral().getString());
        a.getSelectionDialog().add(sd);
        Resource cdr = subject.getPropertyResourceValue(OSLCVocabulary.Core.creationDialog);
        Dialog cd = new Dialog();
        cd.setUrl(this.getRelativeLocation(cdr.getProperty(OSLCVocabulary.Core.dialog).getObject().asResource().getURI()));
        cd.setTitle(cdr.getProperty(DCTerms.title).getObject().asLiteral().getString());
        cd.setLabel(cdr.getProperty(OSLCVocabulary.Core.label).getObject().asLiteral().getString());
        cd.setHintWidth(cdr.getProperty(OSLCVocabulary.Core.hintWidth).getObject().asLiteral().getString());
        cd.setHintHeight(cdr.getProperty(OSLCVocabulary.Core.hintHeight).getObject().asLiteral().getString());
        a.getSelectionDialog().add(cd);
        return a;
    }

    private Contributor decodeContributor(Resource subject) {
        Contributor c = new Contributor();
        c.setIcon(this.getRelativeLocation(subject.getProperty(OSLCVocabulary.Core.icon).getObject().asResource().getURI()));
        c.setIdentifier(subject.getProperty(DCTerms.identifier).getObject().asLiteral().getString());
        c.setTitle(subject.getProperty(DCTerms.title).getObject().asLiteral().getString());
        return c;
    }

    private ServiceProviderCatalog decodeServiceProviderCatalog(Resource subject) {
        ServiceProviderCatalog catalog = new ServiceProviderCatalog();
        catalog.setTitle(subject.getProperty(DCTerms.title).getObject().asLiteral().getString());
        StmtIterator svcProvidersItr = subject.listProperties(OSLCVocabulary.Core.serviceProvider);
        if (svcProvidersItr != null) {
            while (svcProvidersItr.hasNext()) {
                Statement svcProviderStmt = (Statement)svcProvidersItr.next();
                catalog.getEntries().add(this.decodeServiceProviderEntry(svcProviderStmt.getObject().asResource()));
            }
        }
        return catalog;
    }

    private ServiceProviderEntry decodeServiceProviderEntry(Resource resource) {
        ServiceProviderEntry entry = new ServiceProviderEntry();
        ServiceProvider provider = new ServiceProvider();
        provider.setServices(this.getResourceRef(resource.getURI()));
        provider.setTitle(resource.getProperty(DCTerms.title).getObject().asLiteral().getString());
        entry.setServiceProvider(provider);
        return entry;
    }

    private String getRelativeLocation(String uri) {
        if (uri.startsWith(this.serverBase)) {
            return uri.substring(this.serverBase.length());
        }
        return uri;
    }

    private ResourceRef getResourceRef(String uri) {
        return JAXBLinksUtil.getResourceRef(this.getRelativeLocation(uri), null);
    }

    protected Asset decodeAsset(Resource resource) {
        StmtIterator contribsItr;
        Asset asset = new Asset();
        asset.setBase(this.serverBase);
        if (resource.getURI() != null) {
            asset.setAbout(this.getRelativeLocation(resource.getURI()));
        }
        if (resource.hasProperty(DCTerms.title)) {
            asset.setTitle(resource.getProperty(DCTerms.title).getObject().asLiteral().getString());
        }
        if (resource.hasProperty(DCTerms.description)) {
            asset.setDescription(resource.getProperty(DCTerms.description).getObject().asLiteral().getString());
        }
        if (resource.hasProperty(DCTerms.abstract_)) {
            asset.setSubject(resource.getProperty(DCTerms.abstract_).getObject().asLiteral().getString());
        }
        if ((contribsItr = resource.listProperties(DCTerms.contributor)) != null) {
            while (contribsItr.hasNext()) {
                Statement cs = (Statement)contribsItr.next();
                asset.getContributors().add(this.getResourceRef(cs.getObject().asResource().getURI()));
            }
        }
        if (resource.hasProperty(OSLCVocabulary.RAMAsset.community)) {
            asset.setRAMCommunity(this.getResourceRef(resource.getProperty(OSLCVocabulary.RAMAsset.community).getObject().asResource().getURI()));
        }
        if (resource.hasProperty(DCTerms.type)) {
            asset.setType(this.getResourceRef(resource.getProperty(DCTerms.type).getObject().asResource().getURI()));
        }
        if (resource.hasProperty(OSLCVocabulary.RAMAsset.revisionCount)) {
            asset.setEtag(resource.getProperty(OSLCVocabulary.RAMAsset.revisionCount).getObject().asLiteral().getString());
        }
        if (resource.hasProperty(DCTerms.modified)) {
            asset.setModified(OSLCDecoder.decode(resource.getProperty(DCTerms.modified).getObject().asLiteral().getString()));
        }
        if (resource.hasProperty(OSLCVocabulary.Asset.guid) || resource.hasProperty(OSLCVocabulary.Asset.version)) {
            AssetID id = new AssetID();
            if (resource.hasProperty(OSLCVocabulary.Asset.guid)) {
                id.setGUID(resource.getProperty(OSLCVocabulary.Asset.guid).getObject().asLiteral().getString());
            }
            if (resource.hasProperty(OSLCVocabulary.Asset.version)) {
                id.setVersion(resource.getProperty(OSLCVocabulary.Asset.version).getObject().asLiteral().getString());
            }
            asset.setId(id);
        }
        if (resource.hasProperty(OSLCVocabulary.Asset.state)) {
            asset.setState(this.getResourceRef(resource.getProperty(OSLCVocabulary.Asset.state).getObject().asResource().getURI()));
        }
        StmtIterator catStmtItr = resource.listProperties(OSLCVocabulary.Asset.categorization);
        while (catStmtItr.hasNext()) {
            Statement catStmt = (Statement)catStmtItr.next();
            asset.getRAMCategories().add(this.getResourceRef(catStmt.getObject().asResource().getURI()));
        }
        StmtIterator artifactStmtItr = resource.listProperties(OSLCVocabulary.Asset.artifact);
        while (artifactStmtItr.hasNext()) {
            Statement artifactStmt = (Statement)artifactStmtItr.next();
            asset.getArtifacts().add(this.decodeArtifact(artifactStmt.getObject().asResource()));
        }
        StmtIterator tagStmtItr = resource.listProperties(OSLCVocabulary.Asset.tag);
        while (tagStmtItr.hasNext()) {
            Statement tagStmt = (Statement)tagStmtItr.next();
            asset.getTagsList().add(new Tag(tagStmt.getObject().asLiteral().getString(), false));
        }
        StmtIterator listProperties = resource.listProperties();
        if (listProperties != null) {
            while (listProperties.hasNext()) {
                String predicateURI;
                Statement statement = listProperties.nextStatement();
                String nsURI = statement.getPredicate().getNameSpace();
                String nsPrefix = this.model.getNsURIPrefix(nsURI);
                if ("ram_asset_custom_properties".equals(nsPrefix)) {
                    predicateURI = statement.getPredicate().getURI();
                    int index = predicateURI.indexOf(nsURI);
                    if (index <= -1 || predicateURI.charAt(index + nsURI.length()) != '_') continue;
                    String calculatedID = null;
                    String attributeID = predicateURI.substring(nsURI.length() + 1);
                    int sep1 = attributeID.indexOf("___");
                    int sep2 = sep1 > -1 ? attributeID.indexOf("___", sep1 + 3) : -1;
                    boolean communityAssetTypeAttribute = false;
                    boolean assetTypeAttribute = false;
                    boolean globalAttribute = false;
                    if (sep1 > -1 && sep2 > -1) {
                        communityAssetTypeAttribute = true;
                    }
                    if (!communityAssetTypeAttribute && sep1 > -1) {
                        assetTypeAttribute = true;
                    }
                    if (!communityAssetTypeAttribute && !assetTypeAttribute) {
                        globalAttribute = true;
                    }
                    if (communityAssetTypeAttribute) {
                        calculatedID = "classif/assetTypesSchema/" + attributeID.substring(sep1 + 3, sep2) + "/" + attributeID.substring(0, sep1) + "/container.xmi#" + attributeID.substring(sep2 + 3);
                    }
                    if (assetTypeAttribute) {
                        calculatedID = "classif/assetTypesSchema/" + attributeID.substring(0, sep1) + "/container.xmi#" + attributeID.substring(sep1 + 3);
                    }
                    if (globalAttribute) {
                        calculatedID = "classif/assetTypesSchema.xmi#" + attributeID;
                    }
                    if (calculatedID == null) continue;
                    AttributeValue av = new AttributeValue();
                    av.setAttribute(JAXBLinksUtil.getLink(calculatedID));
                    if (statement.getObject().isLiteral()) {
                        String literalValue = statement.getObject().asLiteral().getString();
                        Date date = OSLCDecoder.decode(literalValue);
                        if (date == null) {
                            av.getValues().add(literalValue);
                        } else {
                            av.getValues().add(AttributeConstants.DATE_FORMAT.format(date));
                        }
                    } else if (statement.getObject().isURIResource()) {
                        String uri = statement.getObject().asResource().getURI();
                        uri = uri.startsWith(this.serverBase) && uri.contains(JAXBLinksUtil.USERS_PATH) ? JAXBLinksUtil.getUserIdentifier(uri.substring(uri.indexOf(JAXBLinksUtil.USERS_PATH))) : "<a href=\"" + uri + "\">" + uri + "</a>";
                        av.getValues().add(uri);
                    }
                    asset.getRAMAttributeValues().add(av);
                    continue;
                }
                if (nsURI == null || !nsURI.startsWith(String.valueOf(resource.getURI()) + "#")) continue;
                predicateURI = statement.getPredicate().getURI();
                String object = statement.getObject().asLiteral().getString();
                String localName = statement.getPredicate().getLocalName();
                if (predicateURI == null) continue;
                StmtIterator iter = statement.getPredicate().getModel().listStatements();
                block5: while (iter.hasNext()) {
                    AttributeValue av2;
                    Statement selfDefinedAttributeStatement = (Statement)iter.next();
                    String subject = selfDefinedAttributeStatement.getSubject().getURI();
                    if (!predicateURI.equals(subject) || !DCTerms.title.getURI().equals(selfDefinedAttributeStatement.getPredicate().getURI()) || !selfDefinedAttributeStatement.getObject().isLiteral()) continue;
                    String attributeTitle = selfDefinedAttributeStatement.getObject().asLiteral().getString();
                    for (AttributeValue av2 : asset.getRAMAttributeValues()) {
                        if (!av2.getAttribute().getHref().equals(localName)) continue;
                        av2.getValues().add(object);
                        continue block5;
                    }
                    av2 = new AttributeValue();
                    av2.setAttribute(JAXBLinksUtil.getLink(attributeTitle, localName));
                    av2.getValues().add(object);
                    asset.getRAMAttributeValues().add(av2);
                }
            }
        }
        StmtIterator relatedStatementIter = resource.listProperties(DCTerms.relation);
        String relationshipTypeName = OSLCVocabulary.Asset.relationshipType.toString();
        ArrayList<RelatedResource> relatedList = new ArrayList<RelatedResource>();
        while (relatedStatementIter.hasNext()) {
            Statement relatedStatement = (Statement)relatedStatementIter.next();
            String relationURI = relatedStatement.getObject().asResource().getURI();
            if (relationURI.contains(".xmi#")) {
                relatedList.add(this.getRelatedResource(relatedStatement, "any"));
                continue;
            }
            asset.getRelationships().add(this.getRelationship(relatedStatement, relationURI, relationshipTypeName));
        }
        RelationshipUtil.setRelatedResources(asset, relatedList);
        return asset;
    }

    private Relation getRelationship(Statement relatedStatement, String relationURI, String relationshipTypeName) {
        Relation relation = new Relation();
        relation.setResource(this.getRelativeLocation(relationURI));
        StmtIterator statementIter = relatedStatement.getObject().getModel().listStatements();
        while (statementIter.hasNext()) {
            Statement statement = (Statement)statementIter.next();
            if (!relationshipTypeName.equals(statement.getPredicate().getURI())) continue;
            String uri = null;
            String targetUri = null;
            if (relatedStatement.isReified()) {
                uri = relatedStatement.listReifiedStatements().nextRS().getURI();
                targetUri = statement.getSubject().asResource().getURI();
            } else {
                uri = relatedStatement.getObject().asResource().getURI();
                targetUri = ((Statement)statement.getSubject().listProperties(RDF.object).next()).getObject().asResource().getURI();
            }
            if (uri == null || !uri.equals(targetUri)) continue;
            relation.setType(this.getResourceRef(statement.getResource().getURI()));
            break;
        }
        return relation;
    }

    private RelatedResource getRelatedResource(Statement relatedStmt, String relationshipType) {
        RSIterator reifiedStatmentItr = relatedStmt.listReifiedStatements();
        ReifiedStatement reifiedStatement = (ReifiedStatement)reifiedStatmentItr.next();
        Statement relTypeStmt = reifiedStatement.getProperty(OSLCVocabulary.Asset.relationshipType);
        String relType = relTypeStmt.getObject().asResource().getURI();
        return new RelatedResource(relatedStmt.getObject().asResource().getURI(), null, null, null, relationshipType, this.getRelativeLocation(relType));
    }

    protected Artifact decodeArtifact(Resource artifactResource) {
        Artifact artifact = new Artifact();
        artifact.setBase(this.serverBase);
        if (artifactResource.hasProperty(OSLCVocabulary.Asset.content)) {
            artifact.setContent(this.getResourceRef(artifactResource.getProperty(OSLCVocabulary.Asset.content).getObject().asResource().getURI()));
        }
        if (artifactResource.hasProperty(DCTerms.title)) {
            artifact.setTitle(artifactResource.getProperty(DCTerms.title).getObject().asLiteral().getString());
        }
        if (artifactResource.hasProperty(OSLCVocabulary.Core.label)) {
            artifact.setSubject(artifactResource.getProperty(OSLCVocabulary.Core.label).getObject().asLiteral().getString());
        }
        if (artifactResource.hasProperty(DCTerms.format)) {
            artifact.setMimeType(artifactResource.getProperty(DCTerms.format).getObject().asLiteral().getString());
        }
        if (artifactResource.hasProperty(OSLCVocabulary.Asset.size)) {
            artifact.setSize(artifactResource.getProperty(OSLCVocabulary.Asset.size).getObject().asLiteral().getLong());
        }
        if (artifactResource.hasProperty(DCTerms.modified)) {
            artifact.setModified(OSLCDecoder.decode(artifactResource.getProperty(DCTerms.modified).getObject().asLiteral().getString()));
        }
        return artifact;
    }

    public ServiceProviderCatalog decodeServiceProviderCatalog() {
        return (ServiceProviderCatalog)this.decode(OSLCVocabulary.Core.ServiceProviderCatalog);
    }

    public ServiceDescriptor decodeServiceProvider() {
        return (ServiceDescriptor)this.decode(OSLCVocabulary.Core.ServiceProvider);
    }

    public ResponseInfo decodeResponseInfo() {
        return (ResponseInfo)this.decode(OSLCVocabulary.Core.ResponseInfo);
    }

    private ResponseInfo decodeResponseInfo(Resource subject) {
        ResponseInfo rInfo = new ResponseInfo();
        rInfo.setBase(this.serverBase);
        rInfo.setAbout(this.getRelativeLocation(subject.getURI()));
        if (subject.hasProperty(DCTerms.title)) {
            rInfo.setTitle(subject.getProperty(DCTerms.title).getObject().asLiteral().getString());
        }
        if (subject.hasProperty(DCTerms.description)) {
            rInfo.setDescription(subject.getProperty(DCTerms.description).getObject().asLiteral().getString());
        }
        if (subject.hasProperty(OSLCVocabulary.Core.totalCount)) {
            rInfo.setCount(subject.getProperty(OSLCVocabulary.Core.totalCount).getObject().asLiteral().getString());
        }
        if (subject.hasProperty(OSLCVocabulary.Core.nextPage)) {
            rInfo.setNextPage(this.getRelativeLocation(subject.getProperty(OSLCVocabulary.Core.nextPage).getObject().asResource().getURI()));
        }
        return rInfo;
    }
}

