/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.ArtifactValidationError;
import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.LocalArchiveFolderArtifact;
import com.ibm.ram.client.LocalFileArtifact;
import com.ibm.ram.client.LocalFolderArtifact;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMArtifact;
import com.ibm.ram.client.RAMAssetActivity;
import com.ibm.ram.client.RAMAssetAttribute;
import com.ibm.ram.client.RAMAssetFeedback;
import com.ibm.ram.client.RAMAssetQueryBuilder;
import com.ibm.ram.client.RAMAssetRatings;
import com.ibm.ram.client.RAMAssetTag;
import com.ibm.ram.client.RAMAssetType;
import com.ibm.ram.client.RAMAssetValidation;
import com.ibm.ram.client.RAMCategory;
import com.ibm.ram.client.RAMCategorySchema;
import com.ibm.ram.client.RAMCommunity;
import com.ibm.ram.client.RAMFolderArtifact;
import com.ibm.ram.client.RAMForum;
import com.ibm.ram.client.RAMPersonTime;
import com.ibm.ram.client.RAMRelationship;
import com.ibm.ram.client.RAMRelationshipType;
import com.ibm.ram.client.RAMResourceAttribute;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.client.RAMState;
import com.ibm.ram.client.RAMStateHistory;
import com.ibm.ram.client.RAMSubCategory;
import com.ibm.ram.client.RAMSubscription;
import com.ibm.ram.client.RAMURLArtifact;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.client.RCAssetNotFoundException;
import com.ibm.ram.client.status.RAMStatusMonitor;
import com.ibm.ram.common.data.Activity;
import com.ibm.ram.common.data.Artifact;
import com.ibm.ram.common.data.AssetActivity;
import com.ibm.ram.common.data.AssetAttribute;
import com.ibm.ram.common.data.AssetFeedback;
import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.common.data.AssetRatings;
import com.ibm.ram.common.data.AssetSearchResult;
import com.ibm.ram.common.data.AssetTag;
import com.ibm.ram.common.data.AssetType;
import com.ibm.ram.common.data.Category;
import com.ibm.ram.common.data.CategorySchema;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.CustomAssetActivity;
import com.ibm.ram.common.data.FolderArtifact;
import com.ibm.ram.common.data.Forum;
import com.ibm.ram.common.data.PersonTime;
import com.ibm.ram.common.data.Relationship;
import com.ibm.ram.common.data.RelationshipInfo;
import com.ibm.ram.common.data.RelationshipRange;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.SearchQuery;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.common.data.State;
import com.ibm.ram.common.data.SubCategory;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.AssetNotFoundException;
import com.ibm.ram.common.data.exception.EntitlementException;
import com.ibm.ram.common.data.exception.RAMException;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.ArtifactConstraintValidationError;
import com.ibm.ram.common.util.CategorizationConstraintValidationError;
import com.ibm.ram.common.util.CustomAttributeValidationError;
import com.ibm.ram.common.util.DeltaAssetFileBuilder;
import com.ibm.ram.common.util.FieldValidationError;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.ManifestBuilder;
import com.ibm.ram.common.util.RelationshipConstraintValidationError;
import com.ibm.ram.common.util.UniqueIDGenerator;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.Asset;
import com.ibm.ram.defaultprofile.DefaultprofileFactory;
import com.ibm.ram.defaultprofile.FreeFormDescriptor;
import com.ibm.ram.defaultprofile.FreeFormValue;
import com.ibm.ram.defaultprofile.NodeDescriptor;
import com.ibm.ram.defaultprofile.RelatedAsset;
import com.ibm.ram.defaultprofile.Solution;
import com.ibm.ram.internal.activities.AssetBuildActivity;
import com.ibm.ram.internal.activities.AssetDevActivity;
import com.ibm.ram.internal.client.AbstractRESTClient;
import com.ibm.ram.internal.client.RAMServiceException;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import com.ibm.ram.internal.client.util.AssetUtil;
import com.ibm.ram.internal.client.util.ClientValidationManager;
import com.ibm.ram.internal.common.data.ActivitySO;
import com.ibm.ram.internal.common.data.AssetSO;
import com.ibm.ram.internal.common.util.LifecycleUtilities;
import com.ibm.ram.internal.common.util.RelationshipRangeUtility;
import com.ibm.ram.internal.common.util.Tag;
import com.ibm.ram.internal.common.util.Utilities;
import com.ibm.ram.internal.jaxb.Action;
import com.ibm.ram.internal.jaxb.AssetID;
import com.ibm.ram.internal.jaxb.Lifecycle;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.ObjectFactory;
import com.ibm.ram.internal.jaxb.StateHistory;
import com.ibm.ram.internal.jaxb.Subscription;
import com.ibm.ram.internal.jaxb.Workflow;
import com.ibm.ram.internal.jaxb.atom.FeedType;
import com.ibm.ram.internal.jaxb.util.FeedIterator;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.rest.AbstractRestService;
import com.ibm.ram.internal.rest.Request;
import com.ibm.ram.internal.rest.Response;
import com.ibm.ram.io.zip.ZipEntry;
import com.ibm.ram.io.zip.ZipOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.text.Bidi;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class RAMAsset
extends com.ibm.ram.common.data.Asset
implements IRAMSessionObject {
    private static final Logger logger = Logger.getLogger((String)RAMAsset.class.getName());
    private RAMSession fSession;
    private AssetInformation fAssetInformation;
    private boolean fFullAsset = false;
    private ManifestBuilder fManifestBuilder;
    private String fOriginalGUID;
    private String fOriginalVersion;
    private boolean fCreatedGUID = false;
    private boolean fKeepOldVersion;
    private boolean fOwnersModified = false;
    private RAMAssetAttribute[] fAssetAttributes;
    private Map fAssetAttributesByName;
    private volatile RAMCategorySchema[] fCategorySchemas;
    private Map fCategorySchemasByName;
    private volatile RAMCategorySchema[] fSetSchemas;
    private Map fCategoryValues = new HashMap();
    private volatile RAMAssetTag[] fAssetTags;
    private RAMForum[] fForums;
    private RAMState fState;
    private RAMAssetRatings fAssetRatings;
    private File fRASFile;
    private boolean fDelta;
    private boolean fAssetDirty;
    private boolean fArtifactsFetched;
    private boolean fActivityDirty;
    private boolean fTagDirty;
    private boolean fForumDirty;
    private boolean fRatingDirty;
    private boolean fSubscriptionDirty;
    private boolean fForce;
    private RAMAction fAction;
    private RAMAction[] fAvailableActions;
    private RAMStateHistory fCurrentStateHistory;
    private Lifecycle fLifecycle;
    private static final Lifecycle LEGACY_LIFECYCLE = new Lifecycle(){

        @Override
        public String getHref() {
            return "internal/lifecycles/" + JAXBLinksUtil.LEGACY_WORKFLOW_ID;
        }

        @Override
        public String getIdentifier() {
            return JAXBLinksUtil.LEGACY_WORKFLOW_ID;
        }
    };
    private RAMPersonTime fUsageTime;
    private RAMPersonTime fCreationTime;
    private List fActivitiesToRecord = new ArrayList();
    private DeltaAssetFileBuilder fDeltaAssetFileBuilder;
    private Set fArtifactsToRemove = new HashSet();
    private List<RAMSubscription> fSubscriptions;
    static String SESSION_KEY_DELIM = "#";
    static String SESSION_PENDING_ASSET_KEY = "#PENDING";
    static String SESSION_NEW_ASSET_KEY = "NEW_ASSET";
    static String SESSION_ASSET_KEY = "ASSET";
    Map<NodeDescriptor, NodeDescriptor> forcedSubCategory = new HashMap<NodeDescriptor, NodeDescriptor>();
    private static State REFREH_NEEDED_STATE = new State(){
        public int REFREH_NEEDED_ID = -2;
        public String REFHRESH_NEEDED_NAME = "Refresh Needed";

        @Override
        public int getId() {
            return this.REFREH_NEEDED_ID;
        }

        @Override
        public String getName() {
            return this.REFHRESH_NEEDED_NAME;
        }
    };
    private final String FETCH_ASSET_MUTEX = "FETCH_ASSET";
    private static final char LEFT_TO_RIGHT_MARKER = '\u200e';
    private static final char RIGHT_TO_LEFT_MARKER = '\u200f';
    private Boolean changeLockStatusTo;
    private String changeLockStatusComment;
    private boolean changeLockStatusDirty;
    private String updateComments;

    RAMAsset(RAMSession session, AssetSO webServiceAsset) {
        this.fSession = session;
        this.fFullAsset = true;
        this.fOriginalGUID = webServiceAsset.getIdentification().getGUID();
        this.fOriginalVersion = webServiceAsset.getIdentification().getVersion();
        this.setInternalAsset(webServiceAsset);
    }

    private void setInternalAsset(AssetInformation webServiceAsset) {
        String trimVersion;
        String curVersion;
        this.fAssetInformation = webServiceAsset;
        if (this.fAssetInformation != null && this.fAssetInformation.getIdentification().getVersion() != null && !(curVersion = this.fAssetInformation.getIdentification().getVersion()).equals(trimVersion = curVersion.trim())) {
            this.fAssetInformation.getIdentification().setVersion(trimVersion);
            if (this.fManifestBuilder != null) {
                this.fManifestBuilder.setVersion(trimVersion);
            }
            this.setAssetDirty(true);
        }
    }

    RAMAsset(RAMSession session, AssetInformation webServiceAsset) {
        this.fSession = session;
        this.fFullAsset = false;
        this.fOriginalGUID = webServiceAsset.getIdentification().getGUID();
        this.fOriginalVersion = webServiceAsset.getIdentification().getVersion();
        this.setInternalAsset(webServiceAsset);
    }

    RAMAsset(RAMSession session, String GUID, String version, int managementStyle) {
        this.fSession = session;
        this.fFullAsset = true;
        this.fAction = RAMAction.CREATE;
        this.fAssetInformation = new AssetSO();
        if (GUID == null) {
            GUID = UniqueIDGenerator.getUniqueID();
        }
        this.fOriginalGUID = GUID;
        this.fAssetInformation.getIdentification().setGUID(GUID);
        if (version == null || version.indexOf("*") != -1) {
            version = this.createVersionSuggestion(version);
        }
        this.fOriginalVersion = version;
        this.fAssetInformation.getIdentification().setVersion(version);
        this.fAssetInformation.setManagementStyle(managementStyle);
        this.setInternalAsset(this.fAssetInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void setAsCreateNewVersion(String originalGUID, String originalVersion) {
        block5: {
            this.fOriginalGUID = originalGUID;
            this.fOriginalVersion = originalVersion;
            this.fAction = RAMAction.UPDATE;
            try {
                String string = "FETCH_ASSET";
                // MONITORENTER : "FETCH_ASSET"
                this.fSession.fetchAssetFromServer(new AssetIdentification(this.fOriginalGUID, this.fOriginalVersion), false, false);
                // MONITOREXIT : string
            }
            catch (Exception e) {
                if (!(e instanceof AssetNotFoundException)) break block5;
                this.fAction = RAMAction.CREATE;
            }
        }
        this.setKeepOldVersion(true);
    }

    public RAMAction[] getAvailableActions() throws RAMRuntimeException {
        try {
            if (this.fAvailableActions == null) {
                if (this.getSession().compareServicesVersion(RAMSession.RAM_7_2_0_1_SERVICES_VERSION) >= 0) {
                    AbstractRESTClient restClient = this.getSession().getRESTClient();
                    FeedIterator<Action> response = restClient.getAvailableActions(this.getIdentification(), true);
                    RAMAction[] ret = new RAMAction[response.getSize()];
                    int i = 0;
                    while (i < response.getSize()) {
                        ret[i] = new RAMAction(response.next());
                        ++i;
                    }
                    this.fAvailableActions = ret;
                } else if (this.getSession().compareServicesVersion(RAMSession.RAM_7_2_0_0_SERVICES_VERSION) >= 0) {
                    List<RAMAction> actions = ((RAMState)this.getState()).getAvailableActions(this);
                    RAMAction[] actionArray = actions.toArray(new RAMAction[actions.size()]);
                    this.fAvailableActions = actionArray;
                }
            }
            return this.fAvailableActions;
        }
        catch (Exception e) {
            throw new RAMRuntimeException("Failed to load available actions", e);
        }
    }

    Lifecycle getLifecycle() throws RAMRuntimeException {
        try {
            if (this.fLifecycle == null) {
                if (this.getSession().compareServicesVersion(RAMSession.RAM_7_2_0_0_SERVICES_VERSION) >= 0) {
                    AbstractRESTClient restClient = this.getSession().getRESTClient();
                    Response<Lifecycle> response = restClient.getLifecycle(this.getIdentification(), true);
                    this.fLifecycle = response.getValue();
                }
                if (this.fLifecycle == null) {
                    this.fLifecycle = LEGACY_LIFECYCLE;
                }
            }
            return this.fLifecycle;
        }
        catch (Exception e) {
            throw new RAMRuntimeException("Failed to load asset lifecyle", e);
        }
    }

    boolean isInLifecycle() throws RAMRuntimeException {
        return this.getLifecycle() != null && !this.getLifecycle().equals(LEGACY_LIFECYCLE);
    }

    Workflow getWorkflow() throws RAMRuntimeException {
        Workflow ret = null;
        if (this.isInLifecycle()) {
            ret = this.getLifecycle().getWorkflow().getValue();
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.fAssetInformation.getName();
    }

    @Override
    public void setName(String name) {
        if (name == null && this.fAssetInformation.getName() != null || name != null && !name.equals(this.fAssetInformation.getName())) {
            this.setAssetDirty(true);
        }
        this.fAssetInformation.setName(name);
        if (this.fManifestBuilder != null) {
            this.fManifestBuilder.setName(name);
        }
    }

    @Override
    public String getGUID() throws RAMRuntimeException {
        if (this.fAssetInformation.getIdentification().getGUID() == null) {
            String oldKey = this.getSessionKey();
            this.fAssetInformation.getIdentification().setGUID(this.getManifestBuilder().getId());
            this.fCreatedGUID = true;
            this.getSession().rehashIfNeeded(this, oldKey);
        }
        return this.fAssetInformation.getIdentification().getGUID();
    }

    void internalSetGUID(String guid) {
        if (guid == null && this.fAssetInformation.getIdentification().getGUID() != null || guid != null && !guid.equals(this.fAssetInformation.getIdentification().getGUID())) {
            this.setAssetDirty(true);
        }
        if (this.fOriginalGUID == null) {
            this.fCreatedGUID = true;
        }
        String oldKey = this.getSessionKey();
        this.fAssetInformation.getIdentification().setGUID(guid);
        if (this.fManifestBuilder != null) {
            this.fManifestBuilder.setId(guid);
        }
        this.getSession().rehashIfNeeded(this, oldKey);
        this.fAction = RAMAction.CREATE;
    }

    @Override
    public void setGUID(String guid) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.USE_CREATE_ASSET_TO_CHANGE_GUID"), true);
    }

    @Override
    public AssetIdentification getIdentification() {
        AssetIdentification ret = new AssetIdentification(this.fAssetInformation.getIdentification().getGUID(), this.fAssetInformation.getIdentification().getVersion(), this.fAssetInformation.getIdentification().isPendingAsset(), this.getSession().getIdentification());
        return ret;
    }

    @Override
    public AssetIdentification getMainAssetId() {
        return this.fAssetInformation.getMainAssetId();
    }

    @Override
    public AssetIdentification getPendingAssetId() {
        return this.fAssetInformation.getPendingAssetId();
    }

    @Override
    public void setIdentification(AssetIdentification identification) {
        throw new RAMRuntimeException("The Identifaction cannot be set by the client");
    }

    @Override
    public void setMainAssetId(AssetIdentification mainAsset) {
        throw new RAMRuntimeException("The Main Asset Identification cannot be set by the client");
    }

    @Override
    public void setPendingAssetId(AssetIdentification pendingAsset) {
        throw new RAMRuntimeException("The Pending Asset Identification cannot be set by the client");
    }

    @Override
    public String getVersion() {
        return this.getIdentification().getVersion();
    }

    private String createVersionSuggestion(String versionPattern) {
        String GUID = this.fAssetInformation.getIdentification().getGUID();
        if (versionPattern == null) {
            versionPattern = "*";
        }
        String version = null;
        if (GUID == null) {
            version = "1.0";
        } else {
            String[] versions = this.fetchVersions(versionPattern);
            if (versions.length == 0 || versions[0] == null || versions[0].length() == 0) {
                version = versionPattern.equals("*") ? "1.0" : versionPattern.replaceAll("\\*", "0");
            } else {
                version = versions[0];
                int length = version.length();
                int lastDotIndex = version.lastIndexOf(".");
                char curChar = version.charAt(length - 1);
                if (!Character.isDigit(curChar)) {
                    version = String.valueOf(version) + "1";
                } else if (lastDotIndex == -1) {
                    version = String.valueOf(version) + ".1";
                } else {
                    int pointer = length - 1;
                    int index = length - 1;
                    while (pointer > lastDotIndex) {
                        if (!Character.isDigit(curChar = version.charAt(--pointer))) break;
                        index = pointer;
                    }
                    String lastNumber = version.substring(index);
                    long number = Long.parseLong(lastNumber);
                    version = index == 0 ? Long.toString(number) : String.valueOf(version.substring(0, index)) + Long.toString(++number);
                }
            }
        }
        return version;
    }

    void internalSetVersion(String version) {
        if (version == null || version.indexOf("*") != -1) {
            version = this.createVersionSuggestion(version);
        }
        if (version != null) {
            version = version.trim();
        }
        if (version == null && this.fAssetInformation.getIdentification().getVersion() != null || version != null && !version.equals(this.fAssetInformation.getIdentification().getVersion())) {
            this.setAssetDirty(true);
            this.fAction = RAMAction.CREATE;
        }
        String oldKey = this.getSessionKey();
        this.fAssetInformation.getIdentification().setVersion(version);
        if (this.fManifestBuilder != null) {
            this.fManifestBuilder.setVersion(version);
        }
        this.getSession().rehashIfNeeded(this, oldKey);
    }

    @Override
    public void setVersion(String version) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.USE_CREATE_ASSET_TO_CHANGE_VERSION"), true);
    }

    @Override
    public String getDescription() {
        return this.getInternalAsset().getDescription();
    }

    DeltaAssetFileBuilder getDeltaAssetFileBuilder() throws IOException {
        if (this.fDeltaAssetFileBuilder == null) {
            File unqiueLocation = new File(this.getSession().getLocalStorageFolder(), RAMAsset.cleanFromUnsuitableFilechars(this.getSessionKey()));
            unqiueLocation.deleteOnExit();
            this.fDeltaAssetFileBuilder = new DeltaAssetFileBuilder(unqiueLocation, this.isUpdate());
        }
        return this.fDeltaAssetFileBuilder;
    }

    Set getArtifactsToRemove() {
        return this.fArtifactsToRemove;
    }

    @Override
    public void setDescription(String description) {
        if (description == null && this.getInternalAsset().getDescription() != null || description != null && !description.equals(this.getInternalAsset().getDescription())) {
            this.setAssetDirty(true);
        }
        this.getInternalAsset().setDescription(description);
        if (this.fManifestBuilder != null) {
            this.fManifestBuilder.setDescription(description);
        }
    }

    AssetInformation getInternalAssetInformation() throws RAMRuntimeException {
        if (this.fState != null && this.fState.getId() == REFREH_NEEDED_STATE.getId()) {
            this.upgradeAsset();
        }
        return this.fAssetInformation;
    }

    Link<com.ibm.ram.internal.jaxb.Asset> getRestAssetRef() {
        Link<com.ibm.ram.internal.jaxb.Asset> assetRef = JAXBLinksUtil.getAssetLink(this.getIdentification());
        return assetRef;
    }

    AssetSO getInternalAsset() throws RAMRuntimeException {
        if (!this.fFullAsset || this.fState != null && this.fState.getId() == REFREH_NEEDED_STATE.getId()) {
            this.upgradeAsset();
        }
        return (AssetSO)this.fAssetInformation;
    }

    void assetCommited() throws RAMRuntimeException {
        if (this.fDeltaAssetFileBuilder != null) {
            this.fDeltaAssetFileBuilder.close();
            this.fDeltaAssetFileBuilder = null;
        }
        if (this.fArtifactsToRemove != null) {
            this.fArtifactsToRemove.clear();
        }
        if (this.fRASFile != null && this.fRASFile.exists()) {
            this.fRASFile = null;
        }
        this.fOriginalGUID = this.getGUID();
        this.fOriginalVersion = this.getVersion();
        if (this.fManifestBuilder != null) {
            this.getSession().getResourceSet().getResources().remove((Object)this.fManifestBuilder.getManifestResource());
            this.fManifestBuilder = null;
        }
        AssetInformation newAssetInformation = new AssetInformation();
        newAssetInformation.setAverageRating(this.fAssetInformation.getAverageRating());
        newAssetInformation.setCommunityName(this.fAssetInformation.getCommunityName());
        newAssetInformation.setIdentification(this.fAssetInformation.getIdentification());
        newAssetInformation.setLastModified(this.fAssetInformation.getLastModified());
        newAssetInformation.setManagementStyle(this.fAssetInformation.getManagementStyle());
        newAssetInformation.setName(this.fAssetInformation.getName());
        newAssetInformation.setShortDescription(this.fAssetInformation.getShortDescription());
        newAssetInformation.setTypeName(this.fAssetInformation.getTypeName());
        this.setKeepOldVersion(false);
        this.clearAsset();
        this.fState = new RAMState(this.getSession(), REFREH_NEEDED_STATE);
        newAssetInformation.setStateName(this.fState.getName());
        newAssetInformation.setStateID(this.fState.getId());
        this.fAssetInformation = newAssetInformation;
        this.fForce = false;
        this.clearDirtyFlags();
    }

    void metadataCommited() throws RAMRuntimeException {
        if (this.isActivityDirty()) {
            this.fActivitiesToRecord.clear();
        }
        if (this.isRatingDirty()) {
            this.fAssetRatings = null;
        }
        if (this.isForumDirty()) {
            this.fForums = null;
        }
        if (this.isSubscriptionsDirty()) {
            this.fSubscriptions = null;
        }
        if (this.isChangeLockStatusDirty()) {
            this.changeLockStatusComment = null;
            this.changeLockStatusTo = null;
            this.fState = new RAMState(this.getSession(), REFREH_NEEDED_STATE);
        }
        this.fForce = false;
        this.clearDirtyFlags();
    }

    ManifestBuilder getManifestBuilder() throws RAMRuntimeException {
        if (this.fManifestBuilder == null) {
            try {
                this.fManifestBuilder = this.createManifestBuilder(this.loadManifestFromAssetManifest(), this.fFullAsset);
                if (super.getArtifactsRoot() instanceof RAMFolderArtifact) {
                    RAMFolderArtifact root = (RAMFolderArtifact)super.getArtifactsRoot();
                    root.setAsRoot(this, this.fManifestBuilder.getSolution());
                }
            }
            catch (Exception e) {
                if (e instanceof RAMRuntimeException) {
                    throw (RAMRuntimeException)e;
                }
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
        return this.fManifestBuilder;
    }

    private ManifestBuilder createManifestBuilder(Asset newManifest, boolean setDescriptionFromCurrentAssetInfo) {
        CommunityInformation community;
        if (newManifest == null) {
            ResourceSet resSet = this.getSession().getResourceSet();
            newManifest = ManifestBuilder.createEmptyManifest();
            Resource r = resSet.createResource(URI.createURI((String)("ram:asset/" + newManifest.getId() + ".rmd")));
            r.getContents().add((Object)newManifest);
        }
        ManifestBuilder newManifestBuilder = new ManifestBuilder(newManifest, null, (community = this.getCommunity()) != null ? ((RAMCommunity)community).getInternalCommunityInformation() : null);
        newManifestBuilder.setId(this.fAssetInformation.getIdentification().getGUID());
        newManifestBuilder.setName(this.fAssetInformation.getName());
        newManifestBuilder.setVersion(this.fAssetInformation.getIdentification().getVersion());
        newManifestBuilder.setShortDescription(this.fAssetInformation.getShortDescription());
        if (super.getAssetType() != null) {
            newManifestBuilder.setAssetTypeURI(URI.createURI((String)super.getAssetType().getURI()));
        }
        newManifestBuilder.initializeClassifications(true, Collections.<URI>emptySet(), false);
        newManifestBuilder.initializeCustomAttributes(true, Collections.<String>emptySet(), false);
        if (this.fCreationTime != null) {
            newManifestBuilder.setCreationTime(this.fCreationTime.getManifestTime());
        }
        if (this.fUsageTime != null) {
            newManifestBuilder.setUsageTime(this.fUsageTime.getManifestTime());
        }
        if (setDescriptionFromCurrentAssetInfo) {
            newManifestBuilder.setDescription(((com.ibm.ram.common.data.Asset)this.fAssetInformation).getDescription());
        }
        newManifestBuilder.manageDetails();
        ClientValidationManager validationManager = new ClientValidationManager(this, this.getSession(), this.getSession().getRAMClient(), this.getSession().getResourceSet());
        newManifestBuilder.setValidationManager(validationManager);
        return newManifestBuilder;
    }

    private Asset loadManifestFromAssetManifest() throws RAMRuntimeException {
        AssetSO assetFromServer = this.getInternalAsset();
        Asset assetManifest = null;
        String manifestString = null;
        if (this.isUpdate()) {
            AssetIdentification id = new AssetIdentification(this.getOriginalGUID(), this.getOriginalVersion(), this.getIdentification().isPendingAsset(), this.getIdentification().getRepositoryIdentification());
            RAMAsset remoteAsset = this.getSession().getAsset(id);
            manifestString = remoteAsset.getInternalAsset().getManifest();
        } else {
            manifestString = assetFromServer.getManifest();
        }
        if (manifestString == null) {
            return null;
        }
        try {
            String serverPath = this.getSession().getRAMClient().getWebServerPath();
            assetManifest = RAMAsset.loadManifestFromStream(this.getSession(), "ram://create" + assetFromServer.getIdentification().getGUID() + assetFromServer.getIdentification().getVersion(), new ByteArrayInputStream(manifestString.getBytes("UTF-8")));
            ManifestBuilder.setServerPath(assetManifest.eResource().getResourceSet(), serverPath);
            assetFromServer.setManifest(null);
        }
        catch (Exception ieee) {
            throw new RAMRuntimeException(ieee.getLocalizedMessage(), ieee);
        }
        return assetManifest;
    }

    static Asset loadManifestFromStream(RAMSession session, String uriString, InputStream manifestIs) throws RAMRuntimeException, IOException {
        Asset result = null;
        try {
            if (manifestIs.available() != 0) {
                ResourceSet resSet = session.getResourceSet();
                Resource manifestRes = resSet.createResource(URI.createURI((String)uriString));
                ((XMIResource)manifestRes).setEncoding("UTF-8");
                manifestRes.load(manifestIs, null);
                if (manifestRes.getContents() != null) {
                    result = (Asset)manifestRes.getContents().get(0);
                }
            }
        }
        catch (IOException ieee) {
            throw ieee;
        }
        catch (Exception ieee) {
            throw new RAMRuntimeException(ieee.getLocalizedMessage(), ieee);
        }
        if (result == null) {
            throw new RAMRuntimeException(ClientMessages.getString("AssetUtil.1"), true);
        }
        return result;
    }

    public RAMAssetValidation[] validate() {
        RAMAssetValidation[] problems;
        Map<String, Object> validatorMap = this.getManifestBuilder().getValidationManager().validate();
        if (validatorMap != null && validatorMap.size() > 0) {
            int aec;
            ArrayList<RAMAssetValidation> messagesList = new ArrayList<RAMAssetValidation>();
            FieldValidationError[] fieldValidationErrors = (FieldValidationError[])validatorMap.get("field_errors");
            ArtifactConstraintValidationError[] artifactConstraintErrors = (ArtifactConstraintValidationError[])validatorMap.get("artifact_constraints_errors");
            CustomAttributeValidationError[] customAttributeErrors = (CustomAttributeValidationError[])validatorMap.get("custom_attributes_errors");
            RelationshipConstraintValidationError[] relationshipErrors = (RelationshipConstraintValidationError[])validatorMap.get("relationship_constraints_errors");
            CategorizationConstraintValidationError[] categorizationConstraintErrors = (CategorizationConstraintValidationError[])validatorMap.get("categorization_errors");
            ArtifactValidationError[] artifactErrors = (ArtifactValidationError[])validatorMap.get(ClientValidationManager.ARTIFACT_ERRORS);
            if (fieldValidationErrors != null) {
                aec = 0;
                while (aec < fieldValidationErrors.length) {
                    messagesList.add(new RAMAssetValidation(fieldValidationErrors[aec].getErrorMessage()));
                    ++aec;
                }
            }
            if (artifactConstraintErrors != null) {
                aec = 0;
                while (aec < artifactConstraintErrors.length) {
                    messagesList.add(new RAMAssetValidation(artifactConstraintErrors[aec].getErrorMessage()));
                    ++aec;
                }
            }
            if (customAttributeErrors != null) {
                aec = 0;
                while (aec < customAttributeErrors.length) {
                    messagesList.add(new RAMAssetValidation(customAttributeErrors[aec].getErrorMessage()));
                    ++aec;
                }
            }
            if (relationshipErrors != null) {
                aec = 0;
                while (aec < relationshipErrors.length) {
                    messagesList.add(new RAMAssetValidation(relationshipErrors[aec].getErrorMessage()));
                    ++aec;
                }
            }
            if (categorizationConstraintErrors != null) {
                aec = 0;
                while (aec < categorizationConstraintErrors.length) {
                    messagesList.add(new RAMAssetValidation(categorizationConstraintErrors[aec].getErrorMessage()));
                    ++aec;
                }
            }
            if (artifactErrors != null) {
                aec = 0;
                while (aec < artifactErrors.length) {
                    messagesList.add(new RAMAssetValidation(artifactErrors[aec].getErrorMessage()));
                    ++aec;
                }
            }
            problems = messagesList.toArray(new RAMAssetValidation[messagesList.size()]);
        } else {
            problems = new RAMAssetValidation[]{};
        }
        return problems;
    }

    @Override
    public String getShortDescription() {
        return this.fAssetInformation.getShortDescription();
    }

    @Override
    public void setShortDescription(String shortDescription) {
        if (shortDescription == null && this.fAssetInformation.getShortDescription() != null || shortDescription != null && !shortDescription.equals(this.fAssetInformation.getShortDescription())) {
            this.setAssetDirty(true);
        }
        this.fAssetInformation.setShortDescription(shortDescription);
        if (this.fManifestBuilder != null) {
            this.fManifestBuilder.setShortDescription(shortDescription);
        }
    }

    public int getRevisionCount() throws RAMRuntimeException {
        return this.getManifestBuilder().getRevisionCount();
    }

    @Override
    public Relationship[] getRelationships() throws RAMRuntimeException {
        if (super.getRelationships() == null) {
            List<RelatedAsset> relatedAssets = this.getManifestBuilder().getRelatedAssets();
            Relationship[] relationships = new RAMRelationship[relatedAssets.size()];
            int i = 0;
            while (i < relatedAssets.size()) {
                RelatedAsset relatedAsset = relatedAssets.get(i);
                relationships[i] = new RAMRelationship(this, null, relatedAsset);
                ++i;
            }
            super.setRelationships(relationships);
        }
        return super.getRelationships();
    }

    public RAMRelationship addRelatedAsset(com.ibm.ram.common.data.Asset relatedAsset, RelationshipType relationType) throws RAMRuntimeException {
        if (relatedAsset == null) {
            throw new RAMRuntimeException("Related asset cannot be null");
        }
        if (relationType == null) {
            throw new RAMRuntimeException("Relationship type cannot be null");
        }
        boolean alreadyAdded = false;
        RAMRelationship ret = null;
        RAMRelationship[] relationships = (RAMRelationship[])this.getRelationships();
        int i = 0;
        while (i < relationships.length) {
            RAMRelationship relationship = relationships[i];
            if (relationType.getName().equals(relationship.getRelationshipTypeName()) && relatedAsset.getIdentification().getGUID().equals(relationship.getChildAssetGUID()) && relatedAsset.getIdentification().getVersion().equals(relationship.getChildAssetVersion())) {
                ret = relationship;
                alreadyAdded = true;
                break;
            }
            ++i;
        }
        if (!alreadyAdded) {
            RelatedAsset newRelatedAsset = this.getManifestBuilder().addRelatedAsset(relatedAsset.getName(), relatedAsset.getIdentification().getGUID(), relatedAsset.getIdentification().getVersion(), relationType.getName());
            ret = new RAMRelationship(this, (RAMAsset)relatedAsset, newRelatedAsset);
            ret.setRelationshipType(relationType);
            Relationship[] newRelationships = new RAMRelationship[relationships.length + 1];
            System.arraycopy(relationships, 0, newRelationships, 0, relationships.length);
            newRelationships[relationships.length] = ret;
            ((RAMAsset)relatedAsset).addReverseRelationship(this, ((RAMRelationshipType)relationType).getReverseType(), false);
            super.setRelationships(newRelationships);
            this.setAssetDirty(true);
        }
        return ret;
    }

    public void addSubscription(RAMSubscription subscription) {
        subscription.setAsset(this);
        subscription.setIdentifier(null);
        if (subscription.getUser() == null) {
            subscription.setUser(this.getSession().getUser());
        }
        subscription.setAction(RAMAction.CREATE);
        if (this.fSubscriptions == null) {
            this.getSubscriptions();
        }
        this.fSubscriptions.add(subscription);
        this.setSubscriptionsDirty(true);
    }

    AssetID getAssetID() {
        return new AssetID(this.getIdentification().getGUID(), this.getIdentification().getVersion());
    }

    public RAMSubscription[] getSubscriptions() {
        try {
            if (this.fSubscriptions == null) {
                ArrayList<RAMSubscription> subscriptions = new ArrayList<RAMSubscription>();
                AbstractRESTClient rClient = this.fSession.getRESTClient();
                Request request = new Request(JAXBLinksUtil.getAssetSubscriptionsHref(this.getAssetID()));
                request.setRequestingClass(FeedType.class);
                request.getHeadersMap().put("Cache-Control", "no-store");
                AbstractRestService service = rClient.getRestService(request);
                FeedIterator subFeed = new FeedIterator((FeedType)service.doGet().getValue());
                while (subFeed.hasNext()) {
                    Subscription sub = (Subscription)subFeed.next();
                    subscriptions.add(new RAMSubscription(this, sub));
                }
                this.fSubscriptions = subscriptions;
            }
            return this.fSubscriptions.toArray(new RAMSubscription[this.fSubscriptions.size()]);
        }
        catch (RAMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    void updateSubscriptions(RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (this.fSubscriptions != null && this.fSubscriptions.size() > 0) {
            monitor.beginTask("Update Subscriptions", this.fSubscriptions.size() * 10);
            try {
                AbstractRESTClient rClient = this.fSession.getRESTClient();
                for (RAMSubscription sub : this.fSubscriptions) {
                    AbstractRestService service;
                    Request request;
                    String subHref;
                    if (sub.getAction() == RAMAction.CREATE) {
                        subHref = JAXBLinksUtil.getAssetSubscriptionsHref(this.getAssetID());
                        request = new Request(subHref);
                        request.setRequestingClass(Subscription.class);
                        request.getLink().setValue(new ObjectFactory().createSubscription(sub.getInternalSubscription()));
                        service = rClient.getRestService(request);
                        service.doPost();
                    } else if (sub.getAction() == RAMAction.UPDATE) {
                        subHref = sub.getResourceURI();
                        request = new Request(subHref);
                        request.setRequestingClass(Subscription.class);
                        request.getLink().setValue(new ObjectFactory().createSubscription(sub.getInternalSubscription()));
                        service = rClient.getRestService(request);
                        service.doPut();
                    } else if (sub.getAction() == RAMAction.DELETE) {
                        subHref = sub.getResourceURI();
                        request = new Request(subHref);
                        request.setRequestingClass(Subscription.class);
                        service = rClient.getRestService(request);
                        service.doDelete();
                    }
                    sub.setAction(null);
                    monitor.worked(1);
                }
            }
            catch (Exception e) {
                monitor.appendStatus(this, 2, 1011, e.getLocalizedMessage(), e);
            }
        } else {
            monitor.beginTask("Update Subscriptions", 1);
            monitor.worked(1);
        }
        monitor.done();
    }

    private List<String> getMatchingVersions(RAMAsset asset, RelationshipRange range, boolean syncSearch) {
        return this.getMatchingVersions(asset.getIdentification().getGUID(), range, syncSearch);
    }

    private List<String> getMatchingVersions(String guid, RelationshipRange range, boolean syncSearch) {
        String[] versions = RAMAsset.fetchVersions(guid, "*", syncSearch, this.getSession());
        if (versions.length > 0) {
            ArrayList<String> list = new ArrayList<String>(versions.length);
            String[] stringArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                String version = stringArray[n2];
                if (RelationshipRangeUtility.isVersionInRange(range, version)) {
                    list.add(version);
                }
                ++n2;
            }
            return list;
        }
        return Collections.emptyList();
    }

    public RAMRelationship[] setRelationshipRange(String guid, RelationshipType relationshipType, RelationshipRange relationshipRange) {
        if (relationshipRange == null) {
            throw new IllegalArgumentException();
        }
        List<String> matchingVersions = this.getMatchingVersions(guid, relationshipRange, true);
        return this.setRelationshipRange(guid, matchingVersions, relationshipType, relationshipRange);
    }

    public RAMRelationship[] setRelationshipRange(com.ibm.ram.common.data.Asset relatedAsset, RelationshipType relationshipType, RelationshipRange relationshipRange) throws RAMRuntimeException {
        List<String> matchingVersions = this.getMatchingVersions((RAMAsset)relatedAsset, relationshipRange, true);
        if (matchingVersions.isEmpty()) {
            throw new RCAssetNotFoundException(ClientMessages.getString("RAMAsset.16"), true);
        }
        return this.setRelationshipRange(relatedAsset.getIdentification().getGUID(), matchingVersions, relationshipType, relationshipRange);
    }

    private RAMRelationship[] setRelationshipRange(String guid, List<String> matchingVersions, RelationshipType relationshipType, RelationshipRange relationshipRange) throws RAMRuntimeException {
        RAMRelationship[] relationships;
        ArrayList<RAMRelationship> relationshipList = new ArrayList<RAMRelationship>();
        RAMRelationship[] rAMRelationshipArray = relationships = (RAMRelationship[])this.getRelationships();
        int n = relationships.length;
        int n2 = 0;
        while (n2 < n) {
            RAMRelationship relationship = rAMRelationshipArray[n2];
            if (relationshipType.getName().equals(relationship.getRelationshipType().getName()) && guid.equals(relationship.getChildAssetGUID())) {
                this.removeRelationship(relationship);
            } else {
                relationshipList.add(relationship);
            }
            ++n2;
        }
        List<RAMRelationship> returnRelationshipList = null;
        ManifestBuilder mbldr = this.getManifestBuilder();
        String rangeStr = RelationshipRangeUtility.convertToString(relationshipRange);
        if (!matchingVersions.isEmpty()) {
            ArrayList<RelatedAsset> relatedAssets = new ArrayList<RelatedAsset>();
            if (relationshipRange.isHighestVersionRangeRelationship()) {
                String version = matchingVersions.get(0);
                RelatedAsset newRelatedAsset = mbldr.addRelatedAsset("?", guid, version, relationshipType.getName(), rangeStr);
                relatedAssets.add(newRelatedAsset);
            } else {
                for (String version : matchingVersions) {
                    RelatedAsset newRelatedAsset = mbldr.addRelatedAsset("?", guid, version, relationshipType.getName(), rangeStr);
                    relatedAssets.add(newRelatedAsset);
                }
            }
            returnRelationshipList = new ArrayList<RAMRelationship>(relatedAssets.size());
            for (RelatedAsset relAsset : relatedAssets) {
                try {
                    AssetIdentification id = new AssetIdentification(relAsset.getAssetId(), relAsset.getAssetVersion(), false, this.getIdentification().getRepositoryIdentification());
                    RAMAsset otherEndAsset = this.getSession().getAsset(id);
                    RAMRelationship ramRelationship = new RAMRelationship(this, otherEndAsset, relAsset);
                    ramRelationship.setRelationshipType(relationshipType);
                    returnRelationshipList.add(ramRelationship);
                    otherEndAsset.addReverseRelationship(this, ((RAMRelationshipType)relationshipType).getReverseType(), true);
                }
                catch (RCAssetNotFoundException rCAssetNotFoundException) {
                    mbldr.removeRelatedAsset(relAsset);
                }
            }
        }
        if (returnRelationshipList == null || returnRelationshipList.isEmpty()) {
            returnRelationshipList = Collections.singletonList(new RAMRelationship(this, null, mbldr.addRelatedAsset("<There are no assets visible within the range>", guid, relationshipRange.getRangeInfo().toString(), relationshipType.getName(), rangeStr)));
        }
        relationshipList.addAll(returnRelationshipList);
        Relationship[] newRelationships = relationshipList.toArray(new RAMRelationship[relationshipList.size()]);
        super.setRelationships(newRelationships);
        this.setAssetDirty(true);
        return returnRelationshipList.toArray(new RAMRelationship[returnRelationshipList.size()]);
    }

    public void removeRelationshipRange(com.ibm.ram.common.data.Asset relatedAsset, RelationshipType relationshipType) throws RAMRuntimeException {
        RAMRelationship[] relationships = (RAMRelationship[])this.getRelationships();
        boolean modified = false;
        int i = 0;
        while (i < relationships.length) {
            RelationshipRange range;
            RAMRelationship relationship = relationships[i];
            if (relationshipType.getName().equals(relationship.getRelationshipType().getName()) && relatedAsset.getIdentification().getGUID().equals(relationship.getChildAssetGUID()) && (range = relationship.getRelationshipRange()) != null) {
                RAMAsset reverseAsset;
                relationship.removeRange();
                modified = true;
                String revGUID = relationship.getChildAssetGUID();
                String revVersion = relationship.getChildAssetVersion();
                AssetIdentification id = new AssetIdentification(revGUID, revVersion, false, this.getIdentification().getRepositoryIdentification());
                try {
                    reverseAsset = this.getSession().getAsset(id);
                }
                catch (RCAssetNotFoundException rCAssetNotFoundException) {
                    reverseAsset = null;
                }
                if (reverseAsset != null) {
                    RelationshipType revType = ((RAMRelationshipType)relationship.getRelationshipType()).getReverseType();
                    RAMRelationship[] revAssetRelationships = (RAMRelationship[])reverseAsset.getRelationships();
                    int j = 0;
                    while (j < revAssetRelationships.length) {
                        RelationshipType type = revAssetRelationships[j].getRelationshipType();
                        if (type.equals(revType) && this.getIdentification().getGUID().equals(revAssetRelationships[j].getChildAssetGUID()) && revVersion.equals(revAssetRelationships[j].getChildAssetVersion())) {
                            revAssetRelationships[j].removeRange();
                            reverseAsset.setAssetDirty(true);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (modified) {
            this.setAssetDirty(true);
        }
    }

    void addReverseRelationship(com.ibm.ram.common.data.Asset relatedAsset, RelationshipType relationType, boolean isRange) {
        RAMRelationship[] relationships = (RAMRelationship[])this.getRelationships();
        int x = 0;
        while (x < relationships.length) {
            if (relationships[x].getChildAssetGUID().equals(relatedAsset.getIdentification().getGUID()) && relationships[x].getChildAssetVersion().equals(relatedAsset.getIdentification().getVersion()) && relationships[x].getRelationshipTypeName().equals(relationType.getName())) {
                return;
            }
            ++x;
        }
        String descriptionStr = RelationshipRangeUtility.convertToString(new RelationshipInfo(0, 0, 0, null, true, isRange));
        RelatedAsset newRelatedAsset = this.getManifestBuilder().addRelatedAsset(relatedAsset.getName(), relatedAsset.getIdentification().getGUID(), relatedAsset.getIdentification().getVersion(), relationType.getName(), descriptionStr);
        RAMRelationship rel = new RAMRelationship(this, (RAMAsset)relatedAsset, newRelatedAsset);
        rel.setRelationshipType(relationType);
        Relationship[] newRelationships = new RAMRelationship[relationships.length + 1];
        System.arraycopy(relationships, 0, newRelationships, 0, relationships.length);
        newRelationships[relationships.length] = rel;
        super.setRelationships(newRelationships);
    }

    public void removeRelationship(Relationship rel) {
        this.removeRelationship(rel, true);
    }

    public void recordActivity(AssetActivity activity) throws RAMRuntimeException {
        if ((activity instanceof AssetDevActivity || activity instanceof AssetBuildActivity) && this.getSession().compareServicesVersion(RAMSession.RAM_7_1_1_0_SERVICES_VERSION) < 0) {
            throw new RAMRuntimeException("The passed in activity cannot be recorded prior to 7.1.1");
        }
        this.fActivitiesToRecord.add(new RAMAssetActivity(this, activity, true));
        this.setActivityDirty(true);
    }

    /*
     * WARNING - void declaration
     */
    void removeRelationship(Relationship rel, boolean removeRev) {
        RAMRelationship[] relationships = (RAMRelationship[])this.getRelationships();
        RAMRelationship relationship = null;
        int i = 0;
        while (i < relationships.length) {
            if (relationships[i].equals(rel) || rel.getRelationshipTypeName() != null && rel.getChildAssetGUID() != null && rel.getChildAssetVersion() != null && rel.getRelationshipTypeName().equals(relationships[i].getRelationshipTypeName()) && rel.getChildAssetGUID().equals(relationships[i].getChildAssetGUID()) && rel.getChildAssetVersion().equals(relationships[i].getChildAssetVersion())) {
                relationship = relationships[i];
                break;
            }
            ++i;
        }
        ArrayList<RAMRelationship> relationshipRemoveList = new ArrayList<RAMRelationship>();
        if (relationship != null) {
            RelatedAsset relatedAsset = relationship.getInternalRelatedAsset();
            if (relatedAsset != null && RelationshipRangeUtility.isRangeRelationship(relatedAsset)) {
                void var7_9;
                boolean bl = false;
                while (var7_9 < relationships.length) {
                    if (rel.getRelationshipTypeName() != null && rel.getChildAssetGUID() != null && rel.getRelationshipTypeName().equals(relationships[var7_9].getRelationshipTypeName()) && rel.getChildAssetGUID().equals(relationships[var7_9].getChildAssetGUID())) {
                        relationshipRemoveList.add(relationships[var7_9]);
                    }
                    ++var7_9;
                }
            } else {
                relationshipRemoveList.add(relationship);
            }
        }
        for (Relationship relationship2 : relationshipRemoveList) {
            this.primRemoveRelationship(relationship2, removeRev);
        }
    }

    void primRemoveRelationship(Relationship rel, boolean removeRev) {
        int indexToRemove = -1;
        Object[] relationships = (RAMRelationship[])this.getRelationships();
        int i = 0;
        while (i < relationships.length) {
            RAMRelationship relationship = relationships[i];
            if (relationship.equals(rel) || rel.getRelationshipTypeName() != null && rel.getChildAssetGUID() != null && rel.getChildAssetVersion() != null && rel.getRelationshipTypeName().equals(relationship.getRelationshipTypeName()) && rel.getChildAssetGUID().equals(relationship.getChildAssetGUID()) && rel.getChildAssetVersion().equals(relationship.getChildAssetVersion())) {
                rel = relationship;
                indexToRemove = i;
                this.getManifestBuilder().removeRelatedAsset(relationship.getInternalRelatedAsset());
                break;
            }
            ++i;
        }
        if (indexToRemove > -1) {
            if (removeRev) {
                RAMRelationshipType relType;
                String revGUID = relationships[indexToRemove].getChildAssetGUID();
                String revVersion = relationships[indexToRemove].getChildAssetVersion();
                AssetIdentification id = new AssetIdentification(revGUID, revVersion, false, this.getIdentification().getRepositoryIdentification());
                RAMAsset reverseAsset = null;
                try {
                    reverseAsset = this.getSession().getAsset(id);
                }
                catch (Exception e) {
                    logger.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                if (reverseAsset != null && (relType = (RAMRelationshipType)((RAMRelationship)relationships[indexToRemove]).getRelationshipType()) != null) {
                    RelationshipType revType = relType.getReverseType();
                    int revIndex = -1;
                    RAMRelationship[] revAssetRelationships = (RAMRelationship[])reverseAsset.getRelationships();
                    int i2 = 0;
                    while (i2 < revAssetRelationships.length) {
                        RelationshipType type = revAssetRelationships[i2].getRelationshipType();
                        if (type.equals(revType) && this.getIdentification().getGUID().equals(revAssetRelationships[i2].getChildAssetGUID()) && this.getIdentification().getVersion().equals(revAssetRelationships[i2].getChildAssetVersion())) {
                            revIndex = i2;
                            break;
                        }
                        ++i2;
                    }
                    if (revIndex != -1) {
                        reverseAsset.removeRelationship(revAssetRelationships[revIndex], false);
                    }
                }
            }
            Object[] newRelationships = new RAMRelationship[relationships.length - 1];
            AssetUtil.removeIth(relationships, newRelationships, indexToRemove);
            super.setRelationships((Relationship[])newRelationships);
            this.setAssetDirty(true);
        }
    }

    @Override
    public FolderArtifact getArtifactsRoot() throws RAMRuntimeException {
        if (super.getArtifactsRoot() == null) {
            super.setArtifactsRoot(new RAMFolderArtifact(this, this.getSolutionCreateIfNeeded()));
        }
        this.fArtifactsFetched = true;
        return super.getArtifactsRoot();
    }

    @Override
    public void setArtifactsRoot(FolderArtifact root) throws RAMRuntimeException {
        if (!(root instanceof RAMFolderArtifact)) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.ROOT_MUST_BE_RAMFOLDERArtifact"), true);
        }
        super.setArtifactsRoot(root);
        RAMFolderArtifact ramArtifact = (RAMFolderArtifact)root;
        boolean cfr_ignored_0 = root instanceof LocalArchiveFolderArtifact;
        ramArtifact.setAsRoot(this, this.getSolutionCreateIfNeeded());
    }

    void setManifest(String manifest) throws RAMRuntimeException {
        ManifestBuilder oldBldr = this.fManifestBuilder;
        String oldServerPath = oldBldr != null ? ManifestBuilder.getServerPath(oldBldr.getManifestResourceSet()) : null;
        boolean updated = false;
        try {
            try {
                Map<String, ManifestAccessor.CustomAttribute> attributesMap;
                AssetSO iasset = this.getInternalAsset();
                String serverPath = this.getSession().getRAMClient().getWebServerPath();
                Asset assetManifest = RAMAsset.loadManifestFromStream(this.getSession(), "ram://create" + iasset.getIdentification().getGUID() + iasset.getIdentification().getVersion(), new ByteArrayInputStream(manifest.getBytes("UTF-8")));
                ManifestBuilder.setServerPath(assetManifest.eResource().getResourceSet(), serverPath);
                ManifestBuilder mbldr = this.createManifestBuilder(assetManifest, this.fFullAsset);
                Solution solution = mbldr.getSolution();
                if (solution != null && solution.getArtifact() != null && !this.validateArtifacts(solution.getArtifact().iterator())) {
                    throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.MANIFEST_IS_INVALID"), true);
                }
                Map<URI, ManifestAccessor.ClassificationInfo> categoryMap = mbldr.getClassificationInfos();
                ArrayList<NodeDescriptor> nodesToRemove = new ArrayList<NodeDescriptor>();
                if (!categoryMap.isEmpty()) {
                    try {
                        for (ManifestAccessor.ClassificationInfo cInfo : categoryMap.values()) {
                            String uri = cInfo.getURI().toString();
                            if (this.getSession().getCategorySchemaByURI(uri) != null) continue;
                            Set<NodeDescriptor> nodes = cInfo.getNodeDescriptors();
                            for (NodeDescriptor node : nodes) {
                                nodesToRemove.add(node);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to iterate through asset schemas", (Throwable)e);
                    }
                    for (NodeDescriptor node : nodesToRemove) {
                        mbldr.removeNodeDescriptorFromManifest(node);
                    }
                }
                if (!(attributesMap = mbldr.getCustomAttributes()).isEmpty()) {
                    ArrayList<String> attributeToRemove = new ArrayList<String>();
                    for (ManifestAccessor.CustomAttribute cAttribute : attributesMap.values()) {
                        if (this.getSession().getAssetAttributeByURI(cAttribute.getURIString()) != null) continue;
                        attributeToRemove.add(cAttribute.getURIString());
                    }
                    for (String attrRemove : attributeToRemove) {
                        mbldr.removeCustomAttribute(attrRemove);
                    }
                }
                this.getInternalAsset().setManifest(null);
                this.fManifestBuilder = mbldr;
                if (super.getArtifactsRoot() instanceof RAMFolderArtifact) {
                    RAMFolderArtifact root = (RAMFolderArtifact)super.getArtifactsRoot();
                    root.setAsRoot(this, this.fManifestBuilder.getSolution());
                }
                this.clearAttributesCache();
                this.clearSchemaCache();
                updated = true;
                if (oldBldr != null) {
                    this.getSession().getResourceSet().getResources().remove((Object)oldBldr.getManifestResource());
                }
                oldBldr = null;
            }
            catch (RAMRuntimeException e) {
                throw e;
            }
            catch (Throwable th) {
                logger.warn((Object)th.getLocalizedMessage(), th);
                if (!updated) {
                    this.fManifestBuilder = oldBldr;
                    if (oldBldr != null) {
                        ManifestBuilder.setServerPath(oldBldr.getManifestResourceSet(), oldServerPath);
                    }
                }
            }
        }
        finally {
            if (!updated) {
                this.fManifestBuilder = oldBldr;
                if (oldBldr != null) {
                    ManifestBuilder.setServerPath(oldBldr.getManifestResourceSet(), oldServerPath);
                }
            }
        }
    }

    private boolean validateArtifacts(Iterator aIter) {
        while (aIter.hasNext()) {
            com.ibm.ram.defaultprofile.Artifact a = (com.ibm.ram.defaultprofile.Artifact)aIter.next();
            if (!a.getArtifact().isEmpty()) {
                return this.validateArtifacts(a.getArtifact().iterator());
            }
            if (a.getName() != null) continue;
            logger.warn((Object)MessageFormat.format(ClientMessages.getString("RAMAsset.ERROR_PARSING_MANIFEST"), this, a));
            return false;
        }
        return true;
    }

    private Solution getSolutionCreateIfNeeded() {
        Solution sol = this.getManifestBuilder().getSolution();
        if (sol == null) {
            sol = DefaultprofileFactory.eINSTANCE.createSolution();
            this.getManifestBuilder().getManifest().setSolution(sol);
        }
        return sol;
    }

    @Override
    public CommunityInformation getCommunity() {
        if (super.getCommunity() == null && this.fFullAsset && this.getInternalAsset().getCommunity() != null) {
            super.setCommunity(new RAMCommunity(this.fSession, this.getInternalAsset().getCommunity()));
        } else if (super.getCommunity() == null && this.fAssetInformation.getCommunityName() != null) {
            super.setCommunity(this.fSession.getCommunity(this.fAssetInformation.getCommunityName()));
        }
        return super.getCommunity();
    }

    InputStream getManifestAsStream() throws RAMRuntimeException {
        return RAMAsset.createManifest(this.getManifestBuilder());
    }

    public String getManifestAsString() {
        String ret = null;
        try {
            ret = RAMSession.readAssetManifest(this.getManifestAsStream());
        }
        catch (RAMRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RAMRuntimeException("Failed to create the Asset Manifest", e);
        }
        return ret;
    }

    @Override
    public void setCommunity(CommunityInformation community) throws RAMRuntimeException {
        this.setAssetDirty(true);
        if (community == null) {
            if (this.fManifestBuilder != null) {
                this.fManifestBuilder.setCommunity(null);
                this.clearSchemaCache();
                this.clearAttributesCache();
            }
        } else {
            if (this.fManifestBuilder != null && !community.equals(super.getCommunity())) {
                this.fManifestBuilder.setCommunity(((RAMCommunity)community).getInternalCommunityInformation());
                this.clearSchemaCache();
                this.clearAttributesCache();
            }
            if (!(community instanceof RAMCommunity)) {
                community = this.getSession().getCommunity(community.getName());
            }
            super.setCommunity(community);
            RAMCommunity ramCom = (RAMCommunity)community;
            this.getInternalAsset().setCommunity(ramCom.getInternalCommunityInformation());
        }
    }

    private void clearSchemaCache() {
        this.fCategorySchemas = null;
        this.fCategorySchemasByName = null;
        this.fSetSchemas = null;
        this.fCategoryValues.clear();
    }

    private void clearAttributesCache() {
        this.fAssetAttributes = null;
        this.fAssetAttributesByName = null;
    }

    @Override
    public AssetAttribute[] getAssetAttributes() throws RAMRuntimeException {
        if (this.fAssetAttributes == null) {
            this.initAssetAttributesCache();
        }
        return this.fAssetAttributes;
    }

    @Override
    public AssetAttribute getAssetAttribute(String name) throws RAMRuntimeException {
        if (this.fAssetAttributesByName == null) {
            this.initAssetAttributesCache();
        }
        return (RAMAssetAttribute)this.fAssetAttributesByName.get(name);
    }

    private void initAssetAttributesCache() throws RAMRuntimeException {
        Map<String, ManifestAccessor.CustomAttribute> attributesMap = this.getManifestBuilder().getCustomAttributes();
        this.fAssetAttributesByName = new HashMap();
        if (attributesMap != null) {
            Iterator<ManifestAccessor.CustomAttribute> attributes = attributesMap.values().iterator();
            this.fAssetAttributes = new RAMAssetAttribute[attributesMap.size()];
            int i = 0;
            while (attributes.hasNext()) {
                ManifestAccessor.CustomAttribute cAttribute = attributes.next();
                RAMAssetAttribute attr = this.getSession().getAssetAttributeByURI(cAttribute.getURIString());
                this.fAssetAttributes[i] = attr != null && AssetAttribute.TYPE_RESOURCE.equals(((AssetAttribute)attr).getType()) ? new RAMResourceAttribute(this, cAttribute) : new RAMAssetAttribute(this, cAttribute);
                this.fAssetAttributesByName.put(cAttribute.getName(), this.fAssetAttributes[i]);
                ++i;
            }
        } else {
            this.fAssetAttributes = new RAMAssetAttribute[0];
        }
    }

    @Override
    public RAMAction getAction() {
        if (this.fAction == null) {
            this.fAction = this.getStateID() == State.ASSET_AS_IS_ID ? RAMAction.UPDATE_AS_IS : (this.getStateID() == State.ASSET_DRAFT_ID ? RAMAction.UPDATE_DRAFT : RAMAction.UPDATE);
        }
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        this.fAction = action;
        this.setAssetDirty(true);
    }

    public String[] getVersions() {
        return this.getVersions(false);
    }

    String[] getVersions(boolean syncSearch) {
        return this.fetchVersions("*", syncSearch);
    }

    private String[] fetchVersions(String versionPattern) throws RAMRuntimeException {
        return this.fetchVersions(versionPattern, false);
    }

    protected static String[] fetchVersions(String guid, String versionPattern, boolean syncSearch, RAMSession session) {
        RAMAssetQueryBuilder queryBuilder = new RAMAssetQueryBuilder(session);
        queryBuilder.addQueryField(queryBuilder.QUERY_FIELD_GUID, SearchQuery.escapeLuceneCharacters(guid));
        String versionField = queryBuilder.createQueryFieldText(queryBuilder.QUERY_FIELD_VERSION, versionPattern);
        queryBuilder.addQueryTextField(versionField);
        queryBuilder.setSortByField(queryBuilder.SORT_BY_FIELD_VERSION);
        queryBuilder.setSortAscending(false);
        if (syncSearch) {
            queryBuilder.setSearchModes(16);
        }
        SearchResult result = session.getAssets(queryBuilder);
        AssetSearchResult[] assets = result.getAssetSearchResults();
        String[] ret = new String[assets.length];
        int i = 0;
        while (i < assets.length) {
            ret[i] = ((RAMAsset)assets[i].getAsset()).getOriginalVersion();
            ++i;
        }
        if (assets.length > 0) {
            Arrays.sort(ret, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Utilities.compareVersions(o2, o1);
                }
            });
        }
        return ret;
    }

    private String[] fetchVersions(String versionPattern, boolean syncSearch) throws RAMRuntimeException {
        return RAMAsset.fetchVersions(this.getIdentification().getGUID(), versionPattern, syncSearch, this.getSession());
    }

    public void categorize(SubCategory subCategory) throws RAMRuntimeException {
        this.categorize(subCategory, false);
    }

    public RAMForum createForum(String title, String description) {
        RAMForum ret = new RAMForum(this, this.fSession.getUser(), title, description);
        RAMForum[] forums = (RAMForum[])this.getForums();
        RAMForum[] newForums = new RAMForum[forums.length + 1];
        System.arraycopy(forums, 0, newForums, 0, forums.length);
        newForums[forums.length] = ret;
        this.fForums = newForums;
        this.setForumDirty(true);
        return ret;
    }

    public void categorize(Category category, String categorization) throws RAMRuntimeException {
        this.categorize(category, categorization, false);
    }

    public void categorize(Category category, String categorization, boolean force) throws RAMRuntimeException {
        RAMCategory ramCategory = this.findAssetCategory(category);
        if (ramCategory == null) {
            String message = MessageFormat.format(ClientMessages.getString("RAMAsset.CATEGORIZATION_NOT_VALID"), String.valueOf(category.getName()) + "/" + categorization);
            throw new RAMRuntimeException(message, true);
        }
        if (ramCategory.isFreeFormDescriptor) {
            this.getManifestBuilder().addFreeFormValueToManifest(categorization, ramCategory.getInternalFreeFormDescriptor());
            this.fCategoryValues.remove(ramCategory.getSessionKey());
            this.setAssetDirty(true);
        } else if (ramCategory.isNodeDescriptor) {
            RAMSubCategory subCategory = this.findAssetSubCategory(category, categorization);
            if (subCategory == null) {
                String message = MessageFormat.format(ClientMessages.getString("RAMAsset.CATEGORIZATION_NOT_VALID"), String.valueOf(category.getName()) + "/" + categorization);
                throw new RAMRuntimeException(message, true);
            }
            this.categorize(subCategory, force);
        } else {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.18"), true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void categorize(SubCategory subCategory, boolean force) throws RAMRuntimeException {
        Category myCatgeory = ((RAMSubCategory)subCategory).getCategory();
        RAMSubCategory ramSubCategory = this.findAssetSubCategory(myCatgeory, subCategory.getCategorization());
        if (ramSubCategory == null) {
            String message = MessageFormat.format(ClientMessages.getString("RAMAsset.SUB_CATEGORY_NOT_FOUND_FOR_ASSET"), subCategory.getFullPath(), this.toLocalizedString());
            throw new RAMRuntimeException(message, true);
        }
        if (ramSubCategory.getInternalNodeDescriptor() != null) {
            if (force == Boolean.TRUE) {
                if (!this.getSession().isServierSupportCategorizeForce()) throw new RAMRuntimeException("force categorise is not supported in current RAM server version, set the boolean parameter to false to disable force categorize feature.");
                this.getManifestBuilder().addForcedNodeDescriptor(ramSubCategory.getInternalNodeDescriptor());
            } else {
                this.getManifestBuilder().addNodeDescriptorToManifest(ramSubCategory.getInternalNodeDescriptor());
            }
        } else if (ramSubCategory.getInternalFreeFormValue() != null) {
            this.getManifestBuilder().addFreeFormValueToManifest(ramSubCategory.getInternalFreeFormValue());
        }
        ramSubCategory.internalMarkSet(true);
        this.fCategoryValues.remove(((RAMCategory)ramSubCategory.getCategory()).getSessionKey());
        this.fSetSchemas = null;
        this.setAssetDirty(true);
    }

    private RAMCategory findAssetCategory(Category category) {
        RAMCategory assetCategory = null;
        CategorySchema schema = ((RAMCategory)category).getSchema();
        CategorySchema assetSchema = this.getCategorySchema(schema.getName());
        boolean usedSetSchema = true;
        if (assetSchema == null) {
            assetSchema = this.getAvailableCategorySchema(schema.getName());
            usedSetSchema = false;
        }
        if (assetSchema != null) {
            assetCategory = (RAMCategory)((RAMCategorySchema)assetSchema).getCategory(category.getName());
            if (usedSetSchema && assetCategory == null) {
                assetSchema = this.getAvailableCategorySchema(schema.getName());
                assetCategory = (RAMCategory)((RAMCategorySchema)assetSchema).getCategory(category.getName());
            }
        }
        return assetCategory;
    }

    private RAMSubCategory findAssetSubCategory(Category category, String categorization) {
        RAMSubCategory assetSubCategory = null;
        RAMCategory assetCategory = null;
        CategorySchema schema = ((RAMCategory)category).getSchema();
        CategorySchema assetSchema = this.getCategorySchema(schema.getName());
        boolean usedSetSchema = true;
        if (assetSchema == null) {
            assetSchema = this.getAvailableCategorySchema(schema.getName());
            usedSetSchema = false;
        }
        if (assetSchema != null) {
            assetCategory = (RAMCategory)((RAMCategorySchema)assetSchema).getCategory(category.getName());
            boolean usedSetCategory = true;
            if (usedSetSchema && assetCategory == null) {
                assetSchema = this.getAvailableCategorySchema(schema.getName());
                assetCategory = (RAMCategory)((RAMCategorySchema)assetSchema).getCategory(category.getName());
                usedSetCategory = false;
            }
            if (assetCategory != null) {
                assetSubCategory = (RAMSubCategory)assetCategory.getSubCategory(categorization);
                if (usedSetCategory && assetSubCategory == null) {
                    assetSchema = this.getAvailableCategorySchema(schema.getName());
                    assetCategory = (RAMCategory)((RAMCategorySchema)assetSchema).getCategory(category.getName());
                    assetSubCategory = (RAMSubCategory)assetCategory.getSubCategory(categorization);
                }
            }
        }
        return assetSubCategory;
    }

    public void uncategorize(SubCategory subCategory) {
        RAMSubCategory ramSubCategory = this.findAssetSubCategory(((RAMSubCategory)subCategory).getCategory(), subCategory.getCategorization());
        if (ramSubCategory.getInternalNodeDescriptor() != null) {
            this.getManifestBuilder().removeNodeDescriptorFromManifest(ramSubCategory.getInternalNodeDescriptor());
        } else if (ramSubCategory.getInternalFreeFormValue() != null) {
            this.getManifestBuilder().removeFreeFormValueFromManifest(ramSubCategory.getInternalFreeFormValue());
        }
        this.fCategoryValues.remove(((RAMCategory)ramSubCategory.getCategory()).getSessionKey());
        this.fSetSchemas = null;
        this.setAssetDirty(true);
    }

    void updateRatings(RAMStatusMonitor monitor) throws RAMRuntimeException {
        if (this.fAssetRatings != null && this.fAssetRatings.getFeedback() != null && this.fAssetRatings.getFeedback().length > 0) {
            monitor.beginTask(ClientMessages.getString("RAMAsset.UPDATE_RATINGS"), this.fAssetRatings.getFeedback().length * 10);
            try {
                AssetFeedback[] feedbacks = this.fAssetRatings.getFeedback();
                int i = 0;
                while (i < feedbacks.length) {
                    RAMAssetFeedback feedback = (RAMAssetFeedback)feedbacks[i];
                    if (feedback.isDirty()) {
                        if (feedback.isDelete()) {
                            this.getSession().getRESTClient().deleteAssetRating(this.getIdentification());
                        } else {
                            try {
                                this.getSession().getRAMClient().getRAM1Webservice().rateAssetByID(this.getIdentification(), feedback.getComment(), feedback.getRating(), feedback.isAnonymous(), feedback.getUser().getUid(), feedback.getTimestamp());
                            }
                            catch (Exception e) {
                                monitor.appendStatus(this, 2, 1000, "User " + feedback.getUser().getName() + " could not rate the asset - " + e.getLocalizedMessage(), null);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                monitor.appendStatus(this, 2, 1011, e.getLocalizedMessage(), e);
            }
        } else {
            monitor.beginTask(ClientMessages.getString("RAMAsset.UPDATE_RATINGS"), 1);
            monitor.worked(1);
        }
        monitor.done();
    }

    void updateForums(IProgressMonitor monitor) throws RAMRuntimeException {
        if (this.fForums != null) {
            RAMForum[] forms = this.fForums;
            monitor.beginTask(ClientMessages.getString("RAMAsset.19"), forms.length * 10);
            int i = 0;
            while (!monitor.isCanceled() && i < forms.length) {
                if (forms[i].isDirty()) {
                    String message;
                    try {
                        Forum newForum = forms[i];
                        if (!forms[i].isUpdate()) {
                            message = MessageFormat.format(ClientMessages.getString("RAMAsset.CREATE_NEW_FORUM"), this.toString(), forms[i].getTitle());
                            monitor.subTask(message);
                            newForum = this.getSession().getRAMClient().getRAM1Webservice().createDiscussionForum(this.getIdentification().getGUID(), this.getIdentification().getVersion(), forms[i].getTitle(), forms[i].getDescription(), forms[i].getSubmitter().getUid(), forms[i].getSubmissionDate());
                        }
                        monitor.worked(2);
                        if (!monitor.isCanceled()) {
                            forms[i].updateForum(newForum, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                        }
                    }
                    catch (Exception e) {
                        message = MessageFormat.format(ClientMessages.getString("RAMAsset.FAILED_TO_CREATE_FORUM"), forms[i]);
                        logger.warn((Object)message, (Throwable)e);
                    }
                } else {
                    monitor.worked(10);
                }
                ++i;
            }
        } else {
            monitor.beginTask(ClientMessages.getString("RAMAsset.22"), 1);
            monitor.worked(1);
        }
        monitor.done();
    }

    void uploadActivities(IProgressMonitor monitor) {
        monitor.beginTask(ClientMessages.getString("RAMAsset.23"), this.fActivitiesToRecord.size() * 10);
        RAMAssetActivity[] activities = this.fActivitiesToRecord.toArray(new RAMAssetActivity[this.fActivitiesToRecord.size()]);
        int i = 0;
        while (i < activities.length) {
            RAMAssetActivity activity = activities[i];
            String label = "Update " + this.getName() + ClientMessages.getString("RAMAsset.25") + this.getVersion() + ClientMessages.getString("RAMAsset.26") + ((Activity)activity).getName();
            monitor.subTask(label);
            if (activity instanceof RAMAssetActivity) {
                Activity internalAct;
                RAMAssetActivity ramAssetActivity = activity;
                if (ramAssetActivity.getInternalAssetActivity() instanceof CustomAssetActivity) {
                    CustomAssetActivity customAssetActivity = (CustomAssetActivity)ramAssetActivity.getInternalAssetActivity();
                    try {
                        this.getSession().getRAMClient().getRAM1Webservice().recordActivity(((Activity)activity).getTypeId(), customAssetActivity.getNumberData(), customAssetActivity.getLabel(), customAssetActivity.getDescription(), ramAssetActivity.getAssetGUID(), ramAssetActivity.getAssetVersion(), ramAssetActivity.getUser() != null ? ramAssetActivity.getUser().getUid() : this.getSession().getUser().getUid(), ramAssetActivity.getTimestamp());
                    }
                    catch (Exception e) {
                        logger.warn((Object)ClientMessages.getString("RAMAsset.27"), (Throwable)e);
                    }
                }
                if ((internalAct = ramAssetActivity.getInternalAssetActivity()) instanceof AssetActivity && (internalAct.getTypeId() == 620 || internalAct.getTypeId() == 621)) {
                    AssetActivity assetAct = (AssetActivity)internalAct;
                    String stringData = null;
                    String longData = null;
                    if (assetAct instanceof AssetDevActivity) {
                        AssetDevActivity devAct = (AssetDevActivity)assetAct;
                        stringData = devAct.getArtifact();
                        longData = devAct.serializeLongData();
                    } else if (assetAct instanceof AssetBuildActivity) {
                        AssetBuildActivity buildAct = (AssetBuildActivity)assetAct;
                        stringData = buildAct.getArtifact();
                        longData = buildAct.serializeLongData();
                    }
                    try {
                        this.getSession().getRAMClient().getRAM1Webservice().recordActivity(assetAct.getTypeId(), -1L, stringData, longData, assetAct.getAssetGUID(), assetAct.getAssetVersion(), assetAct.getUser() != null ? assetAct.getUser().getUid() : this.getSession().getUser().getUid(), ramAssetActivity.getTimestamp());
                    }
                    catch (Exception e) {
                        logger.warn((Object)ClientMessages.getString("RAMAsset.27"), (Throwable)e);
                    }
                }
            }
            this.fActivitiesToRecord.remove(activity);
            ++i;
        }
    }

    public void uncategorize(Category category, String categorization) {
        RAMCategory ramCategory = this.findAssetCategory(category);
        if (ramCategory.isFreeFormDescriptor) {
            Set<FreeFormValue> freeFormValues = ((RAMCategorySchema)ramCategory.getSchema()).getInternalClassificationInfo().getFreeformValues();
            for (FreeFormValue freeFormValue : freeFormValues) {
                if (!categorization.equals(freeFormValue.getValue())) continue;
                FreeFormDescriptor descriptor = freeFormValue.getFreeFormDescriptor();
                if (!ramCategory.getInternalDescriptor().equals(descriptor)) continue;
                this.getManifestBuilder().removeFreeFormValueFromManifest(freeFormValue);
                this.fCategoryValues.remove(ramCategory.getSessionKey());
                this.setAssetDirty(true);
                break;
            }
        }
        if (ramCategory.isNodeDescriptor) {
            RAMSubCategory subCategory = (RAMSubCategory)ramCategory.getSubCategory(categorization);
            if (subCategory == null) {
                throw new RAMRuntimeException("Categorization " + category + "/" + categorization + " was not found");
            }
            this.uncategorize(subCategory);
        }
    }

    public String[] getCategorizations(Category category) {
        RAMCategory ramCategory = this.findAssetCategory(category);
        if (ramCategory != null) {
            if (!this.fCategoryValues.containsKey(ramCategory.getSessionKey())) {
                ArrayList<String> values;
                Iterator<Object> iterator;
                if (ramCategory.isFreeFormDescriptor) {
                    Set<FreeFormValue> freeFormValues = ((RAMCategorySchema)ramCategory.getSchema()).getInternalClassificationInfo().getFreeformValues();
                    iterator = freeFormValues.iterator();
                    values = new ArrayList<String>();
                    while (iterator.hasNext()) {
                        FreeFormValue freeFormValue = (FreeFormValue)iterator.next();
                        FreeFormDescriptor descriptor = freeFormValue.getFreeFormDescriptor();
                        if (!ramCategory.getInternalDescriptor().equals(descriptor)) continue;
                        values.add(freeFormValue.getValue());
                    }
                    this.fCategoryValues.put(ramCategory.getSessionKey(), values.toArray(new String[values.size()]));
                }
                if (ramCategory.isNodeDescriptor) {
                    Set<NodeDescriptor> nodeValues = ((RAMCategorySchema)ramCategory.getSchema()).getInternalClassificationInfo().getNodeDescriptors();
                    iterator = nodeValues.iterator();
                    values = new ArrayList();
                    while (iterator.hasNext()) {
                        NodeDescriptor curNode = (NodeDescriptor)iterator.next();
                        StringBuffer currentPath = new StringBuffer();
                        while (curNode.getGeneral() != null) {
                            currentPath.insert(0, curNode.getName());
                            if (curNode.getGeneral().getGeneral() != null) {
                                currentPath.insert(0, "/");
                            }
                            curNode = curNode.getGeneral();
                        }
                        if (!ramCategory.getInternalDescriptor().equals(curNode)) continue;
                        values.add(currentPath.toString());
                    }
                    this.fCategoryValues.put(ramCategory.getSessionKey(), values.toArray(new String[values.size()]));
                }
            }
            return (String[])this.fCategoryValues.get(ramCategory.getSessionKey());
        }
        return null;
    }

    public CategorySchema[] getAllAvailableCategorySchemas() {
        if (this.fCategorySchemas == null) {
            this.initCategorySchemaCache();
        }
        return this.fCategorySchemas;
    }

    public RAMAssetActivity[] getActivites(int[] activityTypes, long fromTime, long toTime) throws EntitlementException, AssetNotFoundException, RAMException {
        ArrayList<RAMAssetActivity> ramActivities = new ArrayList<RAMAssetActivity>();
        try {
            ActivitySO[] activities = this.getSession().getRAMClient().getRAM1Webservice().getActivities(fromTime, toTime, this.getIdentification().getGUID(), this.getIdentification().getVersion(), activityTypes, this.getSession().getLocale().getLanguage());
            if (activities != null) {
                int i = 0;
                while (i < activities.length) {
                    ramActivities.add(new RAMAssetActivity(this, activities[i], false));
                    ++i;
                }
            }
        }
        catch (RemoteException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        catch (RAMServiceException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        catch (RAMRuntimeException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        catch (EntitlementException e) {
            throw e;
        }
        catch (AssetNotFoundException e) {
            throw e;
        }
        catch (RAMException e) {
            throw e;
        }
        RAMAssetActivity[] ret = ramActivities.toArray(new RAMAssetActivity[ramActivities.size()]);
        return ret;
    }

    public CategorySchema getAvailableCategorySchema(String name) {
        CategorySchema ret;
        if (this.fCategorySchemasByName == null) {
            this.initCategorySchemaCache();
        }
        if ((ret = (CategorySchema)this.fCategorySchemasByName.get(name)) == null && this.getSession().getCategorySchema(name) != null && this.getAssetType() != null && this.getManifestBuilder() != null && this.getManifestBuilder().getValidationManager() instanceof ClientValidationManager) {
            ((ClientValidationManager)this.getManifestBuilder().getValidationManager()).refreshAssetType();
            this.initCategorySchemaCache();
        }
        return (CategorySchema)this.fCategorySchemasByName.get(name);
    }

    @Override
    public CategorySchema[] getCategorySchemas() {
        if (this.fSetSchemas == null) {
            RAMCategorySchema[] schemas = (RAMCategorySchema[])this.getAllAvailableCategorySchemas();
            ArrayList<RAMCategorySchema> setSchemas = new ArrayList<RAMCategorySchema>();
            int i = 0;
            while (i < schemas.length) {
                Set<FreeFormValue> freeFormValues = schemas[i].getInternalClassificationInfo().getFreeformValues();
                Iterator<Object> iterator = freeFormValues.iterator();
                RAMCategorySchema schemaToSet = new RAMCategorySchema(this, schemas[i].getInternalClassificationInfo(), true);
                boolean addSchema = false;
                while (iterator.hasNext()) {
                    FreeFormValue freeFormValue = iterator.next();
                    String categoryName = freeFormValue.getFreeFormDescriptor().getName();
                    RAMCategory category = (RAMCategory)schemaToSet.getCategory(categoryName);
                    if (category == null) {
                        RAMCategory newCat = new RAMCategory(schemaToSet, freeFormValue);
                        schemaToSet.addCategory(newCat);
                        addSchema = true;
                        continue;
                    }
                    RAMSubCategory newValue = new RAMSubCategory(category, freeFormValue);
                    category.addSubCategory(newValue);
                }
                Set<NodeDescriptor> nodeValues = schemas[i].getInternalClassificationInfo().getNodeDescriptors();
                for (NodeDescriptor curNode : nodeValues) {
                    SubCategory[] children;
                    RAMSubCategory topSubCategory = null;
                    boolean set = true;
                    while (curNode.getGeneral() != null) {
                        RAMSubCategory subCat = new RAMSubCategory(curNode, set);
                        set = false;
                        if (topSubCategory != null) {
                            subCat.addSubCategory(topSubCategory);
                        }
                        topSubCategory = subCat;
                        curNode = curNode.getGeneral();
                    }
                    RAMCategory category = null;
                    String categoryName = curNode.getName();
                    category = (RAMCategory)schemaToSet.getCategory(categoryName);
                    if (category == null) {
                        category = new RAMCategory(schemaToSet, curNode, true);
                        schemaToSet.addCategory(category);
                        addSchema = true;
                    }
                    if (topSubCategory == null) continue;
                    RAMSubCategory curSubCat = (RAMSubCategory)category.getSubCategory(topSubCategory.getEncodedName());
                    if (curSubCat == null) {
                        curSubCat = topSubCategory;
                        curSubCat.setParent(category);
                        category.addSubCategory(curSubCat);
                    }
                    if ((children = topSubCategory.getSubCategories()) != null && children.length > 0) {
                        topSubCategory = (RAMSubCategory)children[0];
                    } else {
                        curSubCat.internalMarkSet(true);
                        topSubCategory = null;
                    }
                    while (topSubCategory != null) {
                        RAMSubCategory child = (RAMSubCategory)curSubCat.getSubCategory(topSubCategory.getEncodedName());
                        if (child == null) {
                            child = topSubCategory;
                            curSubCat.addSubCategory(child);
                        }
                        child.setParent(curSubCat);
                        curSubCat = child;
                        children = topSubCategory.getSubCategories();
                        if (children != null && children.length > 0) {
                            topSubCategory = (RAMSubCategory)children[0];
                            continue;
                        }
                        curSubCat.internalMarkSet(true);
                        topSubCategory = null;
                    }
                }
                if (addSchema) {
                    setSchemas.add(schemaToSet);
                }
                ++i;
            }
            RAMCategorySchema[] tmpSchemas = setSchemas.toArray(new RAMCategorySchema[setSchemas.size()]);
            this.fSetSchemas = tmpSchemas;
        }
        return this.fSetSchemas;
    }

    @Override
    public CategorySchema getCategorySchema(String name) {
        CategorySchema[] schemas = this.getCategorySchemas();
        CategorySchema schema = null;
        int i = 0;
        while (i < schemas.length) {
            if (name.equals(schemas[i].getName())) {
                schema = schemas[i];
            }
            ++i;
        }
        return schema;
    }

    private void initCategorySchemaCache() throws RAMRuntimeException {
        Map<URI, ManifestAccessor.ClassificationInfo> categoriesMap = this.getManifestBuilder().getClassificationInfos();
        this.fCategorySchemasByName = new HashMap();
        if (categoriesMap != null) {
            Iterator<ManifestAccessor.ClassificationInfo> categorySchemas = categoriesMap.values().iterator();
            ArrayList<RAMCategorySchema> schemas = new ArrayList<RAMCategorySchema>();
            while (categorySchemas.hasNext()) {
                ManifestAccessor.ClassificationInfo categorySchema = categorySchemas.next();
                RAMCategorySchema schema = new RAMCategorySchema(this, categorySchema);
                schemas.add(schema);
                this.fCategorySchemasByName.put(categorySchema.getSchema().getName(), schema);
            }
            this.fCategorySchemas = schemas.toArray(new RAMCategorySchema[schemas.size()]);
        } else {
            this.fCategorySchemas = new RAMCategorySchema[0];
        }
    }

    @Override
    public AssetType getAssetType() {
        if (this.getInternalAsset().getAssetType() == null) {
            return null;
        }
        if (super.getAssetType() == null) {
            super.setAssetType(this.fSession.getAssetTypeByURI(this.getInternalAsset().getAssetType().getURI()));
        }
        return super.getAssetType();
    }

    @Override
    public void setAssetType(AssetType assetType) throws RAMRuntimeException {
        this.setAssetDirty(true);
        if (assetType != null) {
            RAMAssetType ramType = assetType instanceof RAMAssetType ? (RAMAssetType)assetType : this.getSession().getAssetType(assetType.getName());
            super.setAssetType(ramType);
            this.getInternalAsset().setAssetType(ramType.getInternalAssetType());
            if (this.fManifestBuilder != null) {
                this.getManifestBuilder().setAssetTypeURI(URI.createURI((String)assetType.getURI()));
            }
            this.clearSchemaCache();
            this.clearAttributesCache();
        } else {
            this.getInternalAsset().setAssetType(null);
            this.getManifestBuilder().setAssetTypeURI(null);
            this.clearSchemaCache();
            this.clearAttributesCache();
        }
    }

    boolean getOwnersHaveBeenModified() {
        return this.fOwnersModified;
    }

    @Override
    public UserInformation[] getOwners() {
        if (super.getOwners() == null) {
            UserInformation[] users = this.getInternalAsset().getOwners();
            if (users != null && users.length > 0) {
                UserInformation[] owners = new RAMUser[users.length];
                super.setOwners(owners);
                int i = 0;
                while (i < users.length) {
                    owners[i] = this.fSession.fetchUser(users[i]);
                    ++i;
                }
            } else {
                UserInformation[] owners = new RAMUser[1];
                super.setOwners(owners);
                owners[0] = this.fSession.getUser();
            }
        }
        return super.getOwners();
    }

    @Override
    public void setOwners(UserInformation[] owners) throws RAMRuntimeException {
        this.setAssetDirty(true);
        UserInformation[] existingUsers = this.getInternalAsset().getOwners();
        UserInformation[] internalOwners = new UserInformation[owners.length];
        if (existingUsers != null && existingUsers.length != owners.length) {
            this.fOwnersModified = true;
        }
        if (existingUsers == null && owners.length > 0) {
            this.fOwnersModified = true;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<RAMUser> ramOwnersList = new ArrayList<RAMUser>();
        int i = 0;
        while (i < owners.length) {
            RAMUser ramUser = owners[i] instanceof RAMUser ? (RAMUser)owners[i] : this.getSession().getUser(owners[i].getUid());
            internalOwners[i] = ramUser.getInternalUser();
            String id = internalOwners[i].getUid();
            if (!ids.contains(id)) {
                ids.add(id);
                ramOwnersList.add(ramUser);
                if (!this.fOwnersModified) {
                    if (existingUsers == null && !internalOwners[i].getUid().equals(this.getSession().getUser().getUid())) {
                        this.fOwnersModified = true;
                    }
                    if (existingUsers != null) {
                        boolean found = false;
                        int j = 0;
                        while (j < existingUsers.length) {
                            if (existingUsers[j].getUid().equals(internalOwners[i].getUid())) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        this.fOwnersModified = !found;
                    }
                }
            }
            ++i;
        }
        UserInformation[] ramOwners = ramOwnersList.toArray(new RAMUser[ramOwnersList.size()]);
        super.setOwners(ramOwners);
        this.getInternalAsset().setOwners(internalOwners);
    }

    public InputStream getContents() throws RAMRuntimeException, IOException {
        try {
            return this.fSession.getRAMClient().getInputStream(this.fOriginalGUID, this.fOriginalVersion, false);
        }
        catch (MalformedURLException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        catch (RAMServiceException e) {
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
    }

    File getLocalArtifactArchiveFile(RAMStatusMonitor monitor) throws RAMRuntimeException, IOException {
        if (this.fRASFile == null) {
            String message = MessageFormat.format(ClientMessages.getString("AssetUtil.PACKAGE_ASSET"), this.toLocalizedString());
            monitor.beginTask(message, 10);
            if (this.getArtifactsRoot() instanceof LocalArchiveFolderArtifact && ((LocalArchiveFolderArtifact)this.getArtifactsRoot()).getArchiveFile() != null && !this.getManifestBuilder().getSolution().getArtifact().isEmpty()) {
                this.fRASFile = ((LocalArchiveFolderArtifact)this.getArtifactsRoot()).getArchiveFile();
                this.fDelta = false;
            } else if (this.getSession().compareServicesVersion(RAMSession.RAM_7_1_1_0_SERVICES_VERSION) >= 0) {
                ((RAMFolderArtifact)this.getArtifactsRoot()).computeArtifactsAsFlatList((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 10));
                this.getDeltaAssetFileBuilder().updateDeleteFile(this.getArtifactsToRemove());
                this.fRASFile = this.getDeltaAssetFileBuilder().createDeltaFile();
                this.fDelta = true;
            } else {
                LocalArchiveFolderArtifact root = RAMAsset.createLocalArchiveArtifactRootFile(this, monitor);
                this.fRASFile = root.getArchiveFile();
                this.fDelta = false;
            }
        } else {
            String message = MessageFormat.format(ClientMessages.getString("RAMAsset.PACKAGE_ASSET"), this.fRASFile.getName());
            monitor.beginTask(message, 0);
            monitor.done();
        }
        return this.fRASFile;
    }

    static LocalArchiveFolderArtifact createLocalArchiveArtifactRootFile(RAMAsset asset, RAMStatusMonitor monitor) throws RAMRuntimeException, IOException {
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        InputStream manifestStream = null;
        File rasFile = null;
        if (!monitor.isCanceled()) {
            String message = MessageFormat.format(ClientMessages.getString("AssetUtil.PACKAGE_ASSET"), asset.toLocalizedString());
            monitor.beginTask(message, 10);
            RAMFolderArtifact root = (RAMFolderArtifact)asset.getArtifactsRoot();
            if (root instanceof LocalArchiveFolderArtifact && ((LocalArchiveFolderArtifact)root).getArchiveFile() != null) {
                LocalArchiveFolderArtifact archiveRoot = (LocalArchiveFolderArtifact)root;
                rasFile = ((LocalArchiveFolderArtifact)root).getArchiveFile();
                archiveRoot.computeArtifactsAsFlatList((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 10));
            } else {
                block34: {
                    try {
                        try {
                            SubProgressMonitor subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 4);
                            Artifact[] artifacts = ((RAMFolderArtifact)asset.getArtifactsRoot()).computeArtifactsAsFlatList((IProgressMonitor)subMonitor);
                            manifestStream = asset.getManifestAsStream();
                            if (monitor.isCanceled()) break block34;
                            rasFile = File.createTempFile(RAMAsset.cleanFromUnsuitableFilechars(asset.getGUID()), ".ras", asset.getSession().getLocalStorageFolder());
                            rasFile.deleteOnExit();
                            fos = new FileOutputStream(rasFile);
                            zos = new ZipOutputStream(fos);
                            ZipEntry entry = new ZipEntry("manifest.rmd");
                            zos.putNextEntry(entry);
                            byte[] bytes = new byte[5120];
                            double bytesProcessed = 0.0;
                            try {
                                while (manifestStream.available() > 0) {
                                    int read = manifestStream.read(bytes);
                                    if (read <= 0) continue;
                                    zos.write(bytes, 0, read);
                                    bytesProcessed += (double)read;
                                }
                            }
                            finally {
                                zos.closeEntry();
                            }
                            monitor.worked(1);
                            if (!monitor.isCanceled()) {
                                if (artifacts.length == 0) {
                                    monitor.worked(5);
                                } else {
                                    subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 5);
                                    String message1 = MessageFormat.format(ClientMessages.getString("AssetUtil.PACKAGE_ASSET_ADD_ARTIFACTS"), asset.toLocalizedString());
                                    subMonitor.beginTask(message1, artifacts.length);
                                    int i = 0;
                                    while (!monitor.isCanceled() && i < artifacts.length) {
                                        monitor.subTask(artifacts[i].getName());
                                        if (artifacts[i] instanceof LocalFolderArtifact) {
                                            LocalArchiveFolderArtifact.addFolderArtifact(zos, (LocalFolderArtifact)artifacts[i], monitor);
                                        } else if (!(artifacts[i] instanceof RAMURLArtifact)) {
                                            if (artifacts[i] instanceof LocalFileArtifact) {
                                                LocalArchiveFolderArtifact.addArtifact(zos, artifacts[i], ((LocalFileArtifact)artifacts[i]).getContents());
                                            } else if (artifacts[i] instanceof RAMArtifact) {
                                                LocalArchiveFolderArtifact.addArtifact(zos, artifacts[i], ((RAMArtifact)artifacts[i]).downloadContents());
                                            }
                                        }
                                        subMonitor.worked(1);
                                        ++i;
                                    }
                                }
                            }
                        }
                        catch (RAMRuntimeException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                        }
                    }
                    catch (Throwable throwable) {
                        if (zos != null) {
                            try {
                                zos.finish();
                                zos.close();
                            }
                            catch (IOException iOException) {}
                            zos = null;
                        }
                        if (manifestStream != null) {
                            try {
                                manifestStream.close();
                            }
                            catch (IOException iOException) {}
                            manifestStream = null;
                        }
                        throw throwable;
                    }
                }
                if (zos != null) {
                    try {
                        zos.finish();
                        zos.close();
                    }
                    catch (IOException iOException) {}
                    zos = null;
                }
                if (manifestStream != null) {
                    try {
                        manifestStream.close();
                    }
                    catch (IOException iOException) {}
                    manifestStream = null;
                }
            }
        }
        return new LocalArchiveFolderArtifact(rasFile);
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static String cleanFromUnsuitableFilechars(String s) {
        if (RAMAsset.isBlank(s)) {
            return "";
        }
        char[] chars = s.toCharArray();
        boolean mod = false;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != '-' && !Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = 95;
                mod = true;
            }
            ++i;
        }
        return mod ? new String(chars) : s;
    }

    private static InputStream createManifest(ManifestBuilder builder) throws RAMRuntimeException {
        ByteArrayInputStream input;
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Asset asset = builder.getManifest();
            Resource resource = asset.eResource();
            ((XMIResource)resource).setEncoding("UTF-8");
            resource.save((OutputStream)output, Collections.EMPTY_MAP);
            byte[] bytes = output.toByteArray();
            input = new ByteArrayInputStream(bytes);
        }
        catch (Throwable e) {
            if (e instanceof RAMRuntimeException) {
                throw (RAMRuntimeException)e;
            }
            throw new RAMRuntimeException(e.getLocalizedMessage(), e);
        }
        return input;
    }

    void setLocalRASFile(File file) {
        this.fRASFile = file;
    }

    public RAMSession getSession() {
        return this.fSession;
    }

    void setSession(RAMSession session) {
        this.fSession = session;
    }

    String getOriginalGUID() {
        return this.fOriginalGUID;
    }

    String getOriginalVersion() {
        return this.fOriginalVersion;
    }

    boolean isDelta() {
        return this.fDelta;
    }

    @Override
    public boolean isDirty() {
        return this.isAssetDirty() || this.isActivityDirty() || this.isTagDirty() || this.isForumDirty() || this.isRatingDirty() || this.isSubscriptionsDirty() || this.isChangeLockStatusDirty();
    }

    void clearDirtyFlags() {
        this.setAssetDirty(false);
        this.setActivityDirty(false);
        this.setTagDirty(false);
        this.setForumDirty(false);
        this.setRatingDirty(false);
        this.setSubscriptionsDirty(false);
        this.setChangeLockStatusDirty(false);
        this.forcedSubCategory.clear();
        this.updateComments = null;
    }

    boolean isAssetDirty() {
        return this.fAssetDirty;
    }

    boolean isActivityDirty() {
        return this.fActivityDirty;
    }

    void setActivityDirty(boolean activityDirty) {
        this.fActivityDirty = activityDirty;
        if (activityDirty) {
            this.getSession().cache(this);
        }
    }

    boolean isTagDirty() {
        return this.fTagDirty;
    }

    void setTagDirty(boolean tagDirty) {
        this.fTagDirty = tagDirty;
        if (tagDirty) {
            this.getSession().cache(this);
        }
    }

    boolean isForumDirty() {
        return this.fForumDirty;
    }

    void setForumDirty(boolean forumDirty) {
        this.fForumDirty = forumDirty;
        if (forumDirty) {
            this.getSession().cache(this);
        }
    }

    boolean isRatingDirty() {
        return this.fRatingDirty;
    }

    void setRatingDirty(boolean ratingDirty) {
        this.fRatingDirty = ratingDirty;
        if (ratingDirty) {
            this.getSession().cache(this);
        }
    }

    boolean isSubscriptionsDirty() {
        return this.fSubscriptionDirty;
    }

    void setSubscriptionsDirty(boolean subscriptionsDirty) {
        this.fSubscriptionDirty = subscriptionsDirty;
        if (subscriptionsDirty) {
            this.getSession().cache(this);
        }
    }

    public boolean isUpdate() {
        return this.getAction() == RAMAction.UPDATE || this.getAction() == RAMAction.UPDATE_AS_IS || this.getAction() == RAMAction.UPDATE_DRAFT || this.getAction().getId() == -1;
    }

    boolean isCreate() {
        return this.getAction() == RAMAction.CREATE || this.getAction() == RAMAction.CREATE_AS_IS || this.getAction() == RAMAction.CREATE_DRAFT;
    }

    @Override
    public double getAverageRating() {
        return this.fAssetInformation.getAverageRating();
    }

    @Override
    public String getCommunityName() {
        String name = null;
        name = super.getCommunity() != null ? super.getCommunity().getName() : this.fAssetInformation.getCommunityName();
        return name;
    }

    @Override
    public long getLastModified() {
        return this.fAssetInformation.getLastModified();
    }

    @Override
    public int getStateID() {
        this.checkIfRefreshNeeded();
        int id = this.fState != null ? this.fState.getId() : this.fAssetInformation.getStateID();
        return id;
    }

    @Override
    public String getStateName() {
        String name = null;
        this.checkIfRefreshNeeded();
        name = this.fState != null ? this.fState.getName() : this.fAssetInformation.getStateName();
        return name;
    }

    private void checkIfRefreshNeeded() {
        if (this.fState != null && this.fState.getId() == REFREH_NEEDED_STATE.getId()) {
            this.upgradeAsset();
        }
    }

    @Override
    public String getTypeName() {
        String name = null;
        name = super.getAssetType() != null ? super.getAssetType().getName() : this.fAssetInformation.getTypeName();
        return name;
    }

    @Override
    public State getState() throws RAMRuntimeException {
        this.checkIfRefreshNeeded();
        if (this.fState == null) {
            String name = null;
            if (this.getInternalAsset().getState() != null) {
                name = this.getInternalAsset().getState().getName();
            } else if (this.fState == null) {
                name = this.fAssetInformation.getStateName();
            }
            if (this.isInLifecycle()) {
                com.ibm.ram.internal.jaxb.State state = null;
                if (name != null && name.length() > 0) {
                    state = LifecycleUtilities.getStateByName(this.getWorkflow(), name);
                }
                if (state == null) {
                    throw new RAMRuntimeException("Failed to load state " + name + " from workflow " + this.getWorkflow());
                }
                this.fState = new RAMState(this.getSession(), state);
            } else {
                this.fState = this.getSession().getState(name);
            }
        }
        return this.fState;
    }

    @Override
    public AssetTag[] getTags() throws RAMRuntimeException {
        if (this.fAssetTags == null) {
            if (this.getInternalAsset().getTags() == null) {
                this.fAssetTags = new RAMAssetTag[0];
            } else {
                this.fAssetTags = new RAMAssetTag[this.getInternalAsset().getTags().length];
                int i = 0;
                while (i < this.getInternalAsset().getTags().length) {
                    this.fAssetTags[i] = new RAMAssetTag(this, this.getInternalAsset().getTags()[i]);
                    ++i;
                }
            }
        }
        return this.fAssetTags;
    }

    public RAMAssetTag[] addTags(String tags) throws RAMRuntimeException {
        Tag[] newTags = Tag.createTagsFromLabel(tags);
        ArrayList<RAMAssetTag> newRAMTags = new ArrayList<RAMAssetTag>();
        AssetTag[] oldTags = this.getTags();
        int i = 0;
        while (i < newTags.length) {
            boolean exists = false;
            int j = 0;
            while (j < oldTags.length) {
                if (oldTags[j].getTag() != null && oldTags[j].getTag().equals(newTags[i].getTag())) {
                    exists = true;
                }
                ++j;
            }
            if (!exists) {
                newRAMTags.add(new RAMAssetTag(this, newTags[i].getTag()));
                this.setTagDirty(true);
            }
            ++i;
        }
        RAMAssetTag[] newClientTags = newRAMTags.toArray(new RAMAssetTag[newRAMTags.size()]);
        RAMAssetTag[] tmp = new RAMAssetTag[this.fAssetTags.length + newClientTags.length];
        System.arraycopy(this.fAssetTags, 0, tmp, 0, this.fAssetTags.length);
        System.arraycopy(newClientTags, 0, tmp, this.fAssetTags.length, newClientTags.length);
        this.fAssetTags = tmp;
        return newClientTags;
    }

    public void removeTag(AssetTag tag) throws RAMRuntimeException {
        Object[] source = this.fAssetTags;
        int index = -1;
        int i = 0;
        while (i < source.length) {
            if (source[i].equals(tag)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            this.fAssetTags = new RAMAssetTag[source.length - 1];
            AssetUtil.removeIth(source, this.fAssetTags, index);
            this.setAssetDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public AssetRatings getRatings() {
        block8: {
            if (this.fAssetRatings != null) return this.fAssetRatings;
            AssetRatings tmpRatings = this.getInternalAsset().getRatings();
            if (this.isUpdate()) {
                AssetSO asset = null;
                try {
                    String string = "FETCH_ASSET";
                    // MONITORENTER : "FETCH_ASSET"
                    asset = this.fSession.fetchAssetFromServer(this.getIdentification(), false, true);
                    tmpRatings = asset.getRatings();
                    if (tmpRatings != null) {
                        this.getInternalAsset().setRatings(tmpRatings);
                    } else {
                        this.getInternalAsset().setRatings(new AssetRatings());
                    }
                    // MONITOREXIT : string
                    break block8;
                }
                catch (Exception e) {
                    throw new RAMRuntimeException(e.getLocalizedMessage(), e);
                }
            }
            this.getInternalAsset().setRatings(new AssetRatings());
        }
        this.fAssetRatings = new RAMAssetRatings(this, this.getInternalAsset().getRatings());
        return this.fAssetRatings;
    }

    void setAssetDirty(boolean dirtyFlag) {
        this.fArtifactsFetched = false;
        this.fAssetDirty = dirtyFlag;
        if (!dirtyFlag) {
            this.fOwnersModified = false;
            this.getSession().uncache(this);
        } else {
            this.getSession().cache(this);
        }
    }

    void setForce(boolean force) {
        this.fForce = force;
    }

    boolean isForce() {
        return this.fForce;
    }

    boolean isFullAsset() {
        return this.fFullAsset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Forum[] getForums() throws RAMRuntimeException {
        if (this.fForums != null) return this.fForums;
        Forum[] tmpForums = this.getInternalAsset().getForums();
        if (this.isUpdate() && tmpForums == null) {
            AssetSO asset = null;
            try {
                String string = "FETCH_ASSET";
                synchronized ("FETCH_ASSET") {
                    if (this.fForums != null) return this.fForums;
                    asset = this.fSession.fetchAssetFromServer(this.getIdentification(), true, false);
                    tmpForums = asset.getForums();
                    if (tmpForums == null) {
                        tmpForums = new Forum[]{};
                    }
                    this.getInternalAsset().setForums(tmpForums);
                    RAMForum[] forms = new RAMForum[tmpForums.length];
                    int i = 0;
                    while (i < tmpForums.length) {
                        forms[i] = new RAMForum(this, tmpForums[i]);
                        ++i;
                    }
                    this.fForums = forms;
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return this.fForums;
                }
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
        }
        if (tmpForums == null) {
            this.getInternalAsset().setForums(new Forum[0]);
            this.fForums = new RAMForum[0];
            return this.fForums;
        } else {
            RAMForum[] forms = new RAMForum[tmpForums.length];
            int i = 0;
            while (i < tmpForums.length) {
                forms[i] = new RAMForum(this, tmpForums[i]);
                ++i;
            }
            this.fForums = forms;
        }
        return this.fForums;
    }

    static String createSessionKey(AssetIdentification assetIdentification) {
        String GUID = assetIdentification.getGUID();
        String version = assetIdentification.getVersion();
        Boolean pending = new Boolean(assetIdentification.isPendingAsset());
        if (version != null) {
            version = version.trim();
        }
        String ret = String.valueOf(SESSION_ASSET_KEY) + GUID + SESSION_KEY_DELIM + version;
        if (pending.booleanValue()) {
            ret = String.valueOf(ret) + SESSION_PENDING_ASSET_KEY;
        }
        return ret;
    }

    String getSessionKey() {
        String ret = null;
        if (!this.isKeepOldVersion() && this.fOriginalGUID != null && this.fOriginalVersion != null) {
            AssetIdentification id = new AssetIdentification(this.fOriginalGUID, this.fOriginalVersion, this.getIdentification().isPendingAsset(), this.getIdentification().getRepositoryIdentification());
            ret = RAMAsset.createSessionKey(id);
        } else if ((this.isKeepOldVersion() || this.fCreatedGUID) && this.getIdentification().getVersion() != null && this.fAssetInformation.getIdentification().getGUID() != null) {
            AssetIdentification id = new AssetIdentification(this.fAssetInformation.getIdentification().getGUID(), this.getIdentification().getVersion(), this.getIdentification().isPendingAsset(), this.getIdentification().getRepositoryIdentification());
            ret = RAMAsset.createSessionKey(id);
        } else {
            ret = String.valueOf(SESSION_NEW_ASSET_KEY) + this.hashCode();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RAMRuntimeException {
        if (this.fOriginalGUID == null && this.fOriginalVersion == null) {
            throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.31"), true);
        }
        AssetIdentification id = new AssetIdentification(this.fOriginalGUID, this.fOriginalVersion, this.getIdentification().isPendingAsset(), this.getIdentification().getRepositoryIdentification());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Refresh asset " + id));
        }
        this.clearAsset();
        try {
            AssetSO asset = this.fSession.fetchAssetFromServer(id, this.fForums != null, this.fAssetRatings != null);
            AssetInformation assetInformation = this.fAssetInformation;
            synchronized (assetInformation) {
                this.setInternalAsset(asset);
                this.fAction = null;
                this.fFullAsset = true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Asset refreshed from the server " + this.fAssetInformation));
                logger.debug((Object)("New revision count is " + this.getRevisionCount()));
            }
        }
        catch (Exception e) {
            String message = MessageFormat.format(ClientMessages.getString("RAMAsset.FAILED_TO_REFRESH_ASSET"), this.toLocalizedString());
            throw new RAMRuntimeException(message, e);
        }
    }

    @Override
    public PersonTime getUsageTime() {
        String[] manifestTime;
        if (this.fUsageTime == null && (manifestTime = this.getManifestBuilder().getUsageTime()) != null) {
            this.fUsageTime = new RAMPersonTime(manifestTime);
        }
        return this.fUsageTime;
    }

    @Override
    public void setUsageTime(PersonTime usageTime) {
        if (usageTime != null) {
            this.fUsageTime = usageTime instanceof RAMPersonTime ? (RAMPersonTime)usageTime : new RAMPersonTime(usageTime.getAmount(), usageTime.getUnit());
            if (this.fManifestBuilder != null) {
                if (this.fUsageTime != null) {
                    this.fManifestBuilder.setUsageTime(this.fUsageTime.getManifestTime());
                } else {
                    this.fManifestBuilder.setUsageTime(null);
                }
            }
        }
    }

    @Override
    public PersonTime getCreationTime() {
        String[] maniefestTime;
        if (this.fCreationTime == null && (maniefestTime = this.getManifestBuilder().getCreationTime()) != null) {
            this.fCreationTime = new RAMPersonTime(maniefestTime);
        }
        return this.fCreationTime;
    }

    @Override
    public void setCreationTime(PersonTime creationTime) {
        if (creationTime != null) {
            this.fCreationTime = creationTime instanceof RAMPersonTime ? (RAMPersonTime)creationTime : new RAMPersonTime(creationTime.getAmount(), creationTime.getUnit());
            if (this.fManifestBuilder != null) {
                if (this.fCreationTime != null) {
                    this.fManifestBuilder.setCreationTime(this.fCreationTime.getManifestTime());
                } else {
                    this.fManifestBuilder.setCreationTime(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeAsset() {
        if (!this.isDirty() && !this.fArtifactsFetched) {
            this.refresh();
        } else {
            AssetSO webServiceAsset = null;
            try {
                AssetIdentification id = new AssetIdentification(this.fOriginalGUID, this.fOriginalVersion, this.getIdentification().isPendingAsset(), this.getIdentification().getRepositoryIdentification());
                webServiceAsset = this.fSession.fetchAssetFromServer(id, false, false);
            }
            catch (Exception e) {
                throw new RAMRuntimeException(e.getLocalizedMessage(), e);
            }
            webServiceAsset.setAverageRating(this.fAssetInformation.getAverageRating());
            webServiceAsset.setCommunityName(this.fAssetInformation.getCommunityName());
            webServiceAsset.setIdentification(this.fAssetInformation.getIdentification());
            webServiceAsset.setLastModified(this.fAssetInformation.getLastModified());
            webServiceAsset.setManagementStyle(this.fAssetInformation.getManagementStyle());
            webServiceAsset.setName(this.fAssetInformation.getName());
            webServiceAsset.setShortDescription(this.fAssetInformation.getShortDescription());
            webServiceAsset.setTypeName(this.fAssetInformation.getTypeName());
            if (this.fAssetInformation.getStateName() != null && this.fAssetInformation.getStateID() != REFREH_NEEDED_STATE.getId()) {
                webServiceAsset.setStateID(this.fAssetInformation.getStateID());
                webServiceAsset.setStateName(this.fAssetInformation.getStateName());
                this.fState = null;
            }
            AssetInformation assetInformation = this.fAssetInformation;
            synchronized (assetInformation) {
                this.setInternalAsset(webServiceAsset);
            }
        }
        this.fFullAsset = true;
    }

    boolean isKeepOldVersion() {
        return this.fKeepOldVersion;
    }

    void setKeepOldVersion(boolean keepOldVersion) {
        this.fKeepOldVersion = keepOldVersion;
    }

    private void clearAsset() {
        super.setCommunity(null);
        super.setAssetType(null);
        super.setOwners(null);
        super.setRelationships(null);
        super.setAssetAttributes(null);
        super.setArtifactsRoot(null);
        this.fAction = null;
        this.fActivitiesToRecord.clear();
        this.fAssetAttributes = null;
        this.fAssetAttributesByName = null;
        this.fAssetRatings = null;
        this.fAssetTags = null;
        this.fCategorySchemas = null;
        this.fCategorySchemasByName = null;
        this.fCategoryValues.clear();
        this.fCreationTime = null;
        this.fForums = null;
        this.fSetSchemas = null;
        this.fState = null;
        this.fUsageTime = null;
        this.fLifecycle = null;
        this.fAvailableActions = null;
        this.fSubscriptions = null;
        this.changeLockStatusComment = null;
        this.changeLockStatusTo = null;
        this.updateComments = null;
        this.fRASFile = null;
        this.setInternalAsset(new AssetInformation());
        if (this.fManifestBuilder != null) {
            this.getSession().getResourceSet().getResources().remove((Object)this.fManifestBuilder.getManifestResource());
            this.fManifestBuilder = null;
        }
        this.fFullAsset = false;
        this.clearDirtyFlags();
    }

    String toLocalizedString() {
        boolean isRightToLeftLocale;
        String name = null;
        String version = null;
        if (this.fAssetInformation != null && this.fAssetInformation.getName() != null) {
            name = this.fAssetInformation.getName();
            version = this.fAssetInformation.getIdentification().getVersion();
        } else {
            name = this.fOriginalGUID;
            version = this.fOriginalVersion;
        }
        String toString = null;
        toString = name != null && version != null && (Bidi.requiresBidi(name.toCharArray(), 0, name.length()) || Bidi.requiresBidi(version.toCharArray(), 0, version.length())) ? ((isRightToLeftLocale = this.getSession().isRightToLeftLocale()) ? String.valueOf(name) + '\u200f' + "[" + version + "]" : String.valueOf(name) + '\u200e' + "[" + version + "]") : String.valueOf(name) + "[" + version + "]";
        return toString;
    }

    @Override
    public String toString() {
        String name = null;
        String version = null;
        if (this.fAssetInformation != null && this.fAssetInformation.getName() != null) {
            name = this.fAssetInformation.getName();
            version = this.fAssetInformation.getIdentification().getVersion();
        } else {
            name = this.fOriginalGUID;
            version = this.fOriginalVersion;
        }
        return String.valueOf(name) + "[" + version + "]";
    }

    @Override
    public void setAssetAttributes(AssetAttribute[] customAttributes) {
        boolean modified = false;
        if (this.fAssetAttributesByName == null) {
            this.initAssetAttributesCache();
        }
        int i = 0;
        while (i < customAttributes.length) {
            AssetAttribute attribute = customAttributes[i];
            RAMAssetAttribute ramAttribute = (RAMAssetAttribute)this.fAssetAttributesByName.get(attribute.getName());
            if (ramAttribute == null) {
                String value = null;
                if (attribute.getValues() != null && attribute.getValues().length > 0) {
                    value = attribute.getValues()[0];
                }
                ManifestBuilder.CustomAttributeUpdate ca = this.getManifestBuilder().addSelfDefinedCustomAttribute(attribute.getName(), value);
                RAMAssetAttribute newAttribute = new RAMAssetAttribute(this, ca);
                this.fAssetAttributesByName.put(attribute.getName(), newAttribute);
                newAttribute.setValues(attribute.getValues());
                modified = true;
            } else {
                ramAttribute.setValues(attribute.getValues());
            }
            ++i;
        }
        if (modified) {
            RAMAssetAttribute[] tmp = this.fAssetAttributesByName.values().toArray(new RAMAssetAttribute[this.fAssetAttributesByName.size()]);
            this.fAssetAttributes = tmp;
        }
    }

    @Override
    public void setCategorySchemas(CategorySchema[] schemas) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setForums(Forum[] forums) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setRatings(AssetRatings ratings) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setRelationships(Relationship[] relationships) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    void setInternalRelationships(Relationship[] relationships) {
        super.setRelationships(relationships);
    }

    @Override
    public void setState(State state) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.43"), true);
    }

    @Override
    public void setTags(AssetTag[] tags) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public int getManagementStyle() {
        return this.getInternalAssetInformation().getManagementStyle();
    }

    @Override
    public void setAverageRating(double averageRating) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setCommunityName(String communityName) {
        this.fAssetInformation.setCommunityName(communityName);
        if (super.getCommunity() == null || !communityName.equals(super.getCommunity().getName())) {
            this.setCommunity(this.getSession().getCommunity(communityName));
        }
    }

    @Override
    public void setLastModified(long lastModified) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.47"), true);
    }

    @Override
    public void setManagementStyle(int managementStyle) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setStateID(int stateID) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.49"), true);
    }

    @Override
    public void setStateName(String stateName) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMAsset.50"), true);
    }

    @Override
    public void setTypeName(String typeName) {
        this.fAssetInformation.setTypeName(typeName);
        this.setAssetType(this.getSession().getAssetType(typeName));
    }

    void setUpdateAction() {
        this.fAction = this.getStateID() == State.ASSET_AS_IS_ID ? RAMAction.UPDATE_AS_IS : (this.getStateID() == State.ASSET_DRAFT_ID ? RAMAction.UPDATE_DRAFT : RAMAction.UPDATE);
    }

    public RAMStateHistory getCurrentStateHistory() throws RAMRuntimeException {
        if (this.fCurrentStateHistory == null) {
            try {
                RAMStateHistory ramStateHistory;
                AbstractRESTClient restClient = this.getSession().getRESTClient();
                Response<StateHistory> stateHistory = restClient.getCurrentStateHistory(this.getRestAssetRef());
                this.fCurrentStateHistory = ramStateHistory = new RAMStateHistory(this, stateHistory.getValue());
            }
            catch (Exception e) {
                throw new RAMRuntimeException("Faild to fetch the current state history for asset : " + this, e);
            }
        }
        return this.fCurrentStateHistory;
    }

    public boolean isLocked() {
        if (this.getManagementStyle() != 6) {
            return false;
        }
        return this.changeLockStatusTo != Boolean.FALSE;
    }

    public void lockAsset(String comment) {
        if (this.isLocked()) {
            return;
        }
        if (!this.getSession().isServerSupportLocking()) {
            return;
        }
        if (UtilitiesCommon.isEmptyString(comment)) {
            throw new IllegalArgumentException("Lock asset requires a comment.");
        }
        this.changeLockStatusTo = true;
        this.changeLockStatusComment = comment.length() <= 200 ? comment : comment.substring(0, 200);
        this.setChangeLockStatusDirty(true);
    }

    public void unlockAsset(String comment) {
        if (!this.isLocked()) {
            return;
        }
        if (!this.getSession().isServerSupportLocking()) {
            return;
        }
        if (UtilitiesCommon.isEmptyString(comment)) {
            throw new IllegalArgumentException("Unlock asset requires a comment.");
        }
        this.changeLockStatusTo = false;
        this.changeLockStatusComment = comment.length() <= 200 ? comment : comment.substring(0, 200);
        this.setChangeLockStatusDirty(true);
    }

    boolean isChangeLockStatusDirty() {
        return this.changeLockStatusDirty;
    }

    void setChangeLockStatusDirty(boolean dirty) {
        this.changeLockStatusDirty = dirty;
        if (dirty) {
            this.getSession().cache(this);
        }
    }

    Boolean getChangeLockStatus() {
        return this.changeLockStatusTo;
    }

    String getChangeLockStatusComment() {
        return this.changeLockStatusComment;
    }

    public String getUpdateComments() {
        return this.updateComments;
    }

    public void setUpdateComments(String updateComments) {
        this.updateComments = updateComments;
    }
}

