/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.common.data.AssetIdentification;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SearchUtil {
    public static final String LUCENE_SPECIAL_CHARS = "+ - && || ! ( ) { } [ ] ^ \" \u00d2 \u00d3 ~ * ? : \\";
    public static final String LUCENE_ESCAPE_CHARACTER = "\\";
    public static final Pattern LUCENE_CHARACTERS_PATTERN = Pattern.compile(".*(\\+|-|\\&|\\||\\!|\\(|\\)|\\{|\\}|\\[|\\]|\\^|\\\"|\u00d2|\u00d3|\\~|\\*|\\?|\\:|\\\\).*");
    public static final Pattern LUCENE_CHARACTERS_PATTERN_WITH_ESCAPE_CHECK = Pattern.compile(".*[^\\\\](\\+|-|\\&|\\||\\!|\\(|\\)|\\{|\\}|\\[|\\]|\\^|\\\"|\u00d2|\u00d3|\\~|\\*|\\?|\\:|\\\\[^\\+\\&\\|\\!\\(\\)\\{\\}\\[\\]\\^\\\"\\~\\*\\?\\:-]).*");
    public static final Pattern FUZZY_SEARCH_PATTERN = Pattern.compile(".*(\\W|_).*");
    public static final Pattern OR_SEARCH_PATTERN = Pattern.compile(".*(\\sAND\\s|\\sOR\\s|\\sTO\\s).*", 2);
    public static final Pattern ALL_ASSETS_SEARCH_PATTERN = Pattern.compile("\\**");
    public static final Pattern LUCENE_ARTIFACT_OR_SEARCH_PATTERN = Pattern.compile(".*(\\+|-|\\&|\\||\\!|\\(|\\)|\\{|\\}|\\[|\\]|\\^|\\\"|\u00d2|\u00d3|\\:|\\\\).*");
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile(".*\\s.*");
    public static final String LUCENE_SPECIAL_DELIMS = "+-&|!(){}[]^\"\u00d2\u00d3~*?:\\";
    public static final String FIELD_QUERY_OPEN_SYNTAX = ":(";
    public static final String FIELD_QUERY_CLOSE_SYNTAX = ")";
    public static final String DENORMALIZED_FIEILD = "_";
    public static final String SORTABLE_FIELD = "[";
    public static final String FUZZY_SEARCH_FIELD = "{";
    public static final String STORED_FIELD = "_";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String WILDCARD = "*";
    public static final String UNIQUE_ASSET_ID = "uniqueAssetId";
    public static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\\\");
    public static final Pattern PLUS_PATTERN = Pattern.compile("\\+");
    public static final Pattern MINUS_PATTERN = Pattern.compile("-");
    public static final Pattern AND_PATTERN = Pattern.compile("&&");
    public static final Pattern OR_PATTERN = Pattern.compile("\\|\\|");
    public static final Pattern BANG_PATTERN = Pattern.compile("!");
    public static final Pattern LEFT_CURLY_BRACE_PATTERN = Pattern.compile("\\{");
    public static final Pattern RIGHT_CURLY_BRACE_PATTERN = Pattern.compile("\\}");
    public static final Pattern LEFT_PARENTHESE_PATTERN = Pattern.compile("\\(");
    public static final Pattern RIGHT_PARENTHESE_PATTERN = Pattern.compile("\\)");
    public static final Pattern LEFT_BRACKET_PATTERN = Pattern.compile("\\[");
    public static final Pattern RIGHT_BRACKET_PATTERN = Pattern.compile("\\]");
    public static final Pattern CARET_PATTERN = Pattern.compile("\\^");
    public static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    public static final Pattern LEFT_CURLY_QUOTE_PATTERN = Pattern.compile("\u00d2");
    public static final Pattern RIGHT_CURLY_QUOTE_PATTERN = Pattern.compile("\u00d3");
    public static final Pattern TILDE_PATTERN = Pattern.compile("~");
    public static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*");
    public static final Pattern QUESTION_MARK_PATTERN = Pattern.compile("\\?");
    public static final Pattern COLON_PATTERN = Pattern.compile(":");
    public static final Pattern WHITESPACE_CHARACTER_PATTERN = Pattern.compile("\\s");
    public static final Pattern OR_WHITESPACE_PATTERN = Pattern.compile("\\s(?=\\w)");

    public static SearchUtil getInstance() {
        return SearchUtilInstance._instance;
    }

    private SearchUtil() {
    }

    public static String escapeLuceneCharacters(String s) {
        if (s != null) {
            s = BACKSLASH_PATTERN.matcher(s).replaceAll("\\\\\\\\");
            s = PLUS_PATTERN.matcher(s).replaceAll("\\\\+");
            s = MINUS_PATTERN.matcher(s).replaceAll("\\\\-");
            s = AND_PATTERN.matcher(s).replaceAll("\\\\&&");
            s = OR_PATTERN.matcher(s).replaceAll("\\\\||");
            s = BANG_PATTERN.matcher(s).replaceAll("\\\\!");
            s = LEFT_CURLY_BRACE_PATTERN.matcher(s).replaceAll("\\\\{");
            s = RIGHT_CURLY_BRACE_PATTERN.matcher(s).replaceAll("\\\\}");
            s = LEFT_PARENTHESE_PATTERN.matcher(s).replaceAll("\\\\(");
            s = RIGHT_PARENTHESE_PATTERN.matcher(s).replaceAll("\\\\)");
            s = LEFT_BRACKET_PATTERN.matcher(s).replaceAll("\\\\[");
            s = RIGHT_BRACKET_PATTERN.matcher(s).replaceAll("\\\\]");
            s = CARET_PATTERN.matcher(s).replaceAll("\\\\^");
            s = QUOTE_PATTERN.matcher(s).replaceAll("\\\\\"");
            s = LEFT_CURLY_QUOTE_PATTERN.matcher(s).replaceAll("\\\\\u00d2");
            s = RIGHT_CURLY_QUOTE_PATTERN.matcher(s).replaceAll("\\\\\u00d3");
            s = TILDE_PATTERN.matcher(s).replaceAll("\\\\~");
            s = WILDCARD_PATTERN.matcher(s).replaceAll("\\\\*");
            s = QUESTION_MARK_PATTERN.matcher(s).replaceAll("\\\\?");
            s = COLON_PATTERN.matcher(s).replaceAll("\\\\:");
        }
        return s;
    }

    public static String escapeGUIDCharacters(String s) {
        if (s != null) {
            s = LEFT_CURLY_BRACE_PATTERN.matcher(s).replaceAll("\\\\{");
            s = RIGHT_CURLY_BRACE_PATTERN.matcher(s).replaceAll("\\\\}");
        }
        return s;
    }

    public static boolean isSpecialCharacter(String s) {
        boolean result = false;
        if (s != null) {
            StringTokenizer tokenizer = new StringTokenizer(LUCENE_SPECIAL_CHARS, " ");
            while (tokenizer.hasMoreTokens()) {
                String tk = tokenizer.nextToken();
                if (!s.equals(tk)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean hasSpecialCharacter(String s) {
        if (s != null) {
            return LUCENE_CHARACTERS_PATTERN.matcher(s).matches();
        }
        return false;
    }

    public static boolean hasSpecialCharacterWithEscapeCheck(String s) {
        if (s != null) {
            return LUCENE_CHARACTERS_PATTERN_WITH_ESCAPE_CHECK.matcher(s).matches();
        }
        return false;
    }

    public static boolean doArtifactOrSearch(String s) {
        if (s != null) {
            return !LUCENE_ARTIFACT_OR_SEARCH_PATTERN.matcher(s).matches();
        }
        return false;
    }

    public static boolean doFuzzySearch(String text) {
        if (text != null) {
            return !FUZZY_SEARCH_PATTERN.matcher(text = WHITESPACE_CHARACTER_PATTERN.matcher(text).replaceAll("")).matches();
        }
        return false;
    }

    public static boolean doOrSearch(String text) {
        if (text != null) {
            return !OR_SEARCH_PATTERN.matcher(text).matches() && SearchUtil.doFuzzySearch(text);
        }
        return false;
    }

    public static String getDenormalizedField(String fieldName) {
        StringBuilder sb = new StringBuilder("_");
        sb.append(fieldName);
        return sb.toString();
    }

    public static String getSortableField(String fieldName) {
        StringBuilder sb = new StringBuilder(SORTABLE_FIELD);
        sb.append(fieldName);
        return sb.toString();
    }

    public static String getSearchableField(String fieldName) {
        StringBuilder sb = new StringBuilder(FUZZY_SEARCH_FIELD);
        sb.append(fieldName);
        return sb.toString();
    }

    public static String getExactFieldQuery(String field, String searchText) {
        return SearchUtil.getExactFieldQuery(field, searchText, true);
    }

    public static String getExactFieldQuery(String field, String searchText, boolean escapeLuceneCharacters) {
        boolean containsWhitespace = WHITESPACE_PATTERN.matcher(searchText).matches();
        StringBuilder sb = new StringBuilder(field);
        sb.append(FIELD_QUERY_OPEN_SYNTAX);
        if (containsWhitespace) {
            sb.append("\"");
        }
        if (escapeLuceneCharacters) {
            sb.append(SearchUtil.escapeLuceneCharacters(searchText));
        } else {
            sb.append(searchText);
        }
        if (containsWhitespace) {
            sb.append("\"");
        }
        sb.append(FIELD_QUERY_CLOSE_SYNTAX);
        return sb.toString();
    }

    public static String getUniqueAssetQuery(AssetIdentification identification) {
        return SearchUtil.getExactFieldQuery(UNIQUE_ASSET_ID, SearchUtil.getUniqueAssetQueryValue(identification));
    }

    public static String getUniqueAssetQueryValue(AssetIdentification identification) {
        StringBuilder value = new StringBuilder(identification.getGUID());
        value.append("v");
        value.append(identification.getVersion());
        if (identification.isPendingAsset()) {
            value.append("p");
            value.append(String.valueOf(identification.isPendingAsset()));
        }
        return value.toString();
    }

    public static String getFuzzyFieldQuery(String field, String searchText, boolean escapeLuceneCharacters) {
        StringBuilder sb = new StringBuilder(LUCENE_ESCAPE_CHARACTER);
        sb.append(FUZZY_SEARCH_FIELD);
        sb.append(field);
        sb.append(FIELD_QUERY_OPEN_SYNTAX);
        if (escapeLuceneCharacters) {
            sb.append(SearchUtil.escapeLuceneCharacters(searchText));
        } else {
            sb.append(searchText);
        }
        sb.append(FIELD_QUERY_CLOSE_SYNTAX);
        return sb.toString();
    }

    public static String getFuzzySearch(String searchTerms) {
        StringBuilder search = new StringBuilder();
        if (searchTerms != null) {
            String[] terms = searchTerms.split(" ");
            int i = 0;
            while (i < terms.length) {
                StringBuffer sb = new StringBuffer(terms[i]);
                if (!(terms[i].equalsIgnoreCase("AND") || terms[i].equalsIgnoreCase("OR") || terms[i].equalsIgnoreCase("TO"))) {
                    sb.append("~ ");
                } else {
                    sb.append(" ");
                }
                search.append(sb);
                ++i;
            }
        }
        return search.toString().trim();
    }

    public static String getOrSearch(String search) {
        return OR_WHITESPACE_PATTERN.matcher(search).replaceAll(OR);
    }

    /* synthetic */ SearchUtil(SearchUtil searchUtil) {
        this();
    }

    private static class SearchUtilInstance {
        private static final SearchUtil _instance = new SearchUtil(null);

        private SearchUtilInstance() {
        }
    }
}

