/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.jaxb.util;

import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.data.CommunityInformation;
import com.ibm.ram.common.data.FolderArtifact;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.common.util.InputStreamInformation;
import com.ibm.ram.common.util.RAMURLDecoder;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.common.util.UniqueIDGenerator;
import com.ibm.ram.defaultprofile.util.Utilities;
import com.ibm.ram.internal.client.util.StringUtils;
import com.ibm.ram.internal.common.util.LifecycleUtilities;
import com.ibm.ram.internal.jaxb.Action;
import com.ibm.ram.internal.jaxb.Artifact;
import com.ibm.ram.internal.jaxb.ArtifactReference;
import com.ibm.ram.internal.jaxb.ArtifactType;
import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.internal.jaxb.AssetAttribute;
import com.ibm.ram.internal.jaxb.AssetID;
import com.ibm.ram.internal.jaxb.AssetType;
import com.ibm.ram.internal.jaxb.Category;
import com.ibm.ram.internal.jaxb.CategorySchema;
import com.ibm.ram.internal.jaxb.Comment;
import com.ibm.ram.internal.jaxb.Community;
import com.ibm.ram.internal.jaxb.Lifecycle;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.Policy;
import com.ibm.ram.internal.jaxb.PolicyConfiguration;
import com.ibm.ram.internal.jaxb.PolicyGovernor;
import com.ibm.ram.internal.jaxb.RelationshipLink;
import com.ibm.ram.internal.jaxb.Repository;
import com.ibm.ram.internal.jaxb.State;
import com.ibm.ram.internal.jaxb.StateConfiguration;
import com.ibm.ram.internal.jaxb.StateHistory;
import com.ibm.ram.internal.jaxb.User;
import com.ibm.ram.internal.jaxb.UserGroup;
import com.ibm.ram.internal.jaxb.Workflow;
import com.ibm.ram.internal.jaxb.util.JAXBRichLinksUtil;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.oslc.asset.internal.Relation;
import org.oslc.asset.internal.Resource;
import org.oslc.asset.internal.ResourceRef;

public class JAXBLinksUtil {
    private static final String LIFECYCLES_PATH_SEGMENT = "/lifecycles/";
    public static String COMMUNITIES_PATH = "internal/communities/";
    public static String ASSETS_PATH = "internal/assets/";
    public static String MASTER_LIFECYCLES_PATH = "internal/masterLifecycles/";
    public static final String DRAFT_ASSETS_PATH = "internal/drafts/assets/";
    public static String WORKFLOWS_PATH = "internal/workflows/";
    public static String STATES_PATH = "internal/states/";
    public static String ACTIONS_PATH = "internal/actions/";
    public static String LEGACY_WORKFLOW_ID = "com.ibm.ram.legacy";
    public static String CATEGORY_SCHEMAS_PATH = "internal/categorySchemas/";
    public static String CATEGORIES_PATH = "internal/categories/";
    public static String ATTRIBUTES_PATH = "internal/attributes/";
    public static String TYPES_PATH = "internal/types/";
    public static String COMMENTS_PATH = "comments/";
    public static String POLICY_GOVERNOR_PATH = "internal/governors/";
    public static String USERS_PATH = "internal/users/";
    public static String USER_GROUP_PATH = "internal/userGroups/";
    public static final String STATE_ICON_URL = "/internal/icons/states/";
    public static final String STATE_URL = "internal/states/";

    public static Link getLink(String title, String ref) {
        return JAXBLinksUtil.getLink(title, ref, "related", null);
    }

    public static Link getLink(String href) {
        return JAXBLinksUtil.getLink("Unnamed Link", href, "related", null);
    }

    public static <T> Link<T> getLink(String href, T value) {
        return JAXBLinksUtil.getLink("Unnamed Link", href, "related", value);
    }

    public static Link getLink(String title, String ref, String rel) {
        return JAXBLinksUtil.getLink(title, ref, rel, null);
    }

    public static <T> Link<T> getLink(String title, String ref, String rel, T value) {
        return JAXBLinksUtil.getLink(title, ref, rel, null, value);
    }

    public static <T> Link<T> getLink(String title, String ref, T value) {
        return JAXBLinksUtil.getLink(title, ref, "related", null, value);
    }

    public static <T> Link<T> getLink(String title, String ref, String rel, String imgRef, T value) {
        Link<T> r = new Link<T>();
        if (title != null) {
            r.setTitle(JAXButil.getSimpleLiteral(title));
        } else {
            r.setTitle(JAXButil.getSimpleLiteral("Unknown"));
        }
        r.setHref(ref);
        r.setValue(value);
        r.setImage(imgRef);
        r.setRel(rel);
        return r;
    }

    public static <T> Link<T> copyLinkRemoveValue(Link<T> link) {
        Link r = new Link();
        r.setTitle(link.getTitle());
        r.setHref(link.getHref());
        r.setImage(link.getImage());
        r.setRel(link.getRel());
        return r;
    }

    public static Link<Community> getLink(CommunityInformation community) {
        Community jaxbCommunity = new Community();
        jaxbCommunity.setDbid(community.getId());
        jaxbCommunity.setDescription(community.getDescription());
        jaxbCommunity.setIdentifier(Integer.toString(community.getId()));
        jaxbCommunity.setLastModified(JAXButil.getXMLCalendar(new Date()));
        jaxbCommunity.setName(community.getName());
        return JAXBLinksUtil.getLink(jaxbCommunity);
    }

    public static <T extends StateHistory> Link<T> getLink(T history) {
        String href = String.valueOf(JAXBLinksUtil.removeExtension(history.getAsset().getHref())) + "/" + "stateHistories" + "/" + history.getIdentifier();
        history.setHref(href);
        return JAXBLinksUtil.getLink("State History " + history.getStartDate(), href, history);
    }

    public static String createURL(String baseURL, String filePart) {
        return JAXBLinksUtil.createURL(baseURL, filePart, false);
    }

    public static String createURL(String baseURL, String filePart, boolean skipFileEncode) {
        String url = null;
        try {
            StringBuilder sbBaseUrl = new StringBuilder(baseURL);
            if (!baseURL.endsWith("/")) {
                sbBaseUrl.append('/');
            }
            sbBaseUrl.append("index");
            if (filePart.startsWith("/")) {
                filePart = filePart.substring(1);
            }
            if (!skipFileEncode) {
                filePart = JAXButil.urlEncodePathSegments(filePart);
            }
            if (filePart.endsWith("/")) {
                filePart = filePart.substring(0, filePart.length() - 1);
            }
            URI base = new URI(sbBaseUrl.toString());
            url = base.resolve(filePart).toString();
        }
        catch (Exception exception) {
            url = String.valueOf(baseURL) + filePart;
        }
        return url;
    }

    private static String cleanIdentifier(String id) {
        id = id.toLowerCase();
        id = id.replaceAll("\\s|\\{|\\}", "");
        return id;
    }

    public static Link<PolicyConfiguration> getPolicyConfigurationLink(Link<StateConfiguration> stateConfig, PolicyConfiguration policyConfig) {
        String id = policyConfig.getIdentifier();
        if (JAXButil.isEmptyString(id)) {
            id = JAXBLinksUtil.cleanIdentifier(UniqueIDGenerator.getUniqueID());
            policyConfig.setIdentifier(id);
        }
        policyConfig.setStateConfiguration(stateConfig);
        String href = String.valueOf(JAXBLinksUtil.removeExtension(stateConfig.getHref())) + "/" + "policyConfigurations" + "/" + RAMURLEncoder.encode(id);
        policyConfig.setHref(href);
        String name = "Policy Configuration : " + JAXButil.toString(policyConfig.getPolicy().getTitle());
        return JAXBLinksUtil.getLink(name, href, policyConfig);
    }

    public static Link<List<StateHistory>> getStateHistoriesLink(Link<Asset> asset) {
        String href = String.valueOf(JAXBLinksUtil.removeExtension(asset.getHref())) + "/" + "stateHistories";
        return JAXBLinksUtil.getLink("State Histories", href, null);
    }

    public static Link<StateHistory> getStateHistoryLink(Link<Asset> asset, String identifier) {
        String href = String.valueOf(JAXBLinksUtil.removeExtension(asset.getHref())) + "/" + "stateHistories" + "/" + RAMURLEncoder.encode(identifier);
        return JAXBLinksUtil.getLink("State History " + identifier, href, null);
    }

    public static Link<StateHistory> getCurrentStateHistoryLink(Link<Asset> asset) {
        String href = String.valueOf(JAXBLinksUtil.removeExtension(asset.getHref())) + "/" + "stateHistories" + "/" + "current";
        return JAXBLinksUtil.getLink("Current Review History", href, null);
    }

    public static Link<Community> getLink(Community community) {
        String href = String.valueOf(COMMUNITIES_PATH) + RAMURLEncoder.encode(community.getIdentifier());
        community.setHref(href);
        return JAXBLinksUtil.getLink(community.getName(), href, community);
    }

    public static String getCommunityAbout(int communityId) {
        StringBuilder href = new StringBuilder(COMMUNITIES_PATH).append(communityId);
        return href.toString();
    }

    public static String getCommunityIdentifier(String href) {
        String ret = href;
        if (href != null) {
            ret = href.substring(COMMUNITIES_PATH.length());
            int sndx = ret.indexOf("/");
            if (sndx != -1) {
                ret = ret.substring(0, sndx);
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static String getCommunityIdentifier(Link<Community> community) {
        String id = null;
        id = community.isValueSet() ? community.getValue().getIdentifier() : JAXBLinksUtil.getCommunityIdentifier(community.getHref());
        return id;
    }

    public static Link<Artifact> getLink(Link<Asset> assetRef, Artifact artifact) {
        String id = JAXBLinksUtil.getArtifactIdentifier(artifact);
        String href = String.valueOf(JAXBLinksUtil.removeExtension(assetRef.getHref())) + "/" + "artifactDetails" + "/" + id;
        artifact.setHref(href);
        return JAXBLinksUtil.getLink(id, JAXBLinksUtil.getArtifactLinkTitle(artifact), href, artifact);
    }

    public static String getArtifactIdentifier(Artifact artifact) {
        String path = JAXBLinksUtil.getPath(artifact);
        String id = String.valueOf(path) + artifact.getName();
        return id;
    }

    private static String getPath(Artifact artifact) {
        return JAXButil.isEmptyString(artifact.getPath()) ? "" : (artifact.getPath().endsWith("/") ? artifact.getPath() : String.valueOf(artifact.getPath()) + "/");
    }

    public static String getArtifactLinkTitle(Artifact artifact) {
        String path = JAXBLinksUtil.getPath(artifact);
        return JAXButil.isEmptyString(path) ? artifact.getName() : String.valueOf(path) + artifact.getName();
    }

    public static String getArtifactIdentifier(Link<Artifact> artifactRef) {
        if (artifactRef.isValueSet()) {
            return JAXBLinksUtil.getArtifactIdentifier(artifactRef.getValue());
        }
        return JAXBLinksUtil.getArtifactIdentifier(artifactRef.getHref());
    }

    public static String getArtifactIdentifier(String href) {
        String ret = href;
        String artifactDetailsPath = "artifactDetails/";
        String artifactsPath = "artifacts/";
        String artifactsContentsPath = "artifactContents/";
        if (href != null) {
            int artMatch = href.indexOf(artifactsPath);
            int artDetailsMatch = href.indexOf(artifactDetailsPath);
            int artifactsContentsMatch = href.indexOf(artifactsContentsPath);
            if (artMatch != -1 || artDetailsMatch != -1 || artifactsContentsMatch != -1) {
                String firstMatch = null;
                firstMatch = artifactsContentsMatch != -1 && artDetailsMatch == -1 && artMatch == -1 ? artifactsContentsPath : (artifactsContentsMatch == -1 && artDetailsMatch != -1 && artMatch == -1 ? artifactDetailsPath : (artifactsContentsMatch == -1 && artDetailsMatch == -1 && artMatch != -1 ? artifactsPath : (artifactsContentsMatch != -1 && artDetailsMatch != -1 && artMatch == -1 ? (artifactsContentsMatch < artDetailsMatch ? artifactsContentsPath : artifactDetailsPath) : (artifactsContentsMatch == -1 && artDetailsMatch != -1 && artMatch != -1 ? (artMatch < artDetailsMatch ? artifactsPath : artifactDetailsPath) : (artifactsContentsMatch != -1 && artDetailsMatch == -1 && artMatch != -1 ? (artifactsContentsMatch < artMatch ? artifactsContentsPath : artifactsPath) : (artifactsContentsMatch < artDetailsMatch && artifactsContentsMatch < artMatch ? artifactsContentsPath : (artDetailsMatch < artifactsContentsMatch && artDetailsMatch < artMatch ? artifactDetailsPath : artifactsPath)))))));
                ret = href.substring(href.indexOf(firstMatch) + firstMatch.length());
            }
        }
        if (ret != null) {
            ret = JAXButil.urlDecodePathSegments(ret);
        }
        return ret;
    }

    public static String getArtifactPath(String href) {
        String id = JAXBLinksUtil.getArtifactIdentifier(href);
        if (id != null && id.contains("/")) {
            int lastIndex = JAXBRichLinksUtil.getArtifactLastSlashIndex(id);
            if (lastIndex > -1) {
                return id.substring(0, lastIndex);
            }
            return "";
        }
        return "";
    }

    public static String getArtifactName(String href) {
        String id = JAXBLinksUtil.getArtifactIdentifier(href);
        if (id != null && id.contains("/")) {
            int lastIndex = JAXBRichLinksUtil.getArtifactLastSlashIndex(id);
            if (lastIndex > -1) {
                return id.substring(lastIndex + 1);
            }
            return id;
        }
        return id;
    }

    public static Link<List<Artifact>> getArtifactsLinks(Link<Asset> assetRef) {
        String href = String.valueOf(JAXBLinksUtil.removeExtension(assetRef.getHref())) + "/" + "artifactDetails";
        return JAXBLinksUtil.getLink(String.valueOf(JAXButil.toString(assetRef.getTitle())) + " Artifacts", href, null);
    }

    public static Link getAssetDownloadLink(Asset asset) {
        String href = "assetDetail/downloadRelated.faces?guid=" + RAMURLEncoder.encode(asset.getId().getGUID()) + "&v=" + RAMURLEncoder.encode(asset.getId().getVersion());
        return JAXBLinksUtil.getLink(JAXButil.toString(asset.getTitle()), href);
    }

    public static List<Link<Artifact>> getArtifactLinks(com.ibm.ram.common.data.Asset asset) {
        FolderArtifact root = asset.getArtifactsRoot();
        return JAXBLinksUtil.getArtifactLinks(asset, root, new ArrayList<Link<Artifact>>());
    }

    public static Link<Asset> getAssetLink(AssetIdentification assetId) {
        Asset asset = new Asset();
        asset.setId(new AssetID());
        asset.getId().setGUID(assetId.getGUID());
        asset.getId().setVersion(assetId.getVersion());
        return JAXBLinksUtil.getLink(asset);
    }

    public static Link<Asset> getAssetLink(AssetID assetId) {
        Asset asset = new Asset();
        asset.setId(assetId);
        return JAXBLinksUtil.getLink(asset);
    }

    public static Link<Asset> getOSLCAssetLink(AssetIdentification assetId) {
        Asset asset = new Asset();
        asset.setId(new AssetID());
        asset.getId().setGUID(assetId.getGUID());
        asset.getId().setVersion(assetId.getVersion());
        return JAXBLinksUtil.getOSLCLink(asset);
    }

    public static Link<List<Asset>> getAssetsLink() {
        String filePart = "internal/assets";
        return JAXBLinksUtil.getLink("Assets", filePart, null);
    }

    public static String getOSLCAssetURL(AssetID assetId) {
        if (assetId.getGUID() == null) {
            throw new RAMRuntimeException("Could not create Asset URL : GUID is null");
        }
        if (assetId.getVersion() == null) {
            throw new RAMRuntimeException("Could not create Asset URL : Version is null");
        }
        return "oslc/assets/" + RAMURLEncoder.encode(assetId.getGUID()) + "/" + RAMURLEncoder.encode(assetId.getVersion());
    }

    public static String getTRSURL() {
        return "trs";
    }

    public static String getOSLCAssetShapeURL() {
        return "oslc/shapes/asset";
    }

    public static String getTRSBaseURL(long assetDBId) {
        String url = String.valueOf(JAXBLinksUtil.getTRSURL()) + "/" + "base";
        if (assetDBId > -1L) {
            url = String.valueOf(url) + "/" + Long.toString(assetDBId);
        }
        return url;
    }

    public static String getTRSChangelogURL(long lastChangeEventTimestamp) {
        String url = String.valueOf(JAXBLinksUtil.getTRSURL()) + "/" + "changelog";
        if (lastChangeEventTimestamp > -1L) {
            url = String.valueOf(url) + "/" + Long.toString(lastChangeEventTimestamp);
        }
        return url;
    }

    public static String getAccessControlURL() {
        return "acc";
    }

    public static Link<Asset> getOSLCAssetsLink(AssetIdentification assetId) {
        Asset asset = new Asset();
        asset.setId(new AssetID());
        asset.getId().setGUID(assetId.getGUID());
        asset.getId().setVersion(assetId.getVersion());
        return JAXBLinksUtil.getLink(asset);
    }

    public static String getURL(org.oslc.asset.internal.Asset oslcAsset) {
        if (oslcAsset.getId() == null) {
            throw new RAMRuntimeException("Could not create Asset URL : ID is null");
        }
        if (oslcAsset.getId().getGUID() == null) {
            throw new RAMRuntimeException("Could not create Asset URL : GUID is null");
        }
        if (oslcAsset.getId().getVersion() == null) {
            throw new RAMRuntimeException("Could not create Asset URL : Version is null");
        }
        return "oslc/assets/" + RAMURLEncoder.encode(oslcAsset.getId().getGUID()) + "/" + RAMURLEncoder.encode(oslcAsset.getId().getVersion());
    }

    public static AssetID getAssetID(String oslcResourceURI) {
        String href = oslcResourceURI;
        String identifier = href.substring(new String("oslc/assets/").length());
        String[] parts = identifier.split("/");
        AssetID id = new AssetID();
        id.setGUID(JAXButil.urlDecode(parts[0]));
        id.setVersion(JAXButil.urlDecode(parts[1]));
        return id;
    }

    public static String getRelationshipTypesURL(RelationshipLink relLink) {
        return "internal/relationshipTypes/" + RAMURLEncoder.encode(JAXButil.toString(relLink.getTitle()));
    }

    public static String getRelationshipTypeId(Relation relation) {
        if (relation == null || relation.getType() == null || relation.getType().getResource() == null) {
            return null;
        }
        String id = relation.getType().getResource().substring(new String("internal/relationshipTypes/").length());
        return RAMURLDecoder.decode(id);
    }

    public static String getInternalArtifactURL(String oslcArtifactHref) {
        String href = new String(oslcArtifactHref);
        href = href.replaceFirst("oslc/", "internal/");
        href = href.replaceFirst("/artifacts/", "/artifactDetails/");
        return href;
    }

    public static String getOSLCArtifactURL(AssetID assetId, org.oslc.asset.internal.Artifact oslcArtifact) {
        String href = String.valueOf(JAXBLinksUtil.getOSLCAssetURL(assetId)) + "/" + "artifacts" + "/" + oslcArtifact.getTitle();
        return href;
    }

    public static String getOSLCArtifactURL(AssetID assetId, Artifact jaxbArtifact) {
        String href = String.valueOf(JAXBLinksUtil.getOSLCAssetURL(assetId)) + "/" + "artifacts" + "/" + (StringUtils.isBlank(jaxbArtifact.getPath()) ? "" : String.valueOf(jaxbArtifact.getPath()) + "/") + jaxbArtifact.getName();
        return href;
    }

    public static String getOSLCArtifactContentURL(AssetID assetId, String artifactPath) {
        artifactPath = StringUtils.stripSlashPrefix(artifactPath);
        String href = String.valueOf(JAXBLinksUtil.getOSLCAssetURL(assetId)) + "/" + "artifactContents" + "/" + artifactPath;
        return href;
    }

    public static String getOSLCArtifactURL(String internalArtifactHref) {
        String href = new String(internalArtifactHref);
        href = href.replaceFirst("internal/", "oslc/");
        href = href.replaceFirst("/artifactDetails/", "/artifacts/");
        return href;
    }

    public static String getOSLCArtifactContentURL(String internalArtifactHref) {
        String href = new String(internalArtifactHref);
        href = href.replaceFirst("internal/assets/", "oslc/assets/");
        href = href.replaceFirst("/artifactDetails/", "/artifactContents/");
        return href;
    }

    public static Resource getResource(Link link) {
        if (link == null) {
            return null;
        }
        Resource res = new Resource();
        res.setAbout(link.getHref());
        res.setTitle(JAXButil.toString(link.getTitle()));
        return res;
    }

    public static ResourceRef getResourceRef(Link link) {
        if (link == null) {
            return null;
        }
        ResourceRef res = new ResourceRef();
        res.setResource(link.getHref());
        res.setValue(JAXButil.toString(link.getTitle()));
        return res;
    }

    public static ResourceRef getResourceRef(String href, String label) {
        ResourceRef res = new ResourceRef();
        res.setResource(href);
        res.setValue(label);
        return res;
    }

    public static Link getLink(Resource resource) {
        if (resource == null) {
            return null;
        }
        Link link = new Link();
        link.setHref(resource.getAbout());
        link.setTitle(JAXButil.getSimpleLiteral(resource.getTitle()));
        return link;
    }

    public static Link getLink(ResourceRef resource) {
        if (resource == null) {
            return null;
        }
        Link link = new Link();
        link.setHref(resource.getResource());
        link.setTitle(JAXButil.getSimpleLiteral(resource.getValue()));
        return link;
    }

    public static List<Link<Artifact>> getArtifactLinks(com.ibm.ram.common.data.Asset asset, FolderArtifact root) {
        ArrayList<Link<Artifact>> ret = new ArrayList<Link<Artifact>>();
        return JAXBLinksUtil.getArtifactLinks(asset, root, ret);
    }

    public static Link<List<Action>> getAvailableActionsLink(AssetIdentification assetId) {
        return JAXBLinksUtil.getAvailableActionsLink(JAXBLinksUtil.getAssetLink(assetId));
    }

    public static Link<List<Action>> getAvailableActionsLink(Link<Asset> assetRef) {
        String href = assetRef.getHref();
        href = String.valueOf(JAXBLinksUtil.removeExtension(href)) + "/" + "availableActions";
        return JAXBLinksUtil.getLink("Available Actions", href);
    }

    private static List<Link<Artifact>> getArtifactLinks(com.ibm.ram.common.data.Asset asset, FolderArtifact root, List<Link<Artifact>> ret) {
        com.ibm.ram.common.data.Artifact[] children = root.getChildren();
        int i = 0;
        while (children != null && i < children.length) {
            Artifact a = new Artifact();
            String path = children[i].getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            a.setPath(path);
            a.setLabel(children[i].getLabel());
            a.setMimeType(children[i].getMimeType());
            a.setLastModified(JAXButil.getXMLCalendar(new Date(children[i].getCreationDate())));
            a.setSize(children[i].getSize());
            if ("folder" == children[i].getType()) {
                a.setType(ArtifactType.FOLDER);
            } else if ("url" == children[i].getType()) {
                a.setType(ArtifactType.URL);
            } else {
                a.setType(ArtifactType.FILE);
            }
            if (children[i].getReference() != null) {
                ArtifactReference ref = new ArtifactReference();
                ref.setDescription(children[i].getReference().getDescription());
                ref.setKind(children[i].getReference().getKind());
                ref.setValue(children[i].getReference().getValue());
                a.setReference(ref);
            }
            Link<Asset> assetRef = JAXBLinksUtil.getLink(asset);
            Link<Artifact> artifactRef = JAXBLinksUtil.getArtifactDetailLink(assetRef, a);
            ret.add(artifactRef);
            if (children[i] instanceof FolderArtifact) {
                FolderArtifact fa = (FolderArtifact)children[i];
                JAXBLinksUtil.getArtifactLinks(asset, fa, ret);
            }
            ++i;
        }
        return ret;
    }

    public static Link<Lifecycle> getCommunityLifecycleLink(Lifecycle lifecycle) {
        String href = String.valueOf(lifecycle.getCommunity().getHref()) + LIFECYCLES_PATH_SEGMENT + RAMURLEncoder.encode(lifecycle.getIdentifier());
        lifecycle.setHref(href);
        return JAXBLinksUtil.getLink(lifecycle.getName(), href, lifecycle);
    }

    public static String getLifecycleIdentifier(Link<Lifecycle> lifecycleRef) {
        if (lifecycleRef.isValueSet()) {
            return lifecycleRef.getValue().getIdentifier();
        }
        return JAXBLinksUtil.getLifecycleIdentifier(lifecycleRef.getHref());
    }

    public static String getLifecycleIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(COMMUNITIES_PATH)) {
                if (href != null) {
                    int lcNdx = href.indexOf(LIFECYCLES_PATH_SEGMENT);
                    if (lcNdx != -1) {
                        ret = href.substring(lcNdx + LIFECYCLES_PATH_SEGMENT.length());
                    }
                    ret = JAXBLinksUtil.removeExtension(ret);
                    ret = JAXButil.urlDecode(ret);
                }
            } else {
                ret = JAXBLinksUtil.getMasterLifecycleIdentifer(href);
            }
        }
        return ret;
    }

    public static Link<Lifecycle> getLink(Link<Community> communityRef, Lifecycle lifecyle) {
        String href = String.valueOf(JAXBLinksUtil.removeExtension(communityRef.getHref())) + LIFECYCLES_PATH_SEGMENT + RAMURLEncoder.encode(lifecyle.getIdentifier());
        lifecyle.setHref(href);
        return JAXBLinksUtil.getLink(lifecyle.getName(), href, lifecyle);
    }

    public static String getMasterLifecycleIdentifer(String href) {
        int sndx;
        String ret = href;
        if (href != null && href.startsWith(MASTER_LIFECYCLES_PATH) && (sndx = (ret = href.substring(MASTER_LIFECYCLES_PATH.length())).indexOf("/")) != -1) {
            ret = ret.substring(sndx + 1);
        }
        ret = JAXBLinksUtil.removeExtension(ret);
        ret = JAXButil.urlDecode(ret);
        return ret;
    }

    public static Link<Lifecycle> getMasterLifecycleLink(Lifecycle lifecyle) {
        String filePart = "internal/masterLifecycles";
        String href = String.valueOf(filePart) + "/" + RAMURLEncoder.encode(lifecyle.getIdentifier());
        lifecyle.setHref(href);
        return JAXBLinksUtil.getLink(lifecyle.getName(), href, lifecyle);
    }

    public static Link<Lifecycle> getLifecycleLink(Link<Community> communityRef, String lifecyleIdentifier) {
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setIdentifier(lifecyleIdentifier);
        return JAXBLinksUtil.getLink(communityRef, lifecycle);
    }

    public static String getLifecycleAbout(int communityId, String lifecycleId) {
        StringBuilder sb = new StringBuilder();
        sb.append(JAXBLinksUtil.getCommunityAbout(communityId));
        sb.append("/");
        sb.append("lifecycles");
        sb.append("/");
        sb.append(lifecycleId);
        return sb.toString();
    }

    public static Link<List<Lifecycle>> getLifecylesLink(Link<Community> communityRef) {
        String href = String.valueOf(JAXBLinksUtil.removeExtension(communityRef.getHref())) + "/" + "lifecycles";
        return JAXBLinksUtil.getLink(JAXButil.toString(communityRef.getTitle()), href, null);
    }

    public static Link getMasterLifecycles() {
        String filePart = "internal/masterLifecycles";
        return JAXBLinksUtil.getLink("Lifecyles", filePart, null);
    }

    public static Link getAssetLifecycles() {
        String filePart = "internal/lifecycles";
        return JAXBLinksUtil.getLink("Lifecyles", filePart, null);
    }

    public static Link<Lifecycle> getLifecyleLink(Link<Asset> assetRef) {
        String id = JAXBLinksUtil.getAssetIdentifier(assetRef.getHref());
        String href = "internal/lifecycles/" + id;
        return JAXBLinksUtil.getLink("Lifecyles", href, null);
    }

    public static Link<Lifecycle> getLifecyleLink(AssetIdentification assetId) {
        String href = "internal/lifecycles/" + RAMURLEncoder.encode(assetId.getGUID()) + "/" + RAMURLEncoder.encode(assetId.getVersion());
        return JAXBLinksUtil.getLink("Lifecyles", href, null);
    }

    public static String getDraftAssetIdentifier(String href) {
        if (href != null) {
            int aidend;
            int aid = 0;
            if (href.startsWith(DRAFT_ASSETS_PATH)) {
                aid = DRAFT_ASSETS_PATH.length();
            }
            if ((aidend = href.indexOf(47, aid)) == -1) {
                return JAXButil.urlDecode(JAXBLinksUtil.removeExtension(href.substring(aid)));
            }
            return JAXButil.urlDecode(href.substring(aid, aidend));
        }
        return null;
    }

    public static String getDraftAssetIdentifier(Link<Asset> link) {
        if (link == null) {
            return null;
        }
        return JAXBLinksUtil.getDraftAssetIdentifier(link.getHref());
    }

    public static String[] getDraftArtifactIdentifiersFromInputInfo(Link<InputStreamInformation> link) {
        if (link == null) {
            return null;
        }
        return JAXBLinksUtil.getDraftArtifactIdentifiers(link.getHref());
    }

    public static String[] getDraftArtifactIdentifiersFromInputStream(Link<? extends InputStream> link) {
        if (link == null) {
            return null;
        }
        return JAXBLinksUtil.getDraftArtifactIdentifiers(link.getHref());
    }

    public static String[] getDraftArtifactIdentifiers(String href) {
        if (!JAXButil.isEmptyString(href)) {
            int artTypendx;
            int aidndx = 0;
            if (href.startsWith(DRAFT_ASSETS_PATH)) {
                aidndx = DRAFT_ASSETS_PATH.length();
            }
            if ((artTypendx = href.indexOf(47, aidndx) + 1) == 0) {
                return null;
            }
            int artndx = href.indexOf(47, artTypendx) + 1;
            if (artndx == 0) {
                return null;
            }
            int fnndx = href.lastIndexOf(47) + 1;
            return new String[]{JAXButil.urlDecode(href.substring(aidndx, artTypendx - 1)), artndx == fnndx ? "" : JAXButil.urlDecodePathSegments(href.substring(artndx, fnndx - 1)), JAXButil.urlDecode(href.substring(fnndx))};
        }
        return null;
    }

    public static Link<Asset> getDraftAssetLink(Asset asset, String uniqueID) {
        String filePart = DRAFT_ASSETS_PATH + RAMURLEncoder.encode(uniqueID);
        asset.setHref(filePart);
        return JAXBLinksUtil.getLink("Draft Asset - " + uniqueID, filePart, asset);
    }

    public static Link<Asset> getDraftAssetLink(String uniqueID) {
        String filePart = DRAFT_ASSETS_PATH + RAMURLEncoder.encode(uniqueID);
        return JAXBLinksUtil.getLink("Draft Asset - " + uniqueID, filePart, null);
    }

    public static Link<List<Asset>> getDraftAssetsLink() {
        String filePart = "internal/drafts/assets";
        return JAXBLinksUtil.getLink("Draft Assets", filePart, null);
    }

    public static String getDraftArtifactURL(String transId, String artifactPath) {
        return DRAFT_ASSETS_PATH + RAMURLEncoder.encode(transId) + "/" + "artifacts" + "/" + JAXButil.urlEncodePathSegments(artifactPath);
    }

    public static Link<InputStreamInformation> getDraftArtifactDownloadLink(Link<Asset> assetRef, Artifact artifact) {
        String[] segments = JAXBLinksUtil.getPath(artifact).split("/");
        StringBuilder path = new StringBuilder();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!JAXButil.isEmptyString(segment)) {
                path.append(RAMURLEncoder.encode(segment)).append('/');
            }
            ++n2;
        }
        String filePart = String.valueOf(JAXBLinksUtil.removeExtension(assetRef.getHref())) + "/" + "artifacts" + "/" + path + RAMURLEncoder.encode(artifact.getName());
        artifact.setHref(filePart);
        return JAXBLinksUtil.getLink(JAXBLinksUtil.getArtifactLinkTitle(artifact), filePart, null);
    }

    public static Link getArtifactDownloadLink(Link<Asset> assetRef, Artifact artifact) {
        String[] segments = JAXBLinksUtil.getPath(artifact).split("/");
        StringBuffer path = new StringBuffer();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!JAXButil.isEmptyString(segment)) {
                path.append(String.valueOf(RAMURLEncoder.encode(segment)) + "/");
            }
            ++n2;
        }
        String assetId = JAXBLinksUtil.getAssetIdentifier(assetRef.getHref());
        String filePart = "artifact/" + assetId + "/" + path.toString() + RAMURLEncoder.encode(artifact.getName());
        artifact.setHref(filePart);
        return JAXBLinksUtil.getLink(JAXBLinksUtil.getArtifactLinkTitle(artifact), filePart);
    }

    public static Link<Artifact> getDraftArtifactDetailLink(Link<Asset> assetRef, Artifact artifact) {
        String[] segments = JAXBLinksUtil.getPath(artifact).split("/");
        StringBuffer path = new StringBuffer();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!JAXButil.isEmptyString(segment)) {
                path.append(String.valueOf(RAMURLEncoder.encode(segment)) + "/");
            }
            ++n2;
        }
        String filePart = String.valueOf(JAXBLinksUtil.removeExtension(assetRef.getHref())) + "/" + "artifactDetails" + "/" + path.toString() + RAMURLEncoder.encode(artifact.getName());
        Link<InputStreamInformation> artifactContentLink = JAXBLinksUtil.getDraftArtifactDownloadLink(assetRef, artifact);
        artifact.setContent(artifactContentLink.getHref());
        artifact.setHref(filePart);
        return JAXBLinksUtil.getLink(JAXBLinksUtil.getArtifactLinkTitle(artifact), filePart, artifact);
    }

    public static Link<Artifact> getArtifactDetailLink(Asset asset, String artifactTitle) {
        String[] segments = artifactTitle.split("/");
        StringBuffer path = new StringBuffer();
        boolean first = true;
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!JAXButil.isEmptyString(segment)) {
                if (!first) {
                    path.append("/");
                }
                first = false;
                path.append(RAMURLEncoder.encode(segment));
            }
            ++n2;
        }
        String filePart = String.valueOf(JAXBLinksUtil.removeExtension(asset.getHref())) + "/" + "artifactDetails" + "/" + path.toString();
        return JAXBLinksUtil.getLink(artifactTitle, filePart);
    }

    public static Link<Artifact> getArtifactDetailLink(Link<Asset> assetRef, Artifact artifact) {
        String[] segments = JAXBLinksUtil.getPath(artifact).split("/");
        StringBuffer path = new StringBuffer();
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!JAXButil.isEmptyString(segment)) {
                path.append(String.valueOf(RAMURLEncoder.encode(segment)) + "/");
            }
            ++n2;
        }
        String filePart = String.valueOf(JAXBLinksUtil.removeExtension(assetRef.getHref())) + "/" + "artifactDetails" + "/" + path.toString() + RAMURLEncoder.encode(artifact.getName());
        Link artifactContentLink = JAXBLinksUtil.getArtifactDownloadLink(assetRef, artifact);
        artifact.setContent(artifactContentLink.getHref());
        artifact.setHref(filePart);
        return JAXBLinksUtil.getLink(JAXBLinksUtil.getArtifactLinkTitle(artifact), filePart, artifact);
    }

    public static Link<Asset> getLink(Asset asset) {
        String filePart = JAXBLinksUtil.getAssetHref(asset);
        asset.setHref(filePart);
        return JAXBLinksUtil.getLink(JAXButil.toString(asset.getTitle()), filePart, asset);
    }

    public static Link<Asset> getOSLCLink(Asset asset) {
        String filePart = JAXBLinksUtil.getOSLCAssetHref(asset);
        asset.setHref(filePart);
        return JAXBLinksUtil.getLink(JAXButil.toString(asset.getTitle()), filePart, asset);
    }

    public static String getAssetSubscriptionsHref(AssetID id) {
        return String.valueOf(JAXBLinksUtil.getAssetHref(id)) + "/" + "subscriptions";
    }

    public static String getAssetHref(Asset asset) {
        String filePart = JAXBLinksUtil.getAssetHref(asset.getId());
        return filePart;
    }

    public static String getAssetGeneralDetailsURL(AssetID asset) {
        String filePart = "assetDetail/generalDetails.faces?guid=" + JAXButil.urlDecode(asset.getGUID()) + "&v=" + JAXButil.urlDecode(asset.getVersion());
        return filePart;
    }

    public static String getAssetHref(AssetID id) {
        String identifier = String.valueOf(RAMURLEncoder.encode(id.getGUID())) + "/" + RAMURLEncoder.encode(id.getVersion());
        String filePart = String.valueOf(ASSETS_PATH) + identifier;
        return filePart;
    }

    public static String getOSLCAssetHref(Asset asset) {
        return JAXBLinksUtil.getOSLCAssetURL(asset.getId());
    }

    public static Link<Asset> getLink(com.ibm.ram.common.data.Asset asset) {
        String identifier = String.valueOf(RAMURLEncoder.encode(asset.getIdentification().getGUID())) + "/" + RAMURLEncoder.encode(asset.getIdentification().getVersion());
        String href = String.valueOf(ASSETS_PATH) + identifier;
        return JAXBLinksUtil.getLink(asset.getName(), href, null);
    }

    public static String getAssetIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(ASSETS_PATH)) {
                ret = href.substring(ASSETS_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
        }
        return ret;
    }

    public static Link<Workflow> getLink(Workflow workflow) {
        String href = String.valueOf(WORKFLOWS_PATH) + RAMURLEncoder.encode(workflow.getIdentifier());
        workflow.setHref(href);
        return JAXBLinksUtil.getLink(workflow.getName(), href, workflow);
    }

    public static String getWorkflowIdentifier(Link link) {
        if (link == null) {
            return null;
        }
        if (link.isValueSet() && link.getValue() instanceof Workflow) {
            return ((Workflow)link.getValue()).getIdentifier();
        }
        if (link.isValueSet() && link.getValue() instanceof Action) {
            return JAXBLinksUtil.getWorkflowIdentifier(((Action)link.getValue()).getWorkflow());
        }
        if (link.isValueSet() && link.getValue() instanceof State) {
            return JAXBLinksUtil.getWorkflowIdentifier(((State)link.getValue()).getWorkflow());
        }
        return JAXBLinksUtil.getWorkflowIdentifier(link.getHref());
    }

    public static String getWorkflowIdentifier(String href) {
        String ret = href;
        if (href != null) {
            int sndx;
            if (href.startsWith(WORKFLOWS_PATH)) {
                ret = href.substring(WORKFLOWS_PATH.length());
            } else if (href.startsWith(ACTIONS_PATH)) {
                ret = href.substring(ACTIONS_PATH.length());
                int sndx2 = ret.indexOf("/");
                if (sndx2 != -1) {
                    ret = ret.substring(0, sndx2);
                }
            } else if (href.startsWith(STATES_PATH) && (sndx = (ret = href.substring(STATES_PATH.length())).indexOf("/")) != -1) {
                ret = ret.substring(0, sndx);
            }
        }
        ret = JAXBLinksUtil.removeExtension(ret);
        ret = JAXButil.urlDecode(ret);
        return ret;
    }

    public static Link<Repository> getRepositoryLink() {
        String filePart = "internal/repository";
        return JAXBLinksUtil.getLink("Repository Information", filePart, null);
    }

    public static Link<List<Workflow>> getWorkflowsLink() {
        String href = "internal/workflows";
        return JAXBLinksUtil.getLink("Workflows", href);
    }

    public static Link<State> getLink(State state) {
        if (state == null) {
            return null;
        }
        if (state.getHref() == null) {
            StringBuilder href = new StringBuilder(STATES_PATH);
            String sid = state.getIdentifier();
            int sndx = sid.lastIndexOf(47);
            if (sndx == -1) {
                if (state.getWorkflow() == null) {
                    href.append(LEGACY_WORKFLOW_ID).append("/");
                } else {
                    String id = JAXBLinksUtil.getWorkflowIdentifier(state.getWorkflow());
                    href.append(id).append("/");
                }
            } else {
                href.append(sid.substring(0, sndx + 1));
                state.setIdentifier(sid.substring(sndx + 1));
            }
            href.append(state.getIdentifier());
            state.setHref(href.toString());
        }
        return JAXBLinksUtil.getLink(state.getName(), state.getHref(), "related", state.getIconUrl(), state);
    }

    public static Link<StateConfiguration> getStateConfigurationLink(Link<Lifecycle> lifecycleRef, StateConfiguration stateConfig) {
        String id = stateConfig.getIdentifier();
        if (JAXButil.isEmptyString(id)) {
            id = JAXBLinksUtil.getStateIdentifier(stateConfig.getState().getHref());
            stateConfig.setIdentifier(id);
        }
        stateConfig.setLifecycle(lifecycleRef);
        String href = String.valueOf(JAXBLinksUtil.removeExtension(lifecycleRef.getHref())) + "/" + "stateConfigurations" + "/" + RAMURLEncoder.encode(id);
        stateConfig.setHref(href);
        String name = "State Configuration : " + JAXButil.toString(stateConfig.getState().getTitle());
        return JAXBLinksUtil.getLink(name, href, stateConfig);
    }

    public static Link<StateConfiguration> getStateHistoryConfigurationLink(Link<StateHistory> stateHistoryRef, StateConfiguration stateConfig) {
        String id = stateConfig.getIdentifier();
        if (JAXButil.isEmptyString(id)) {
            id = JAXBLinksUtil.getStateIdentifier(stateConfig.getState().getHref());
            stateConfig.setIdentifier(id);
        }
        String href = String.valueOf(JAXBLinksUtil.removeExtension(stateHistoryRef.getHref())) + "/" + "stateConfiguration";
        stateConfig.setHref(href);
        String name = "State Configuration";
        return JAXBLinksUtil.getLink(name, href, stateConfig);
    }

    public static String getStateIdentifier(Link<State> link) {
        if (link == null) {
            return null;
        }
        if (link.isValueSet()) {
            return link.getValue().getIdentifier();
        }
        return JAXBLinksUtil.getStateIdentifier(link.getHref());
    }

    public static String getStateFullIdentifier(Link<State> link) {
        if (link == null) {
            return null;
        }
        if (link.isValueSet()) {
            State v = link.getValue();
            return Utilities.formStateWorkflowId(JAXBLinksUtil.getWorkflowIdentifier(v.getWorkflow()), v.getIdentifier());
        }
        return JAXBLinksUtil.getStateFullIdentifier(link.getHref());
    }

    public static String getStateIdentifier(String href) {
        String ret = href;
        if (href != null && href.startsWith(STATES_PATH) && (ret = href.substring(STATES_PATH.length())).indexOf("/") != -1) {
            ret = ret.substring(ret.indexOf("/") + 1);
        }
        ret = JAXBLinksUtil.removeExtension(ret);
        ret = JAXButil.urlDecode(ret);
        return ret;
    }

    public static String getStateFullIdentifier(String href) {
        String ret = href;
        if (href != null && href.startsWith(STATES_PATH)) {
            ret = href.substring(STATES_PATH.length());
        }
        ret = JAXBLinksUtil.removeExtension(ret);
        ret = JAXButil.urlDecode(ret);
        return ret;
    }

    public static Link<Action> getLink(Action action) {
        StringBuilder href = new StringBuilder(ACTIONS_PATH);
        if (action.getWorkflow() == null) {
            href.append(LEGACY_WORKFLOW_ID).append("/");
        } else {
            String id = JAXBLinksUtil.getWorkflowIdentifier(action.getWorkflow());
            href.append(id).append("/");
        }
        href.append(action.getIdentifier());
        action.setHref(href.toString());
        return JAXBLinksUtil.getLink(action.getName(), href.toString(), "related", action.getIconUrl(), action);
    }

    public static String getActionIdentifier(Link<Action> link) {
        if (link == null) {
            return null;
        }
        if (link.isValueSet()) {
            return link.getValue().getIdentifier();
        }
        return JAXBLinksUtil.getActionIdentifier(link.getHref());
    }

    public static String getActionIdentifier(String href) {
        int sndx;
        String ret = href;
        if (href != null && href.startsWith(ACTIONS_PATH) && (sndx = (ret = href.substring(ACTIONS_PATH.length())).indexOf("/")) != -1) {
            ret = ret.substring(sndx + 1);
        }
        ret = JAXBLinksUtil.removeExtension(ret);
        ret = JAXButil.urlDecode(ret);
        return ret;
    }

    public static Link<CategorySchema> getLink(CategorySchema categorySchema) {
        String path = JAXButil.urlEncodePathSegments(categorySchema.getIdentifier());
        String href = String.valueOf(CATEGORY_SCHEMAS_PATH) + path;
        categorySchema.setHref(href);
        return JAXBLinksUtil.getLink(categorySchema.getName(), href, categorySchema);
    }

    public static String getCategorySchemaIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(CATEGORY_SCHEMAS_PATH)) {
                ret = href.substring(CATEGORY_SCHEMAS_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static Link<Category> getLink(Category category) {
        String path = JAXButil.urlEncodePathSegments(category.getIdentifier());
        String href = String.valueOf(CATEGORIES_PATH) + path;
        category.setHref(href);
        return JAXBLinksUtil.getLink(category.getDisplayPath(), href, category);
    }

    public static String getCategoryIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(CATEGORIES_PATH)) {
                ret = href.substring(CATEGORIES_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static Link<AssetAttribute> getLink(AssetAttribute attribute) {
        String path = JAXButil.urlEncodePathSegments(attribute.getIdentifier());
        String href = String.valueOf(ATTRIBUTES_PATH) + path;
        attribute.setHref(href);
        return JAXBLinksUtil.getLink(attribute.getName(), href, attribute);
    }

    public static String getAttributeIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(ATTRIBUTES_PATH)) {
                ret = href.substring(ATTRIBUTES_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static Link<AssetType> getLink(AssetType assetType) {
        String path = JAXButil.urlEncodePathSegments(assetType.getIdentifier());
        String href = String.valueOf(TYPES_PATH) + path;
        assetType.setHref(href);
        return JAXBLinksUtil.getLink(assetType.getName(), href, assetType);
    }

    public static String getAssetTypeIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(TYPES_PATH)) {
                ret = href.substring(TYPES_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static Link<AssetType> getLink(com.ibm.ram.common.data.AssetType assetType) {
        AssetType type = new AssetType();
        type.setDbid(assetType.getId());
        type.setIdentifier(assetType.getURI());
        type.setName(assetType.getName());
        return JAXBLinksUtil.getLink(type);
    }

    public static ResourceRef getCommunityAssetTypeRef(AssetType assetType, String communityName, int communityId) {
        ResourceRef ref = new ResourceRef();
        Link<AssetType> type = JAXBLinksUtil.getLink(assetType);
        StringBuffer href = new StringBuffer(type.getHref()).append("/").append("communities").append("/").append(communityId);
        ref.setResource(href.toString());
        ref.setValue(communityName);
        return ref;
    }

    public static String getCommunityAssetTypeAbout(String typeURI, int communityId) {
        StringBuffer href = new StringBuffer(JAXBLinksUtil.getAssetTypeAbout(typeURI)).append("/").append("communities").append("/").append(communityId);
        return href.toString();
    }

    public static String getAssetTypeAbout(String typeURI) {
        StringBuffer href = new StringBuffer(TYPES_PATH).append(JAXButil.urlEncodePathSegments(typeURI));
        return href.toString();
    }

    public static Link<Comment> getLink(Link<StateHistory> historyRef, Comment comment) {
        String base = JAXBLinksUtil.removeExtension(historyRef.getHref());
        String filePart = String.valueOf(COMMENTS_PATH) + RAMURLEncoder.encode(comment.getIdentifier());
        String url = JAXBLinksUtil.createURL(base, filePart);
        comment.setHref(url);
        return JAXBLinksUtil.getLink("Comment " + comment.getLastModified(), url, comment);
    }

    public static Link<List<Comment>> getCommentsLink(Link<StateHistory> historyRef) {
        String base = JAXBLinksUtil.removeExtension(historyRef.getHref());
        String filePart = "comments";
        String url = JAXBLinksUtil.createURL(base, filePart);
        return JAXBLinksUtil.getLink("Comments", url, null);
    }

    public static String getCommentIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(COMMENTS_PATH)) {
                ret = href.substring(COMMENTS_PATH.length());
            } else if (href.indexOf(COMMENTS_PATH) > -1) {
                ret = href.substring(href.indexOf(COMMENTS_PATH) + COMMENTS_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static String getCommentIdentifier(Link<Comment> comment) {
        String id = null;
        id = comment.isValueSet() ? comment.getValue().getIdentifier() : JAXBLinksUtil.getCommentIdentifier(comment.getHref());
        return id;
    }

    public static Link<PolicyGovernor> getLink(PolicyGovernor policyGovernor) {
        String href = String.valueOf(POLICY_GOVERNOR_PATH) + RAMURLEncoder.encode(policyGovernor.getIdentifier());
        policyGovernor.setHref(href);
        return JAXBLinksUtil.getLink(policyGovernor.getName(), href, policyGovernor);
    }

    public static String getPolicyGovernorIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(POLICY_GOVERNOR_PATH)) {
                ret = href.substring(POLICY_GOVERNOR_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            if ((ret = JAXButil.urlDecode(ret)).indexOf("/") != -1) {
                ret = ret.substring(0, ret.indexOf("/"));
            }
        }
        return ret;
    }

    public static Link<Policy> getLink(Policy policy) {
        Link<PolicyGovernor> policyGovernor = policy.getGovernor();
        String govRef = JAXBLinksUtil.removeExtension(policyGovernor.getHref());
        String href = String.valueOf(govRef) + "/" + "policies" + "/" + RAMURLEncoder.encode(policy.getIdentifier());
        policy.setHref(href);
        return JAXBLinksUtil.getLink(policy.getName(), href, policy);
    }

    public static String getPolicyIdentifier(String href) {
        String ret = href;
        String policiesPath = "policies/";
        if (href != null) {
            if (href.indexOf(policiesPath) != -1) {
                ret = href.substring(href.indexOf(policiesPath) + policiesPath.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static Link<User> getLink(User user) {
        String href = String.valueOf(USERS_PATH) + RAMURLEncoder.encode(user.getIdentifier());
        user.setHref(href);
        return JAXBLinksUtil.getLink(user.getName(), href, "related", user.getImageURL(), user);
    }

    public static String getUserIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(USERS_PATH)) {
                ret = href.substring(USERS_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static String getUserResourceURL(String uid) {
        return String.valueOf(USERS_PATH) + uid;
    }

    public static Link<UserGroup> getLink(UserGroup userGroup) {
        String href = String.valueOf(USER_GROUP_PATH) + RAMURLEncoder.encode(userGroup.getIdentifier());
        userGroup.setHref(href);
        return JAXBLinksUtil.getLink(userGroup.getName(), href, userGroup);
    }

    public static Link<UserGroup> getUserGroupLink(int userGroupId) {
        String href = String.valueOf(USER_GROUP_PATH) + userGroupId;
        return JAXBLinksUtil.getLink("User Group", href, null);
    }

    public static String getUserGroupIdentifier(String href) {
        String ret = href;
        if (href != null) {
            if (href.startsWith(USER_GROUP_PATH)) {
                ret = href.substring(USER_GROUP_PATH.length());
            }
            ret = JAXBLinksUtil.removeExtension(ret);
            ret = JAXButil.urlDecode(ret);
        }
        return ret;
    }

    public static void normalizeLinks(String baseURI, Link ... links) {
        Link[] linkArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            Link link = linkArray[n2];
            if (link != null) {
                link.setHref(JAXBLinksUtil.getNormalizedLinkRef(link, baseURI));
            }
            ++n2;
        }
    }

    public static void denormalizeLinks(String baseURI, Link ... links) {
        Link[] linkArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            Link link = linkArray[n2];
            if (link != null) {
                link.setHref(JAXBLinksUtil.getDenormalizedLinkRef(link, baseURI));
            }
            ++n2;
        }
    }

    public static String getNormalizedLinkRef(Link link, String baseURI) {
        if (link.getHref() == null) {
            return null;
        }
        String href = link.getHref();
        if (href.startsWith(baseURI)) {
            href = href.substring(baseURI.length());
        }
        href = JAXBLinksUtil.removeExtension(href);
        return href;
    }

    public static String removeExtension(String href) {
        if (href == null) {
            return null;
        }
        if (href.endsWith(".xml")) {
            href = href.substring(0, href.length() - ".xml".length());
        } else if (href.endsWith(".json")) {
            href = href.substring(0, href.length() - ".json".length());
        } else if (href.endsWith(".wml")) {
            href = href.substring(0, href.length() - ".wml".length());
        }
        return href;
    }

    public static String getDenormalizedLinkRef(Link link, String baseURI) {
        if (link.getHref() == null) {
            return null;
        }
        String href = link.getHref();
        if (!href.startsWith(baseURI)) {
            href = JAXBLinksUtil.createURL(baseURI, href, true);
        }
        return href;
    }

    public static String getStateIconURL(String datatebaseStateWFId) {
        String[] ids = LifecycleUtilities.getWorkflowAndStateId(datatebaseStateWFId);
        return JAXBLinksUtil.getStateIconURL(ids[0], ids[1]);
    }

    public static String getStateIconURL(String workflowIdentifier, String stateIdentifier) {
        if (workflowIdentifier != null && stateIdentifier != null && workflowIdentifier.length() > 0 && stateIdentifier.length() > 0) {
            if (workflowIdentifier.equals(LEGACY_WORKFLOW_ID)) {
                return LifecycleUtilities.getLegacyStateIcon(stateIdentifier);
            }
            return STATE_ICON_URL + RAMURLEncoder.encode(workflowIdentifier) + "/" + RAMURLEncoder.encode(stateIdentifier);
        }
        return "";
    }

    public static String getDatabaseStateWorkflowId(Link<State> stateLink) {
        String href;
        String dbId = "[no state]";
        if (stateLink != null && (href = stateLink.getHref()) != null && href.startsWith(STATE_URL)) {
            dbId = href.substring(STATE_URL.length());
            dbId = JAXBLinksUtil.removeExtension(dbId);
        }
        return dbId;
    }

    public static String getLegacyDatabaseStateWorkflowId(String stateName) {
        String id = "";
        if (stateName != null) {
            id = String.valueOf(LEGACY_WORKFLOW_ID) + "/" + RAMURLEncoder.encode(stateName);
        }
        return id;
    }

    public static String getOSLCv2ArtifactPathFromV1Path(String oslcV1ArtifactPath) {
        String assetsPrefix;
        String v2Path = oslcV1ArtifactPath;
        if (oslcV1ArtifactPath != null && oslcV1ArtifactPath.startsWith(assetsPrefix = "oslc/assets/")) {
            int versionEndSlashIndex;
            int guidEndSlashIndex = oslcV1ArtifactPath.indexOf("/", assetsPrefix.length() + 1);
            int n = versionEndSlashIndex = guidEndSlashIndex < 0 || guidEndSlashIndex >= oslcV1ArtifactPath.length() ? -1 : oslcV1ArtifactPath.indexOf("/", guidEndSlashIndex + 1);
            if (versionEndSlashIndex + 1 < oslcV1ArtifactPath.length() && oslcV1ArtifactPath.substring(versionEndSlashIndex + 1).startsWith("artifacts/")) {
                v2Path = String.valueOf(oslcV1ArtifactPath.substring(0, versionEndSlashIndex)) + "#" + oslcV1ArtifactPath.substring(versionEndSlashIndex + 1);
            }
        }
        return v2Path;
    }

    public static String getOSLCv1ArtifactPathFromV2Path(String oslcV2ArtifactPath) {
        String assetsPrefix;
        String v1Path = oslcV2ArtifactPath;
        if (oslcV2ArtifactPath != null && oslcV2ArtifactPath.startsWith(assetsPrefix = "oslc/assets")) {
            int versionSlashIndex;
            int guidSlashIndex = oslcV2ArtifactPath.indexOf("/", assetsPrefix.length() + 1);
            int n = versionSlashIndex = guidSlashIndex < 0 || guidSlashIndex >= oslcV2ArtifactPath.length() ? -1 : oslcV2ArtifactPath.indexOf("#", guidSlashIndex + 1);
            if (versionSlashIndex + 1 < oslcV2ArtifactPath.length() && oslcV2ArtifactPath.substring(versionSlashIndex + 1).startsWith("artifacts/")) {
                v1Path = String.valueOf(oslcV2ArtifactPath.substring(0, versionSlashIndex)) + "/" + oslcV2ArtifactPath.substring(versionSlashIndex + 1);
            }
        }
        return v1Path;
    }

    public static Link getAssetRatingLink(AssetIdentification assetId) {
        Link<Asset> assetLink = JAXBLinksUtil.getAssetLink(assetId);
        String hrf = String.valueOf(assetLink.getHref()) + "/" + "assetRating";
        return JAXBLinksUtil.getLink("AssetRating", hrf, null);
    }
}

