/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands.ucm;

import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;

public class RecommendBaselineCommand
extends OutputCleartoolCommand {
    private String baselineName;
    private String stream;

    public RecommendBaselineCommand(String stream, String baselineName) {
        this.stream = stream;
        this.baselineName = baselineName;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String outputStream, String errorStream) {
        boolean recommendStatus = false;
        if (outputStream != null && outputStream.length() > 0) {
            String[] lines = outputStream.split("\r\n");
            int i = 0;
            while (i < lines.length) {
                if (lines[i].startsWith("Changed stream")) {
                    recommendStatus = true;
                }
                ++i;
            }
        }
        final boolean recommendSuccess = recommendStatus;
        return new RecommendBaselineCommandOutput(){

            @Override
            public boolean recommendSuccess() {
                return recommendSuccess;
            }
        };
    }

    @Override
    protected String[] getArguments() {
        return new String[]{"chstream", "-nc", "-recommended", this.baselineName, this.stream};
    }

    public static interface RecommendBaselineCommandOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public boolean recommendSuccess();
    }
}

