/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.jaxb.util;

import com.ibm.ram.common.data.AssetIdentification;
import com.ibm.ram.common.emf.ArtifactDetail;
import com.ibm.ram.common.emf.Attribute;
import com.ibm.ram.common.emf.util.ArtifactAdapter;
import com.ibm.ram.common.util.AttributeConstants;
import com.ibm.ram.common.util.ManifestAccessor;
import com.ibm.ram.common.util.UtilitiesCommon;
import com.ibm.ram.defaultprofile.ClassificationSchema;
import com.ibm.ram.defaultprofile.Descriptor;
import com.ibm.ram.defaultprofile.NodeDescriptor;
import com.ibm.ram.defaultprofile.util.Utilities;
import com.ibm.ram.internal.jaxb.Artifact;
import com.ibm.ram.internal.jaxb.ArtifactReference;
import com.ibm.ram.internal.jaxb.ArtifactType;
import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.internal.jaxb.AssetAttribute;
import com.ibm.ram.internal.jaxb.AttributeType;
import com.ibm.ram.internal.jaxb.Category;
import com.ibm.ram.internal.jaxb.CategorySchema;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.util.ArtifactPropOptions;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import com.ibm.ram.internal.jaxb.util.JAXButil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class JAXBRichLinksUtil {
    protected static Logger LOGGER = Logger.getLogger(JAXBRichLinksUtil.class);

    public static List<Link<Artifact>> getArtifactLinks(com.ibm.ram.defaultprofile.Asset asset, ArtifactPropOptions artifactProps, String baseURL) {
        if (asset.getSolution() != null) {
            return JAXBRichLinksUtil.getArtifactLinks(asset, (List<com.ibm.ram.defaultprofile.Artifact>)asset.getSolution().getArtifact(), new ArrayList<Link<Artifact>>(), artifactProps, baseURL);
        }
        return Collections.EMPTY_LIST;
    }

    public static int getArtifactLastSlashIndex(String artifactPath) {
        int lastSlashIndex = artifactPath.lastIndexOf("/");
        if (lastSlashIndex > 1 && artifactPath.charAt(lastSlashIndex - 1) == '/' && artifactPath.charAt(lastSlashIndex - 2) == ':') {
            lastSlashIndex = artifactPath.lastIndexOf("/", lastSlashIndex - 2);
        }
        return lastSlashIndex;
    }

    private static List<Link<Artifact>> getArtifactLinks(com.ibm.ram.defaultprofile.Asset asset, List<com.ibm.ram.defaultprofile.Artifact> artifacts, List<Link<Artifact>> ret, ArtifactPropOptions artifactProps, String baseURL) {
        if (artifacts != null) {
            ArtifactAdapter adapter = ArtifactAdapter.getAdapter(asset);
            for (com.ibm.ram.defaultprofile.Artifact artifactSDO : artifacts) {
                String label;
                int lastSlashIndex;
                Artifact artifact = new Artifact();
                String pathIncludingName = artifactSDO.computePathInSolution("/");
                String path = pathIncludingName.substring(0, lastSlashIndex = JAXBRichLinksUtil.getArtifactLastSlashIndex(pathIncludingName));
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                artifact.setPath(path);
                artifact.setName(adapter.getFileName(artifactSDO));
                if (artifactProps.shouldLoadSubject() && !UtilitiesCommon.isEmptyString(label = ManifestAccessor.getArtifactLabel(artifactSDO))) {
                    artifact.setLabel(ManifestAccessor.getArtifactLabel(artifactSDO));
                }
                if (artifactProps.shouldLoadSubject()) {
                    artifact.setDescription(artifactSDO.getDescription() != null ? artifactSDO.getDescription().getValue() : null);
                }
                if ("folder".equals(artifactSDO.getType())) {
                    artifact.setType(ArtifactType.FOLDER);
                } else if ("url".equals(artifactSDO.getType())) {
                    artifact.setType(ArtifactType.URL);
                } else if ("url_cache".equals(artifactSDO.getType())) {
                    artifact.setType(ArtifactType.URL);
                } else {
                    ArtifactDetail artifactDetail;
                    artifact.setType(ArtifactType.FILE);
                    if (artifactProps.shouldLoadMimeType() && !UtilitiesCommon.isEmptyString(artifactSDO.getType())) {
                        artifact.setMimeType(artifactSDO.getType());
                    }
                    if ((artifactDetail = adapter.getArtifactDetail(artifactSDO)) != null) {
                        artifact.setLastModified(JAXButil.getXMLCalendar(new Date(artifactDetail.getLastModifiedDate().getTime())));
                        if (artifactProps.shouldLoadSize()) {
                            artifact.setSize(artifactDetail.getSize());
                        }
                        artifact.setChecksum(artifactDetail.getAdler32CRC());
                    } else {
                        LOGGER.debug((Object)("Artifact missing an ArtifactDetail: " + artifact.getName()));
                        if (asset.getDataAsDate() != null) {
                            artifact.setLastModified(JAXButil.getXMLCalendar(asset.getDataAsDate()));
                        } else {
                            artifact.setLastModified(JAXButil.getXMLCalendar(new Date()));
                        }
                        if (artifactProps.shouldLoadSize()) {
                            artifact.setSize(0L);
                        }
                    }
                    if (artifact.getLastModified() != null && artifact.getLastModified().toGregorianCalendar() != null) {
                        artifact.setEtag(String.valueOf(artifact.getLastModified().toGregorianCalendar().getTimeInMillis()));
                    }
                }
                if (artifactProps.shouldLoadReference() && artifactSDO.getReference() != null) {
                    ArtifactReference ref = new ArtifactReference();
                    if (artifactSDO.getReference().getDescription() != null) {
                        ref.setDescription(artifactSDO.getReference().getDescription().getValue());
                    }
                    if (artifactSDO.getReference().getReferenceKind() != null) {
                        ref.setKind(artifactSDO.getReference().getReferenceKind().getName());
                    }
                    ref.setValue(artifactSDO.getReference().getValue());
                    artifact.setReference(ref);
                }
                Link<Asset> assetRef = JAXBLinksUtil.getAssetLink(new AssetIdentification(asset.getId(), asset.getVersion()));
                Link<Artifact> artifactDetail = JAXBLinksUtil.getArtifactDetailLink(assetRef, artifact);
                artifact.setHref(artifactDetail.getHref());
                ret.add(artifactDetail);
                if (artifactSDO.getArtifact() == null || artifactSDO.getArtifact().isEmpty()) continue;
                JAXBRichLinksUtil.getArtifactLinks(asset, (List<com.ibm.ram.defaultprofile.Artifact>)artifactSDO.getArtifact(), ret, artifactProps, baseURL);
            }
        }
        return ret;
    }

    public static AssetAttribute getAttribute(Attribute attribute, ResourceSet rSet) {
        return JAXBRichLinksUtil.getAttribute(attribute, rSet, new AssetAttribute());
    }

    public static <T extends AssetAttribute> T getAttribute(Attribute attribute, ResourceSet rSet, T into) {
        into.setName(attribute.getName());
        into.setDescription(attribute.getDescription());
        String localizedURI = Utilities.getClassificationSchemaURIString(attribute.getUriString(), rSet);
        into.setIdentifier(localizedURI);
        AttributeConstants.Type type = attribute.getAttributeType();
        switch (type) {
            case bool: {
                into.setType(AttributeType.BOOLEAN);
                break;
            }
            case date: {
                into.setType(AttributeType.DATE);
                break;
            }
            case link: {
                into.setType(AttributeType.LINK);
                break;
            }
            case number: {
                into.setType(AttributeType.NUMBER);
                break;
            }
            case text: {
                into.setType(AttributeType.TEXT);
                break;
            }
            case user: {
                into.setType(AttributeType.USER);
                break;
            }
            case xml: {
                into.setType(AttributeType.XML);
                break;
            }
            case resource: {
                into.setType(AttributeType.RESOURCE);
                break;
            }
        }
        JAXBLinksUtil.getLink(into);
        return into;
    }

    public static CategorySchema getCategorySchema(ClassificationSchema cs, String baseURI) {
        CategorySchema schema = new CategorySchema();
        schema.setBase(baseURI);
        String id = JAXBRichLinksUtil.getURI(cs);
        if (id.endsWith("/")) {
            id = id.substring(0, id.length() - 1);
        }
        if (id.endsWith("#")) {
            id = id.substring(0, id.length() - 1);
        }
        schema.setIdentifier(id);
        schema.setName(cs.getName());
        schema.setSource(JAXBLinksUtil.getResourceRef(id, "XMI Source"));
        JAXBLinksUtil.getLink(schema);
        return schema;
    }

    public static Category getCategory(ClassificationSchema cs, String uri, String baseURI) {
        CategorySchema schema = new CategorySchema();
        schema.setBase(baseURI);
        String id = JAXBRichLinksUtil.getURI(cs);
        if (id.endsWith("/")) {
            id = id.substring(0, id.length() - 1);
        }
        if (id.endsWith("#")) {
            id = id.substring(0, id.length() - 1);
        }
        schema.setIdentifier(id);
        schema.setName(cs.getName());
        Link<CategorySchema> schemaRef = JAXBLinksUtil.getLink(schema);
        EList nodes = cs.getDescriptor();
        NodeDescriptor target = JAXBRichLinksUtil.findCategory(uri, (EList<Descriptor>)nodes);
        Category category = null;
        if (target != null) {
            category = new Category();
            category.setBase(baseURI);
            category.setCategorySchema(schemaRef);
            category.setName(target.getName());
            category.setIdentifier(JAXBRichLinksUtil.getURI(target));
            if (target.getName() != null && !target.eIsProxy()) {
                StringBuffer path = new StringBuffer(target.getName());
                NodeDescriptor node = target.getGeneral();
                while (node != null) {
                    path.insert(0, String.valueOf(node.getName()) + "/");
                    node = node.getGeneral();
                }
                path.insert(0, String.valueOf(schema.getName()) + "/");
                category.setDisplayPath(path.toString());
            }
        }
        schema.setSource(JAXBLinksUtil.getResourceRef(id, "XMI Source"));
        return category;
    }

    private static NodeDescriptor findCategory(String uri, EList<Descriptor> nodes) {
        NodeDescriptor target = null;
        if (nodes != null) {
            for (Descriptor descriptor : nodes) {
                if (!(descriptor instanceof NodeDescriptor)) continue;
                NodeDescriptor node = (NodeDescriptor)descriptor;
                if (uri.equals(JAXBRichLinksUtil.getURI(node))) {
                    target = node;
                    break;
                }
                if (node.getSpecific() != null && (target = JAXBRichLinksUtil.findCategory(uri, (EList<Descriptor>)node.getSpecific())) != null) break;
            }
        }
        return target;
    }

    private static String getURI(NodeDescriptor node) {
        String fragment = node.eResource().getURIFragment((EObject)node);
        String URI2 = null;
        if (node != null && node.eResource() != null && node.eResource().getURI() != null) {
            URI2 = String.valueOf(Utilities.getClassificationSchemaURIString(node.eResource().getURI().toString(), (EObject)node)) + "#" + fragment;
        }
        return URI2;
    }

    private static String getURI(ClassificationSchema cs) {
        if (cs != null && cs.eResource() != null && cs.eResource().getURI() != null) {
            return Utilities.getClassificationSchemaURIString(cs.eResource().getURI().toString(), (EObject)cs);
        }
        return null;
    }
}

