/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.AssetFeedback;
import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;

public class RAMAssetFeedback
extends AssetFeedback {
    private RAMAsset fAsset;
    private RAMUser fUser;
    private AssetFeedback fAssetFeedback;
    private boolean fDirty = false;
    private boolean fDelete = false;

    RAMAssetFeedback(RAMAsset asset, AssetFeedback feedback) throws RAMRuntimeException {
        this.fAsset = asset;
        this.fAssetFeedback = feedback;
    }

    RAMAssetFeedback(RAMAsset asset) throws RAMRuntimeException {
        this.fAsset = asset;
        this.fAssetFeedback = new AssetFeedback();
        this.fDirty = true;
    }

    @Override
    public String getComment() {
        return this.fAssetFeedback.getComment();
    }

    AssetFeedback getInternalFeedback() {
        return this.fAssetFeedback;
    }

    @Override
    public long getId() {
        return this.fAssetFeedback.getId();
    }

    @Override
    public int getRating() {
        return this.fAssetFeedback.getRating();
    }

    @Override
    public long getTimestamp() {
        return this.fAssetFeedback.getTimestamp();
    }

    @Override
    public UserInformation getUser() {
        if (this.fUser == null) {
            this.fUser = this.fAsset.getSession().fetchUser(this.fAssetFeedback.getUser());
        }
        return this.fUser;
    }

    @Override
    public boolean isAnonymous() {
        return this.fAssetFeedback.isAnonymous();
    }

    public AssetInformation getAsset() {
        return this.fAsset;
    }

    @Override
    public void setAnonymous(boolean anonymous) {
        if (anonymous != this.fAssetFeedback.isAnonymous()) {
            this.fAssetFeedback.setAnonymous(anonymous);
            this.fDirty = true;
        }
    }

    @Override
    public void setComment(String comment) {
        if (comment != null && !comment.equals(this.fAssetFeedback.getComment())) {
            this.fAssetFeedback.setComment(comment);
            this.fDirty = true;
        }
    }

    @Override
    public void setId(long id) {
        throw new RAMRuntimeException("The ID can only be set by the server");
    }

    @Override
    public void setRating(int rating) {
        if (rating != this.fAssetFeedback.getRating()) {
            if (rating < 0) {
                throw new RAMRuntimeException("Rating cannot be less than zero");
            }
            if (rating > 5) {
                throw new RAMRuntimeException("Rating cannot be greater than 5");
            }
            this.fAssetFeedback.setRating(rating);
            this.fDirty = true;
        }
    }

    @Override
    public void setTimestamp(long timestamp) {
        if (timestamp != this.fAssetFeedback.getTimestamp()) {
            this.fAssetFeedback.setTimestamp(timestamp);
            this.fDirty = true;
        }
    }

    @Override
    public void setUser(UserInformation user) {
        if (user != null && (this.fAssetFeedback.getUser() == null || user.getUid() == this.fAssetFeedback.getUser().getUid())) {
            this.fAssetFeedback.setUser(user);
            this.fDirty = true;
        }
    }

    boolean isDirty() {
        return this.fDirty;
    }

    void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    void setDelete(boolean delete) {
        this.fDelete = delete;
    }

    boolean isDelete() {
        return this.fDelete;
    }
}

