/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AttributeConstants {
    public static final String USERGROUP_SUFFIX = "~ug";
    public static final String BOOLEAN = Type.bool.toString();
    public static final String DATE = Type.date.toString();
    public static final String LINK = Type.link.toString();
    public static final String NUMBER = Type.number.toString();
    public static final String TEXT = Type.text.toString();
    public static final String USER = Type.user.toString();
    public static final String XML = Type.xml.toString();
    public static final String RESOURCE = Type.resource.toString();
    public static final String DEFECT_FACTORY = Type.defectFactory.toString();
    public static final String SELF_DEFINED = Type.selfDefined.toString();
    public static final String GADGET = Type.gadget.toString();
    public static final String DEFAULT_VALUE = "default value";
    public static final String PATTERN = "pattern";
    public static final String PATTERN_ERROR_MESSAGE = "pattern error message";
    public static final String LINK_LABEL = "link label";
    public static final String MINIMUM_DATE = "minimum date";
    public static final String MAXIMUM_DATE = "maximum date";
    public static final String MINIMUM_NUMBER = "minimum number";
    public static final String MAXIMUM_NUMBER = "maximum number";
    public static final String MULTI_SELECT = "multi";
    public static final String SINGLE_SELECT = "single";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public static Date getDate(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            try {
                return DATE_FORMAT.parse(s);
            }
            catch (ParseException parseException) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        return null;
    }

    public static enum Type {
        text,
        bool,
        date,
        link,
        number,
        user,
        xml,
        resource,
        defectFactory,
        selfDefined,
        gadget;

    }
}

