/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.util.UtilitiesCommon;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WeakValueConcurrentHashMap<K, V> {
    private ConcurrentMap<K, WeakValue<K, V>> map = new ConcurrentHashMap<K, WeakValue<K, V>>();
    private ReferenceQueue<V> queue = new ReferenceQueue();

    public ConcurrentMap<K, ? extends WeakReference<V>> getMap() {
        this.expungeStaleEntries();
        return this.map;
    }

    private V getWeakValue(WeakValue<K, V> wv) {
        return wv != null ? (V)wv.get() : null;
    }

    public boolean containsKey(Object key) {
        this.expungeStaleEntries();
        return this.map.containsKey(key);
    }

    public V get(Object key) {
        this.expungeStaleEntries();
        return this.getWeakValue((WeakValue)this.map.get(key));
    }

    public V put(K key, V value) {
        this.expungeStaleEntries();
        return this.getWeakValue(this.map.put(key, new WeakValue<K, V>(key, value, this.queue)));
    }

    public V putIfAbsent(K key, V value) {
        this.expungeStaleEntries();
        return this.getWeakValue(this.map.putIfAbsent(key, new WeakValue<K, V>(key, value, this.queue)));
    }

    public V remove(Object key) {
        this.expungeStaleEntries();
        return this.getWeakValue((WeakValue)this.map.remove(key));
    }

    public boolean remove(Object key, Object value) {
        return this.map.remove(key, new TestEntry<Object>(value));
    }

    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.map.isEmpty();
    }

    public int size() {
        this.expungeStaleEntries();
        return this.map.size();
    }

    private void expungeStaleEntries() {
        WeakValue e;
        while ((e = (WeakValue)this.queue.poll()) != null) {
            this.map.remove(e.getKey(), e);
        }
    }

    private static class TestEntry<WV> {
        private WV wv;

        public TestEntry(WV wv) {
            this.wv = wv;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof WeakValue) {
                return UtilitiesCommon.objectsEqual(this.wv, ((WeakValue)obj).get());
            }
            return false;
        }
    }

    private static class WeakValue<KK, WV>
    extends WeakReference<WV> {
        private KK key;

        public WeakValue(KK key, WV referent, ReferenceQueue<? super WV> q) {
            super(referent, q);
            this.key = key;
        }

        KK getKey() {
            return this.key;
        }

        public WeakValue(WV referent) {
            super(referent);
        }

        public int hashCode() {
            Object v = this.get();
            return v != null ? v.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof TestEntry) {
                return UtilitiesCommon.objectsEqual(this.get(), ((TestEntry)obj).wv);
            }
            return false;
        }
    }
}

