/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializationVisitor;
import com.google.gson.JsonSerializer;
import com.google.gson.MemoryRefStack;
import com.google.gson.ObjectNavigator;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ObjectTypePair;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.lang.reflect.Type;

final class JsonSerializationContextDefault
implements JsonSerializationContext {
    private final ObjectNavigatorFactory factory;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final boolean serializeNulls;
    private final NamespacePrefixMapper prefixMapper;
    private final MemoryRefStack ancestors;

    JsonSerializationContextDefault(ObjectNavigatorFactory factory, boolean serializeNulls, NamespacePrefixMapper prefixMapper, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers) {
        this.factory = factory;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
        this.prefixMapper = prefixMapper;
        this.ancestors = new MemoryRefStack();
    }

    @Override
    public JsonElement serialize(Object src) {
        if (src == null) {
            return JsonNull.createJsonNull();
        }
        return this.serialize(src, src.getClass(), true);
    }

    @Override
    public JsonElement serialize(Object src, Type typeOfSrc) {
        return this.serialize(src, typeOfSrc, true);
    }

    public JsonElement serialize(Object src, Type typeOfSrc, boolean preserveType) {
        ObjectNavigator on = this.factory.create(new ObjectTypePair(src, typeOfSrc, preserveType));
        JsonSerializationVisitor visitor = new JsonSerializationVisitor(this.factory, this.serializeNulls, this.serializers, this, this.ancestors);
        on.accept(visitor);
        return visitor.getJsonElement();
    }

    public boolean isSerializeNulls() {
        return this.serializeNulls;
    }

    @Override
    public NamespacePrefixMapper getPrefixMapper() {
        return this.prefixMapper;
    }
}

