/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.common.data.exception.RAMRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class RAMClientProperties {
    private static Logger logger = Logger.getLogger((String)RAMClientProperties.class.getName());
    public static String REST_CACHE_TEMP_DELET_KEY = "com.ibm.ram.client.rest.temp.delete";
    public static String REST_CACHE_FOLDER_PROPERTY_KEY = "com.ibm.ram.client.rest.cacheFolder";
    public static String REQUEST_BASE_PATH_KEY_API = "com.ibm.ram.api.requestBase";
    private static Properties properties = new Properties();
    private static RAMClientPropertiesManager proMgr = new RAMClientPropertiesManager();
    private static Map<String, Set> prosRegisteredMap = new HashMap<String, Set>();

    public static void load(File proFile) {
        if (!proFile.exists()) {
            throw new RAMRuntimeException("Properties file path: " + proFile.getAbsolutePath() + " does not exist.");
        }
        if (!proFile.canRead()) {
            throw new RAMRuntimeException("Properties file path: " + proFile.getAbsolutePath() + " is not allowed for reading.");
        }
        Properties temp = null;
        try {
            temp = properties;
            properties = new Properties();
            properties.load(new FileInputStream(proFile));
        }
        catch (IOException e) {
            properties = temp;
            logger.warn((Object)"IOException while loading properties file.", (Throwable)e);
        }
    }

    public static void serialize2PropertyFile(String propertyFilePath) throws RAMRuntimeException {
        if (propertyFilePath == null) {
            throw new RAMRuntimeException("Property file path could not be null.");
        }
        File proFile = new File(propertyFilePath);
        try {
            if (proFile.exists()) {
                logger.warn((Object)("Detect a existing file in path: " + propertyFilePath + ". Contents in existing file will be override."));
            } else if (!proFile.createNewFile()) {
                throw new RAMRuntimeException("Could create property file under path: " + propertyFilePath);
            }
            if (!proFile.canWrite()) {
                throw new RAMRuntimeException("Properties file path: " + propertyFilePath + " is not allowed for writing.");
            }
            if (!properties.isEmpty()) {
                properties.store(new FileOutputStream(proFile), "properties file created at: " + new Date().toString());
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Properties file does not exist in: " + propertyFilePath), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("IOException during serialising properties into properties file: " + propertyFilePath), (Throwable)e);
        }
    }

    public static String getProperty(String propertyName) {
        String v = properties.getProperty(propertyName);
        if (v == null) {
            v = System.getProperty(propertyName);
        }
        return v;
    }

    public static void setProperty(String propertyName, String value) {
        Object old = properties.setProperty(propertyName, value);
        if (old != value) {
            proMgr.notifyObservers(propertyName, value);
        }
    }

    public static void subscribe(Observer observer, String[] pros) {
        proMgr.registerForProperties(observer, pros);
    }

    public static void unsubscribe(Observer observer, String[] pros) {
        proMgr.unregisterForProperties(observer, pros);
    }

    static class RAMClientPropertiesManager
    extends Observable {
        RAMClientPropertiesManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerForProperties(Observer observer, String[] properties) {
            if (properties.length > 0) {
                String[] stringArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    String pro = stringArray[n2];
                    Map map = prosRegisteredMap;
                    synchronized (map) {
                        if (prosRegisteredMap.containsKey(pro)) {
                            ((Set)prosRegisteredMap.get(pro)).add(observer);
                        } else {
                            HashSet<Observer> observerSet = new HashSet<Observer>();
                            observerSet.add(observer);
                            prosRegisteredMap.put(pro, observerSet);
                        }
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterForProperties(Observer observer, String[] properties) {
            if (properties.length > 0) {
                String[] stringArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    String pro = stringArray[n2];
                    Map map = prosRegisteredMap;
                    synchronized (map) {
                        if (prosRegisteredMap.containsKey(pro)) {
                            ((Set)prosRegisteredMap.get(pro)).remove(observer);
                        }
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyObservers(String pro, Object data) {
            Map map = prosRegisteredMap;
            synchronized (map) {
                Set observerSet = (Set)prosRegisteredMap.get(pro);
                if (observerSet != null) {
                    Iterator itr = observerSet.iterator();
                    while (itr.hasNext()) {
                        ((Observer)itr.next()).update(this, data);
                    }
                }
            }
        }

        @Override
        public void addObserver(Observer observer) {
            throw new RAMRuntimeException("Method is not implemented. Refer to {@link RAMClientProeprtiesManager#registerForProperties(Observer observer, String[] properties)}");
        }

        @Override
        public synchronized void deleteObserver(Observer observer) {
            throw new RAMRuntimeException("Method is not implemented. Refer to {@link RAMClientProeprtiesManager#unregisterForProperties(Observer observer, String[] properties)}");
        }
    }
}

