/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.IRAMSessionObject;
import com.ibm.ram.client.RAMAction;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.RelationshipType;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;

public class RAMRelationshipType
extends RelationshipType
implements IRAMSessionObject {
    private static String RELATIONSHIP_TYPE_HASH_KEY = "RELATIONSHIP_TYPE:";
    private String fOriginalName;
    private RelationshipType fAssetRelationType;
    private RelationshipType fReverseType;
    private RAMSession fSession;
    private boolean fDirty = false;
    private RAMAction fAction;

    RAMRelationshipType(RAMSession session, RelationshipType webServiceAssetRelationType) {
        this.fSession = session;
        this.fAssetRelationType = webServiceAssetRelationType;
        this.fOriginalName = webServiceAssetRelationType.getName();
        this.fAction = RAMAction.CREATE;
    }

    RAMRelationshipType(RAMSession session, String name, String reverseName, boolean preferredEnd) {
        this.fSession = session;
        this.fAssetRelationType = new RelationshipType();
        this.fAssetRelationType.setName(name);
        this.fAssetRelationType.setDisplayName(name);
        this.fAssetRelationType.setPreferredEnd(preferredEnd);
        this.fAssetRelationType.setReverseName(reverseName);
        this.fAction = RAMAction.CREATE;
        this.setDirty(preferredEnd);
    }

    @Override
    public String getDisplayName() throws RAMRuntimeException {
        return this.fAssetRelationType.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMRelationshipType.not_updateable"), true);
    }

    @Override
    public String getName() throws RAMRuntimeException {
        return this.fAssetRelationType.getName();
    }

    @Override
    public void setName(String name) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMRelationshipType.not_updateable"), true);
    }

    RelationshipType getInternalAssetRelationType() throws RAMRuntimeException {
        return this.fAssetRelationType;
    }

    public String toString() {
        if (this.fAssetRelationType == null || this.fAssetRelationType.getDisplayName() == null && this.fAssetRelationType.getName() == null) {
            return super.toString();
        }
        if (this.fAssetRelationType.getDisplayName() != null) {
            return this.fAssetRelationType.getDisplayName();
        }
        return this.fAssetRelationType.getName();
    }

    public RelationshipType getReverseType() {
        if (this.fReverseType == null) {
            String reverseName = this.getReverseName();
            this.fReverseType = this.fSession.getRelationshipType(reverseName);
        }
        return this.fReverseType;
    }

    public RAMSession getSession() {
        return this.fSession;
    }

    @Override
    public String getReverseName() {
        String name = null;
        name = this.fReverseType != null ? this.fReverseType.getName() : this.fAssetRelationType.getReverseName();
        return name;
    }

    void setDirty(boolean dirtyFlag) {
        this.fDirty = dirtyFlag;
        if (dirtyFlag) {
            this.getSession().cache(this);
        } else {
            this.getSession().uncache(this);
        }
    }

    @Override
    public boolean isDirty() {
        return this.fDirty;
    }

    String getSessionKey() {
        return String.valueOf(RELATIONSHIP_TYPE_HASH_KEY) + this.getName();
    }

    void relationshipTypeCommited() throws RAMRuntimeException {
        this.fOriginalName = this.getName();
        this.fAction = RAMAction.CREATE;
        this.setDirty(false);
    }

    String getOriginalName() {
        return this.fOriginalName;
    }

    @Override
    public boolean isPreferredEnd() {
        return this.fAssetRelationType.isPreferredEnd();
    }

    @Override
    public void setPreferredEnd(boolean preferredEnd) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMRelationshipType.not_updateable"), true);
    }

    @Override
    public void setReverseName(String reverseName) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMRelationshipType.not_updateable"), true);
    }

    @Override
    public RAMAction getAction() {
        return this.fAction;
    }

    public void setAction(RAMAction action) {
        if (action != RAMAction.CREATE && action != RAMAction.DELETE) {
            String message = MessageFormat.format(ClientMessages.getString("ACTION_NOT_ACCEPTABLE"), action.getName(), this.getClass().getName());
            throw new RAMRuntimeException(message, true);
        }
        this.fAction = action;
        if (action == RAMAction.DELETE) {
            this.setDirty(true);
        }
    }
}

