/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAssetSearchResult;
import com.ibm.ram.client.RAMSearchFilter;
import com.ibm.ram.client.RAMSession;
import com.ibm.ram.common.data.AssetInformation;
import com.ibm.ram.common.data.AssetSearchResult;
import com.ibm.ram.common.data.SearchFilter;
import com.ibm.ram.common.data.SearchResult;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.common.data.SearchAssetInformationSO;
import com.ibm.ram.internal.common.data.SearchResultSO;

public class RAMSearchResult
extends SearchResult {
    private RAMSession fSession;
    private SearchResultSO fSearchResult;

    RAMSearchResult(RAMSession session, SearchResultSO webServiceSearchResult) {
        this.fSession = session;
        this.fSearchResult = webServiceSearchResult;
    }

    @Override
    public AssetInformation[] getAssets() {
        if (super.getAssets() == null) {
            this.initialize();
        }
        return super.getAssets();
    }

    private void initialize() throws RAMRuntimeException {
        AssetSearchResult[] assetSearchResults = this.fSearchResult.getAssetSearchResults();
        SearchAssetInformationSO[] assetInfos = this.fSearchResult.getSearchAssets();
        AssetInformation[] ramAssets = null;
        AssetSearchResult[] results = null;
        if (assetSearchResults != null) {
            ramAssets = new RAMAsset[assetSearchResults.length];
            results = new RAMAssetSearchResult[assetSearchResults.length];
            int i = 0;
            while (i < assetSearchResults.length) {
                ramAssets[i] = this.fSession.getAssetFromLocalCache(assetSearchResults[i].getAsset());
                results[i] = new RAMAssetSearchResult((RAMAsset)ramAssets[i], assetSearchResults[i]);
                ++i;
            }
        } else if (assetInfos != null) {
            ramAssets = new RAMAsset[assetInfos.length];
            results = new RAMAssetSearchResult[assetInfos.length];
            int i = 0;
            while (i < assetInfos.length) {
                AssetSearchResult resultEntry = new AssetSearchResult();
                resultEntry.setAsset(assetInfos[i]);
                resultEntry.setRelevance(assetInfos[i].getRelevance());
                ramAssets[i] = this.fSession.getAssetFromLocalCache(assetInfos[i]);
                results[i] = new RAMAssetSearchResult((RAMAsset)ramAssets[i], resultEntry);
                ++i;
            }
        }
        super.setAssets(ramAssets);
        super.setAssetSearchResults(results);
    }

    @Override
    public int getTotalResultsCount() {
        return this.fSearchResult.getTotalResultsCount();
    }

    @Override
    public AssetSearchResult[] getAssetSearchResults() {
        if (super.getAssetSearchResults() == null) {
            this.initialize();
        }
        return super.getAssetSearchResults();
    }

    @Override
    public SearchFilter[] getFacets() {
        if (super.getFacets() == null) {
            if (this.fSearchResult.getFacets() == null) {
                super.setFacets(new RAMSearchFilter[0]);
            } else {
                SearchFilter[] rawFilters = this.fSearchResult.getFacets();
                SearchFilter[] filters = new RAMSearchFilter[rawFilters.length];
                int i = 0;
                while (i < rawFilters.length) {
                    filters[i] = new RAMSearchFilter(rawFilters[i]);
                    ++i;
                }
                super.setFacets(filters);
            }
        }
        return super.getFacets();
    }

    @Override
    public int getIndex() {
        return this.fSearchResult.getIndex();
    }

    @Override
    public SearchFilter getTags() {
        if (super.getTags() == null) {
            super.setTags(new RAMSearchFilter(this.fSearchResult.getTags()));
        }
        return super.getTags();
    }

    @Override
    public void setAssets(AssetInformation[] assets) {
        throw new RAMRuntimeException("Search result assets are not settable by the client");
    }

    @Override
    public void setAssetSearchResults(AssetSearchResult[] assetSearchResults) {
        throw new RAMRuntimeException("Search result assets are not settable by the client");
    }

    @Override
    public void setFacets(SearchFilter[] facets) {
        throw new RAMRuntimeException("Search facets are not settable by the client");
    }

    @Override
    public void setIndex(int index) {
        throw new RAMRuntimeException("Search index is not settable by the client");
    }

    @Override
    public void setTags(SearchFilter tags) {
        throw new RAMRuntimeException("Search tags are not settable by the client");
    }

    @Override
    public void setTotalResultsCount(int totalResultsCount) {
        throw new RAMRuntimeException("Search count is not settable by the client");
    }
}

