/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMComment;
import com.ibm.ram.client.RAMVote;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.AbstractRESTClient;
import com.ibm.ram.internal.jaxb.Asset;
import com.ibm.ram.internal.jaxb.Comment;
import com.ibm.ram.internal.jaxb.Link;
import com.ibm.ram.internal.jaxb.StateHistory;
import com.ibm.ram.internal.jaxb.Vote;
import com.ibm.ram.internal.jaxb.util.FeedIterator;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import java.util.List;

public class RAMStateHistory {
    private RAMAsset fAsset;
    private StateHistory fStateHistory;
    private RAMComment[] fComments;
    private RAMVote[] fVotes;

    RAMStateHistory(RAMAsset asset, StateHistory jaxbStateHistory) {
        this.fAsset = asset;
        this.fStateHistory = jaxbStateHistory;
    }

    public void castVote(RAMVote vote) throws RAMRuntimeException {
        try {
            StateHistory history;
            AbstractRESTClient client = this.fAsset.getSession().getRESTClient();
            Link<Asset> restAssetRef = this.fAsset.getRestAssetRef();
            String stateHistroyId = this.fStateHistory.getIdentifier();
            Vote internalVote = vote.getInternalVote();
            if (vote.getComment() != null) {
                Link<StateHistory> stateHistoryRef = JAXBLinksUtil.getStateHistoryLink(restAssetRef, stateHistroyId);
                Link<Comment> commentRef = internalVote.getComment();
                Comment iCom = client.postComment(stateHistoryRef, commentRef.getValue());
                internalVote.setComment(JAXBLinksUtil.getLink(stateHistoryRef, iCom));
            }
            client.putVote(restAssetRef, stateHistroyId, internalVote);
            this.fStateHistory = history = client.getStateHistory(restAssetRef, this.fStateHistory.getIdentifier()).getValue();
            this.fVotes = null;
            this.fComments = null;
        }
        catch (Exception e) {
            throw new RAMRuntimeException("Failed to cast vote on state history : " + this.fStateHistory, e);
        }
    }

    public void comment(RAMComment comment) {
        try {
            AbstractRESTClient client = this.fAsset.getSession().getRESTClient();
            Link<Asset> restAssetRef = this.fAsset.getRestAssetRef();
            String stateHistroyId = this.fStateHistory.getIdentifier();
            Link<StateHistory> stateHistoryRef = JAXBLinksUtil.getStateHistoryLink(restAssetRef, stateHistroyId);
            Comment iCom = client.postComment(stateHistoryRef, comment.getInternalComment());
            comment.setInternalComment(iCom);
            this.fComments = null;
        }
        catch (Exception e) {
            throw new RAMRuntimeException("Failed to cast vote on state history : " + this.fStateHistory, e);
        }
    }

    public RAMComment[] getComments() {
        if (this.fComments == null) {
            try {
                AbstractRESTClient client = this.fAsset.getSession().getRESTClient();
                Link<Asset> restAssetRef = this.fAsset.getRestAssetRef();
                String stateHistroyId = this.fStateHistory.getIdentifier();
                Link<StateHistory> stateHistoryRef = JAXBLinksUtil.getStateHistoryLink(restAssetRef, stateHistroyId);
                FeedIterator<Comment> comments = client.getComments(stateHistoryRef);
                RAMComment[] tmpComments = new RAMComment[comments.getSize()];
                int i = 0;
                for (Comment comment : comments) {
                    tmpComments[i++] = new RAMComment(this, comment);
                }
                this.fComments = tmpComments;
            }
            catch (Exception exception) {
                throw new RAMRuntimeException("Failed to cast vote on state history : " + this.fStateHistory);
            }
        }
        return this.fComments;
    }

    public RAMVote[] getVotes() {
        if (this.fVotes == null) {
            try {
                List<Vote> votes = this.fStateHistory.getVotes();
                RAMVote[] tmpVotes = new RAMVote[votes.size()];
                int i = 0;
                for (Vote vote : votes) {
                    tmpVotes[i++] = new RAMVote(this, vote);
                }
                this.fVotes = tmpVotes;
            }
            catch (Exception exception) {
                throw new RAMRuntimeException("Failed to cast vote on state history : " + this.fStateHistory);
            }
        }
        return this.fVotes;
    }

    public RAMAsset getAsset() {
        return this.fAsset;
    }

    StateHistory getInternalStateHistory() {
        return this.fStateHistory;
    }
}

