/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client;

import com.ibm.ram.client.RAMAsset;
import com.ibm.ram.client.RAMAttachment;
import com.ibm.ram.client.RAMForum;
import com.ibm.ram.client.RAMPost;
import com.ibm.ram.client.RAMUser;
import com.ibm.ram.common.data.Attachment;
import com.ibm.ram.common.data.Post;
import com.ibm.ram.common.data.Topic;
import com.ibm.ram.common.data.UserInformation;
import com.ibm.ram.common.data.exception.RAMRuntimeException;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RAMTopic
extends Topic {
    private static final Logger logger = Logger.getLogger((String)RAMForum.class.getName());
    private RAMForum fForum;
    private RAMAttachment fAttachment;
    private RAMPost[] fPosts;
    private Topic fTopic;
    private boolean fUpdate = false;
    private boolean fDirty = false;
    private boolean fDelete = false;
    private RAMUser fSubmitter;
    private RAMAsset fAsset;

    RAMTopic(RAMForum forum, Topic topic) {
        this.fAsset = forum.getAsset();
        this.fTopic = topic;
        this.fForum = forum;
        this.fTopic = topic;
        this.fUpdate = true;
    }

    RAMTopic(RAMForum forum, RAMUser submitter, String title, String description) {
        this.fAsset = forum.getAsset();
        this.fTopic = new Topic();
        this.fForum = forum;
        this.fTopic.setId(-1);
        this.fTopic.setForumID(this.fForum.getId());
        this.fTopic.setTitle(title != null ? title : "");
        this.fTopic.setDescription(description != null ? description : "");
        this.setSubmitter(submitter);
        this.fUpdate = false;
        this.fDirty = true;
    }

    boolean isUpdate() {
        return this.fUpdate;
    }

    boolean isDelete() {
        return this.fDelete;
    }

    boolean isDirty() {
        return this.fDirty;
    }

    void updateTopic(Topic topic, IProgressMonitor monitor) {
        if (!this.fDirty) {
            monitor.beginTask(ClientMessages.getString("RAMTopic.0"), 1);
            this.fPosts = null;
            this.fSubmitter = null;
            this.fTopic = topic;
            monitor.worked(1);
        } else {
            RAMPost[] posts = (RAMPost[])this.getPosts();
            monitor.beginTask(ClientMessages.getString("RAMTopic.1"), posts.length * 10 + 1);
            this.fSubmitter = null;
            this.fTopic.setDescription(topic.getDescription());
            this.fTopic.setId(topic.getId());
            this.fTopic.setLastUpdatedDate(topic.getLastUpdatedDate());
            this.fTopic.setState(topic.getState());
            this.fTopic.setTitle(topic.getTitle());
            monitor.worked(1);
            int i = 0;
            while (!monitor.isCanceled() && i < posts.length) {
                if (!posts[i].isUpdate() && posts[i].isDirty()) {
                    try {
                        String message = MessageFormat.format(ClientMessages.getString("RAMTopic.CREATE_NEW_POST"), this.getAsset().getName(), this.getTitle());
                        monitor.subTask(message);
                        Post newPost = this.getAsset().getSession().getRAMClient().getRAM1Webservice().createDiscussionPost(posts[i].getTitle(), posts[i].getDescription(), this.getId(), (int)posts[i].getReplyToPostID(), posts[i].getSubmitter().getUid(), posts[i].getSubmissionDate());
                        monitor.worked(8);
                        if (!monitor.isCanceled()) {
                            posts[i].updatePost(newPost, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        }
                    }
                    catch (Exception e) {
                        String message = MessageFormat.format(ClientMessages.getString("RAMTopic.FAILED_TO_CREATE_POST"), posts[i]);
                        logger.error((Object)message, (Throwable)e);
                    }
                } else {
                    monitor.worked(10);
                }
                ++i;
            }
        }
        this.fDirty = false;
        this.fUpdate = true;
    }

    public RAMPost createPost(String title, String description) {
        RAMPost ret = new RAMPost(this, this.getAsset().getSession().getUser(), title, description);
        RAMPost[] posts = (RAMPost[])this.getPosts();
        RAMPost[] newPosts = new RAMPost[posts.length + 1];
        System.arraycopy(posts, 0, newPosts, 0, posts.length);
        newPosts[posts.length] = ret;
        this.fPosts = newPosts;
        this.setDirty(true);
        return ret;
    }

    void setDirty(boolean dirty) {
        this.fDirty = dirty;
        if (dirty) {
            this.getForum().setDirty(true);
        }
    }

    @Override
    public Attachment getAttachment() {
        if (this.fAttachment == null && this.fTopic.getAttachment() != null) {
            this.fAttachment = new RAMAttachment(this, this.fTopic.getAttachment());
        }
        return this.fAttachment;
    }

    @Override
    public int getForumID() {
        return this.fTopic.getForumID();
    }

    @Override
    public int getId() {
        return this.fTopic.getId();
    }

    @Override
    public Post[] getPosts() {
        if (this.fPosts == null) {
            if (this.fTopic.getPosts() == null) {
                this.fPosts = new RAMPost[0];
            } else {
                Post[] wsPosts = this.fTopic.getPosts();
                RAMPost[] posts = new RAMPost[wsPosts.length];
                int i = 0;
                while (i < wsPosts.length) {
                    posts[i] = new RAMPost(this, wsPosts[i]);
                    ++i;
                }
                this.fPosts = posts;
            }
        }
        return this.fPosts;
    }

    public RAMForum getForum() {
        return this.fForum;
    }

    @Override
    public String getDescription() {
        return this.fTopic.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.fTopic.setDescription(description);
    }

    @Override
    public long getLastUpdatedDate() {
        return this.fTopic.getLastUpdatedDate();
    }

    @Override
    public String getState() {
        return this.fTopic.getState();
    }

    @Override
    public long getSubmissionDate() {
        return this.fTopic.getSubmissionDate();
    }

    @Override
    public UserInformation getSubmitter() {
        if (this.fSubmitter == null) {
            RAMUser newUser;
            this.fSubmitter = newUser = this.getAsset().getSession().fetchUser(this.fTopic.getSubmitter());
        }
        return this.fSubmitter;
    }

    @Override
    public String getTitle() {
        return this.fTopic.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.fTopic.setTitle(title);
    }

    public RAMAsset getAsset() {
        return this.fAsset;
    }

    @Override
    public void setAttachment(Attachment attachment) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMTopic.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setForumID(int forumID) {
        this.fTopic.setForumID(forumID);
    }

    @Override
    public void setId(int id) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMTopic.TOPIC_ID_IS_ONLY_SET_BT_SERVER"), true);
    }

    @Override
    public void setPosts(Post[] posts) {
        throw new RAMRuntimeException(ClientMessages.getString("RAMTopic.METHOD_NOT_IMPLEMENTED"), true);
    }

    @Override
    public void setLastUpdatedDate(long lastUpdatedDate) {
        this.fTopic.setLastUpdatedDate(lastUpdatedDate);
    }

    @Override
    public void setState(String state) {
        this.fTopic.setState(state);
    }

    @Override
    public void setSubmissionDate(long submissionDate) {
        this.fTopic.setSubmissionDate(submissionDate);
    }

    @Override
    public void setSubmitter(UserInformation submitter) {
        if (submitter instanceof RAMUser) {
            RAMUser ramUser = (RAMUser)submitter;
            this.fTopic.setSubmitter(ramUser.getInternalUser());
            this.fSubmitter = ramUser;
        } else {
            this.fTopic.setSubmitter(submitter);
            this.fSubmitter = null;
        }
    }

    public String toString() {
        if (this.fTopic == null && this.fTopic.getTitle() == null) {
            return super.toString();
        }
        return this.getForum() + "/" + this.getTitle();
    }
}

