/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.client.status;

import com.ibm.ram.client.status.RAMStatusCodes;
import com.ibm.ram.internal.client.bundles.ClientMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RAMStatus
extends Status
implements RAMStatusCodes {
    private Object fTargetObject;
    private List fChildren;
    private boolean fIsMulti;
    private static final String PLUGIN_ID = "com.ibm.ram.client";
    private int fOKCount;
    private int fInfoCount;
    private int fWarnCount;
    private int fErrorCount;

    private RAMStatus(Object tagetObject, int severity, int code, String message, Throwable exception) {
        super(severity, PLUGIN_ID, code, message != null ? message : "", exception);
        this.fIsMulti = false;
        this.fTargetObject = tagetObject;
    }

    public RAMStatus() {
        super(0, PLUGIN_ID, 1, "", null);
        this.fIsMulti = true;
        this.fChildren = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendStatus(Object targetObject, int severity, int code, String message, Throwable exception) {
        RAMStatus status = new RAMStatus(targetObject, severity, code, message, exception);
        switch (severity) {
            case 4: {
                ++this.fErrorCount;
                break;
            }
            case 2: {
                ++this.fWarnCount;
                break;
            }
            case 1: {
                ++this.fInfoCount;
                break;
            }
            case 0: {
                ++this.fOKCount;
            }
        }
        if (this.getSeverity() < severity) {
            this.setSeverity(severity);
        }
        List list = this.fChildren;
        synchronized (list) {
            this.fChildren.add(status);
        }
    }

    void setInternalSeverity(int severity) {
        super.setSeverity(severity);
    }

    public void setCode(int code) {
        super.setCode(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus[] getChildren() {
        RAMStatus[] ret = null;
        if (!this.fIsMulti) {
            ret = new RAMStatus[]{};
        } else {
            List list = this.fChildren;
            synchronized (list) {
                ret = this.fChildren.toArray(new RAMStatus[this.fChildren.size()]);
            }
        }
        return ret;
    }

    public String getMessage() {
        if (this.isMultiStatus()) {
            String message;
            StringBuffer buffer = new StringBuffer();
            boolean delim = false;
            if (this.fErrorCount > 0) {
                if (this.fErrorCount == 1) {
                    buffer.append(ClientMessages.getString("RAMStatus.1_ERROR"));
                } else {
                    message = MessageFormat.format(ClientMessages.getString("RAMStatus.ERRORS"), new Integer(this.fErrorCount));
                    buffer.append(message);
                }
                delim = true;
            }
            if (this.fWarnCount > 0) {
                if (delim) {
                    buffer.append(", ");
                }
                if (this.fWarnCount == 1) {
                    buffer.append(ClientMessages.getString("RAMStatus.1_WARNING"));
                } else {
                    message = MessageFormat.format(ClientMessages.getString("RAMStatus.WARNINGS"), new Integer(this.fWarnCount));
                    buffer.append(message);
                }
                delim = true;
            }
            if (this.fInfoCount > 0) {
                if (delim) {
                    buffer.append(", ");
                }
                if (this.fInfoCount == 1) {
                    buffer.append(ClientMessages.getString("RAMStatus.1_INFO"));
                } else {
                    message = MessageFormat.format(ClientMessages.getString("RAMStatus.INFOS"), new Integer(this.fInfoCount));
                    buffer.append(message);
                }
            }
            return buffer.toString();
        }
        return super.getMessage();
    }

    public boolean isMultiStatus() {
        return this.fIsMulti;
    }

    public Object getTargetObject() {
        return this.fTargetObject;
    }
}

