/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.common.util;

import com.ibm.ram.common.util.ManifestAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class CachedRAMURIConverter
extends ManifestAccessor.BaseRAMURIConverterImpl
implements ManifestAccessor.SetServerPath {
    private Map cacheMap = new HashMap();
    private String serverPath;
    private String classificationPrefix;

    public CachedRAMURIConverter(String serverPath) {
        this.serverPath = serverPath;
    }

    public void addCacheMapping(URI serverURI, URI cacheURI) {
        serverURI = serverURI.trimFragment();
        cacheURI = cacheURI.trimFragment();
        this.cacheMap.put(serverURI, cacheURI);
    }

    public void removeCacheMapping(URI serverURI) {
        this.cacheMap.remove(serverURI.trimFragment());
    }

    @Override
    public String getServerPath() {
        return this.serverPath;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        URI cacheURI = (URI)this.cacheMap.get(uri);
        return cacheURI == null ? super.createInputStream(uri) : super.createInputStream(cacheURI);
    }

    @Override
    public Resource delegatedGetResource(URI schemaURI, boolean loadOnDemand) {
        return null;
    }

    @Override
    public void setServerPath(String serverPath) {
        this.serverPath = serverPath;
        this.classificationPrefix = null;
    }

    @Override
    public String getClassificationPrefix() {
        if (this.classificationPrefix == null) {
            this.classificationPrefix = String.valueOf(this.getServerPath()) + "classif/";
        }
        return this.classificationPrefix;
    }
}

