/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.Apply;
import com.ibm.ram.fix.FileAccess;
import com.ibm.ram.fix.Fixes;
import com.ibm.ram.fix.PatchControl;
import com.ibm.ram.fix.ZipFileAccess;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class FolderFileAccess
extends FileAccess {
    private final File folder;

    public FolderFileAccess(File folder, byte[] copybuffer, File workDir) {
        super(copybuffer, workDir);
        this.folder = folder;
    }

    FolderFileAccess(File folder, FileAccess nestedFA, String path) {
        super(nestedFA, path);
        this.folder = folder;
    }

    public File getBase() {
        return this.folder;
    }

    public File getFile(String name) {
        return new File(this.folder, name);
    }

    @Override
    public InputStream getIS(String file) throws IOException {
        File f = this.getFile(file);
        switch (this.getFileType(f)) {
            case file: {
                return new FileInputStream(f);
            }
            case directory: {
                throw new Fixes.FileIsDirectory(f.toString());
            }
        }
        throw new FileNotFoundException(f.toString());
    }

    @Override
    public OutputStream getOS(String file) throws IOException, Fixes.FileIsDirectory {
        return this.getOS(this.getFile(file));
    }

    protected OutputStream getOS(File file) throws IOException, Fixes.FileIsDirectory {
        switch (this.getFileType(file)) {
            default: {
                file.getParentFile().mkdirs();
            }
            case file: {
                return new FileOutputStream(file);
            }
            case directory: 
        }
        throw new Fixes.FileIsDirectory(file.toString());
    }

    @Override
    public boolean touch(String filename) {
        return FolderFileAccess.touch(this.getFile(filename));
    }

    public static boolean touch(File file) {
        if (file.exists() && file.canWrite() && file.isFile()) {
            if (file.setLastModified(System.currentTimeMillis())) {
                return true;
            }
            try {
                long origTime = file.lastModified();
                RandomAccessFile raf = new RandomAccessFile(file, "rw");
                long cursor = raf.getFilePointer();
                byte b = raf.readByte();
                raf.seek(cursor);
                raf.write(b);
                raf.close();
                return file.lastModified() != origTime;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public List<String> getFiles(FileAccess.NameFilter filter, boolean nest) {
        ArrayList<String> pcFiles = new ArrayList<String>();
        this.getFiles(pcFiles, filter, this.folder, new StringBuilder(), nest);
        return pcFiles;
    }

    private void getFiles(final List<String> pcFiles, final FileAccess.NameFilter filter, File dir, final StringBuilder dirSB, final boolean nest) {
        dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    if (nest) {
                        int dirlen = dirSB.length();
                        try {
                            if (dirSB.length() > 0 && dirSB.charAt(dirSB.length() - 1) != '/') {
                                dirSB.append('/');
                            }
                            dirSB.append(pathname.getName());
                            FolderFileAccess.this.getFiles(pcFiles, filter, pathname, dirSB, true);
                        }
                        finally {
                            dirSB.setLength(dirlen);
                        }
                    }
                } else {
                    String fn = PatchControl.createFilename(dirSB, pathname.getName(), '/');
                    if (filter.acceptName(FolderFileAccess.this, fn)) {
                        pcFiles.add(fn);
                    }
                }
                return false;
            }
        });
    }

    @Override
    protected void doFinish() {
        for (String file : this.getDeletes()) {
            Apply.deleteFiles(this.getFile(file));
        }
        Collection<Pattern> delPatterns = this.getDeletePatterns();
        if (!delPatterns.isEmpty()) {
            this.deleteFiles(delPatterns, this.folder, new StringBuilder());
        }
    }

    private void deleteFiles(final Collection<Pattern> patterns, File dir, final StringBuilder rootSB) {
        File[] deleteFiles;
        if (dir.isDirectory() && (deleteFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    int rootlen = rootSB.length();
                    try {
                        if (rootSB.length() > 0 && rootSB.charAt(rootlen - 1) != '/') {
                            rootSB.append('/');
                        }
                        rootSB.append(file.getName());
                        FolderFileAccess.this.deleteFiles(patterns, file, rootSB);
                    }
                    finally {
                        rootSB.setLength(rootlen);
                    }
                } else {
                    for (Pattern pattern : patterns) {
                        if (!pattern.matcher(PatchControl.createFilename(rootSB, file.getName(), '/')).matches()) continue;
                        return true;
                    }
                }
                return false;
            }
        })) != null) {
            File[] fileArray = deleteFiles;
            int n = deleteFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
    }

    @Override
    public String getFullname(String name) {
        return this.getFile(name).toString();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FileAccess getNested(String name) throws ZipException, IOException {
        f = this.getFile(name);
        switch (FolderFileAccess.$SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType()[this.getFileType(f).ordinal()]) {
            case 1: {
                return new ZipFileAccess(f, this, name);
            }
            case 2: {
                return new FolderFileAccess(f, this, name);
            }
        }
        dirNdx = -1;
        if (true) ** GOTO lbl16
        do {
            intermediateFn = name.substring(0, dirNdx);
            switch (FolderFileAccess.$SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType()[this.getFileType(intermediateFn).ordinal()]) {
                case 1: {
                    nestedFA = this.getNestedFA(intermediateFn);
                    nestLocalToIntermediate = name.substring(dirNdx + 1);
                    return nestedFA != null ? nestedFA.getNested(nestLocalToIntermediate) : this.getNested(intermediateFn).getNested(nestLocalToIntermediate);
                }
            }
lbl16:
            // 2 sources

            ++dirNdx;
        } while ((dirNdx = name.indexOf(47, dirNdx)) != -1);
        throw new FileNotFoundException(f.toString());
    }

    @Override
    public FileAccess.FileType getFileType(String name) {
        return this.getFileType(this.getFile(name));
    }

    private FileAccess.FileType getFileType(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                return FileAccess.FileType.file;
            }
            return FileAccess.FileType.directory;
        }
        return FileAccess.FileType.notExist;
    }

    @Override
    public void addContents(String name, String contents) throws IOException {
        OutputStreamWriter w = null;
        OutputStream os = null;
        try {
            os = this.getOS(name);
            w = new OutputStreamWriter(os, Charset.forName("UTF-8"));
            Apply.copyReader(new StringReader(contents), w, new char[contents.length() * 4], true, true);
        }
        catch (Throwable throwable) {
            Apply.close(w);
            Apply.close(os);
            throw throwable;
        }
        Apply.close(w);
        Apply.close(os);
    }

    @Override
    public void extractTo(String name, ZipEntry ze, ZipFile zip) throws IOException {
        OutputStream os = null;
        InputStream zin = null;
        try {
            File to = this.getFile(name);
            os = this.getOS(to);
            zin = zip.getInputStream(ze);
            Apply.copyStreams(zin, os, this.getCopybuffer(), true, true);
            os = null;
            zin = null;
            long mod = ze.getTime();
            if (mod >= 0L) {
                to.setLastModified(mod);
            }
        }
        catch (Throwable throwable) {
            Apply.close(os);
            Apply.close(zin);
            throw throwable;
        }
        Apply.close(os);
        Apply.close(zin);
    }

    @Override
    public void doClose() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public InputStream getNestedIS(String local) throws FileNotFoundException, Fixes.FileIsDirectory, IOException {
        switch (FolderFileAccess.$SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType()[this.getFileType(local).ordinal()]) {
            case 2: {
                throw new Fixes.FileIsDirectory(local);
            }
            case 1: {
                return this.getIS(local);
            }
        }
        dirNdx = -1;
        if (true) ** GOTO lbl15
        do {
            lfn = local.substring(0, dirNdx);
            switch (FolderFileAccess.$SWITCH_TABLE$com$ibm$ram$fix$FileAccess$FileType()[this.getFileType(lfn).ordinal()]) {
                case 1: {
                    nestedFA = this.getNestedFA(lfn);
                    nestLocal = local.substring(dirNdx + 1);
                    return nestedFA == null ? this.getNested(lfn).getNestedIS(nestLocal) : nestedFA.getIS(nestLocal);
                }
            }
lbl15:
            // 2 sources

            ++dirNdx;
        } while ((dirNdx = local.indexOf(47, dirNdx)) != -1);
        throw new FileNotFoundException(this.getFullname(local));
    }

    @Override
    public File extract(String file) throws IOException {
        File f = this.getFile(file);
        switch (this.getFileType(f)) {
            case file: {
                return f;
            }
            case directory: {
                throw new Fixes.FileIsDirectory(this.getFullname(file));
            }
        }
        throw new FileNotFoundException(this.getFullname(file));
    }
}

