/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.fix;

import com.ibm.ram.fix.Apply;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PatchControl
implements Cloneable {
    public static final String FIX_CONTROL_EXTENSION = ".fix.xml";
    public static final String FIX_UNDO = ".undo";
    public static final String FIX_UNDO_CONTROL_EXTENSION = ".undo.fix.xml";
    public static final String FIX_VERIFIED_FILE = "fix.verified";
    public static final String DELETE_FILE = "ibm-partialapp-delete.props";
    public static final String DELETE_FILE_PATH_PREFIX = "META-INF/";
    public static final String DELETE_FILE_PATH = "META-INF/ibm-partialapp-delete.props";
    private static final String VERIFY_CHECKSUM_ATTRIBUTE = "checksum";
    private static final String VERIFY_VFILE_ATTRIBUTE = "vfile";
    private static final String VERIFY_DELETED_ATTRIBUTE = "deleted";
    private static final String VERIFY_FILE_ATTRIBUTE = "file";
    private static final String TESTFIX_VERIFY_ELEMENT = "verify";
    private static final String FIX_INCLUDES_ELEMENT = "includes";
    private static final String FIX_FIXENTRY_ELEMENT = "fixes";
    private static final String INCLUDE_FIXENTRY_ELEMENT = "fixes";
    private static final String FIXENTRY_WORKITEM_ATTRIBUTE = "workitem";
    private static final String FIXENTRY_DESCRIPTION_ATTRIBUTE = "description";
    private static final String FIX_BASE_ATTRIBUTE = "base";
    private static final String FIX_RUNTIME_BASE_LOCATION_ATTRIBUTE = "runtimeBase";
    private static final String FIX_BASE_VERSION_PATTERN_ATTRIBUTE = "basePattern";
    private static final String FIX_NAME_ATTRIBUTE = "name";
    private static final String FIX_PREFIX_ATTRIBUTE = "prefix";
    private static final String FIX_ELEMENT = "fix";
    private static final String FIX_FIX_ELEMENT = "fix";
    private static final String FIX_FIX_FILE_ATTRIBUTE = "file";
    private static final String INCLUDES_FIX_ATTRIBUTE = "fix";
    private static final String FIX_TOUCH_ELEMENT = "touches";
    private static final String FIX_TOUCH_FILE_ATTRIBUTE = "file";
    private static final String FIX_TOUCH_BASE_ATTRIBUTE = "base";
    private static final String FIX_TOUCH_INCLUDE_ATTRIBUTE = "include";
    private static final String FIX_TOUCH_EXCLUDE_ATTRIBUTE = "exclude";
    private static final String FIX_TOUCH_RECURSE_ATTRIBUTE = "recurse";
    public static final String DEFAULT_BASE_VERSION_PATTERN = "\\s*V?([^\\-\r\n]+).*";
    private String patchName;
    private String patchPrefix;
    private boolean isDeprecated;
    private String baseVersion = "";
    private String runtimeBase;
    private String baseVersionPattern = "\\s*V?([^\\-\r\n]+).*";
    private List<VerifyFile> verifies = new ArrayList<VerifyFile>();
    private List<Include> includes = new ArrayList<Include>(1);
    private List<FixEntry> fixEntries = new ArrayList<FixEntry>(1);
    private List<Fix> fixes = new ArrayList<Fix>(0);
    private List<Touch> touches = new ArrayList<Touch>(0);

    public String getPatchName() {
        return this.patchName;
    }

    public StringBuilder getPatchNameSB() {
        return new StringBuilder(this.getPatchName());
    }

    public void setPatchName(String patchName) {
        this.patchName = patchName;
    }

    public void setPatchPrefix(String patchPrefix) {
        this.patchPrefix = patchPrefix;
    }

    public String getPatchPrefix() {
        return this.patchPrefix;
    }

    private void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion != null ? baseVersion : "";
    }

    public String getRuntimeBase() {
        return this.runtimeBase;
    }

    public void setRuntimeBase(String runtimeBase) {
        this.runtimeBase = runtimeBase;
    }

    public void setBaseVersionPattern(String baseVersionPattern) {
        this.baseVersionPattern = baseVersionPattern;
    }

    public String getBaseVersionPattern() {
        return this.baseVersionPattern;
    }

    public List<VerifyFile> getVerifies() {
        return this.verifies;
    }

    public List<Include> getIncludes() {
        return this.includes;
    }

    public List<FixEntry> getFixEntries() {
        return this.fixEntries;
    }

    public List<Fix> getFixes() {
        return this.fixes;
    }

    public List<Touch> getTouches() {
        return this.touches;
    }

    public void writeToXML(Writer writer) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element testfix = doc.createElement("fix");
        doc.appendChild(testfix);
        testfix.setAttribute(FIX_NAME_ATTRIBUTE, this.getPatchName());
        testfix.setAttribute(FIX_PREFIX_ATTRIBUTE, this.getPatchPrefix());
        if (this.getBaseVersion().length() != 0) {
            testfix.setAttribute("base", this.getBaseVersion());
        }
        if (this.getRuntimeBase() != null) {
            testfix.setAttribute(FIX_RUNTIME_BASE_LOCATION_ATTRIBUTE, this.getRuntimeBase());
        }
        if (!DEFAULT_BASE_VERSION_PATTERN.equals(this.getBaseVersionPattern())) {
            testfix.setAttribute(FIX_BASE_VERSION_PATTERN_ATTRIBUTE, this.getBaseVersionPattern());
        }
        this.outputFixEntries(this.fixEntries, testfix, doc, "fixes");
        for (Include testFix : this.includes) {
            Element testFixincludes = doc.createElement(FIX_INCLUDES_ELEMENT);
            testfix.appendChild(testFixincludes);
            testFixincludes.setAttribute("fix", testFix.getFix());
            this.outputFixEntries(testFix.getFixEntries(), testFixincludes, doc, "fixes");
        }
        for (VerifyFile vf : this.getVerifies()) {
            Element verify = doc.createElement(TESTFIX_VERIFY_ELEMENT);
            testfix.appendChild(verify);
            verify.setAttribute("file", vf.getFilePath());
            if (vf.isDeleted()) {
                verify.setAttribute(VERIFY_DELETED_ATTRIBUTE, "true");
            }
            if (vf instanceof VerifyJarDelta) {
                VerifyJarDelta vj = (VerifyJarDelta)vf;
                verify.setAttribute(VERIFY_VFILE_ATTRIBUTE, vj.getVFilePath());
                continue;
            }
            if (!(vf instanceof VerifyFileCheckSum)) continue;
            VerifyFileCheckSum vc = (VerifyFileCheckSum)vf;
            verify.setAttribute(VERIFY_CHECKSUM_ATTRIBUTE, String.valueOf(vc.getChecksum()));
        }
        for (Fix fix : this.fixes) {
            Element tf = doc.createElement("fix");
            testfix.appendChild(tf);
            tf.setAttribute("file", fix.getFile());
        }
        for (Touch touch : this.touches) {
            Element tch = doc.createElement(FIX_TOUCH_ELEMENT);
            testfix.appendChild(tch);
            if (touch.getFile() != null) {
                tch.setAttribute("file", touch.getFile());
                continue;
            }
            if (touch.getBase().length() > 0) {
                tch.setAttribute("base", touch.getBase());
            }
            tch.setAttribute(FIX_TOUCH_INCLUDE_ATTRIBUTE, touch.getInclude());
            if (touch.getExclude() != null && touch.getExclude().length() > 0) {
                tch.setAttribute(FIX_TOUCH_EXCLUDE_ATTRIBUTE, touch.getExclude());
            }
            if (touch.isRecurse()) continue;
            tch.setAttribute(FIX_TOUCH_RECURSE_ATTRIBUTE, Boolean.toString(touch.isRecurse()));
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult result = new StreamResult(writer);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
    }

    private void outputFixEntries(List<FixEntry> fixes, Element parent, Document doc, String tag) {
        for (FixEntry fixEntry : fixes) {
            Element fixentry = doc.createElement(tag);
            fixentry.setAttribute(FIXENTRY_WORKITEM_ATTRIBUTE, fixEntry.getWorkitem());
            fixentry.setAttribute(FIXENTRY_DESCRIPTION_ATTRIBUTE, fixEntry.getDescription());
            parent.appendChild(fixentry);
        }
    }

    public static PatchControl loadXML(Reader rdr) throws IOException, ParserConfigurationException, SAXException {
        try {
            String basePattern;
            String runtimeBase;
            String base;
            String pname;
            PatchControl pc = new PatchControl();
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(rdr));
            Element testfix = doc.getDocumentElement();
            String fixFixElement = "fix";
            String includesFixAttribute = "fix";
            if (!"fix".equals(testfix.getTagName())) {
                if ("testfix".equals(testfix.getTagName())) {
                    fixFixElement = "testfix";
                    includesFixAttribute = "testfix";
                    pc.setPatchPrefix("testFix");
                    pc.setDeprecated(true);
                } else if (!"fix".equals(testfix.getTagName())) {
                    throw new InvalidObjectException("Document root is not an fix (\"" + testfix.getTagName() + "\"");
                }
            }
            if ((pname = testfix.getAttribute(FIX_NAME_ATTRIBUTE)).length() == 0) {
                throw new InvalidObjectException("fix is missing the name");
            }
            pc.setPatchName(pname);
            if (pc.getPatchPrefix() == null) {
                String prefix = testfix.getAttribute(FIX_PREFIX_ATTRIBUTE);
                if (prefix.length() == 0) {
                    throw new InvalidObjectException("fix is missing the prefix");
                }
                pc.setPatchPrefix(prefix);
            }
            if ((base = testfix.getAttribute("base")).length() != 0) {
                pc.setBaseVersion(base);
            }
            if ((runtimeBase = testfix.getAttribute(FIX_RUNTIME_BASE_LOCATION_ATTRIBUTE)).length() != 0) {
                pc.setRuntimeBase(runtimeBase);
            }
            if ((basePattern = testfix.getAttribute(FIX_BASE_VERSION_PATTERN_ATTRIBUTE)).length() != 0) {
                pc.setBaseVersionPattern(basePattern);
            }
            NodeList testFixElements = testfix.getChildNodes();
            int els = testFixElements.getLength();
            int i = 0;
            while (i < els) {
                Node child = testFixElements.item(i);
                if (child.getNodeType() == 1) {
                    String file;
                    Element ce = (Element)child;
                    String tag = ce.getTagName();
                    if (FIX_INCLUDES_ELEMENT.equals(tag)) {
                        String testfixInclude = ce.getAttribute(includesFixAttribute);
                        if (testfixInclude.length() == 0) {
                            throw new InvalidObjectException("includes is missing the " + includesFixAttribute);
                        }
                        Include inc = new Include();
                        inc.setFix(testfixInclude);
                        NodeList fixEntries = ce.getElementsByTagName("fixes");
                        int flx = fixEntries.getLength();
                        int fi = 0;
                        while (fi < flx) {
                            Element fe = (Element)fixEntries.item(fi);
                            inc.getFixEntries().add(PatchControl.loadFixEntry(fe));
                            ++fi;
                        }
                        pc.getIncludes().add(inc);
                    } else if (TESTFIX_VERIFY_ELEMENT.equals(tag)) {
                        VerifyFile vf;
                        file = ce.getAttribute("file");
                        if (file.length() == 0) {
                            throw new InvalidObjectException("verify is missing the file");
                        }
                        String del = ce.getAttribute(VERIFY_DELETED_ATTRIBUTE);
                        boolean deleted = Boolean.parseBoolean(del);
                        String vff = ce.getAttribute(VERIFY_VFILE_ATTRIBUTE);
                        if (vff.length() != 0) {
                            VerifyJarDelta vj = new VerifyJarDelta();
                            vf = vj;
                            vj.setVFilePath(vff);
                        } else {
                            String vc = ce.getAttribute(VERIFY_CHECKSUM_ATTRIBUTE);
                            if (vc.length() != 0) {
                                VerifyFileCheckSum vcf = new VerifyFileCheckSum();
                                vf = vcf;
                                vcf.setChecksum(Long.valueOf(vc));
                            } else {
                                if (!deleted) {
                                    throw new InvalidObjectException("verify is missing the necessary attributes to determine the type of verify.");
                                }
                                vf = new VerifyFile();
                            }
                        }
                        vf.setFilePath(file);
                        vf.setDeleted(deleted);
                        pc.getVerifies().add(vf);
                    } else if ("fixes".equals(tag)) {
                        pc.getFixEntries().add(PatchControl.loadFixEntry(ce));
                    } else if (fixFixElement.equals(tag)) {
                        file = ce.getAttribute("file");
                        if (file.length() == 0) {
                            throw new InvalidObjectException(String.valueOf(fixFixElement) + " is missing the " + "file");
                        }
                        Fix tf = new Fix();
                        tf.setFile(file);
                        pc.getFixes().add(tf);
                    } else if (FIX_TOUCH_ELEMENT.equals(tag)) {
                        Touch touch = new Touch();
                        String file2 = ce.getAttribute("file");
                        if (file2.length() == 0) {
                            String trecurse;
                            String include;
                            String tchbase = ce.getAttribute("base");
                            if (tchbase.length() > 0) {
                                touch.setBase(tchbase);
                            }
                            if ((include = ce.getAttribute(FIX_TOUCH_INCLUDE_ATTRIBUTE)).length() == 0) {
                                throw new InvalidObjectException("touches is missing the include");
                            }
                            String recurse = ce.getAttribute(FIX_TOUCH_RECURSE_ATTRIBUTE);
                            if (recurse.length() > 0 && !recurse.equalsIgnoreCase(trecurse = Boolean.valueOf(recurse).toString())) {
                                throw new InvalidObjectException(String.valueOf(trecurse) + " is invalid for the " + FIX_TOUCH_RECURSE_ATTRIBUTE);
                            }
                            touch.setInclude(include);
                            String exclude = ce.getAttribute(FIX_TOUCH_EXCLUDE_ATTRIBUTE);
                            if (exclude.length() > 0) {
                                touch.setExclude(exclude);
                            }
                            if (recurse.length() > 0 && !Boolean.parseBoolean(recurse)) {
                                touch.setRecurse(false);
                            }
                        } else {
                            touch.setFile(file2);
                        }
                        pc.getTouches().add(touch);
                    }
                }
                ++i;
            }
            PatchControl patchControl = pc;
            return patchControl;
        }
        finally {
            rdr.close();
        }
    }

    private static FixEntry loadFixEntry(Element fixEntry) throws InvalidObjectException {
        FixEntry r = new FixEntry();
        String wi = fixEntry.getAttribute(FIXENTRY_WORKITEM_ATTRIBUTE);
        if (wi == null || wi.length() <= 0) {
            throw new InvalidObjectException(String.valueOf(fixEntry.getTagName()) + " is missing the " + FIXENTRY_WORKITEM_ATTRIBUTE);
        }
        r.setWorkitem(fixEntry.getAttribute(FIXENTRY_WORKITEM_ATTRIBUTE));
        if (fixEntry.hasAttribute(FIXENTRY_DESCRIPTION_ATTRIBUTE)) {
            r.setDescription(fixEntry.getAttribute(FIXENTRY_DESCRIPTION_ATTRIBUTE));
        }
        return r;
    }

    public Object clone() throws CloneNotSupportedException {
        PatchControl clone = (PatchControl)super.clone();
        clone.fixEntries = (List)((ArrayList)this.fixEntries).clone();
        clone.includes = (List)((ArrayList)this.includes).clone();
        clone.fixes = (List)((ArrayList)this.fixes).clone();
        clone.verifies = (List)((ArrayList)this.verifies).clone();
        clone.touches = (List)((ArrayList)this.touches).clone();
        return clone;
    }

    public static String readRuntimeVersion(InputStream runtimeBaseFile, String baseVersionPattern) {
        Reader br;
        block11: {
            String string;
            block12: {
                br = null;
                br = new BufferedReader(new InputStreamReader(runtimeBaseFile, Charset.forName("UTF-8")));
                StringWriter sw = new StringWriter();
                Apply.copyReader(br, sw, new char[200], true, true);
                Matcher matcher = Pattern.compile(baseVersionPattern, 8).matcher(sw.toString());
                if (!matcher.find()) break block11;
                String baseVersion = matcher.group(1).trim();
                if (baseVersion.length() == 0) {
                    throw new IllegalArgumentException("Base version pattern returned spaces or empty string from base version file \"" + runtimeBaseFile + '\"');
                }
                string = baseVersion;
                if (br == null) break block12;
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            return string;
        }
        try {
            try {
                throw new IllegalArgumentException("Base version pattern could not match anything from base version file \"" + runtimeBaseFile + '\"');
            }
            catch (IOException e) {
                throw new IllegalArgumentException("IO Exception reading base version file \"" + runtimeBaseFile + "\" msg=\"" + e.getMessage() + '\"');
            }
        }
        catch (Throwable throwable) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
    }

    public static void loadDeletes(Collection<String> deletes, InputStream is, String delFileNamePrefix) throws IOException {
        try {
            String line;
            StringBuilder delFileSB = new StringBuilder(delFileNamePrefix);
            BufferedReader rdr = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            while ((line = rdr.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                deletes.add(PatchControl.createFilename(delFileSB, line, '/'));
            }
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
    }

    public static boolean isFixControl(String filename, ControlType ctype, int startNdx, String tfName) {
        switch (ctype) {
            case doType: {
                if (!filename.endsWith(FIX_CONTROL_EXTENSION) || filename.endsWith(FIX_UNDO_CONTROL_EXTENSION)) break;
                if (tfName != null) {
                    return filename.regionMatches(filename.length() - FIX_CONTROL_EXTENSION.length() - tfName.length(), tfName, 0, tfName.length());
                }
                return true;
            }
            case undoType: {
                if (!filename.endsWith(FIX_UNDO_CONTROL_EXTENSION)) break;
                if (tfName != null) {
                    return filename.regionMatches(filename.length() - FIX_UNDO_CONTROL_EXTENSION.length() - tfName.length(), tfName, 0, tfName.length());
                }
                return true;
            }
            case eitherType: {
                if (filename.endsWith(FIX_CONTROL_EXTENSION)) {
                    if (tfName != null) {
                        return filename.regionMatches(filename.length() - FIX_CONTROL_EXTENSION.length() - tfName.length(), tfName, 0, tfName.length());
                    }
                    return true;
                }
                if (filename.endsWith(FIX_UNDO_CONTROL_EXTENSION)) {
                    if (tfName != null) {
                        return filename.regionMatches(filename.length() - FIX_UNDO_CONTROL_EXTENSION.length() - tfName.length(), tfName, 0, tfName.length());
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isDeprecatedTestFixControl(String filename, ControlType ctype, int startNdx, String tfName) {
        if (filename.regionMatches(startNdx, "testFix", 0, "testFix".length())) {
            switch (ctype) {
                case doType: {
                    if (!filename.endsWith(".xml") || filename.endsWith(".undo.xml") || filename.endsWith(FIX_CONTROL_EXTENSION)) break;
                    if (tfName != null) {
                        return filename.regionMatches(filename.length() - ".xml".length() - tfName.length(), tfName, 0, tfName.length());
                    }
                    return true;
                }
                case undoType: {
                    if (!filename.endsWith(".undo.xml")) break;
                    if (tfName != null) {
                        return filename.regionMatches(filename.length() - ".undo.xml".length() - tfName.length(), tfName, 0, tfName.length());
                    }
                    return true;
                }
                case eitherType: {
                    if (filename.endsWith(".xml") && !filename.endsWith(FIX_CONTROL_EXTENSION)) {
                        if (tfName != null) {
                            return filename.regionMatches(filename.length() - ".xml".length() - tfName.length(), tfName, 0, tfName.length());
                        }
                        return true;
                    }
                    if (filename.endsWith(".undo.xml")) {
                        if (tfName != null) {
                            return filename.regionMatches(filename.length() - ".undo.xml".length() - tfName.length(), tfName, 0, tfName.length());
                        }
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public static String createFilename(StringBuilder prefixSB, String filename, char fileSep) {
        int prefixSBLen = prefixSB.length();
        try {
            if (prefixSBLen > 0) {
                if (prefixSB.charAt(prefixSBLen - 1) != fileSep) {
                    prefixSB.append(fileSep);
                }
                String string = prefixSB.append(filename).toString();
                return string;
            }
            String string = filename;
            return string;
        }
        finally {
            prefixSB.setLength(prefixSBLen);
        }
    }

    public static enum ControlType {
        doType,
        undoType,
        eitherType;

    }

    public static class Fix {
        private String file;

        public void setFile(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class FixEntry {
        private String workitem;
        private String description;

        public String getWorkitem() {
            return this.workitem;
        }

        public void setWorkitem(String workitem) {
            this.workitem = workitem;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class Include {
        private String fix;
        private List<FixEntry> fixEntries = new ArrayList<FixEntry>(0);

        public List<FixEntry> getFixEntries() {
            return this.fixEntries;
        }

        public void setFix(String fix) {
            this.fix = fix;
        }

        public String getFix() {
            return this.fix;
        }
    }

    public static class Touch {
        private String file;
        private String base = "";
        private String include;
        private String exclude;
        private boolean recurse = true;

        public int hashCode() {
            return (((this.hash(this.file) * 31 + this.hash(this.base)) * 31 + this.hash(this.include)) * 31 + this.hash(this.exclude)) * 31 + Boolean.valueOf(this.recurse).hashCode();
        }

        private int hash(String s) {
            return s != null ? s.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                return true;
            }
            if (!(o instanceof Touch)) {
                return false;
            }
            Touch ot = (Touch)o;
            return this.equal(this.file, ot.file) && this.equal(this.base, ot.base) && this.equal(this.include, ot.include) && this.recurse == ot.recurse;
        }

        private boolean equal(String a, String b) {
            if (a != b) {
                if (a != null) {
                    return a.equals(b);
                }
                return b.equals(a);
            }
            return true;
        }

        public void setBase(String base) {
            this.base = base;
        }

        public String getBase() {
            return this.base;
        }

        public String getInclude() {
            return this.include;
        }

        public void setInclude(String include) {
            this.include = include;
        }

        public String getExclude() {
            return this.exclude;
        }

        public void setExclude(String excludes) {
            this.exclude = excludes;
        }

        public boolean isRecurse() {
            return this.recurse;
        }

        public void setRecurse(boolean recurse) {
            this.recurse = recurse;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }

    public static class VerifyFile {
        private String filePath;
        private boolean deleted;

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = !filePath.endsWith("/") ? filePath : filePath.substring(0, filePath.length() - 1);
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
        }
    }

    public static class VerifyFileCheckSum
    extends VerifyFile {
        private long checksum;

        public long getChecksum() {
            return this.checksum;
        }

        public void setChecksum(long checksum) {
            this.checksum = checksum;
        }
    }

    public static class VerifyJarDelta
    extends VerifyFile {
        private String vfilePath;

        public String getVFilePath() {
            return this.vfilePath;
        }

        public void setVFilePath(String vfilePath) {
            this.vfilePath = vfilePath;
        }
    }
}

