/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.activities;

import com.ibm.ram.common.data.Activity;
import com.ibm.ram.common.data.AssetActivity;
import com.ibm.ram.common.data.CustomAssetActivity;
import com.ibm.ram.internal.activities.AssetFeedbackActivity;
import com.ibm.ram.internal.activities.AssetUpdateActivity;
import com.ibm.ram.internal.common.util.ActivityTypes;

public class ActivityFactory
implements ActivityTypes {
    public static Activity createActivity(int type) {
        if (type >= 1000 && type <= 1100) {
            return new CustomAssetActivity();
        }
        switch (type) {
            case 310: 
            case 350: 
            case 380: {
                return new AssetFeedbackActivity();
            }
            case 680: {
                return new AssetUpdateActivity();
            }
        }
        return new AssetActivity();
    }

    public static AssetActivity getAssetActivity(AssetActivity activity) {
        AssetActivity ret = null;
        if (activity.getTypeId() >= 1000 && activity.getTypeId() <= 1100) {
            if (activity instanceof CustomAssetActivity) {
                return activity;
            }
        } else {
            switch (activity.getTypeId()) {
                case 310: 
                case 350: 
                case 380: {
                    if (activity instanceof AssetFeedbackActivity) {
                        return activity;
                    }
                    AssetFeedbackActivity afActivity = new AssetFeedbackActivity();
                    ret = afActivity;
                }
                case 680: {
                    if (activity instanceof AssetUpdateActivity) {
                        return activity;
                    }
                    AssetUpdateActivity auActivity = new AssetUpdateActivity();
                    ret = auActivity;
                }
            }
            return ret;
        }
        ret = new CustomAssetActivity();
        ret.setActivityId(activity.getActivityId());
        ret.setAssetGUID(activity.getAssetGUID());
        ret.setAssetName(activity.getAssetName());
        ret.setAssetVersion(activity.getAssetVersion());
        ret.setAssetSubmission(activity.isAssetSubmission());
        ret.setName(activity.getName());
        ret.setTarget(activity.getTarget());
        ret.setTargetURL(activity.getTargetURL());
        ret.setTimestamp(activity.getTimestamp());
        ret.setTypeId(activity.getTypeId());
        ret.setUser(activity.getUser());
        return ret;
    }
}

