/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RAMMappings {
    private static String SESSION_KEY_DELIM = "#";
    private static final String COMMUNITY_NAME_MAPPINGS = "RAM_MAPPINGS.COMMUNITY_NAME_MAPPINGS";
    private static final String ASSET_TYPE_NAME_MAPPINGS = "RAM_MAPPINGS.ASSET_TYPE_NAME_MAPPINGS";
    private static final String RELATIONSHIP_TYPE_NAME_MAPPINGS = "RAM_MAPPINGS.RELATIONSHIP_TYPE_NAME_MAPPINGS";
    private static final String USER_ID_MAPPINGS = "RAM_MAPPINGS.USER_ID_MAPPINGS";
    private static final String CATEGORIZATION_MAPPINGS = "RAM_MAPPINGS.CATEGORIZATION_MAPPINGS";
    private static final String ASSET_ATTRIBUTE_NAME_MAPPINGS = "RAM_MAPPINGS.ASSET_ATTRIBUTE_NAME_MAPPINGS";
    private static final String ASSET_ATTRIBUTE_VALUE_MAPPINGS = "RAM_MAPPINGS.ASSET_ATTRIBUTE_VALUE_MAPPINGS";
    private static final String ASSET_MAPPINGS = "RAM_MAPPINGS.ASSET_MAPPINGS";
    private static final String FOLLOW_RELATED_ASSETS = "FOLLOW_RELATED_ASSETS";
    private static final String FILTER_EXISTING_ASSETS = "FILTER_EXISTING_ASSETS";
    private HashMap fCommunityNameMappings;
    private HashMap fAssetTypeMappings;
    private HashMap fRelationshipTypeNameMappings;
    private HashMap fUseridMappings;
    private HashMap fCategorizationMappings;
    private HashMap fAssetAttributeNameMappings;
    private HashMap fAssetAttributeValueMappings;
    private HashMap fAssetMappings;
    private List fInvalidAssets = new ArrayList();
    private List fInvalidCategorization = new ArrayList();
    private List fInvalidAssetAttribute = new ArrayList();
    private List fInvalidCommunity = new ArrayList();
    private List fInvalidAssetType = new ArrayList();
    private List fInvalidRelationshipType = new ArrayList();
    private volatile Boolean fFollowRelatedAssets;
    private volatile Boolean fFilterOutExistingAssets;

    public boolean isFollowRelatedAssets() {
        if (this.fFollowRelatedAssets == null) {
            this.fFollowRelatedAssets = new Boolean(false);
        }
        return this.fFollowRelatedAssets;
    }

    public void setFollowRelatedAssets(boolean followRelatedAssets) {
        this.fFollowRelatedAssets = new Boolean(followRelatedAssets);
    }

    public boolean isFilterOutExistingAssets() {
        if (this.fFilterOutExistingAssets == null) {
            this.fFilterOutExistingAssets = new Boolean(false);
        }
        return this.fFilterOutExistingAssets;
    }

    public void setFilterOutExistingAssets(boolean filterOutExistingAssets) {
        this.fFilterOutExistingAssets = new Boolean(filterOutExistingAssets);
    }

    public Map getCommunityNameMappings() {
        if (this.fCommunityNameMappings == null) {
            this.fCommunityNameMappings = new HashMap();
        }
        return this.fCommunityNameMappings;
    }

    public Map getAssetTypeNameMappings() {
        if (this.fAssetTypeMappings == null) {
            this.fAssetTypeMappings = new HashMap();
        }
        return this.fAssetTypeMappings;
    }

    public Map getRelationshipTypeNameMappings() {
        if (this.fRelationshipTypeNameMappings == null) {
            this.fRelationshipTypeNameMappings = new HashMap();
        }
        return this.fRelationshipTypeNameMappings;
    }

    public Map getUserIdMappings() {
        if (this.fUseridMappings == null) {
            this.fUseridMappings = new HashMap();
        }
        return this.fUseridMappings;
    }

    public Map getCategorizationMappings() {
        if (this.fCategorizationMappings == null) {
            this.fCategorizationMappings = new HashMap();
        }
        return this.fCategorizationMappings;
    }

    public Map getAssetAttributeNameMappings() {
        if (this.fAssetAttributeNameMappings == null) {
            this.fAssetAttributeNameMappings = new HashMap();
        }
        return this.fAssetAttributeNameMappings;
    }

    public Map getAssetAttributeValueMappings() {
        if (this.fAssetAttributeValueMappings == null) {
            this.fAssetAttributeValueMappings = new HashMap();
        }
        return this.fAssetAttributeValueMappings;
    }

    public Map getAssetMappings() {
        if (this.fAssetMappings == null) {
            this.fAssetMappings = new HashMap();
        }
        return this.fAssetMappings;
    }

    public static String createSessionKey(String GUID, String version) {
        return String.valueOf(GUID) + SESSION_KEY_DELIM + version;
    }

    public static String[] getGUIDAndVersionFromSessionKey(String key) {
        String GUID = key.substring(0, key.indexOf(SESSION_KEY_DELIM));
        String version = key.substring(key.indexOf(SESSION_KEY_DELIM) + SESSION_KEY_DELIM.length());
        return new String[]{GUID, version};
    }

    public boolean isInvalidAsset(String GUID, String version) {
        String key = RAMMappings.createSessionKey(GUID, version);
        return this.fInvalidAssets.contains(key);
    }

    public void setAssetIsInvalid(String GUID, String version, boolean invalid) {
        String key = RAMMappings.createSessionKey(GUID, version);
        if (invalid) {
            this.fInvalidAssets.add(key);
        } else {
            this.fInvalidAssets.remove(key);
        }
    }

    public boolean isInvalidAssetAttribute(String name) {
        return this.fInvalidAssetAttribute.contains(name);
    }

    public void setAssetAttributeIsInvalid(String name, boolean isInvalid) {
        if (isInvalid) {
            this.fInvalidAssetAttribute.add(name);
        } else {
            this.fInvalidAssetAttribute.remove(name);
        }
    }

    public boolean isInvalidCategorization(String path) {
        return this.fInvalidCategorization.contains(path);
    }

    public void setCategorizationIsInvalid(String path, boolean invalid) {
        if (invalid) {
            this.fInvalidCategorization.add(path);
        } else {
            this.fInvalidCategorization.remove(path);
        }
    }

    public boolean isInvalidAssetType(String type) {
        return this.fInvalidAssetType.contains(type);
    }

    public void setAssetTypeIsInvalid(String type, boolean invalid) {
        if (invalid) {
            this.fInvalidAssetType.add(type);
        } else {
            this.fInvalidAssetType.remove(type);
        }
    }

    public boolean isInvalidCommunity(String name) {
        return this.fInvalidCommunity.contains(name);
    }

    public void setCommunityIsInvalid(String name, boolean invalid) {
        if (invalid) {
            this.fInvalidCommunity.add(name);
        } else {
            this.fInvalidCommunity.remove(name);
        }
    }

    public boolean isInvalidRelationshipType(String type) {
        return this.fInvalidRelationshipType.contains(type);
    }

    public void setRelationshipTypeIsInvalid(String type, boolean invalid) {
        if (invalid) {
            this.fInvalidRelationshipType.add(type);
        } else {
            this.fInvalidRelationshipType.remove(type);
        }
    }

    public void load(HashMap map) {
        if (map == null) {
            this.fCommunityNameMappings = null;
            this.fAssetTypeMappings = null;
            this.fRelationshipTypeNameMappings = null;
        } else {
            HashMap loadedCommunityNameMappings;
            Object filterExisting;
            Object followRelated = map.get(FOLLOW_RELATED_ASSETS);
            if (followRelated instanceof Boolean) {
                this.setFollowRelatedAssets((Boolean)followRelated);
            }
            if ((filterExisting = map.get(FILTER_EXISTING_ASSETS)) instanceof Boolean) {
                this.setFilterOutExistingAssets((Boolean)filterExisting);
            }
            if ((loadedCommunityNameMappings = (HashMap)map.get(COMMUNITY_NAME_MAPPINGS)) == null) {
                this.fCommunityNameMappings = null;
            } else if (this.fCommunityNameMappings == null) {
                this.fCommunityNameMappings = loadedCommunityNameMappings;
            } else {
                this.fCommunityNameMappings.clear();
                this.fCommunityNameMappings.putAll(loadedCommunityNameMappings);
            }
            HashMap loadedAssetTypesMapping = (HashMap)map.get(ASSET_TYPE_NAME_MAPPINGS);
            if (loadedAssetTypesMapping == null) {
                this.fAssetTypeMappings = null;
            } else if (this.fAssetTypeMappings == null) {
                this.fAssetTypeMappings = loadedAssetTypesMapping;
            } else {
                this.fAssetTypeMappings.clear();
                this.fAssetTypeMappings.putAll(loadedAssetTypesMapping);
            }
            HashMap loadedRelationshipTypeNameMapping = (HashMap)map.get(RELATIONSHIP_TYPE_NAME_MAPPINGS);
            if (loadedRelationshipTypeNameMapping == null) {
                this.fRelationshipTypeNameMappings = null;
            } else if (this.fRelationshipTypeNameMappings == null) {
                this.fRelationshipTypeNameMappings = loadedRelationshipTypeNameMapping;
            } else {
                this.fRelationshipTypeNameMappings.clear();
                this.fRelationshipTypeNameMappings.putAll(loadedRelationshipTypeNameMapping);
            }
            HashMap loadedUserIdMapping = (HashMap)map.get(USER_ID_MAPPINGS);
            if (loadedUserIdMapping == null) {
                this.fUseridMappings = null;
            } else if (this.fUseridMappings == null) {
                this.fUseridMappings = loadedUserIdMapping;
            } else {
                this.fUseridMappings.clear();
                this.fUseridMappings.putAll(loadedUserIdMapping);
            }
            HashMap loadedCategorizationMappings = (HashMap)map.get(CATEGORIZATION_MAPPINGS);
            if (loadedCategorizationMappings == null) {
                this.fCategorizationMappings = null;
            } else if (this.fCategorizationMappings == null) {
                this.fCategorizationMappings = loadedCategorizationMappings;
            } else {
                this.fCategorizationMappings.clear();
                this.fCategorizationMappings.putAll(loadedCategorizationMappings);
            }
            HashMap loadedAttributeMappings = (HashMap)map.get(ASSET_ATTRIBUTE_NAME_MAPPINGS);
            if (loadedAttributeMappings == null) {
                this.fAssetAttributeNameMappings = null;
            } else if (this.fAssetAttributeNameMappings == null) {
                this.fAssetAttributeNameMappings = loadedAttributeMappings;
            } else {
                this.fAssetAttributeNameMappings.clear();
                this.fAssetAttributeNameMappings.putAll(loadedAttributeMappings);
            }
            HashMap loadedAttributeValueMappings = (HashMap)map.get(ASSET_ATTRIBUTE_VALUE_MAPPINGS);
            if (loadedAttributeValueMappings == null) {
                this.fAssetAttributeValueMappings = null;
            } else if (this.fAssetAttributeValueMappings == null) {
                this.fAssetAttributeValueMappings = loadedAttributeValueMappings;
            } else {
                this.fAssetAttributeValueMappings.clear();
                this.fAssetAttributeValueMappings.putAll(loadedAttributeValueMappings);
            }
            HashMap loadedAssetMappings = (HashMap)map.get(ASSET_MAPPINGS);
            if (loadedAssetMappings == null) {
                this.fAssetMappings = null;
            } else if (this.fAssetMappings == null) {
                this.fAssetMappings = loadedAssetMappings;
            } else {
                this.fAssetMappings.clear();
                this.fAssetMappings.putAll(loadedAssetMappings);
            }
        }
    }

    public void save(HashMap model) {
        if (this.fFollowRelatedAssets != null) {
            model.put(FOLLOW_RELATED_ASSETS, this.fFollowRelatedAssets);
        }
        if (this.fFilterOutExistingAssets != null) {
            model.put(FILTER_EXISTING_ASSETS, this.fFilterOutExistingAssets);
        }
        if (this.fCommunityNameMappings != null) {
            model.put(COMMUNITY_NAME_MAPPINGS, this.fCommunityNameMappings);
        }
        if (this.fAssetTypeMappings != null) {
            model.put(ASSET_TYPE_NAME_MAPPINGS, this.fAssetTypeMappings);
        }
        if (this.fRelationshipTypeNameMappings != null) {
            model.put(RELATIONSHIP_TYPE_NAME_MAPPINGS, this.fRelationshipTypeNameMappings);
        }
        if (this.fUseridMappings != null) {
            model.put(USER_ID_MAPPINGS, this.fUseridMappings);
        }
        if (this.fCategorizationMappings != null) {
            model.put(CATEGORIZATION_MAPPINGS, this.fCategorizationMappings);
        }
        if (this.fAssetAttributeNameMappings != null) {
            model.put(ASSET_ATTRIBUTE_NAME_MAPPINGS, this.fAssetAttributeNameMappings);
        }
        if (this.fAssetAttributeValueMappings != null) {
            model.put(ASSET_ATTRIBUTE_VALUE_MAPPINGS, this.fAssetAttributeValueMappings);
        }
        if (this.fAssetMappings != null) {
            model.put(ASSET_MAPPINGS, this.fAssetMappings);
        }
    }
}

