/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.data;

import com.ibm.ram.common.emf.EMFFactory;
import com.ibm.ram.common.emf.NamespaceMapping;
import com.ibm.ram.internal.common.util.SerializationHelper;
import java.util.HashMap;
import java.util.Map;

public class XMLArtifactAttributeConstraint {
    private static String FILE_TYPES_KEY = "FT";
    private static String XPATH_KEY = "X";
    private static String NAMESPACE_MAPPING_KEY = "NM";
    private Map fConfig;
    private NamespaceMapping[] fNamespaces;

    public XMLArtifactAttributeConstraint() {
        this.fConfig = new HashMap();
    }

    public XMLArtifactAttributeConstraint(String config) throws Exception {
        SerializationHelper helper = new SerializationHelper(config);
        this.fConfig = (Map)helper.deserialize();
    }

    public XMLArtifactAttributeConstraint(Map config) throws Exception {
        this.fConfig = config;
    }

    public String serialize() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(FILE_TYPES_KEY, this.getFileTypes());
        map.put(XPATH_KEY, this.getXPath());
        map.put(NAMESPACE_MAPPING_KEY, this.getNamespaceMappings());
        SerializationHelper helper = new SerializationHelper(map);
        return helper.serialize();
    }

    public String[] getFileTypesArray() {
        if (this.getFileTypes() == null || this.getFileTypes().equals("")) {
            return new String[0];
        }
        return this.getFileTypes().split(";");
    }

    public String getFileTypes() {
        return (String)this.fConfig.get(FILE_TYPES_KEY);
    }

    public void setFileTypes(String fileTypes) {
        this.fConfig.put(FILE_TYPES_KEY, fileTypes);
    }

    public String getXPath() {
        return (String)this.fConfig.get(XPATH_KEY);
    }

    public void setXPath(String path) {
        this.fConfig.put(XPATH_KEY, path);
    }

    public String getNamespaceMappings() {
        return (String)this.fConfig.get(NAMESPACE_MAPPING_KEY);
    }

    public void setNamespaceMappings(String namespaceMappings) {
        this.fConfig.put(NAMESPACE_MAPPING_KEY, namespaceMappings);
    }

    public void addNamespaceMapping(String prefix, String URI2) {
        if (prefix != null && URI2 != null && !prefix.equals("") && !URI2.equals("")) {
            NamespaceMapping[] namespace = this.getNamespaceMappingsArray();
            int i = 0;
            while (i < namespace.length) {
                if (prefix.equals(namespace[i].getPrefix())) {
                    return;
                }
                ++i;
            }
            if (this.getNamespaceMappings() != null && !this.getNamespaceMappings().equals("")) {
                if (this.getNamespaceMappings().endsWith(";")) {
                    this.setNamespaceMappings(this.getNamespaceMappings().substring(0, this.getNamespaceMappings().length() - 1));
                }
                this.setNamespaceMappings(String.valueOf(this.getNamespaceMappings()) + ";" + prefix + "=" + URI2);
            } else {
                this.setNamespaceMappings(String.valueOf(prefix) + "=" + URI2);
            }
            this.fNamespaces = null;
        }
    }

    public void removeNamespaceMapping(String prefix) {
        NamespaceMapping[] namespace = this.getNamespaceMappingsArray();
        StringBuffer nameSpaces = new StringBuffer();
        int i = 0;
        while (i < namespace.length) {
            if (!prefix.equals(namespace[i].getPrefix())) {
                nameSpaces.append(String.valueOf(namespace[i].getPrefix()) + "=" + namespace[i].getURI() + ";");
            }
            ++i;
        }
        this.setNamespaceMappings(nameSpaces.toString());
        if (this.getNamespaceMappings().endsWith(";")) {
            this.setNamespaceMappings(this.getNamespaceMappings().substring(0, this.getNamespaceMappings().length() - 1));
        }
        this.fNamespaces = null;
    }

    public void addFileType(String extension) {
        String[] fileTypes = this.getFileTypesArray();
        int i = 0;
        while (i < fileTypes.length) {
            if (extension.equals(fileTypes[0])) {
                return;
            }
            ++i;
        }
        if (this.getFileTypes() != null && !this.getFileTypes().equals("")) {
            if (this.getFileTypes().endsWith(";")) {
                this.setFileTypes(this.getFileTypes().substring(0, this.getFileTypes().length() - 1));
            }
            this.setFileTypes(String.valueOf(this.getFileTypes()) + ";" + extension);
        } else {
            this.setFileTypes(extension);
        }
    }

    public void removeFileType(String extension) {
        String[] fileTypes = this.getFileTypesArray();
        StringBuffer fileTypesBuffer = new StringBuffer();
        int i = 0;
        while (i < fileTypes.length) {
            if (!extension.equals(fileTypes[i])) {
                fileTypesBuffer.append(String.valueOf(fileTypes[i]) + ";");
            }
            ++i;
        }
        this.setFileTypes(fileTypesBuffer.toString());
        if (this.getFileTypes().endsWith(";")) {
            this.setFileTypes(this.getFileTypes().substring(0, this.getFileTypes().length() - 1));
        }
    }

    public NamespaceMapping[] getNamespaceMappingsArray() {
        if (this.fNamespaces == null) {
            if (this.getNamespaceMappings() == null || this.getNamespaceMappings().equals("")) {
                this.fNamespaces = new NamespaceMapping[0];
            } else {
                String[] curNamespaces = this.getNamespaceMappings().split(";");
                this.fNamespaces = new NamespaceMapping[curNamespaces.length];
                int i = 0;
                while (i < curNamespaces.length) {
                    String[] nMapping = curNamespaces[i].split("=");
                    this.fNamespaces[i] = EMFFactory.eINSTANCE.createNamespaceMapping();
                    this.fNamespaces[i].setPrefix(nMapping[0]);
                    this.fNamespaces[i].setURI(nMapping[1]);
                    ++i;
                }
            }
        }
        return this.fNamespaces;
    }
}

