/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.common.util;

import com.ibm.ram.internal.common.data.lifecycle.VisualLifecycle;
import com.ibm.ram.internal.common.util.AppletServerAccess;
import com.ibm.ram.internal.common.util.VisualLifecycleComponentWrapper;
import com.ibm.ram.internal.jaxb.ExitCondition;
import com.ibm.ram.internal.jaxb.Lifecycle;
import com.ibm.ram.internal.jaxb.StateConfiguration;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;

public abstract class VisualLifecycleAccessor
extends AppletServerAccess {
    public static final String TRANSITION_IDENTIFIER_DELIM = "...transitionIdentifierDelim...";
    private VisualLifecycle visualLifecycle;
    private Locale locale;

    public VisualLifecycleAccessor(VisualLifecycle visualLifecycle, URL serverURL) {
        super(serverURL);
        this.visualLifecycle = visualLifecycle;
    }

    public abstract void selected(VisualLifecycleComponentWrapper var1);

    public abstract void saveComplete(boolean var1, String var2);

    public void load(InputStream is) {
        this.setChanged();
        this.notifyObservers(is);
    }

    public Lifecycle getLifecycle() {
        return this.visualLifecycle.getLifecycle();
    }

    public VisualLifecycle getVisualLifecycle() {
        return this.visualLifecycle;
    }

    public void updateLifecycleComponent(VisualLifecycleComponentWrapper component) {
        this.setChanged();
        this.notifyObservers(component);
        block0 : switch (component.getType()) {
            case 1: {
                StateConfiguration updatedConfiguration = (StateConfiguration)component.getComponent();
                List<StateConfiguration> configurations = this.visualLifecycle.getLifecycle().getStateConfigurations();
                int i = 0;
                while (i < configurations.size()) {
                    StateConfiguration config = configurations.get(i);
                    String id = updatedConfiguration.getState().getHref();
                    if (id.equals(config.getState().getHref())) {
                        configurations.set(i, updatedConfiguration);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                ExitCondition exitCondition = (ExitCondition)component.getComponent();
                String startingStateIdentifier = exitCondition.getState().getHref();
                List<StateConfiguration> exitStateConfigurations = this.visualLifecycle.getLifecycle().getStateConfigurations();
                int i = 0;
                while (i < exitStateConfigurations.size()) {
                    StateConfiguration config = exitStateConfigurations.get(i);
                    if (startingStateIdentifier.equals(config.getState().getHref())) {
                        List<ExitCondition> exitConditions = config.getExitConditions();
                        int j = 0;
                        while (j < exitConditions.size()) {
                            ExitCondition condition = exitConditions.get(j);
                            String tempExitConditionId = String.valueOf(condition.getState().getHref()) + condition.getAction().getHref();
                            if (tempExitConditionId.equals(String.valueOf(exitCondition.getState().getHref()) + exitCondition.getAction().getHref())) {
                                exitConditions.set(j, exitCondition);
                                break block0;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public static String getTransitionIdentifier(ExitCondition condition) {
        return String.valueOf(JAXBLinksUtil.getStateIdentifier(condition.getState())) + TRANSITION_IDENTIFIER_DELIM + JAXBLinksUtil.getActionIdentifier(condition.getAction());
    }
}

