/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class JsonMethodSerializeDeserialize<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        Map<String, Method> fields = this.getSerializeFields(src, typeOfSrc);
        for (Map.Entry<String, Method> field : fields.entrySet()) {
            Object fieldValue = null;
            try {
                fieldValue = field.getValue().invoke(src, new Object[0]);
                String name = field.getKey();
                if (fieldValue == null) {
                    jsonObject.add(name, new JsonNull());
                    continue;
                }
                if (fieldValue instanceof String) {
                    jsonObject.addProperty(name, (String)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Character) {
                    jsonObject.addProperty(name, (Character)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Boolean) {
                    jsonObject.addProperty(name, (Boolean)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Number) {
                    jsonObject.addProperty(name, (Number)fieldValue);
                    continue;
                }
                jsonObject.add(name, context.serialize(fieldValue));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    @Override
    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = (JsonObject)json;
        Object to = this.construct(jsonObj, typeOfT);
        Map<String, DeserializeData> deserialData = this.getDeserializeFields(to, typeOfT);
        Set<Map.Entry<String, JsonElement>> fields = jsonObj.entrySet();
        for (Map.Entry<String, JsonElement> field : fields) {
            DeserializeData deData = deserialData.get(field.getKey());
            if (deData == null) continue;
            if (!deData.isCollection()) {
                try {
                    deData.getSetMethod().invoke(to, context.deserialize(field.getValue(), deData.getDeserializeType(field.getValue())));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                Collection fCollection = (Collection)deData.getSetMethod().invoke(to, new Object[0]);
                JsonArray list = field.getValue().getAsJsonArray();
                for (JsonElement element : list) {
                    fCollection.add(context.deserialize(element, deData.getDeserializeType(element)));
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return (T)to;
    }

    protected <C extends T> C construct(JsonObject jsonO, Type typeOfT) {
        Class cls = (Class)typeOfT;
        try {
            return (C)cls.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected abstract Map<String, Method> getSerializeFields(T var1, Type var2);

    protected abstract Map<String, ? extends DeserializeData> getDeserializeFields(T var1, Type var2);

    protected Method getMethod(Class<? extends T> cls, String methodName, Class<?> ... parms) {
        try {
            return cls.getMethod(methodName, parms);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static class DeserializeData {
        private final Method setMethod;
        private final Type[] parameterTypes;

        public DeserializeData(Method setMethod) {
            this.setMethod = setMethod;
            this.parameterTypes = setMethod.getGenericParameterTypes();
        }

        public Method getSetMethod() {
            return this.setMethod;
        }

        public boolean isCollection() {
            return this.parameterTypes.length == 0;
        }

        public Type getDeserializeType(JsonElement fieldValue) {
            switch (this.parameterTypes.length) {
                case 1: {
                    return this.parameterTypes[0];
                }
                case 0: {
                    Type rt = this.setMethod.getGenericReturnType();
                    if (rt instanceof ParameterizedType) {
                        return ((ParameterizedType)rt).getActualTypeArguments()[0];
                    }
                    return rt;
                }
            }
            return Object.class;
        }
    }
}

