/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.ibm.ram.common.util.AttributeConstants;
import com.ibm.ram.common.util.RAMURLEncoder;
import com.ibm.ram.internal.jaxb.AssetAttribute;
import com.ibm.ram.internal.jaxb.AttributeType;
import com.ibm.ram.internal.jaxb.AttributeValue;
import com.ibm.ram.internal.jaxb.util.JAXBLinksUtil;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import org.oslc.asset.internal.Artifact;
import org.oslc.asset.internal.Asset;
import org.oslc.asset.internal.Assets;
import org.oslc.asset.internal.Dialog;
import org.oslc.asset.internal.Factory;
import org.oslc.asset.internal.Relation;
import org.oslc.asset.internal.ResourceRef;
import org.oslc.asset.internal.ServiceDescriptor;
import org.oslc.asset.internal.SimpleQuery;
import org.oslc.asset.internal.Tag;
import org.oslc.asset.internal.v2.OSLCEncoder;

public class OSLCJsonEncoder<T>
implements JsonSerializer<T> {
    @Override
    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        if (src instanceof Asset) {
            return this.encodeAsset((Asset)src, true);
        }
        if (src instanceof ServiceDescriptor) {
            return this.encodeServiceDescriptor((ServiceDescriptor)src);
        }
        if (src instanceof Artifact) {
            return this.encodeArtifact((Artifact)src, true);
        }
        return null;
    }

    public JsonElement encodeAsset(Asset src, boolean includePrefix) {
        JsonObject json = new JsonObject();
        String baseUrl = src.getBase();
        JsonObject prefixes = null;
        if (includePrefix) {
            prefixes = this.encodeBasePrefixes();
            prefixes.addProperty("acc", "http://jazz.net/ns/acp#");
            prefixes.addProperty("ram_asset", "http://jazz.net/xmlns/prod/ram/2.0/");
            prefixes.addProperty("ram_asset_custom_properties", String.valueOf(baseUrl) + "custom_properties#");
            json.add("prefixes", prefixes);
        }
        this.encodeRdfResource(json, baseUrl, "oslc:instanceShape", src.getType());
        this.encodeRdfResource(json, baseUrl, "ram_asset:community", src.getRAMCommunity());
        this.encodeRdfResources(json, baseUrl, "dcterms:contributor", src.getContributors());
        this.encodeProperty(json, "dcterms:title", src.getTitle());
        this.encodeTime(json, "dcterms:modified", src.getModified());
        this.encodeRdfResource(json, "oslc:serviceProvider", String.valueOf(baseUrl) + "oslc" + "/" + "assetServices");
        if (src.getDbid() != null) {
            json.addProperty("dcterms:identifier", Integer.toString(src.getDbid()));
            this.encodeRdfResource(json, "acc:accessControl", String.valueOf(baseUrl) + "acc" + "/" + "assets" + "/" + src.getDbid());
        }
        this.encodeRdfResource(json, baseUrl, "dcterms:type", src.getType());
        this.encodeProperty(json, "dcterms:description", src.getDescription());
        this.encodeProperty(json, "dcterms:abstract", src.getSubject());
        this.encodeRdfResource(json, baseUrl, "oslc_asset:artifactFactory", src.getArtifactFactory());
        this.encodeRdfResource(json, baseUrl, "oslc_asset:state", src.getState());
        this.encodeRdfResource(json, "rdf:type", "http://open-services.net/ns/asset#Asset");
        this.encodeProperty(json, "ram_asset:revisionCount", src.getEtag());
        if (src.getId() != null) {
            this.encodeProperty(json, "oslc_asset:guid", src.getId().getGUID());
            this.encodeProperty(json, "oslc_asset:version", src.getId().getVersion());
            json.addProperty("rdf:about", String.valueOf(baseUrl) + "oslc" + "/" + "assets" + "/" + src.getId().getGUID() + "/" + src.getId().getVersion());
        }
        this.encodeRdfResources(json, baseUrl, "oslc_asset:categorization", src.getRAMCategories());
        JsonArray tags = new JsonArray();
        for (Tag tag : src.getTagsList()) {
            JsonObject jsonTag = new JsonObject();
            jsonTag.addProperty("value", tag.getValue());
            jsonTag.addProperty("oslc:readOnly", tag.isReadOnlye());
            tags.add(jsonTag);
        }
        if (tags.size() != 0) {
            json.add("oslc_asset:tag", tags);
        }
        if (src.getRelationships() != null && !src.getRelationships().isEmpty()) {
            JsonArray relations = new JsonArray();
            for (Relation relation : src.getRelationships()) {
                JsonObject jsonRelation = new JsonObject();
                jsonRelation.addProperty("rdf:resource", String.valueOf(baseUrl) + relation.getResource());
                this.encodeRdfResource(jsonRelation, "oslc_asset:relationshipType", String.valueOf(baseUrl) + relation.getType().getResource());
                relations.add(jsonRelation);
            }
            json.add("dcterms:relation", relations);
        }
        if (src.getRAMAttributeValues() != null && !src.getRAMAttributeValues().isEmpty()) {
            String attrPrefix = "classif/assetTypesSchema";
            boolean addedSelfDefinedPrefix = false;
            for (AttributeValue av : src.getRAMAttributeValues()) {
                String attributeIdentifier = JAXBLinksUtil.getAttributeIdentifier(av.getAttribute().getHref());
                StringBuilder oslcID = new StringBuilder();
                if (attributeIdentifier.startsWith(attrPrefix)) {
                    if (attributeIdentifier.substring(attrPrefix.length()).startsWith(".xmi#")) {
                        oslcID.append("_");
                        oslcID.append(attributeIdentifier.substring(attrPrefix.length() + 5));
                    } else if (attributeIdentifier.charAt(attrPrefix.length()) == '/') {
                        int firstSlashIndex = attrPrefix.length() + 1;
                        int secondSlashIndex = firstSlashIndex > -1 ? attributeIdentifier.indexOf("/", firstSlashIndex + 1) : -1;
                        int thirdSlashIndex = secondSlashIndex > -1 ? attributeIdentifier.indexOf("/", secondSlashIndex + 1) : -1;
                        int fragmentIndex = attributeIdentifier.lastIndexOf("#");
                        if (secondSlashIndex > -1 && thirdSlashIndex < 0) {
                            oslcID.append("_");
                            oslcID.append(attributeIdentifier.substring(firstSlashIndex, secondSlashIndex));
                            oslcID.append("___");
                            oslcID.append(attributeIdentifier.substring(fragmentIndex + 1));
                        } else if (secondSlashIndex > -1 && thirdSlashIndex > -1) {
                            oslcID.append("_");
                            oslcID.append(attributeIdentifier.substring(secondSlashIndex + 1, thirdSlashIndex));
                            oslcID.append("___");
                            oslcID.append(attributeIdentifier.substring(firstSlashIndex, secondSlashIndex));
                            oslcID.append("___");
                            oslcID.append(attributeIdentifier.substring(fragmentIndex + 1));
                        }
                    }
                } else {
                    if (includePrefix && !addedSelfDefinedPrefix) {
                        addedSelfDefinedPrefix = true;
                        prefixes.addProperty("j0", String.valueOf(baseUrl) + "oslc" + "/" + "assets" + "/" + src.getId().getGUID() + "/" + src.getId().getVersion());
                    }
                    JsonObject customAttr = new JsonObject();
                    this.encodeProperties(customAttr, "value", av.getValues());
                    customAttr.addProperty("decterms:title", av.getAttribute().getTitle().toString());
                    this.encodeRdfResource(customAttr, "rdf:type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Property");
                    json.add("j0:ca." + attributeIdentifier, customAttr);
                }
                if (oslcID.length() <= 0) continue;
                String propertyName = "ram_asset_custom_properties:" + oslcID.toString();
                AssetAttribute attribute = av.getAttribute().getValue();
                AttributeType type = attribute == null ? AttributeType.TEXT : attribute.getType();
                for (String val : av.getValues()) {
                    switch (type) {
                        default: {
                            json.addProperty(propertyName, val);
                            break;
                        }
                        case DATE: {
                            this.encodeTime(json, propertyName, AttributeConstants.getDate(val));
                            break;
                        }
                        case USER: {
                            this.encodeRdfResource(json, propertyName, String.valueOf(baseUrl) + JAXBLinksUtil.USERS_PATH + RAMURLEncoder.encode(val));
                            break;
                        }
                        case RESOURCE: {
                            json.addProperty(propertyName, val);
                            break;
                        }
                        case LINK: {
                            int lastIndex;
                            int startIndex = val.indexOf("href=\"");
                            if (startIndex > -1) {
                                startIndex += 6;
                            }
                            if ((lastIndex = val.indexOf("\"", startIndex)) > -1 && startIndex > -1) {
                                this.encodeRdfResource(json, propertyName, val.substring(startIndex, lastIndex));
                                break;
                            }
                            json.addProperty(propertyName, val);
                        }
                    }
                }
            }
        }
        if (src.getArtifacts() != null && !src.getArtifacts().isEmpty()) {
            JsonArray artifacts = new JsonArray();
            for (Artifact artifact : src.getArtifacts()) {
                artifact.setBase(baseUrl);
                artifacts.add(this.encodeArtifact(artifact, false));
            }
            json.add("oslc_asset:artifact", artifacts);
        }
        return json;
    }

    protected JsonElement encodeServiceDescriptor(ServiceDescriptor src) {
        JsonObject json = new JsonObject();
        json.add("prefixes", this.encodeBasePrefixes());
        String baseUrl = src.getBase();
        json.addProperty("dcterms:description", src.getDescription());
        json.addProperty("decterms:title", src.getTitle());
        json.addProperty("rdf:about", String.valueOf(baseUrl) + src.getAbout());
        this.encodeRdfResource(json, "rdf:type", "http://open-services.net/ns/core#ServiceProvider");
        JsonObject publisher = new JsonObject();
        json.add("dcterms:publisher", publisher);
        this.encodeRdfResource(publisher, "oslc:icon", String.valueOf(baseUrl) + src.getContributor().getIcon());
        publisher.addProperty("dcterms:identifier", src.getContributor().getIdentifier());
        publisher.addProperty("dcterms:title", src.getContributor().getTitle());
        this.encodeRdfResource(publisher, "rdf:type", "http://open-services.net/ns/core#Publisher");
        JsonArray prefixDefs = new JsonArray();
        prefixDefs.add(this.encodePrefix("dcterms", "http://purl.org/dc/terms/"));
        prefixDefs.add(this.encodePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        prefixDefs.add(this.encodePrefix("oslc", "http://open-services.net/ns/core#"));
        prefixDefs.add(this.encodePrefix("oslc_asset", "http://open-services.net/ns/asset#"));
        json.add("oslc:prefixDefinition", prefixDefs);
        JsonObject service = new JsonObject();
        json.add("oslc:service", service);
        this.encodeRdfResource(service, "oslc:domain", "http://open-services.net/ns/asset#Asset");
        this.encodeRdfResource(service, "rdf:type", "http://open-services.net/ns/core#Service");
        Assets assets = src.getAssets();
        JsonArray factories = new JsonArray();
        for (Factory factory : assets.getFactory()) {
            JsonObject creationFact = new JsonObject();
            this.encodeRdfResource(creationFact, "rdf:type", "http://open-services.net/ns/core#CreationFactory");
            creationFact.addProperty("dcterms:title", factory.getTitle());
            this.encodeRdfResource(creationFact, "oslc:creation", String.valueOf(baseUrl) + factory.getAbout());
            this.encodeRdfResource(creationFact, "oslc:resourceShape", String.valueOf(baseUrl) + "oslc" + "/" + "shapes" + "/" + "assets");
            this.encodeRdfResource(creationFact, "oslc:usage", "http://open-services.net/ns/core#default");
            this.encodeRdfResource(creationFact, "oslc:usage", "http://open-services.net/ns/asset#Asset");
            this.encodeRdfResource(creationFact, "oslc:resourceType", "http://open-services.net/ns/asset#Asset");
            factories.add(creationFact);
        }
        service.add("oslc:creationFactory", factories);
        JsonArray queries = new JsonArray();
        for (SimpleQuery query : assets.getSimpleQuery()) {
            JsonObject queryCap = new JsonObject();
            this.encodeRdfResource(queryCap, "oslc:usage", "http://open-services.net/ns/core#default");
            this.encodeRdfResource(queryCap, "oslc:usage", "http://open-services.net/ns/asset#Asset");
            this.encodeRdfResource(queryCap, "oslc:resourceType", "http://open-services.net/ns/asset#Asset");
            this.encodeRdfResource(queryCap, "rdf:type", "http://open-services.net/ns/core#QueryCapability");
            this.encodeRdfResource(queryCap, "oslc:resourceShape", String.valueOf(baseUrl) + "oslc" + "/" + "shapes" + "/" + "assets");
            this.encodeRdfResource(queryCap, "oslc:queryBase", String.valueOf(baseUrl) + query.getAbout());
            queryCap.addProperty("dcterms:title", query.getTitle());
            queries.add(queryCap);
        }
        service.add("oslc:queryCapability", queries);
        JsonArray createDialogs = new JsonArray();
        this.encodeDialog(createDialogs, assets.getCreationDialog(), baseUrl);
        service.add("oslc:creationDialog", createDialogs);
        JsonArray selectionDialogs = new JsonArray();
        this.encodeDialog(selectionDialogs, assets.getSelectionDialog(), baseUrl);
        service.add("oslc:selectionDialog", selectionDialogs);
        return json;
    }

    private void encodeDialog(JsonArray jsonParent, List<Dialog> dialogs, String baseUrl) {
        for (Dialog dialog : dialogs) {
            JsonObject jsonDialog = new JsonObject();
            this.encodeRdfResource(jsonDialog, "oslc:usage", "http://open-services.net/ns/core#default");
            this.encodeRdfResource(jsonDialog, "oslc:usage", "http://open-services.net/ns/asset#Asset");
            this.encodeRdfResource(jsonDialog, "oslc:resourceType", "http://open-services.net/ns/asset#Asset");
            jsonDialog.addProperty("oslc:hintHeight", dialog.getHintHeight());
            jsonDialog.addProperty("oslc:hintWidth", dialog.getHintWidth());
            this.encodeRdfResource(jsonDialog, "oslc:dialog", String.valueOf(baseUrl) + dialog.getUrl());
            jsonDialog.addProperty("oslc:label", dialog.getLabel());
            jsonDialog.addProperty("dcterms:title", dialog.getTitle());
            this.encodeRdfResource(jsonDialog, "rdf:type", "http://open-services.net/ns/core#Dialog");
            jsonParent.add(jsonDialog);
        }
    }

    private JsonObject encodePrefix(String prefix, String base) {
        JsonObject jsonPre = new JsonObject();
        jsonPre.addProperty("oslc:prefix", prefix);
        this.encodeRdfResource(jsonPre, "oslc:prefixBase", base);
        return jsonPre;
    }

    protected JsonElement encodeArtifact(Artifact artifact, boolean includePrefixes) {
        JsonObject json = new JsonObject();
        if (includePrefixes) {
            json.add("prefixes", this.encodeBasePrefixes());
        }
        this.encodeProperty(json, "dcterms:title", artifact.getTitle());
        this.encodeProperty(json, "oslc:label", artifact.getSubject());
        if (artifact.getReference() != null) {
            this.encodeRdfResource(json, "url".equals(artifact.getReference().getKind()) ? "" : artifact.getBase(), "oslc_asset:content", artifact.getContent());
        } else {
            this.encodeRdfResource(json, artifact.getBase(), "oslc_asset:content", artifact.getContent());
        }
        this.encodeProperty(json, "dcterms:format", artifact.getMimeType());
        this.encodeRdfResource(json, "rdf:type", "http://open-services.net/ns/asset#Artifact");
        if (artifact.getSize() != null) {
            this.encodeProperty(json, "oslc_asset:size", artifact.getSize().toString());
        }
        if (artifact.getModified() != null) {
            this.encodeProperty(json, "dcterms:modified", OSLCEncoder.encode(artifact.getModified()));
        }
        return json;
    }

    private JsonObject encodeBasePrefixes() {
        JsonObject prefixes = new JsonObject();
        prefixes.addProperty("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        prefixes.addProperty("dcterms", "http://purl.org/dc/terms/");
        prefixes.addProperty("oslc_asset", "http://open-services.net/ns/asset#");
        prefixes.addProperty("oslc", "http://open-services.net/ns/core#");
        return prefixes;
    }

    private void encodeRdfResources(JsonObject json, String baseUrl, String property, List<ResourceRef> refs) {
        if (refs == null || refs.isEmpty()) {
            return;
        }
        JsonArray array = new JsonArray();
        for (ResourceRef ref : refs) {
            JsonObject encodedProp = new JsonObject();
            encodedProp.addProperty("rdf:resource", String.valueOf(baseUrl) + ref.getResource());
            array.add(encodedProp);
        }
        json.add(property, array);
    }

    private void encodeRdfResource(JsonObject json, String baseUrl, String property, ResourceRef ref) {
        if (ref == null) {
            return;
        }
        this.encodeRdfResource(json, property, String.valueOf(baseUrl) + ref.getResource());
    }

    private void encodeRdfResource(JsonObject json, String property, String value) {
        JsonObject encodedProp = new JsonObject();
        encodedProp.addProperty("rdf:resource", value);
        json.add(property, encodedProp);
    }

    private void encodeTime(JsonObject json, String property, Date date) {
        if (date != null) {
            json.addProperty(property, OSLCEncoder.encode(date));
        }
    }

    private void encodeProperty(JsonObject json, String property, String value) {
        if (value != null) {
            json.addProperty(property, value);
        }
    }

    private void encodeProperties(JsonObject json, String property, List<String> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        JsonArray array = new JsonArray();
        for (String value : values) {
            array.add(new JsonPrimitive(value));
        }
        json.add(property, array);
    }
}

