/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractCleartoolCommand {
    private static Logger logger = Logger.getLogger(AbstractCleartoolCommand.class);

    protected abstract String[] getArguments();

    protected File getFolderToRunIn() {
        return null;
    }

    public ICommandOutput run(String cleartoolPath) throws IOException, InterruptedException {
        String[] args = this.getArguments();
        File inFolder = this.getFolderToRunIn();
        if (args != null && (inFolder == null || inFolder != null && inFolder.exists())) {
            String[] command = new String[args.length + 1];
            command[0] = cleartoolPath;
            System.arraycopy(args, 0, command, 1, args.length);
            if (logger.isDebugEnabled()) {
                StringBuffer cmd = new StringBuffer();
                cmd.append(String.valueOf(this.getClass().getName()) + " [" + System.currentTimeMillis() + "]: ");
                if (command != null) {
                    int ac = 0;
                    while (ac < command.length) {
                        cmd.append(String.valueOf(command[ac]) + ", ");
                        ++ac;
                    }
                }
                logger.debug((Object)cmd);
            }
            Process process = Runtime.getRuntime().exec(command, null, inFolder);
            ICommandOutput output = this.handleProcess(process);
            if (logger.isDebugEnabled()) {
                StringBuffer cmd = new StringBuffer();
                cmd.append(String.valueOf(this.getClass().getName()) + " [" + System.currentTimeMillis() + "]: Finished");
                logger.debug((Object)cmd);
            }
            return output;
        }
        return null;
    }

    protected abstract ICommandOutput handleProcess(Process var1) throws IOException, InterruptedException;

    public static interface ICommandOutput {
    }
}

