/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CleartoolCommandConstants {
    private static final Logger logger;
    public static String ERROR;
    public static String CREATE_LABEL_TYPE;
    public static String LS_OUTPUT_RULE;
    public static String LS_OUTPUT_VIEW_PRIVATE_OBJECT;
    public static String LS_OUTPUT_VERSION;
    public static String LS_OUTPUT_CHECKEDOUT_FROM;
    public static String HOSTINFO_REGISTRY_HOST;
    public static String HOSTINFO_REGISTRY_REGION;
    public static String LSVIEW_VIEW_SEPERATOR;
    public static String LSVIEW_GLOBAL_PATH;
    public static String LSVIEW_SERVER_HOST;
    public static String LSVIEW_REGION;
    public static String LSVIEW_ACTIVE;
    public static String LSVIEW_UUID;
    public static String LSVIEW_OWNER;
    public static String LSVIEW_ATTRIBUTES;
    public static String LSVIEW_SERVER_PATH;
    public static String LSVIEW_SNAPSHOT;
    public static String LSVIEW_ACTIVE_YES;
    public static String LSVIEW_UCMVIEW;
    public static String LSVOB_VOB_SEPERATOR;
    public static String LSVOB_GLOBAL_PATH;
    public static String LSVOB_SERVER_HOST;
    public static String LSVOB_REGION;
    public static String LSVOB_ACTIVE;
    public static String LSVOB_PRIVATE_ACCESS;
    public static String LSVOB_FAMILYUUID;
    public static String LSVOB_REPLICAUUID;
    public static String LSVOB_MOUNTOPTIONS;
    public static String LSVOB_SERVER_PATH;
    public static String LSVOB_ACTIVE_YES;
    public static String LSVOB_REGISTRY_ATTRIBUTES;
    public static String LSVOB_UCMVOB;
    public static String LSPROJECT_PROJECT;
    public static String LSPROJECT_INTEGRATION_STREAM;
    public static String LSPROJECT_MODIFIABLE_COMPONENTS;
    public static String LSPROJECT_RECOMMENDED_BASELINES;
    public static String LSPROJECT_DEFAULT_PROMO_LEVEL;
    public static String LSPROJECT_MODEL;
    public static String LSPROJECT_POLICIES;
    public static String LSPROJECT_NAMING_TEMPLATE;
    public static String LSBL_OWNER;
    public static String LSBL_GROUP;
    public static String LSBL_COMPONENT;
    public static String LSBL_STREAM;
    public static String LSBL_LABEL_STATUS;
    public static String LSBL_CHANGE_SETS;
    public static String LSBL_PROMOTION_LEVEL;
    public static String LSBL_DEPENDS_ON;
    public static String DIFFBL_DIFFERENCES;
    public static String DIFFBL_DIFFNONE;
    public static String DELIVER_COMPLETE;
    public static String STREAM;
    public static String INTEGRATION;
    public static String BASELINE;
    public static String CREATED;
    public static String SET;
    public static String REMOVED;
    public static String COMPONENT;
    public static String LSSTREAM_OWNER;
    public static String LSSTREAM_GROUP;
    public static String LSSTREAM_PROJECT;
    public static String LSSTREAM_DEFAULT_DELIVER_STREAM;
    public static String LSSTREAM_DEVELOPMENT_STREAMS;
    public static String LSSTREAM_CONTAINS_ACTIVITIES;
    public static String LSSTREAM_FOUNDATION_BASELINES;
    public static String LSSTREAM_RECOMMENDED_BASELINES;
    public static String LSSTREAM_VIEWS;
    public static String LSSTREAM_POLICIES;
    public static String LSSTREAM_POLICIES_EFFECTIVE;
    public static String LSSTREAM_NAMING_TEMPLATE;
    public static String LSACTIVITY_CHANGE_SETS;
    public static String LSACTIVITY_TITLE;
    public static String LSACTIVITY_CURRENT_VIEW;
    public static String LSACTIVITY_STREAM;
    public static String LSACTIVITY_GROUP;
    public static String LSACTIVITY_OWNER;
    public static String LSACTIVITY_ACTIVITY;
    public static String LSCOMP_ROOTDIR;

    static {
        byte[] content;
        InputStream is;
        logger = Logger.getLogger(CleartoolCommandConstants.class);
        String cliContent = null;
        if (Locale.JAPANESE.equals(Locale.getDefault()) || Locale.JAPAN.equals(Locale.getDefault())) {
            logger.info((Object)"Using Japanese Cleartool CLI");
            is = CleartoolCommandConstants.class.getResourceAsStream("ja/cleartoolCLI_ja.out");
            try {
                content = CleartoolCommandConstants.readInputStream(is);
                cliContent = new String(content, "MS932");
            }
            catch (IOException e) {
                logger.error((Object)"Unable to read Cleartool CLI output for Japanese.", (Throwable)e);
            }
        } else {
            logger.info((Object)"Using English Cleartool CLI");
            is = CleartoolCommandConstants.class.getResourceAsStream("cleartoolCLI.out");
            try {
                content = CleartoolCommandConstants.readInputStream(is);
                cliContent = new String(content);
            }
            catch (IOException e) {
                logger.error((Object)"Unable to read Cleartool CLI output for English.", (Throwable)e);
            }
        }
        if (cliContent == null) {
            throw new RuntimeException("Unable to read Cleartool CLI");
        }
        StringTokenizer lineTokenizer = new StringTokenizer(cliContent, "\r\n");
        while (lineTokenizer.hasMoreTokens()) {
            String line = lineTokenizer.nextToken();
            int sep = line.indexOf(61);
            String key = line.substring(0, sep);
            String value = line.substring(sep + 1);
            try {
                Field f = CleartoolCommandConstants.class.getField(key);
                f.set(null, value);
            }
            catch (SecurityException e) {
                logger.error((Object)("Unable to set field: " + key), (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                logger.error((Object)("Unable to set field: " + key), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("Unable to set field: " + key), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)("Unable to set field: " + key), (Throwable)e);
            }
        }
    }

    private static byte[] readInputStream(InputStream is) throws IOException {
        ByteBuffer byteBuffer = null;
        if (is != null) {
            byte[] bytes = new byte[8192];
            int read = is.read(bytes);
            while (read > -1) {
                if (byteBuffer == null) {
                    byteBuffer = ByteBuffer.allocate(read);
                } else {
                    ByteBuffer newBuffer = ByteBuffer.allocate(byteBuffer.limit() + read);
                    newBuffer.put(byteBuffer.array(), 0, byteBuffer.limit());
                    byteBuffer = newBuffer;
                }
                byteBuffer.put(bytes, 0, read);
                read = is.read(bytes);
            }
        }
        return byteBuffer == null ? null : byteBuffer.array();
    }
}

