/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ram.internal.scm.clearcase.commands;

import com.ibm.ram.internal.scm.clearcase.VOB;
import com.ibm.ram.internal.scm.clearcase.commands.AbstractCleartoolCommand;
import com.ibm.ram.internal.scm.clearcase.commands.CleartoolCommandConstants;
import com.ibm.ram.internal.scm.clearcase.commands.OutputCleartoolCommand;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ListVOBCommand
extends OutputCleartoolCommand {
    private static String KEY_VOB_SEPERATOR = CleartoolCommandConstants.LSVOB_VOB_SEPERATOR;
    private static String KEY_GLOBAL_PATH = CleartoolCommandConstants.LSVOB_GLOBAL_PATH;
    private static String KEY_SERVER_HOST = CleartoolCommandConstants.LSVOB_SERVER_HOST;
    private static String KEY_REGION = CleartoolCommandConstants.LSVOB_REGION;
    private static String KEY_ACTIVE = CleartoolCommandConstants.LSVOB_ACTIVE;
    private static String KEY_PRIVATE_ACCESS = CleartoolCommandConstants.LSVOB_PRIVATE_ACCESS;
    private static String KEY_FAMILYUUID = CleartoolCommandConstants.LSVOB_FAMILYUUID;
    private static String KEY_REPLICAUUID = CleartoolCommandConstants.LSVOB_REPLICAUUID;
    private static String KEY_MOUNTOPTIONS = CleartoolCommandConstants.LSVOB_MOUNTOPTIONS;
    private static String KEY_SERVER_PATH = CleartoolCommandConstants.LSVOB_SERVER_PATH;
    private static String KEY_REGISTRY_ATTRIBUTES = CleartoolCommandConstants.LSVOB_REGISTRY_ATTRIBUTES;
    private String hostName = null;
    private String familyUUID = null;

    public ListVOBCommand(String vobID, boolean isHostName, boolean isFamilyUUID) {
        if (isHostName) {
            this.hostName = vobID;
        } else if (isFamilyUUID) {
            this.familyUUID = vobID;
        }
    }

    @Override
    protected String[] getArguments() {
        if (this.hostName != null) {
            return new String[]{"lsvob", "-long", "-host", this.hostName};
        }
        if (this.familyUUID != null) {
            return new String[]{"lsvob", "-long", "-family", this.familyUUID};
        }
        return null;
    }

    @Override
    protected AbstractCleartoolCommand.ICommandOutput parseOutput(String output, String error) {
        final ArrayList<VOB> vobsList = new ArrayList<VOB>();
        if (output != null && output.length() > 0) {
            String[] vobStrings = output.split(KEY_VOB_SEPERATOR);
            int vc = 0;
            while (vc < vobStrings.length) {
                if (vobStrings[vc].trim().length() > 0) {
                    StringTokenizer lines = new StringTokenizer(vobStrings[vc], "\r\n");
                    String firstLine = lines.nextToken();
                    int spaceLocation = firstLine.indexOf(" ");
                    String vobName = spaceLocation < 0 ? firstLine : firstLine.substring(0, spaceLocation);
                    String vobDescription = spaceLocation < 0 ? null : firstLine.substring(spaceLocation + 1, firstLine.length());
                    boolean active = false;
                    boolean privateVOB = false;
                    boolean ucmVOB = false;
                    String mountOptions = null;
                    String globalPath = null;
                    String region = null;
                    String serverHost = null;
                    String familyUuid = null;
                    String replicaUuid = null;
                    String serverPath = null;
                    String registryAttributes = null;
                    while (lines.hasMoreTokens()) {
                        String line = lines.nextToken().trim();
                        if (line.startsWith(KEY_ACTIVE)) {
                            active = line.substring(KEY_ACTIVE.length()).indexOf(CleartoolCommandConstants.LSVOB_ACTIVE_YES) > -1;
                            continue;
                        }
                        if (line.startsWith(KEY_MOUNTOPTIONS)) {
                            mountOptions = line.substring(KEY_MOUNTOPTIONS.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_GLOBAL_PATH)) {
                            globalPath = line.substring(KEY_GLOBAL_PATH.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_FAMILYUUID)) {
                            familyUuid = line.substring(KEY_FAMILYUUID.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_REGION)) {
                            region = line.substring(KEY_REGION.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_SERVER_HOST)) {
                            serverHost = line.substring(KEY_SERVER_HOST.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_REPLICAUUID)) {
                            replicaUuid = line.substring(KEY_REPLICAUUID.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_SERVER_PATH)) {
                            serverPath = line.substring(KEY_SERVER_PATH.length()).trim();
                            continue;
                        }
                        if (line.startsWith(KEY_PRIVATE_ACCESS)) {
                            privateVOB = true;
                            continue;
                        }
                        if (!line.startsWith(KEY_REGISTRY_ATTRIBUTES)) continue;
                        registryAttributes = line.substring(KEY_REGISTRY_ATTRIBUTES.length()).trim();
                        boolean bl = ucmVOB = registryAttributes.indexOf(CleartoolCommandConstants.LSVOB_UCMVOB) != -1;
                    }
                    serverHost = this.resolveDomain(serverHost);
                    VOB v = new VOB();
                    v.setActive(active);
                    v.setDescription(vobDescription);
                    v.setGlobalPath(globalPath);
                    v.setTag(vobName);
                    v.setRegion(region);
                    v.setServerHost(serverHost);
                    v.setServerPath(serverPath);
                    v.setFamilyUUID(familyUuid);
                    v.setReplicaUUID(replicaUuid);
                    v.setPrivateVOB(privateVOB);
                    v.setMountOptions(mountOptions);
                    v.setUCMVOB(ucmVOB);
                    vobsList.add(v);
                }
                ++vc;
            }
        }
        return new ListVOBOutput(){

            @Override
            public VOB[] getVOBs() {
                return vobsList.toArray(new VOB[vobsList.size()]);
            }
        };
    }

    private String resolveDomain(String serverHost) {
        String resolved = serverHost;
        try {
            String canonicalHostName;
            InetAddress serverInetAddr = InetAddress.getByName(serverHost);
            if (serverInetAddr != null && (canonicalHostName = serverInetAddr.getCanonicalHostName()) != null && canonicalHostName.trim().length() > 0) {
                resolved = canonicalHostName;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return resolved;
    }

    public static interface ListVOBOutput
    extends AbstractCleartoolCommand.ICommandOutput {
        public VOB[] getVOBs();
    }
}

